/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.scene.ConnectionDirection;
import com.android.tools.idea.naveditor.scene.CurvePoints;
import com.android.tools.idea.naveditor.scene.NavActionHelperKt$WhenMappings;
import com.android.tools.idea.naveditor.scene.NavDrawHelperKt;
import com.android.tools.idea.naveditor.scene.NavSceneManager;
import com.intellij.util.ui.JBUI;
import java.awt.BasicStroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000f\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\b\u001a\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u001e\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0010\u001a\u001e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0010\u001a\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u0018\u0010 \u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0010H\u0002\u001a(\u0010!\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0010H\u0002\u001a\u001e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020\u0016\u001a\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020%2\u0006\u0010,\u001a\u00020*H\u0002\u001a\u0018\u0010-\u001a\u00020*2\u0006\u0010+\u001a\u00020%2\u0006\u0010,\u001a\u00020*H\u0002\u001a\u0016\u0010.\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u0019\u001a\u001e\u00100\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0010\u001a\u000e\u00101\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019\u001a)\u00102\u001a\b\u0012\u0004\u0012\u00020\u0012032\u0006\u00104\u001a\u00020\u00122\u0006\u00105\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u00106\u001a \u00107\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u0005H\u0002\u001a(\u00107\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u00109\u001a\u00020\u00052\u0006\u0010:\u001a\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0007\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"ACTION_PADDING", "", "ACTION_STROKE", "Ljava/awt/BasicStroke;", "ACTION_STROKE_WIDTH", "", "CONTROL_POINT_THRESHOLD", "DASHED_ACTION_STROKE", "DASHED_STROKE_CYCLE", "SELF_ACTION_LENGTHS", "", "SELF_ACTION_RADII", "", "getSELF_ACTION_RADII", "()[F", "START_DIRECTION", "Lcom/android/tools/idea/naveditor/scene/ConnectionDirection;", "getAnyPoint", "Ljava/awt/geom/Point2D$Float;", "action", "Lcom/android/tools/idea/common/scene/SceneComponent;", "context", "Lcom/android/tools/idea/common/scene/SceneContext;", "getArrowPoint", "rectangle", "Ljava/awt/geom/Rectangle2D$Float;", "direction", "getArrowRectangle", "view", "Lcom/android/tools/idea/common/surface/SceneView;", "p", "getCenterPoint", "getConnectionPoint", "getControlPoint", "p1", "p2", "getCurvePoints", "Lcom/android/tools/idea/naveditor/scene/CurvePoints;", "source", "dest", "sceneContext", "getCurveX", "", "points", "t", "getCurveY", "getDestinationDirection", "destination", "getEndPoint", "getStartPoint", "selfActionPoints", "", "start", "end", "(Ljava/awt/geom/Point2D$Float;Ljava/awt/geom/Point2D$Float;Lcom/android/tools/idea/common/scene/SceneContext;)[Ljava/awt/geom/Point2D$Float;", "shiftPoint", "shift", "shiftX", "shiftY", "intellij.android.designer"})
public final class NavActionHelperKt {
    private static final float ACTION_STROKE_WIDTH = JBUI.scale((float)3.0f);
    private static final float DASHED_STROKE_CYCLE = JBUI.scale((float)5.0f);
    @JvmField
    @NotNull
    public static final int[] SELF_ACTION_LENGTHS = new int[]{JBUI.scale((int)28), JBUI.scale((int)26), JBUI.scale((int)60), JBUI.scale((int)8)};
    @NotNull
    private static final float[] SELF_ACTION_RADII = new float[]{JBUI.scale((float)10.0f), JBUI.scale((float)10.0f), JBUI.scale((float)5.0f)};
    @JvmField
    @NotNull
    public static final BasicStroke ACTION_STROKE = new BasicStroke(ACTION_STROKE_WIDTH, 0, 1);
    @JvmField
    @NotNull
    public static final BasicStroke DASHED_ACTION_STROKE = new BasicStroke(ACTION_STROKE_WIDTH, 0, 1, DASHED_STROKE_CYCLE, new float[]{DASHED_STROKE_CYCLE}, DASHED_STROKE_CYCLE);
    private static final ConnectionDirection START_DIRECTION = ConnectionDirection.RIGHT;
    private static final int CONTROL_POINT_THRESHOLD = JBUI.scale((int)120);
    private static final int ACTION_PADDING = JBUI.scale((int)8);

    @NotNull
    public static final float[] getSELF_ACTION_RADII() {
        return SELF_ACTION_RADII;
    }

    @NotNull
    public static final Point2D.Float[] selfActionPoints(@NotNull Point2D.Float start, @NotNull Point2D.Float end, @NotNull SceneContext context) {
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)end, (String)"end");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Point2D.Float p1 = new Point2D.Float(start.x + (float)context.getSwingDimension(SELF_ACTION_LENGTHS[0]), start.y);
        Point2D.Float p2 = new Point2D.Float(p1.x, end.y + (float)context.getSwingDimension(SELF_ACTION_LENGTHS[3]));
        Point2D.Float p3 = new Point2D.Float(end.x, p2.y);
        return new Point2D.Float[]{start, p1, p2, p3, end};
    }

    @NotNull
    public static final ConnectionDirection getDestinationDirection(@NotNull Rectangle2D.Float source, @NotNull Rectangle2D.Float destination) {
        boolean higher;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        Point2D.Float start = NavActionHelperKt.getStartPoint(source);
        Point2D.Float end = NavActionHelperKt.getCenterPoint(destination);
        float slope = destination.width == 0.0f ? 1.0f : destination.height / destination.width;
        float rise = (start.x - end.x) * slope;
        boolean bl = higher = start.y < end.y;
        if (higher && start.y < end.y + rise) {
            return ConnectionDirection.TOP;
        }
        return !higher && start.y > end.y - rise ? ConnectionDirection.BOTTOM : ConnectionDirection.LEFT;
    }

    @NotNull
    public static final Point2D.Float getStartPoint(@NotNull Rectangle2D.Float rectangle) {
        Intrinsics.checkParameterIsNotNull((Object)rectangle, (String)"rectangle");
        return NavActionHelperKt.getConnectionPoint(rectangle, START_DIRECTION);
    }

    @NotNull
    public static final Rectangle2D.Float getArrowRectangle(@NotNull SceneView view, @NotNull Point2D.Float p, @NotNull ConnectionDirection direction) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        Intrinsics.checkParameterIsNotNull((Object)((Object)direction), (String)"direction");
        Rectangle2D.Float rectangle = new Rectangle2D.Float();
        float parallel = Coordinates.getSwingDimension(view, NavSceneManager.ACTION_ARROW_PARALLEL);
        float perpendicular = Coordinates.getSwingDimension(view, NavSceneManager.ACTION_ARROW_PERPENDICULAR);
        float deltaX = direction.getDeltaX();
        float deltaY = direction.getDeltaY();
        rectangle.x = p.x + (deltaX == 0.0f ? -perpendicular : parallel * (deltaX - 1.0f)) / (float)2;
        rectangle.y = p.y + (deltaY == 0.0f ? -perpendicular : parallel * (deltaY - 1.0f)) / (float)2;
        rectangle.width = Math.abs(deltaX * parallel) + Math.abs(deltaY * perpendicular);
        rectangle.height = Math.abs(deltaX * perpendicular) + Math.abs(deltaY * parallel);
        return rectangle;
    }

    private static final Point2D.Float getConnectionPoint(Rectangle2D.Float rectangle, ConnectionDirection direction) {
        return NavActionHelperKt.shiftPoint(NavActionHelperKt.getCenterPoint(rectangle), direction, rectangle.width / (float)2, rectangle.height / (float)2);
    }

    @NotNull
    public static final CurvePoints getCurvePoints(@NotNull Rectangle2D.Float source, @NotNull Rectangle2D.Float dest, @NotNull SceneContext sceneContext) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
        Intrinsics.checkParameterIsNotNull((Object)sceneContext, (String)"sceneContext");
        ConnectionDirection destDirection = NavActionHelperKt.getDestinationDirection(source, dest);
        Point2D.Float startPoint = NavActionHelperKt.getStartPoint(source);
        Point2D.Float endPoint = NavActionHelperKt.getEndPoint(sceneContext, dest, destDirection);
        return new CurvePoints(startPoint, NavActionHelperKt.getControlPoint(sceneContext, startPoint, endPoint, START_DIRECTION), NavActionHelperKt.getControlPoint(sceneContext, endPoint, startPoint, destDirection), endPoint, destDirection);
    }

    private static final Point2D.Float getControlPoint(SceneContext context, Point2D.Float p1, Point2D.Float p2, ConnectionDirection direction) {
        float shift = (float)Math.min(Math.hypot(p1.x - p2.x, p1.y - p2.y) / (double)2, (double)context.getSwingDimension(CONTROL_POINT_THRESHOLD));
        return NavActionHelperKt.shiftPoint(p1, direction, shift);
    }

    @NotNull
    public static final Point2D.Float getEndPoint(@NotNull SceneContext context, @NotNull Rectangle2D.Float rectangle, @NotNull ConnectionDirection direction) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)rectangle, (String)"rectangle");
        Intrinsics.checkParameterIsNotNull((Object)((Object)direction), (String)"direction");
        return NavActionHelperKt.shiftPoint(NavActionHelperKt.getArrowPoint(context, rectangle, direction), direction, (float)context.getSwingDimensionDip(NavSceneManager.ACTION_ARROW_PARALLEL) - 1.0f);
    }

    @Nullable
    public static final Point2D.Float getAnyPoint(@NotNull SceneComponent action2, @NotNull SceneContext context) {
        Intrinsics.checkParameterIsNotNull((Object)action2, (String)"action");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Scene scene = action2.getScene();
        Intrinsics.checkExpressionValueIsNotNull((Object)scene, (String)"action.scene");
        Scene scene2 = scene;
        Object object = scene2.getRoot();
        if (object == null || (object = ((SceneComponent)object).getNlComponent()) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"scene.root?.nlComponent ?: return null");
        Object rootNlComponent = object;
        NlComponent nlComponent = action2.getNlComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)nlComponent, (String)"action.nlComponent");
        NlComponent actionNlComponent = nlComponent;
        NlComponent nlComponent2 = NavComponentHelperKt.getEffectiveSource(actionNlComponent, (NlComponent)rootNlComponent);
        if (nlComponent2 == null) {
            return null;
        }
        NlComponent sourceNlComponent = nlComponent2;
        SceneComponent sceneComponent = scene2.getSceneComponent(sourceNlComponent);
        if (sceneComponent == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent, (String)"scene.getSceneComponent(\u2026Component) ?: return null");
        SceneComponent sourceSceneComponent = sceneComponent;
        Rectangle2D.Float sourceRect = Coordinates.getSwingRectDip(context, sourceSceneComponent.fillDrawRect2D(0L, null));
        switch (NavActionHelperKt$WhenMappings.$EnumSwitchMapping$0[NavComponentHelperKt.getActionType(actionNlComponent, (NlComponent)rootNlComponent).ordinal()]) {
            case 1: {
                Rectangle2D.Float float_ = sourceRect;
                Intrinsics.checkExpressionValueIsNotNull((Object)float_, (String)"sourceRect");
                Point2D.Float[] points = NavActionHelperKt.selfActionPoints(NavActionHelperKt.getStartPoint(float_), NavActionHelperKt.getEndPoint(context, sourceRect, ConnectionDirection.BOTTOM), context);
                return new Point2D.Float(points[1].x, (points[1].y + points[2].y) / (float)2);
            }
            case 2: 
            case 3: {
                NlComponent nlComponent3 = NavComponentHelperKt.getEffectiveDestination(actionNlComponent);
                if (nlComponent3 == null) {
                    return null;
                }
                NlComponent targetNlComponent = nlComponent3;
                SceneComponent sceneComponent2 = scene2.getSceneComponent(targetNlComponent);
                if (sceneComponent2 == null) {
                    return null;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)sceneComponent2, (String)"scene.getSceneComponent(\u2026Component) ?: return null");
                SceneComponent destinationSceneComponent = sceneComponent2;
                Rectangle2D.Float destRect = Coordinates.getSwingRectDip(context, destinationSceneComponent.fillDrawRect2D(0L, null));
                Rectangle2D.Float float_ = sourceRect;
                Intrinsics.checkExpressionValueIsNotNull((Object)float_, (String)"sourceRect");
                Rectangle2D.Float float_2 = destRect;
                Intrinsics.checkExpressionValueIsNotNull((Object)float_2, (String)"destRect");
                CurvePoints curvePoints = NavActionHelperKt.getCurvePoints(float_, float_2, context);
                return new Point2D.Float((float)NavActionHelperKt.getCurveX(curvePoints, 0.5), (float)NavActionHelperKt.getCurveY(curvePoints, 0.5));
            }
            case 4: 
            case 5: {
                Rectangle2D.Float float_ = Coordinates.getSwingRectDip(context, action2.fillDrawRect2D(0L, null));
                Intrinsics.checkExpressionValueIsNotNull((Object)float_, (String)"Coordinates.getSwingRect\u2026.fillDrawRect2D(0, null))");
                return NavActionHelperKt.getCenterPoint(float_);
            }
        }
        return null;
    }

    @NotNull
    public static final Point2D.Float getArrowPoint(@NotNull SceneContext context, @NotNull Rectangle2D.Float rectangle, @NotNull ConnectionDirection direction) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)rectangle, (String)"rectangle");
        Intrinsics.checkParameterIsNotNull((Object)((Object)direction), (String)"direction");
        int shiftY = ACTION_PADDING;
        if (direction == ConnectionDirection.TOP) {
            shiftY += (int)JBUI.scale((float)NavDrawHelperKt.HEADER_HEIGHT);
        }
        return NavActionHelperKt.shiftPoint(NavActionHelperKt.getConnectionPoint(rectangle, direction), direction, context.getSwingDimension(shiftY));
    }

    private static final Point2D.Float getCenterPoint(Rectangle2D.Float rectangle) {
        return new Point2D.Float((float)rectangle.getCenterX(), (float)rectangle.getCenterY());
    }

    private static final Point2D.Float shiftPoint(Point2D.Float p, ConnectionDirection direction, float shift) {
        return NavActionHelperKt.shiftPoint(p, direction, shift, shift);
    }

    private static final Point2D.Float shiftPoint(Point2D.Float p, ConnectionDirection direction, float shiftX, float shiftY) {
        return new Point2D.Float(p.x + shiftX * (float)direction.getDeltaX(), p.y + shiftY * (float)direction.getDeltaY());
    }

    private static final double getCurveX(CurvePoints points, double t) {
        return Math.pow(1.0 - t, 3.0) * (double)points.p1.x + (double)3 * Math.pow(1.0 - t, 2.0) * t * (double)points.p2.x + (double)3 * (1.0 - t) * Math.pow(t, 2.0) * (double)points.p3.x + Math.pow(t, 3.0) * (double)points.p4.x;
    }

    private static final double getCurveY(CurvePoints points, double t) {
        return Math.pow(1.0 - t, 3.0) * (double)points.p1.y + (double)3 * Math.pow(1.0 - t, 2.0) * t * (double)points.p2.y + (double)3 * (1.0 - t) * Math.pow(t, 2.0) * (double)points.p3.y + Math.pow(t, 3.0) * (double)points.p4.y;
    }
}

