/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.property.inspector;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.res.ResourceHelper;
import com.google.common.collect.Lists;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.UIUtil;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddArgumentDialog
extends DialogWrapper {
    private JPanel myContentPanel;
    JCheckBox myNullableCheckBox;
    private JTextField myNameTextField;
    private JPanel myDefaultValuePanel;
    JComboBox<String> myDefaultValueComboBox;
    JTextField myDefaultValueTextField;
    private JBLabel myNullableLabel;
    private JComboBox<Type> myTypeComboBox;
    @Nullable
    private final NlComponent myExistingComponent;
    @NotNull
    private final NlComponent myParent;
    private String myCustomType;
    private Type mySelectedType;
    private MutableCollectionComboBoxModel<String> myDefaultValueComboModel;

    public AddArgumentDialog(@Nullable NlComponent existing2, @NotNull NlComponent parent) {
        if (parent == null) {
            AddArgumentDialog.$$$reportNull$$$0(0);
        }
        super(false);
        this.$$$setupUI$$$();
        this.myDefaultValueComboModel = new MutableCollectionComboBoxModel();
        this.init();
        this.myParent = parent;
        this.myExistingComponent = existing2;
        for (Type t : Type.values()) {
            this.myTypeComboBox.addItem(t);
        }
        this.myTypeComboBox.setRenderer((ListCellRenderer<Type>)new ListCellRendererWrapper<Type>(){

            public void customize(JList list, Type value2, int index, boolean isSelected, boolean hasFocus) {
                if (index == -1 && value2 == Type.CUSTOM) {
                    this.setText(AddArgumentDialog.this.myCustomType);
                } else {
                    this.setText(value2.display);
                }
                this.setBackground(UIUtil.getListBackground((boolean)isSelected));
                this.setForeground(UIUtil.getListForeground((boolean)isSelected));
            }
        });
        this.myTypeComboBox.setEditable(false);
        this.myDefaultValueComboBox.setModel((ComboBoxModel<String>)this.myDefaultValueComboModel);
        if (existing2 != null) {
            this.setName(NavComponentHelperKt.getArgumentName(existing2));
            this.setType(NavComponentHelperKt.getTypeAttr(existing2));
            this.setNullable(NavComponentHelperKt.getNullable(existing2));
            this.setDefaultValue(NavComponentHelperKt.getDefaultValue(existing2));
            this.myOKAction.putValue("Name", "Update");
            this.setTitle("Update Argument Link");
        } else {
            ((CardLayout)this.myDefaultValuePanel.getLayout()).show(this.myDefaultValuePanel, "textDefaultValue");
            this.myOKAction.putValue("Name", "Add");
            this.setTitle("Add Argument Link");
        }
        this.myTypeComboBox.addActionListener(event -> {
            if ("comboBoxChanged".equals(event.getActionCommand())) {
                this.newTypeSelected();
            }
        });
        this.myDefaultValueComboBox.setRenderer((ListCellRenderer<String>)new ListCellRendererWrapper<String>(){

            public void customize(JList list, String value2, int index, boolean selected, boolean hasFocus) {
                this.setText(value2 == null ? "No default value" : value2);
            }
        });
    }

    void setType(@Nullable String typeStr) {
        if (typeStr == null) {
            this.myTypeComboBox.setSelectedItem((Object)Type.INFERRED);
        } else {
            boolean found = false;
            for (Type type : Type.values()) {
                if (!typeStr.equals(type.attrValue)) continue;
                this.myTypeComboBox.setSelectedItem((Object)type);
                found = true;
                break;
            }
            if (!found) {
                this.myCustomType = typeStr;
                this.myTypeComboBox.setSelectedItem((Object)Type.CUSTOM);
            }
        }
        this.updateUi();
    }

    private void newTypeSelected() {
        if (this.myTypeComboBox.getSelectedItem() == Type.CUSTOM) {
            Project project = this.myParent.getModel().getProject();
            PsiClass parcelable = ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)project), (String)"android.os.Parcelable");
            PsiClass current = null;
            if (this.myCustomType != null) {
                current = ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)project), (String)this.myCustomType);
            }
            TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)project).createInheritanceClassChooser("Select Parcelable Class", GlobalSearchScope.allScope((Project)project), parcelable, current);
            chooser.showDialog();
            PsiClass selection = chooser.getSelected();
            if (selection != null) {
                this.myCustomType = selection.getQualifiedName();
            } else {
                this.myTypeComboBox.setSelectedItem((Object)this.mySelectedType);
            }
        }
        this.updateUi();
    }

    private void updateUi() {
        Type newType = (Type)((Object)this.myTypeComboBox.getSelectedItem());
        if (newType != this.mySelectedType) {
            boolean nullable = newType == Type.STRING || newType == Type.CUSTOM;
            this.myNullableCheckBox.setEnabled(nullable);
            this.myNullableLabel.setEnabled(nullable);
            if (!nullable) {
                this.myNullableCheckBox.setSelected(false);
            }
            if (newType == Type.BOOLEAN) {
                ((CardLayout)this.myDefaultValuePanel.getLayout()).show(this.myDefaultValuePanel, "comboDefaultValue");
                this.myDefaultValueComboModel.update((List)Lists.newArrayList((Object[])new String[]{null, "true", "false"}));
            } else if (newType == Type.CUSTOM) {
                ((CardLayout)this.myDefaultValuePanel.getLayout()).show(this.myDefaultValuePanel, "comboDefaultValue");
                this.myDefaultValueComboModel.update((List)Lists.newArrayList((Object[])new String[]{null, "@null"}));
            } else {
                this.myDefaultValueTextField.setText("");
                ((CardLayout)this.myDefaultValuePanel.getLayout()).show(this.myDefaultValuePanel, "textDefaultValue");
            }
            this.mySelectedType = newType;
        }
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel jPanel = this.myContentPanel;
        if (jPanel == null) {
            AddArgumentDialog.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction()};
        if (actionArray == null) {
            AddArgumentDialog.$$$reportNull$$$0(2);
        }
        return actionArray;
    }

    @Nullable
    String getType() {
        Type selectedType = (Type)((Object)this.myTypeComboBox.getSelectedItem());
        return selectedType == Type.CUSTOM ? this.myCustomType : selectedType.attrValue;
    }

    @Nullable
    String getDefaultValue() {
        if (this.mySelectedType == Type.BOOLEAN || this.mySelectedType == Type.CUSTOM) {
            return (String)this.myDefaultValueComboBox.getSelectedItem();
        }
        return this.myDefaultValueTextField.getText();
    }

    void setDefaultValue(String defaultValue) {
        if (this.mySelectedType == Type.BOOLEAN || this.mySelectedType == Type.CUSTOM) {
            this.myDefaultValueComboBox.setSelectedItem(defaultValue);
        } else {
            this.myDefaultValueTextField.setText(defaultValue);
        }
    }

    boolean isNullable() {
        return this.myNullableCheckBox.isSelected();
    }

    void setNullable(boolean nullable) {
        this.myNullableCheckBox.setSelected(nullable);
    }

    String getName() {
        return this.myNameTextField.getText();
    }

    void setName(@Nullable String name) {
        this.myNameTextField.setText(name);
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String name = this.getName();
        if (name == null || name.isEmpty()) {
            return new ValidationInfo("Name must be set", (JComponent)this.myNameTextField);
        }
        if (this.myParent.getChildren().stream().anyMatch(c -> c != this.myExistingComponent && NavComponentHelperKt.isArgument(c) && NavComponentHelperKt.getArgumentName(c).equals(name))) {
            return new ValidationInfo("Name must be unique", (JComponent)this.myNameTextField);
        }
        String defaultValue = this.getDefaultValue();
        if (defaultValue != null && !defaultValue.isEmpty()) {
            Object type = this.myTypeComboBox.getSelectedItem();
            if (type == Type.LONG) {
                if (!defaultValue.endsWith("L")) {
                    defaultValue = defaultValue + "L";
                }
                try {
                    Long.parseLong(defaultValue.substring(0, defaultValue.length() - 1));
                }
                catch (NumberFormatException e) {
                    return new ValidationInfo("Long default values must be in the format '1234L'");
                }
            }
            if (type == Type.INTEGER) {
                try {
                    Integer.parseInt(defaultValue);
                }
                catch (NumberFormatException e) {
                    return new ValidationInfo("Default value must be an integer");
                }
            }
            if (type == Type.REFERENCE) {
                ResourceValue resourceValue2;
                ResourceUrl url = ResourceUrl.parse((String)defaultValue);
                if (url == null) {
                    return new ValidationInfo("Reference not correctly formatted");
                }
                ResourceResolver resourceResolver = this.myParent.getModel().getConfiguration().getResourceResolver();
                if (resourceResolver != null && (resourceValue2 = (ResourceValue)ApplicationManager.getApplication().runReadAction(() -> ResourceHelper.resolve((RenderResources)resourceResolver, url, (XmlElement)this.myParent.getTag()))) == null) {
                    return new ValidationInfo("Resource does not exist");
                }
            }
        }
        return null;
    }

    public void save() {
        WriteCommandAction.runWriteCommandAction((Project)this.myParent.getModel().getProject(), () -> {
            NlComponent realComponent = this.myExistingComponent;
            if (realComponent == null) {
                XmlTag tag = this.myParent.getTag().createChildTag("argument", null, null, false);
                realComponent = this.myParent.getModel().createComponent(null, tag, this.myParent, null, InsertType.CREATE);
            }
            NavComponentHelperKt.setArgumentName(realComponent, this.getName());
            NavComponentHelperKt.setTypeAttr(realComponent, this.getType());
            if (this.isNullable()) {
                NavComponentHelperKt.setNullable(realComponent, true);
            } else {
                realComponent.removeAttribute("http://schemas.android.com/apk/res-auto", "nullable");
            }
            String defaultValue = this.getDefaultValue();
            if (defaultValue != null && !defaultValue.isEmpty()) {
                if (this.myTypeComboBox.getSelectedItem() == Type.LONG && !defaultValue.endsWith("L")) {
                    defaultValue = defaultValue + "L";
                }
                NavComponentHelperKt.setDefaultValue(realComponent, defaultValue);
            } else {
                realComponent.removeAndroidAttribute("defaultValue");
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/naveditor/property/inspector/AddArgumentDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/naveditor/property/inspector/AddArgumentDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JPanel jPanel;
        JTextField jTextField2;
        JCheckBox jCheckBox;
        JBLabel jBLabel;
        JPanel jPanel2;
        this.myContentPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Name:");
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Type:");
        jPanel2.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setText("Default Value:");
        jPanel2.add((Component)jBLabel4, new GridConstraints(3, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myNullableLabel = jBLabel = new JBLabel();
        jBLabel.setText("Nullable:");
        jPanel2.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myNullableCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("");
        jPanel2.add((Component)jCheckBox, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myNameTextField = jTextField2 = new JTextField();
        jPanel2.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JComboBox jComboBox = new JComboBox();
        this.myTypeComboBox = jComboBox;
        jComboBox.setEditable(true);
        jPanel2.add(jComboBox, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myDefaultValuePanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.myDefaultValueComboBox = jComboBox2;
        jPanel.add(jComboBox2, "comboDefaultValue");
        this.myDefaultValueTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, "textDefaultValue");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private static enum Type {
        INFERRED("<inferred type>", null),
        INTEGER("Integer", "integer"),
        LONG("Long", "long"),
        BOOLEAN("Boolean", "boolean"),
        STRING("String", "string"),
        REFERENCE("Resource Reference", "reference"),
        CUSTOM("Custom Parcelable...", "custom");

        String display;
        String attrValue;

        private Type(String display2, String attrValue) {
            this.display = display2;
            this.attrValue = attrValue;
        }

        public String toString() {
            return this.display;
        }
    }
}

