/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.model;

import com.android.builder.model.BuildTypeContainer;
import com.android.ide.common.gradle.model.IdeVariant;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.module.Module;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManifestPlaceholderResolver {
    public static Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{(\\w+)\\}");
    private final ImmutableMap<String, Object> myPlaceholders;

    public ManifestPlaceholderResolver(@NotNull Module module) {
        if (module == null) {
            ManifestPlaceholderResolver.$$$reportNull$$$0(0);
        }
        AndroidModuleModel model = AndroidModuleModel.get(module);
        if (model != null) {
            ImmutableMap.Builder placeholdersBuilder = ImmutableMap.builder();
            IdeVariant selectedVariant = model.getSelectedVariant();
            BuildTypeContainer buildType = model.findBuildType(selectedVariant.getBuildType());
            if (buildType != null) {
                placeholdersBuilder.putAll(buildType.getBuildType().getManifestPlaceholders());
            }
            placeholdersBuilder.putAll(selectedVariant.getMergedFlavor().getManifestPlaceholders());
            this.myPlaceholders = placeholdersBuilder.build();
        } else {
            this.myPlaceholders = ImmutableMap.of();
        }
    }

    @NotNull
    public ImmutableMap<String, Object> getPlaceholders() {
        ImmutableMap<String, Object> immutableMap = this.myPlaceholders;
        if (immutableMap == null) {
            ManifestPlaceholderResolver.$$$reportNull$$$0(1);
        }
        return immutableMap;
    }

    @Nullable
    public String resolve(@Nullable String value2) {
        if (value2 == null) {
            return null;
        }
        if (this.myPlaceholders.isEmpty() || !value2.contains("${")) {
            return value2;
        }
        StringBuffer output = new StringBuffer();
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(value2);
        while (matcher.find()) {
            Object placeholderValue = this.myPlaceholders.get((Object)matcher.group(1));
            matcher.appendReplacement(output, placeholderValue != null ? Matcher.quoteReplacement(placeholderValue.toString()) : "$0");
        }
        matcher.appendTail(output);
        return output.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/model/ManifestPlaceholderResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/model/ManifestPlaceholderResolver";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

