/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellEnabledDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.logcat.AndroidLogcatReceiver;
import com.android.tools.idea.run.LoggingReceiver;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.intellij.execution.impl.ConsoleBuffer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidOutputReceiver;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
public final class AndroidLogcatService
implements AndroidDebugBridge.IDeviceChangeListener,
Disposable {
    private final Object myLock = new Object();
    @GuardedBy(value="myLock")
    private final Map<IDevice, AndroidLogcatReceiver> myLogReceivers = new HashMap<IDevice, AndroidLogcatReceiver>();
    @GuardedBy(value="myLock")
    private final Map<IDevice, LogcatBuffer> myLogBuffers = new HashMap<IDevice, LogcatBuffer>();
    @GuardedBy(value="myLock")
    private final Map<IDevice, ExecutorService> myExecutors = new HashMap<IDevice, ExecutorService>();
    @GuardedBy(value="myLock")
    private final Multimap<IDevice, LogcatListener> myDeviceToListenerMultimap = ArrayListMultimap.create();

    private static Logger getLog() {
        return Logger.getInstance(AndroidLogcatService.class);
    }

    @NotNull
    public static AndroidLogcatService getInstance() {
        AndroidLogcatService androidLogcatService = (AndroidLogcatService)ServiceManager.getService(AndroidLogcatService.class);
        if (androidLogcatService == null) {
            AndroidLogcatService.$$$reportNull$$$0(0);
        }
        return androidLogcatService;
    }

    AndroidLogcatService() {
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startReceiving(@NotNull IDevice device) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(1);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myLogReceivers.containsKey(device)) {
                return;
            }
            this.connect(device);
            AndroidLogcatReceiver receiver = this.newAndroidLogcatReceiver(device);
            this.myLogReceivers.put(device, receiver);
            this.myLogBuffers.put(device, new LogcatBuffer());
            this.myExecutors.get(device).submit(() -> AndroidLogcatService.executeLogcat((IShellEnabledDevice)device, receiver));
        }
    }

    @NotNull
    private AndroidLogcatReceiver newAndroidLogcatReceiver(final @NotNull IDevice device) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(2);
        }
        AndroidLogcatReceiver androidLogcatReceiver = new AndroidLogcatReceiver(device, new LogcatListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLogLineReceived(@NotNull LogCatMessage line) {
                if (line == null) {
                    1.$$$reportNull$$$0(0);
                }
                Object object = AndroidLogcatService.this.myLock;
                synchronized (object) {
                    AndroidLogcatService.this.myDeviceToListenerMultimap.get((Object)device).forEach(listener2 -> listener2.onLogLineReceived(line));
                    LogcatBuffer buffer = (LogcatBuffer)AndroidLogcatService.this.myLogBuffers.get(device);
                    if (buffer != null) {
                        buffer.addMessage(line);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/logcat/AndroidLogcatService$1", "onLogLineReceived"));
            }
        });
        if (androidLogcatReceiver == null) {
            AndroidLogcatService.$$$reportNull$$$0(3);
        }
        return androidLogcatReceiver;
    }

    private static void executeLogcat(@NotNull IShellEnabledDevice device, @NotNull AndroidLogcatReceiver receiver) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(4);
        }
        if (receiver == null) {
            AndroidLogcatService.$$$reportNull$$$0(5);
        }
        try {
            AndroidLogcatService.execute(device, AndroidLogcatService.supportsEpochFormatModifier(device) ? "logcat -v long -v epoch" : "logcat -v long", receiver, Duration.ZERO);
        }
        catch (Throwable throwable) {
            AndroidLogcatService.getLog().warn(throwable);
            String app = IdeInfo.getInstance().isAndroidStudio() ? "com.android.studio" : "com.jetbrains.idea";
            receiver.notifyLine(new LogCatHeader(Log.LogLevel.ERROR, 0, 0, app, "AndroidLogcatService", Instant.now()), throwable.toString());
        }
    }

    private static boolean supportsEpochFormatModifier(@NotNull IShellEnabledDevice device) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(6);
        }
        LogcatHelpReceiver receiver = new LogcatHelpReceiver();
        device.executeShellCommand("logcat --help", (IShellOutputReceiver)receiver, 10L, TimeUnit.SECONDS);
        return receiver.mySupportsEpochFormatModifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(@NotNull IDevice device) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(7);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myExecutors.containsKey(device)) {
                ThreadFactory factory = new ThreadFactoryBuilder().setNameFormat("logcat-" + device.getName()).build();
                this.myExecutors.put(device, Executors.newSingleThreadExecutor(factory));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect(@NotNull IDevice device) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(8);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.stopReceiving(device);
            this.myExecutors.remove(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopReceiving(@NotNull IDevice device) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(9);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myLogReceivers.containsKey(device)) {
                this.myLogReceivers.get(device).cancel();
                this.myLogReceivers.remove(device);
                this.myLogBuffers.remove(device);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLogcat(@NotNull IDevice device, @NotNull Project project) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(10);
        }
        if (project == null) {
            AndroidLogcatService.$$$reportNull$$$0(11);
        }
        Object object = this.myLock;
        synchronized (object) {
            ExecutorService executor = this.myExecutors.get(device);
            if (executor == null) {
                this.notifyThatLogcatWasCleared(device);
                return;
            }
            this.stopReceiving(device);
            executor.submit(() -> {
                try {
                    AndroidLogcatService.execute((IShellEnabledDevice)device, "logcat -c", new LoggingReceiver(AndroidLogcatService.getLog()), Duration.ofSeconds(5L));
                }
                catch (Exception exception) {
                    AndroidLogcatService.getLog().warn((Throwable)exception);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        String title = AndroidBundle.message("android.logcat.error.dialog.title", new Object[0]);
                        Messages.showErrorDialog((Project)project, (String)exception.toString(), (String)title);
                    });
                }
                this.notifyThatLogcatWasCleared(device);
            });
            this.startReceiving(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyThatLogcatWasCleared(@NotNull IDevice device) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(12);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myDeviceToListenerMultimap.get((Object)device).forEach(LogcatListener::onCleared);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NotNull IDevice device, @NotNull LogcatListener listener2, boolean addOldLogs) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(13);
        }
        if (listener2 == null) {
            AndroidLogcatService.$$$reportNull$$$0(14);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (addOldLogs && this.myLogBuffers.containsKey(device)) {
                for (LogCatMessage line : this.myLogBuffers.get(device).getMessages()) {
                    listener2.onLogLineReceived(line);
                }
            }
            this.myDeviceToListenerMultimap.put((Object)device, (Object)listener2);
            if (device.isOnline()) {
                this.startReceiving(device);
            }
        }
    }

    public void addListener(@NotNull IDevice device, @NotNull LogcatListener listener2) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(15);
        }
        if (listener2 == null) {
            AndroidLogcatService.$$$reportNull$$$0(16);
        }
        this.addListener(device, listener2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NotNull IDevice device, @NotNull LogcatListener listener2) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(17);
        }
        if (listener2 == null) {
            AndroidLogcatService.$$$reportNull$$$0(18);
        }
        Object object = this.myLock;
        synchronized (object) {
            Collection listeners = this.myDeviceToListenerMultimap.get((Object)device);
            if (listeners.isEmpty()) {
                return;
            }
            listeners.remove(listener2);
            if (listeners.isEmpty()) {
                this.stopReceiving(device);
            }
        }
    }

    public void deviceConnected(@NotNull IDevice device) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(19);
        }
        if (device.isOnline()) {
            this.startReceiving(device);
        }
    }

    public void deviceDisconnected(@NotNull IDevice device) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(20);
        }
        this.disconnect(device);
    }

    public void deviceChanged(@NotNull IDevice device, int changeMask) {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(21);
        }
        if (device.isOnline()) {
            this.startReceiving(device);
        } else {
            this.disconnect(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        Object object = this.myLock;
        synchronized (object) {
            for (AndroidLogcatReceiver receiver : this.myLogReceivers.values()) {
                receiver.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Disposer.dispose((Disposable)this);
        Object object = this.myLock;
        synchronized (object) {
            this.myExecutors.values().forEach(executor -> {
                try {
                    executor.shutdownNow();
                    executor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    AndroidLogcatService.getLog().info("Error shutting down executor", (Throwable)e);
                }
            });
        }
    }

    private static void execute(@NotNull IShellEnabledDevice device, @NotNull String command, @NotNull AndroidOutputReceiver receiver, @NotNull Duration duration) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if (device == null) {
            AndroidLogcatService.$$$reportNull$$$0(22);
        }
        if (command == null) {
            AndroidLogcatService.$$$reportNull$$$0(23);
        }
        if (receiver == null) {
            AndroidLogcatService.$$$reportNull$$$0(24);
        }
        if (duration == null) {
            AndroidLogcatService.$$$reportNull$$$0(25);
        }
        device.executeShellCommand(command, (IShellOutputReceiver)receiver, duration.toMillis(), TimeUnit.MILLISECONDS);
        if (receiver.isCancelled()) {
            return;
        }
        receiver.invalidate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/logcat/AndroidLogcatService";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 5: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/logcat/AndroidLogcatService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "newAndroidLogcatReceiver";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startReceiving";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "newAndroidLogcatReceiver";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "executeLogcat";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "supportsEpochFormatModifier";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "disconnect";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "stopReceiving";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "clearLogcat";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "notifyThatLogcatWasCleared";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "deviceConnected";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "deviceDisconnected";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "deviceChanged";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class LogcatHelpReceiver
    extends MultiLineReceiver {
        private boolean mySupportsEpochFormatModifier;
        private boolean myCancelled;

        private LogcatHelpReceiver() {
        }

        public void processNewLines(@NotNull String[] lines) {
            if (lines == null) {
                LogcatHelpReceiver.$$$reportNull$$$0(0);
            }
            if (this.mySupportsEpochFormatModifier) {
                this.myCancelled = true;
                return;
            }
            this.mySupportsEpochFormatModifier = Arrays.stream(lines).anyMatch(line -> line.contains("epoch"));
        }

        public boolean isCancelled() {
            return this.myCancelled;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/android/tools/idea/logcat/AndroidLogcatService$LogcatHelpReceiver", "processNewLines"));
        }
    }

    public static interface LogcatListener {
        default public void onLogLineReceived(@NotNull LogCatMessage line) {
            if (line == null) {
                LogcatListener.$$$reportNull$$$0(0);
            }
        }

        default public void onCleared() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/logcat/AndroidLogcatService$LogcatListener", "onLogLineReceived"));
        }
    }

    private static class LogcatBuffer {
        private int myBufferSize;
        private final LinkedList<LogCatMessage> myMessages = new LinkedList();

        private LogcatBuffer() {
        }

        public void addMessage(@NotNull LogCatMessage message) {
            if (message == null) {
                LogcatBuffer.$$$reportNull$$$0(0);
            }
            this.myMessages.add(message);
            this.myBufferSize += message.getMessage().length();
            if (ConsoleBuffer.useCycleBuffer()) {
                while (this.myBufferSize > ConsoleBuffer.getCycleBufferSize()) {
                    this.myBufferSize -= this.myMessages.removeFirst().getMessage().length();
                }
            }
        }

        @NotNull
        public List<LogCatMessage> getMessages() {
            LinkedList<LogCatMessage> linkedList = this.myMessages;
            if (linkedList == null) {
                LogcatBuffer.$$$reportNull$$$0(1);
            }
            return linkedList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/logcat/AndroidLogcatService$LogcatBuffer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/logcat/AndroidLogcatService$LogcatBuffer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessages";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addMessage";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

