/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.builder.model.LintOptions;
import com.android.ide.common.gradle.model.IdeAndroidProject;
import com.android.tools.analytics.Anonymizer;
import com.android.tools.analytics.CommonMetricsData;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.lint.LintIdeAnalytics$WhenMappings;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.tools.idea.util.FileExtensions;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Severity;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LintAction;
import com.google.wireless.android.sdk.stats.LintIssueId;
import com.google.wireless.android.sdk.stats.LintPerformance;
import com.google.wireless.android.sdk.stats.LintSession;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.inspections.lint.ProblemData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002JV\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\b2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2&\u0010\r\u001a\"\u0012\u0004\u0012\u00020\u000e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\b\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u000fH\u0002J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eJX\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2&\u0010\r\u001a\"\u0012\u0004\u0012\u00020\u000e\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\b\u0018\u00010\bJ:\u0010\"\u001a\u00020\u001b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\"\u0010$\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0%j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t`&H\u0002J<\u0010'\u001a\u00020\u001b2\"\u0010$\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0%j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t`&2\u0006\u0010(\u001a\u00020\u00062\u0006\u0010)\u001a\u00020*H\u0002J\f\u0010+\u001a\u00020**\u00020,H\u0002J\f\u0010+\u001a\u00020**\u00020-H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/android/tools/idea/lint/LintIdeAnalytics;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "computeApplicationId", "", "computeIssueData", "", "Lcom/google/wireless/android/sdk/stats/LintIssueId$Builder;", "warnings1", "", "Lorg/jetbrains/android/inspections/lint/ProblemData;", "warnings2", "Lcom/android/tools/lint/detector/api/Issue;", "Ljava/io/File;", "severityModule", "Lcom/intellij/openapi/module/Module;", "computePerformance", "Lcom/google/wireless/android/sdk/stats/LintPerformance;", "driver", "Lcom/android/tools/lint/client/api/LintDriver;", "singleFileAnalysis", "", "computeProjectId", "projectPath", "logFeedback", "", "issue", "feedback", "Lcom/google/wireless/android/sdk/stats/LintAction$LintFeedback;", "logSession", "type", "Lcom/google/wireless/android/sdk/stats/LintSession$AnalysisType;", "recordIssueData", "warnings", "map", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "recordSeverityOverride", "id", "lintSeverity", "Lcom/google/wireless/android/sdk/stats/LintIssueId$LintSeverity;", "toAnalyticsSeverity", "Lcom/android/tools/lint/detector/api/Severity;", "", "intellij.android.core"})
public final class LintIdeAnalytics {
    private final Project project;

    public final void logFeedback(@NotNull String issue2, @NotNull LintAction.LintFeedback feedback) {
        LintAction.Builder builder;
        String it;
        String string;
        AndroidStudioEvent.Builder builder2;
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)feedback, (String)"feedback");
        AndroidStudioEvent.Builder $receiver = builder2 = AndroidStudioEvent.newBuilder();
        boolean bl = false;
        $receiver.setKind(AndroidStudioEvent.EventKind.LINT_ACTION);
        String string2 = this.computeProjectId(this.project);
        if (string2 != null) {
            it = string = string2;
            boolean bl2 = false;
            $receiver.setProjectId(it);
        }
        String string3 = this.computeApplicationId(this.project);
        if (string3 != null) {
            it = string = string3;
            boolean bl3 = false;
            $receiver.setRawProjectId(it);
        }
        LintAction.Builder $receiver2 = builder = LintAction.newBuilder();
        boolean bl4 = false;
        $receiver2.setIssueId(issue2);
        $receiver2.setLintFeedback(feedback);
        LintAction action2 = builder.build();
        $receiver.setLintAction(action2);
        AndroidStudioEvent.Builder builder3 = builder2;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder3, (String)"AndroidStudioEvent.newBu\u2026lintAction = action\n    }");
        AndroidStudioEvent.Builder event = UsageTrackerUtils.withProjectId(builder3, this.project);
        UsageTracker.log((AndroidStudioEvent.Builder)event);
    }

    public final void logSession(@NotNull LintSession.AnalysisType type, @NotNull LintDriver driver, @Nullable Module severityModule, @Nullable List<? extends ProblemData> warnings1, @Nullable Map<Issue, ? extends Map<File, ? extends List<? extends ProblemData>>> warnings2) {
        AndroidStudioEvent.Builder builder;
        LintSession.Builder builder2;
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)driver, (String)"driver");
        if (this.project.isDisposed()) {
            return;
        }
        LintSession.Builder $receiver = builder2 = LintSession.newBuilder();
        boolean bl = false;
        $receiver.setAnalysisType(type);
        $receiver.setProjectId(this.computeProjectId(this.project));
        $receiver.setLintPerformance(this.computePerformance(driver, type == LintSession.AnalysisType.IDE_FILE));
        $receiver.setBaselineEnabled(driver.getBaseline() != null);
        $receiver.setIncludingGeneratedSources(driver.getCheckGeneratedSources());
        $receiver.setIncludingTestSources(driver.getCheckTestSources());
        $receiver.setIncludingDependencies(driver.getCheckDependencies());
        for (LintIssueId.Builder issueBuilder : this.computeIssueData(warnings1, warnings2, severityModule).values()) {
            $receiver.addIssueIds(issueBuilder);
        }
        LintSession session = builder2.build();
        AndroidStudioEvent.Builder $receiver2 = builder = AndroidStudioEvent.newBuilder();
        boolean bl2 = false;
        $receiver2.setKind(AndroidStudioEvent.EventKind.LINT_SESSION);
        $receiver2.setLintSession(session);
        $receiver2.setJavaProcessStats(CommonMetricsData.getJavaProcessStats());
        $receiver2.setJvmDetails(CommonMetricsData.getJvmDetails());
        AndroidStudioEvent.Builder builder3 = builder;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder3, (String)"AndroidStudioEvent.newBu\u2026ricsData.jvmDetails\n    }");
        AndroidStudioEvent.Builder event = UsageTrackerUtils.withProjectId(builder3, this.project);
        UsageTracker.log((AndroidStudioEvent.Builder)event);
    }

    private final LintPerformance computePerformance(LintDriver driver, boolean singleFileAnalysis) {
        LintPerformance.Builder builder;
        LintPerformance.Builder $receiver = builder = LintPerformance.newBuilder();
        boolean bl = false;
        $receiver.setAnalysisTimeMs(System.currentTimeMillis() - driver.getAnalysisStartTime());
        $receiver.setFileCount((long)driver.getFileCount());
        if (!singleFileAnalysis) {
            $receiver.setModuleCount((long)driver.getModuleCount());
            $receiver.setJavaSourceCount((long)driver.getJavaFileCount());
            $receiver.setKotlinSourceCount((long)driver.getKotlinFileCount());
            $receiver.setResourceFileCount((long)driver.getResourceFileCount());
            $receiver.setTestSourceCount((long)driver.getTestSourceCount());
        }
        LintPerformance lintPerformance = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)lintPerformance, (String)"LintPerformance.newBuild\u2026g()\n      }\n    }.build()");
        return lintPerformance;
    }

    private final void recordSeverityOverride(HashMap<String, LintIssueId.Builder> map2, String id, LintIssueId.LintSeverity lintSeverity) {
        LintIssueId.Builder builder;
        LintIssueId.Builder builder2 = map2.get(id);
        if (builder2 != null) {
            return;
        }
        LintIssueId.Builder $receiver = builder = LintIssueId.newBuilder();
        boolean bl = false;
        Map map3 = map2;
        String string = id;
        LintIssueId.Builder builder3 = $receiver;
        Intrinsics.checkExpressionValueIsNotNull((Object)builder3, (String)"this");
        LintIssueId.Builder builder4 = builder3;
        map3.put(string, builder4);
        $receiver.setIssueId(id);
        $receiver.setCount(0L);
        $receiver.setSeverity(lintSeverity);
    }

    private final LintIssueId.LintSeverity toAnalyticsSeverity(@NotNull Severity $receiver) {
        LintIssueId.LintSeverity lintSeverity;
        switch (LintIdeAnalytics$WhenMappings.$EnumSwitchMapping$0[$receiver.ordinal()]) {
            case 1: {
                lintSeverity = LintIssueId.LintSeverity.FATAL_SEVERITY;
                break;
            }
            case 2: {
                lintSeverity = LintIssueId.LintSeverity.ERROR_SEVERITY;
                break;
            }
            case 3: {
                lintSeverity = LintIssueId.LintSeverity.WARNING_SEVERITY;
                break;
            }
            case 4: {
                lintSeverity = LintIssueId.LintSeverity.INFORMATIONAL_SEVERITY;
                break;
            }
            case 5: {
                lintSeverity = LintIssueId.LintSeverity.IGNORE_SEVERITY;
                break;
            }
            default: {
                lintSeverity = LintIssueId.LintSeverity.UNKNOWN_SEVERITY;
            }
        }
        return lintSeverity;
    }

    private final LintIssueId.LintSeverity toAnalyticsSeverity(int $receiver) {
        LintIssueId.LintSeverity lintSeverity;
        switch ($receiver) {
            case 1: {
                lintSeverity = LintIssueId.LintSeverity.FATAL_SEVERITY;
                break;
            }
            case 2: {
                lintSeverity = LintIssueId.LintSeverity.ERROR_SEVERITY;
                break;
            }
            case 3: {
                lintSeverity = LintIssueId.LintSeverity.WARNING_SEVERITY;
                break;
            }
            case 4: {
                lintSeverity = LintIssueId.LintSeverity.INFORMATIONAL_SEVERITY;
                break;
            }
            case 5: {
                lintSeverity = LintIssueId.LintSeverity.IGNORE_SEVERITY;
                break;
            }
            default: {
                lintSeverity = LintIssueId.LintSeverity.UNKNOWN_SEVERITY;
            }
        }
        return lintSeverity;
    }

    private final Map<String, LintIssueId.Builder> computeIssueData(List<? extends ProblemData> warnings1, Map<Issue, ? extends Map<File, ? extends List<? extends ProblemData>>> warnings2, Module severityModule) {
        AndroidModuleModel androidModuleModel;
        HashMap<String, LintIssueId.Builder> map2 = new HashMap<String, LintIssueId.Builder>(344);
        if (warnings1 != null) {
            this.recordIssueData(warnings1, map2);
        }
        if (warnings2 != null) {
            for (Map<File, ? extends List<? extends ProblemData>> map3 : warnings2.values()) {
                for (List<? extends ProblemData> list : map3.values()) {
                    this.recordIssueData(list, map2);
                }
            }
        }
        if (severityModule != null && (androidModuleModel = AndroidModuleModel.get(severityModule)) != null) {
            try {
                LintOptions lintOptions;
                IdeAndroidProject ideAndroidProject = androidModuleModel.getAndroidProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)ideAndroidProject, (String)"model.androidProject");
                IdeAndroidProject gradleModel = ideAndroidProject;
                LintOptions lintOptions2 = lintOptions = gradleModel.getLintOptions();
                Intrinsics.checkExpressionValueIsNotNull((Object)lintOptions2, (String)"lintOptions");
                Map overrides = lintOptions2.getSeverityOverrides();
                if (overrides != null && !overrides.isEmpty()) {
                    Iterator iterator = overrides.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry;
                        Map.Entry entry2 = entry = iterator.next();
                        String id = (String)entry2.getKey();
                        entry2 = entry;
                        Integer severity = (Integer)entry2.getValue();
                        String string = id;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id");
                        Integer n = severity;
                        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"severity");
                        this.recordSeverityOverride(map2, string, this.toAnalyticsSeverity(n));
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return map2;
    }

    private final void recordIssueData(List<? extends ProblemData> warnings, HashMap<String, LintIssueId.Builder> map2) {
        for (ProblemData problemData : warnings) {
            LintIssueId.Builder issueBuilder;
            Issue issue2;
            Intrinsics.checkExpressionValueIsNotNull((Object)problemData.getIssue(), (String)"warning.issue");
            String id = issue2.getId();
            LintIssueId.Builder builder = map2.get(id);
            if (builder == null) {
                LintIssueId.Builder builder2;
                LintIssueId.Builder builder3;
                LintIdeAnalytics lintIdeAnalytics;
                LintIdeAnalytics $receiver = lintIdeAnalytics = this;
                boolean bl = false;
                LintIssueId.Builder $receiver2 = builder3 = LintIssueId.newBuilder();
                boolean bl2 = false;
                Map map3 = map2;
                String string = id;
                Intrinsics.checkExpressionValueIsNotNull((Object)$receiver2, (String)"this");
                map3.put(string, builder2);
                $receiver2.setIssueId(issue2.getId());
                Severity configuredSeverity = problemData.getConfiguredSeverity();
                $receiver2.setSeverity(configuredSeverity == null || configuredSeverity == issue2.getDefaultSeverity() ? LintIssueId.LintSeverity.DEFAULT_SEVERITY : $receiver.toAnalyticsSeverity(configuredSeverity));
                builder = builder3;
            }
            LintIssueId.Builder builder2 = issueBuilder = builder;
            Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"issueBuilder");
            builder2.setCount(issueBuilder.getCount() + 1L);
        }
    }

    private final String computeApplicationId(Project project) {
        ModuleManager moduleManager;
        ModuleManager moduleManager2 = moduleManager = ModuleManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager2, (String)"moduleManager");
        for (Module module : moduleManager2.getModules()) {
            AndroidModuleModel androidModel = AndroidModuleModel.get(module);
            if (androidModel == null) continue;
            IdeAndroidProject ideAndroidProject = androidModel.getAndroidProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)ideAndroidProject, (String)"androidModel.androidProject");
            if (ideAndroidProject.getProjectType() != 0) continue;
            return androidModel.getApplicationId();
        }
        return null;
    }

    private final String computeProjectId(Project project) {
        VirtualFile virtualFile = project.getBaseDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"project.baseDir");
        return this.computeProjectId(FileExtensions.toIoFile(virtualFile));
    }

    private final String computeProjectId(File projectPath) {
        String string;
        if (projectPath == null) {
            return null;
        }
        try {
            string = Anonymizer.anonymizeUtf8((ILogger)((ILogger)new NullLogger()), (String)projectPath.getAbsolutePath());
        }
        catch (IOException e) {
            string = "*ANONYMIZATION_ERROR*";
        }
        return string;
    }

    public LintIdeAnalytics(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
    }
}

