/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.variant.view;

import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacetConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.ModuleTypeComparator;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.android.tools.idea.gradle.variant.conflict.ConflictResolution;
import com.android.tools.idea.gradle.variant.conflict.ConflictSet;
import com.android.tools.idea.gradle.variant.view.BuildVariantUpdater;
import com.android.tools.idea.gradle.variant.view.ModuleVariantsInfoGraph;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildVariantView {
    private static final Object[] TABLE_COLUMN_NAMES = new Object[]{"Module", "Build Variant"};
    private static final int MODULE_COLUMN_INDEX = 0;
    private static final int VARIANT_COLUMN_INDEX = 1;
    private static final Color CONFLICT_CELL_BACKGROUND = MessageType.ERROR.getPopupBackground();
    private final Project myProject;
    private BuildVariantUpdater myUpdater;
    private JPanel myToolWindowPanel;
    private JBTable myVariantsTable;
    private JPanel myNotificationPanel;
    private final List<Conflict> myConflicts;

    @NotNull
    public static BuildVariantView getInstance(@NotNull Project project) {
        if (project == null) {
            BuildVariantView.$$$reportNull$$$0(0);
        }
        BuildVariantView buildVariantView = (BuildVariantView)ServiceManager.getService((Project)project, BuildVariantView.class);
        if (buildVariantView == null) {
            BuildVariantView.$$$reportNull$$$0(1);
        }
        return buildVariantView;
    }

    public BuildVariantView(@NotNull Project project) {
        if (project == null) {
            BuildVariantView.$$$reportNull$$$0(2);
        }
        this(project, BuildVariantUpdater.getInstance(project));
    }

    @VisibleForTesting
    public BuildVariantView(@NotNull Project project, @NotNull BuildVariantUpdater updater) {
        if (project == null) {
            BuildVariantView.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            BuildVariantView.$$$reportNull$$$0(4);
        }
        this.$$$setupUI$$$();
        this.myConflicts = new ArrayList<Conflict>();
        this.myProject = project;
        this.myUpdater = updater;
        this.myUpdater.addSelectionChangeListener(this::invokeListeners);
        ((JComponent)this.myVariantsTable.getParent().getParent()).setBorder((Border)JBUI.Borders.empty());
    }

    private void createUIComponents() {
        this.myVariantsTable = new BuildVariantTable();
        new TableSpeedSearch((JTable)this.myVariantsTable);
        this.myNotificationPanel = new NotificationPanel();
        this.myNotificationPanel.setVisible(false);
    }

    public void createToolWindowContent(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            BuildVariantView.$$$reportNull$$$0(5);
        }
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        Content content = contentFactory.createContent((JComponent)this.myToolWindowPanel, "", false);
        toolWindow.getContentManager().addContent(content);
        this.updateContents();
    }

    public void updateContents() {
        GradleSyncState gradleSyncState = GradleSyncState.getInstance(this.myProject);
        if (gradleSyncState.isSyncInProgress() && !gradleSyncState.isSyncSkipped()) {
            this.projectImportStarted();
            return;
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        ArrayList<BuildVariantItem[]> variantNamesPerRow = new ArrayList<BuildVariantItem[]>();
        for (Module module : this.getGradleModulesWithAndroidProjects()) {
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            NdkFacet ndkFacet = NdkFacet.getInstance(module);
            assert (androidFacet != null || ndkFacet != null);
            String variantName = ndkFacet != null ? ((NdkFacetConfiguration)ndkFacet.getConfiguration()).SELECTED_BUILD_VARIANT : androidFacet.getProperties().SELECTED_BUILD_VARIANT;
            BuildVariantItem[] variantNames = BuildVariantView.getVariantItems(module);
            if (variantNames != null) {
                variantNamesPerRow.add(variantNames);
            }
            if (variantName == null) continue;
            Object[] row = new Object[]{module, variantName};
            rows.add(row);
        }
        Runnable setModelTask = () -> this.getVariantsTable().setModel(rows, variantNamesPerRow);
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            setModelTask.run();
        } else {
            application.invokeLater(setModelTask);
        }
    }

    public void projectImportStarted() {
        this.getVariantsTable().setLoading(true);
    }

    @NotNull
    private List<Module> getGradleModulesWithAndroidProjects() {
        ArrayList<Module> gradleModules = new ArrayList<Module>();
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            AndroidFacet androidFacet = AndroidFacet.getInstance(module);
            if (androidFacet != null && androidFacet.requiresAndroidModel() && ((AndroidFacetConfiguration)androidFacet.getConfiguration()).getModel() != null) {
                gradleModules.add(module);
                continue;
            }
            NdkFacet ndkFacet = NdkFacet.getInstance(module);
            if (ndkFacet == null || ndkFacet.getNdkModuleModel() == null) continue;
            gradleModules.add(module);
        }
        if (!gradleModules.isEmpty()) {
            gradleModules.sort(ModuleTypeComparator.INSTANCE);
            ArrayList<Module> arrayList = gradleModules;
            if (arrayList == null) {
                BuildVariantView.$$$reportNull$$$0(6);
            }
            return arrayList;
        }
        List<Module> list = Collections.emptyList();
        if (list == null) {
            BuildVariantView.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private BuildVariantTable getVariantsTable() {
        BuildVariantTable buildVariantTable = (BuildVariantTable)this.myVariantsTable;
        if (buildVariantTable == null) {
            BuildVariantView.$$$reportNull$$$0(8);
        }
        return buildVariantTable;
    }

    @Nullable
    private static BuildVariantItem[] getVariantItems(@NotNull Module module) {
        Collection<String> variantNames;
        if (module == null) {
            BuildVariantView.$$$reportNull$$$0(9);
        }
        if ((variantNames = BuildVariantView.getVariantNames(module)) == null) {
            return null;
        }
        Object[] items2 = new BuildVariantItem[variantNames.size()];
        int i2 = 0;
        for (String name : variantNames) {
            items2[i2++] = new BuildVariantItem(module.getName(), name);
        }
        Arrays.sort(items2);
        return items2;
    }

    @Nullable
    private static Collection<String> getVariantNames(@NotNull Module module) {
        NdkModuleModel ndkModuleModel;
        if (module == null) {
            BuildVariantView.$$$reportNull$$$0(10);
        }
        if ((ndkModuleModel = NdkModuleModel.get(module)) != null) {
            return ndkModuleModel.getNdkVariantNames();
        }
        AndroidModuleModel androidModel = AndroidModuleModel.get(module);
        if (androidModel != null) {
            return androidModel.getVariantNames();
        }
        return null;
    }

    public void updateContents(@NotNull List<Conflict> conflicts) {
        if (conflicts == null) {
            BuildVariantView.$$$reportNull$$$0(11);
        }
        this.myNotificationPanel.setVisible(!conflicts.isEmpty());
        ((NotificationPanel)this.myNotificationPanel).myCurrentConflictIndex = -1;
        this.myConflicts.clear();
        this.myConflicts.addAll(conflicts);
        this.updateContents();
    }

    public void findAndSelect(@NotNull Module module) {
        if (module == null) {
            BuildVariantView.$$$reportNull$$$0(12);
        }
        this.findAndSelect(module, 0);
    }

    public void findAndSelectVariantEditor(@NotNull Module module) {
        if (module == null) {
            BuildVariantView.$$$reportNull$$$0(13);
        }
        this.findAndSelect(module, 1);
    }

    private void findAndSelect(@NotNull Module module, int columnIndex) {
        if (module == null) {
            BuildVariantView.$$$reportNull$$$0(14);
        }
        int rowCount = this.myVariantsTable.getRowCount();
        for (int row = 0; row < rowCount; ++row) {
            if (!module.equals(this.myVariantsTable.getValueAt(row, 0))) continue;
            this.myVariantsTable.getSelectionModel().setSelectionInterval(row, row);
            this.myVariantsTable.getColumnModel().getSelectionModel().setSelectionInterval(columnIndex, columnIndex);
            TableUtil.scrollSelectionToVisible((JTable)this.myVariantsTable);
            this.myVariantsTable.requestFocusInWindow();
            break;
        }
    }

    private void invokeListeners() {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            this.updateContents();
        } else {
            application.invokeLater(this::updateContents);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/variant/view/BuildVariantView";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/variant/view/BuildVariantView";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradleModulesWithAndroidProjects";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariantsTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createToolWindowContent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getVariantItems";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getVariantNames";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateContents";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findAndSelect";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findAndSelectVariantEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myToolWindowPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        JBTable jBTable = this.myVariantsTable;
        jBTable.setCellSelectionEnabled(true);
        jBScrollPane.setViewportView((Component)jBTable);
        JPanel jPanel2 = this.myNotificationPanel;
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myToolWindowPanel;
    }

    private static class ModuleTableCell
    extends AbstractTableCellEditor
    implements TableCellRenderer {
        private static final Border EMPTY_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        @Nullable
        private Conflict myConflict;
        private JPanel myPanel;
        private JLabel myModuleNameLabel = new JLabel();
        private JPanel myButtonsPanel;
        private JButton myInfoButton;
        private JButton myFixButton;
        private Object myValue;

        ModuleTableCell() {
            this.myModuleNameLabel.setOpaque(false);
            this.myInfoButton = ModuleTableCell.createButton(AllIcons.General.BalloonInformation);
            this.myInfoButton.setToolTipText("More info");
            this.myInfoButton.addActionListener(e -> {
                if (this.myValue instanceof Module) {
                    Module module = (Module)this.myValue;
                    ModuleVariantsInfoGraph dialog = new ModuleVariantsInfoGraph(module);
                    dialog.show();
                }
            });
            this.myFixButton = ModuleTableCell.createButton(AllIcons.Actions.QuickfixBulb);
            this.myFixButton.setToolTipText("Fix problem");
            this.myFixButton.addActionListener(e -> {
                if (this.myConflict != null) {
                    Project project = this.myConflict.getSource().getProject();
                    boolean solved = ConflictResolution.solveSelectionConflict(this.myConflict);
                    if (solved) {
                        ConflictSet conflicts = ConflictSet.findConflicts(project);
                        conflicts.showSelectionConflicts();
                    }
                }
                this.stopCellEditing();
            });
            this.myButtonsPanel = new JPanel();
            this.myButtonsPanel.setOpaque(false);
            this.myButtonsPanel.add(this.myInfoButton);
            this.myButtonsPanel.add(this.myFixButton);
            this.myPanel = new JPanel(new BorderLayout()){

                @Override
                public String getToolTipText(MouseEvent e) {
                    String toolTip = ModuleTableCell.getToolTipTextIfUnderX(myModuleNameLabel, e.getX());
                    if (toolTip != null) {
                        return toolTip;
                    }
                    int x = e.getX() - myButtonsPanel.getX();
                    toolTip = ModuleTableCell.getToolTipTextIfUnderX(myInfoButton, x);
                    if (toolTip != null) {
                        return toolTip;
                    }
                    toolTip = ModuleTableCell.getToolTipTextIfUnderX(myFixButton, x);
                    if (toolTip != null) {
                        return toolTip;
                    }
                    return super.getToolTipText(e);
                }
            };
            this.myPanel.add((Component)this.myModuleNameLabel, "Center");
            this.myPanel.add((Component)this.myButtonsPanel, "East");
        }

        @NotNull
        private static JButton createButton(@NotNull Icon icon) {
            if (icon == null) {
                ModuleTableCell.$$$reportNull$$$0(0);
            }
            JButton button = new JButton(icon);
            button.setBorder(null);
            button.setBorderPainted(false);
            button.setContentAreaFilled(false);
            JButton jButton = button;
            if (jButton == null) {
                ModuleTableCell.$$$reportNull$$$0(1);
            }
            return jButton;
        }

        @Nullable
        private static String getToolTipTextIfUnderX(@NotNull JComponent c, int x) {
            if (c == null) {
                ModuleTableCell.$$$reportNull$$$0(2);
            }
            if (c.isVisible() && x >= c.getX() && x <= c.getX() + c.getWidth()) {
                return c.getToolTipText();
            }
            return null;
        }

        public Component getTableCellEditorComponent(JTable table2, Object value2, boolean isSelected, int row, int column) {
            this.setUpComponent(table2, value2, true, true, row);
            return this.myPanel;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setUpComponent(table2, value2, isSelected, hasFocus, row);
            return this.myPanel;
        }

        private void setUpComponent(@NotNull JTable table2, @Nullable Object value2, boolean isSelected, boolean hasFocus, int row) {
            Color background;
            Module module;
            if (table2 == null) {
                ModuleTableCell.$$$reportNull$$$0(3);
            }
            this.myValue = value2;
            String moduleName = null;
            Icon moduleIcon = null;
            boolean isAndriodGradleModule = false;
            if (value2 instanceof Module && !(module = (Module)value2).isDisposed()) {
                moduleName = module.getName();
                moduleIcon = GradleUtil.getModuleIcon(module);
                isAndriodGradleModule = AndroidModuleModel.get(module) != null;
            }
            this.myModuleNameLabel.setText(moduleName == null ? "" : moduleName);
            this.myModuleNameLabel.setIcon(moduleIcon);
            Color color = background = isSelected ? table2.getSelectionBackground() : table2.getBackground();
            if (isAndriodGradleModule) {
                this.myInfoButton.setVisible(true);
                this.myConflict = ((BuildVariantTable)((Object)table2)).findConflict(row);
                this.myModuleNameLabel.setToolTipText(this.myConflict != null ? this.myConflict.toString() : null);
                this.myFixButton.setVisible(this.myConflict != null);
                if (this.myConflict != null) {
                    background = CONFLICT_CELL_BACKGROUND;
                }
            } else {
                this.myInfoButton.setVisible(false);
                this.myFixButton.setVisible(false);
            }
            this.myPanel.setBackground(background);
            Border border = hasFocus ? UIUtil.getTableFocusCellHighlightBorder() : EMPTY_BORDER;
            this.myPanel.setBorder(border);
        }

        public Object getCellEditorValue() {
            return this.myValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/variant/view/BuildVariantView$ModuleTableCell";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/variant/view/BuildVariantView$ModuleTableCell";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createButton";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createButton";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getToolTipTextIfUnderX";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setUpComponent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class VariantsCellRenderer
    extends DefaultTableCellRenderer {
        private VariantsCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table2, value2, isSelected, hasFocus, row, column);
            if (c instanceof JLabel) {
                JLabel component = (JLabel)c;
                Color background = isSelected ? table2.getSelectionBackground() : table2.getBackground();
                Conflict conflictFound = ((BuildVariantTable)((Object)table2)).findConflict(row);
                if (conflictFound != null) {
                    background = CONFLICT_CELL_BACKGROUND;
                }
                component.setBackground(background);
                String toolTip = conflictFound != null ? conflictFound.toString() : null;
                component.setToolTipText(toolTip);
                component.setBorder(BorderFactory.createCompoundBorder(component.getBorder(), BorderFactory.createEmptyBorder(3, 2, 4, 2)));
            }
            return c;
        }
    }

    private static class BuildVariantTableModel
    extends DefaultTableModel {
        BuildVariantTableModel(List<Object[]> rows) {
            super((Object[][])rows.toArray((T[])new Object[rows.size()][TABLE_COLUMN_NAMES.length]), TABLE_COLUMN_NAMES);
        }
    }

    private class BuildVariantTable
    extends JBTable {
        private boolean myLoading;
        private final List<TableCellEditor> myCellEditors;
        private final ModuleTableCell myModuleCellRenderer;
        private final ModuleTableCell myModuleCellEditor;
        private final VariantsCellRenderer myVariantsCellRenderer;

        BuildVariantTable() {
            super((TableModel)new BuildVariantTableModel(Collections.emptyList()));
            this.myCellEditors = new ArrayList<TableCellEditor>();
            this.myModuleCellRenderer = new ModuleTableCell();
            this.myModuleCellEditor = new ModuleTableCell();
            this.myVariantsCellRenderer = new VariantsCellRenderer();
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    Component editorComponent;
                    int column = BuildVariantTable.this.getSelectedColumn();
                    int row = BuildVariantTable.this.getSelectedRow();
                    if (column == 1 && row >= 0 && e.getKeyCode() == 113 && BuildVariantTable.this.editCellAt(row, column) && (editorComponent = BuildVariantTable.this.getEditorComponent()) instanceof ComboBox) {
                        editorComponent.requestFocusInWindow();
                        ((ComboBox)editorComponent).showPopup();
                    }
                }
            });
        }

        @Nullable
        Conflict findConflict(int row) {
            for (Conflict conflict : BuildVariantView.this.myConflicts) {
                Object module = this.getValueAt(row, 0);
                if (!conflict.getSource().equals(module)) continue;
                return conflict;
            }
            return null;
        }

        public boolean isCellEditable(int row, int column) {
            return true;
        }

        void setLoading(boolean loading) {
            this.myLoading = loading;
            this.setPaintBusy(this.myLoading);
            this.clearContents();
            String text = this.myLoading ? "Loading..." : "Nothing to Show";
            this.getEmptyText().setText(text);
        }

        private void clearContents() {
            this.setModel(new BuildVariantTableModel(Collections.emptyList()));
            this.myCellEditors.clear();
        }

        void setModel(@NotNull List<Object[]> rows, @NotNull List<BuildVariantItem[]> variantNamesPerRow) {
            if (rows == null) {
                BuildVariantTable.$$$reportNull$$$0(0);
            }
            if (variantNamesPerRow == null) {
                BuildVariantTable.$$$reportNull$$$0(1);
            }
            this.setLoading(false);
            if (rows.isEmpty()) {
                this.setModel(new BuildVariantTableModel(rows));
                return;
            }
            boolean hasVariants = !variantNamesPerRow.isEmpty();
            List<Object> content = hasVariants ? rows : Collections.emptyList();
            this.setModel(new BuildVariantTableModel(content));
            this.addBuildVariants(variantNamesPerRow);
        }

        private void addBuildVariants(@NotNull List<BuildVariantItem[]> variantNamesPerRow) {
            if (variantNamesPerRow == null) {
                BuildVariantTable.$$$reportNull$$$0(2);
            }
            for (int row = 0; row < variantNamesPerRow.size(); ++row) {
                Object[] items2 = variantNamesPerRow.get(row);
                BuildVariantItem selected = null;
                for (BuildVariantItem buildVariantItem : items2) {
                    if (!buildVariantItem.hasBuildVariantName(this.getValueAt(row, 1))) continue;
                    selected = buildVariantItem;
                    break;
                }
                ComboBox editor2 = new ComboBox(items2);
                if (selected != null) {
                    editor2.setSelectedItem(selected);
                }
                editor2.setBorder(BorderFactory.createEmptyBorder());
                editor2.addItemListener(e -> {
                    if (e.getStateChange() == 1) {
                        BuildVariantItem selectedVariant = (BuildVariantItem)e.getItem();
                        BuildVariantView.this.myUpdater.updateSelectedVariant(BuildVariantView.this.myProject, selectedVariant.myModuleName, selectedVariant.myBuildVariantName);
                    }
                });
                final DefaultCellEditor defaultCellEditor = new DefaultCellEditor((JComboBox<?>)editor2);
                editor2.addKeyListener((KeyListener)new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 27) {
                            defaultCellEditor.cancelCellEditing();
                        }
                    }
                });
                this.myCellEditors.add(defaultCellEditor);
            }
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            return column == 0 ? this.myModuleCellRenderer : this.myVariantsCellRenderer;
        }

        public TableCellEditor getCellEditor(int row, int column) {
            if (column == 1 && row >= 0 && row < this.myCellEditors.size()) {
                return this.myCellEditors.get(row);
            }
            return this.myModuleCellEditor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rows";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variantNamesPerRow";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/variant/view/BuildVariantView$BuildVariantTable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setModel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addBuildVariants";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BuildVariantItem
    implements Comparable<BuildVariantItem> {
        @NotNull
        final String myModuleName;
        @NotNull
        final String myBuildVariantName;

        BuildVariantItem(@NotNull String moduleName, @NotNull String buildVariantName) {
            if (moduleName == null) {
                BuildVariantItem.$$$reportNull$$$0(0);
            }
            if (buildVariantName == null) {
                BuildVariantItem.$$$reportNull$$$0(1);
            }
            this.myModuleName = moduleName;
            this.myBuildVariantName = buildVariantName;
        }

        @Override
        public int compareTo(@Nullable BuildVariantItem o) {
            return o != null ? Collator.getInstance().compare(this.myBuildVariantName, o.myBuildVariantName) : 1;
        }

        boolean hasBuildVariantName(@Nullable Object name) {
            return this.myBuildVariantName.equals(name);
        }

        public String toString() {
            return this.myBuildVariantName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "moduleName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "buildVariantName";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/variant/view/BuildVariantView$BuildVariantItem";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class NotificationPanel
    extends JPanel {
        int myCurrentConflictIndex;

        NotificationPanel() {
            super(new BorderLayout());
            this.myCurrentConflictIndex = -1;
            Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.NOTIFICATION_BACKGROUND);
            this.setBackground(color == null ? UIUtil.getToolTipBackground() : color);
            this.setBorder(BorderFactory.createEmptyBorder(1, 15, 1, 15));
            this.setPreferredSize(new Dimension(-1, JBUI.scale((int)24)));
            JLabel textLabel = new JLabel("Variant selection conflicts found.");
            textLabel.setOpaque(false);
            this.add((Component)textLabel, "Center");
            DefaultActionGroup group = new DefaultActionGroup();
            ActionManager actionManager = ActionManager.getInstance();
            AnAction nextConflictAction = new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    NotificationPanel.this.navigateConflicts(true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/variant/view/BuildVariantView$NotificationPanel$1", "actionPerformed"));
                }
            };
            nextConflictAction.copyFrom(actionManager.getAction("NextOccurence"));
            group.add(nextConflictAction);
            AnAction prevConflictAction = new AnAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    NotificationPanel.this.navigateConflicts(false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/variant/view/BuildVariantView$NotificationPanel$2", "actionPerformed"));
                }
            };
            prevConflictAction.copyFrom(actionManager.getAction("PreviousOccurence"));
            group.add(prevConflictAction);
            ActionToolbar toolbar = actionManager.createActionToolbar("AndroidBuildVariantViewNotifications", (ActionGroup)group, true);
            toolbar.setReservePlaceAutoPopupIcon(false);
            toolbar.setMinimumButtonSize((Dimension)JBUI.size((int)23, (int)23));
            JComponent toolbarComponent = toolbar.getComponent();
            toolbarComponent.setBorder(null);
            toolbarComponent.setOpaque(false);
            this.add((Component)toolbarComponent, "East");
        }

        private void navigateConflicts(boolean forward) {
            int conflictCount = BuildVariantView.this.myConflicts.size();
            if (conflictCount == 0) {
                return;
            }
            if (forward) {
                ++this.myCurrentConflictIndex;
                if (this.myCurrentConflictIndex >= conflictCount) {
                    this.myCurrentConflictIndex = 0;
                }
            } else {
                --this.myCurrentConflictIndex;
                if (this.myCurrentConflictIndex < 0) {
                    this.myCurrentConflictIndex = conflictCount - 1;
                }
            }
            Conflict conflict = (Conflict)BuildVariantView.this.myConflicts.get(this.myCurrentConflictIndex);
            BuildVariantView.this.findAndSelect(conflict.getSource());
        }
    }

    public static interface BuildVariantSelectionChangeListener {
        public void selectionChanged();
    }
}

