/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.google.common.base.Strings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.net.HttpConfigurable;
import java.util.Objects;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProxySettings {
    @NonNls
    public static final String HTTP_PROXY_TYPE = "http";
    @NonNls
    public static final String HTTPS_PROXY_TYPE = "https";
    @NonNls
    private static final String PROXY_HOST_PROPERTY_SUFFIX = "proxyHost";
    @NonNls
    private static final String PROXY_PORT_PROPERTY_SUFFIX = "proxyPort";
    @NonNls
    private static final String PROXY_USER_PROPERTY_SUFFIX = "proxyUser";
    @NonNls
    private static final String PROXY_PASSWORD_PROPERTY_SUFFIX = "proxyPassword";
    @NonNls
    private static final String PROXY_EXCEPTIONS_PROPERTY_SUFFIX = "nonProxyHosts";
    @NotNull
    private String myProxyType;
    @Nullable
    private String myHost;
    @Nullable
    private String myExceptions;
    @Nullable
    private String myUser;
    @Nullable
    private String myPassword;
    private int myPort;

    public ProxySettings(@NotNull String proxyType) {
        if (proxyType == null) {
            ProxySettings.$$$reportNull$$$0(0);
        }
        this.myPort = 80;
        this.myProxyType = proxyType;
    }

    public ProxySettings(@NotNull Properties properties, @NotNull String proxyType) {
        if (properties == null) {
            ProxySettings.$$$reportNull$$$0(1);
        }
        if (proxyType == null) {
            ProxySettings.$$$reportNull$$$0(2);
        }
        this.myPort = 80;
        this.myProxyType = proxyType;
        this.myHost = properties.getProperty(this.getProxyPropertyName(PROXY_HOST_PROPERTY_SUFFIX));
        String portValue = properties.getProperty(this.getProxyPropertyName(PROXY_PORT_PROPERTY_SUFFIX));
        if (StringUtil.isNotEmpty((String)portValue)) {
            try {
                this.myPort = Integer.parseInt(portValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.myExceptions = properties.getProperty(this.getProxyPropertyName(PROXY_EXCEPTIONS_PROPERTY_SUFFIX));
        this.myUser = properties.getProperty(this.getProxyPropertyName(PROXY_USER_PROPERTY_SUFFIX));
        this.myPassword = properties.getProperty(this.getProxyPropertyName(PROXY_PASSWORD_PROPERTY_SUFFIX));
    }

    public ProxySettings(@NotNull HttpConfigurable ideProxySettings) {
        if (ideProxySettings == null) {
            ProxySettings.$$$reportNull$$$0(3);
        }
        this.myPort = 80;
        this.myProxyType = HTTP_PROXY_TYPE;
        this.myHost = ideProxySettings.PROXY_HOST;
        this.myPort = ideProxySettings.PROXY_PORT;
        if (ideProxySettings.PROXY_AUTHENTICATION) {
            this.myUser = ideProxySettings.getProxyLogin();
            this.myPassword = ideProxySettings.getPlainProxyPassword();
        }
        this.myExceptions = ideProxySettings.PROXY_EXCEPTIONS;
    }

    public void applyProxySettings(@NotNull Properties properties) {
        if (properties == null) {
            ProxySettings.$$$reportNull$$$0(4);
        }
        properties.setProperty(this.getProxyPropertyName(PROXY_HOST_PROPERTY_SUFFIX), this.myHost);
        properties.setProperty(this.getProxyPropertyName(PROXY_PORT_PROPERTY_SUFFIX), String.valueOf(this.myPort));
        if (StringUtil.isEmpty((String)this.myUser)) {
            properties.remove(this.getProxyPropertyName(PROXY_USER_PROPERTY_SUFFIX));
            properties.remove(this.getProxyPropertyName(PROXY_PASSWORD_PROPERTY_SUFFIX));
        } else {
            properties.setProperty(this.getProxyPropertyName(PROXY_USER_PROPERTY_SUFFIX), this.myUser);
            properties.setProperty(this.getProxyPropertyName(PROXY_PASSWORD_PROPERTY_SUFFIX), Strings.nullToEmpty((String)this.myPassword));
        }
        if (StringUtil.isEmpty((String)this.myExceptions)) {
            properties.remove(this.getProxyPropertyName(PROXY_EXCEPTIONS_PROPERTY_SUFFIX));
        } else {
            properties.setProperty(this.getProxyPropertyName(PROXY_EXCEPTIONS_PROPERTY_SUFFIX), this.myExceptions);
        }
    }

    @NotNull
    private String getProxyPropertyName(@NotNull String propertySuffix) {
        if (propertySuffix == null) {
            ProxySettings.$$$reportNull$$$0(5);
        }
        String string = "systemProp." + this.myProxyType + "." + propertySuffix;
        if (string == null) {
            ProxySettings.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public String getHost() {
        return this.myHost;
    }

    public void setHost(@Nullable String host) {
        this.myHost = host;
    }

    @Nullable
    public String getExceptions() {
        return this.myExceptions;
    }

    public void setExceptions(@Nullable String exceptions) {
        this.myExceptions = exceptions;
    }

    @Nullable
    public String getUser() {
        return this.myUser;
    }

    public void setUser(@Nullable String user) {
        this.myUser = user;
    }

    @Nullable
    public String getPassword() {
        return this.myPassword;
    }

    public void setPassword(@Nullable String password) {
        this.myPassword = password;
    }

    public int getPort() {
        return this.myPort;
    }

    public void setPort(int port) {
        this.myPort = port;
    }

    public void setProxyType(@NotNull String proxyType) {
        if (proxyType == null) {
            ProxySettings.$$$reportNull$$$0(7);
        }
        this.myProxyType = proxyType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProxySettings)) {
            return false;
        }
        ProxySettings settings = (ProxySettings)o;
        return this.myPort == settings.myPort && Objects.equals(this.myProxyType, settings.myProxyType) && Objects.equals(this.myHost, settings.myHost) && Objects.equals(this.myExceptions, settings.myExceptions) && Objects.equals(this.myUser, settings.myUser) && Objects.equals(this.myPassword, settings.myPassword);
    }

    public int hashCode() {
        return Objects.hash(this.myProxyType, this.myHost, this.myExceptions, this.myUser, this.myPassword, this.myPort);
    }

    public String toString() {
        return "ProxySettings{myProxyType='" + this.myProxyType + '\'' + ", myHost='" + this.myHost + '\'' + ", myExceptions='" + this.myExceptions + '\'' + ", myUser='" + this.myUser + '\'' + ", myPassword='" + this.myPassword + '\'' + ", myPort=" + this.myPort + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxyType";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideProxySettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertySuffix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/util/ProxySettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/util/ProxySettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProxyPropertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyProxySettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getProxyPropertyName";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setProxyType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

