/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.util;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.GradleProjectSettingsFinder;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;

public class GradleVersions {
    private static final Pattern GRADLE_JAR_NAME_PATTERN = Pattern.compile("gradle-core-(.*)\\.jar");
    @NotNull
    private final GradleProjectSettingsFinder mySettingsFinder;

    @NotNull
    public static GradleVersions getInstance() {
        GradleVersions gradleVersions = (GradleVersions)ServiceManager.getService(GradleVersions.class);
        if (gradleVersions == null) {
            GradleVersions.$$$reportNull$$$0(0);
        }
        return gradleVersions;
    }

    public GradleVersions(@NotNull GradleProjectSettingsFinder settingsFinder) {
        if (settingsFinder == null) {
            GradleVersions.$$$reportNull$$$0(1);
        }
        this.mySettingsFinder = settingsFinder;
    }

    @Nullable
    public GradleVersion getGradleVersion(@NotNull Project project) {
        GradleVersion revision;
        GradleVersion gradleVersion;
        GradleSyncState syncState;
        if (project == null) {
            GradleVersions.$$$reportNull$$$0(2);
        }
        if ((syncState = GradleSyncState.getInstance(project)).isSyncNeeded() != ThreeState.YES && (gradleVersion = syncState.getSummary().getGradleVersion()) != null && (revision = GradleVersion.tryParse((String)GradleVersions.removeTimestampFromGradleVersion(gradleVersion.toString()))) != null) {
            return revision;
        }
        GradleProjectSettings gradleSettings = this.mySettingsFinder.findGradleProjectSettings(project);
        if (gradleSettings != null) {
            String gradleHome;
            DistributionType distributionType = gradleSettings.getDistributionType();
            if (distributionType == DistributionType.DEFAULT_WRAPPED) {
                GradleWrapper gradleWrapper = GradleWrapper.find(project);
                if (gradleWrapper != null) {
                    try {
                        String wrapperVersion = gradleWrapper.getGradleVersion();
                        if (wrapperVersion != null) {
                            return GradleVersion.tryParse((String)GradleVersions.removeTimestampFromGradleVersion(wrapperVersion));
                        }
                    }
                    catch (IOException e) {
                        Logger.getInstance(this.getClass()).info("Failed to read Gradle version in wrapper", (Throwable)e);
                    }
                }
            } else if (distributionType == DistributionType.LOCAL && StringUtil.isNotEmpty((String)(gradleHome = gradleSettings.getGradleHome()))) {
                File gradleHomePath = new File(gradleHome);
                return this.getGradleVersion(gradleHomePath);
            }
        }
        return null;
    }

    @Nullable
    public GradleVersion getGradleVersion(@NotNull File gradleHomePath) {
        File libFolderPath;
        if (gradleHomePath == null) {
            GradleVersions.$$$reportNull$$$0(3);
        }
        if ((libFolderPath = new File(gradleHomePath, "lib")).isDirectory()) {
            for (File child : FileUtil.notNullize((File[])libFolderPath.listFiles())) {
                GradleVersion version2 = GradleVersions.getGradleVersionFromJar(child);
                if (version2 == null) continue;
                return version2;
            }
        }
        return null;
    }

    @VisibleForTesting
    @Nullable
    static GradleVersion getGradleVersionFromJar(@NotNull File libraryJarFile) {
        String fileName;
        Matcher matcher;
        if (libraryJarFile == null) {
            GradleVersions.$$$reportNull$$$0(4);
        }
        if ((matcher = GRADLE_JAR_NAME_PATTERN.matcher(fileName = libraryJarFile.getName())).matches()) {
            String version2 = matcher.group(1);
            return GradleVersion.tryParse((String)GradleVersions.removeTimestampFromGradleVersion(version2));
        }
        return null;
    }

    @VisibleForTesting
    @NotNull
    public static String removeTimestampFromGradleVersion(@NotNull String gradleVersion) {
        int dashIndex;
        if (gradleVersion == null) {
            GradleVersions.$$$reportNull$$$0(5);
        }
        if ((dashIndex = gradleVersion.indexOf(45)) != -1) {
            String string = gradleVersion.substring(0, dashIndex);
            if (string == null) {
                GradleVersions.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = gradleVersion;
        if (string == null) {
            GradleVersions.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isGradle4OrNewer(@NotNull Project project) {
        GradleVersion gradleVersion;
        if (project == null) {
            GradleVersions.$$$reportNull$$$0(8);
        }
        return (gradleVersion = GradleVersions.getInstance().getGradleVersion(project)) != null && gradleVersion.compareIgnoringQualifiers("4.0") >= 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/util/GradleVersions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsFinder";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleHomePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryJarFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/util/GradleVersions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "removeTimestampFromGradleVersion";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getGradleVersion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getGradleVersionFromJar";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeTimestampFromGradleVersion";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isGradle4OrNewer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

