/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.quickfix;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.google.common.base.Splitter;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class QuickFixes {
    public static final char QUICK_FIX_PATH_SEPARATOR = '/';
    @NonNls
    public static final String SET_LIBRARY_DEPENDENCY_QUICK_FIX = "setLibraryDependency";

    private QuickFixes() {
    }

    public static void executeQuickFix(@NotNull String quickFix, @NonNls PsContext context) {
        if (quickFix == null) {
            QuickFixes.$$$reportNull$$$0(0);
        }
        List segments = Splitter.on((char)'/').splitToList((CharSequence)quickFix);
        assert (!segments.isEmpty());
        String action2 = (String)segments.get(0);
        if (SET_LIBRARY_DEPENDENCY_QUICK_FIX.equals(action2)) {
            assert (segments.size() == 5);
            String moduleName = (String)segments.get(1);
            String dependency = (String)segments.get(2);
            String configurationName = (String)segments.get(3);
            String version2 = (String)segments.get(4);
            QuickFixes.setLibraryDependencyVersion(context, moduleName, dependency, configurationName, version2);
        }
    }

    private static void setLibraryDependencyVersion(@NonNls PsContext context, @NotNull String moduleName, @NotNull String dependency, @NotNull String configurationName, @NotNull String version2) {
        if (moduleName == null) {
            QuickFixes.$$$reportNull$$$0(1);
        }
        if (dependency == null) {
            QuickFixes.$$$reportNull$$$0(2);
        }
        if (configurationName == null) {
            QuickFixes.$$$reportNull$$$0(3);
        }
        if (version2 == null) {
            QuickFixes.$$$reportNull$$$0(4);
        }
        PsModule module = context.getProject().findModuleByName(moduleName);
        PsArtifactDependencySpec spec = PsArtifactDependencySpec.Companion.create(dependency);
        if (module != null && spec != null) {
            module.setLibraryDependencyVersion(spec, configurationName, version2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/structure/quickfix/QuickFixes";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "executeQuickFix";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setLibraryDependencyVersion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

