/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.repositories.search;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.FoundArtifact;
import com.android.tools.idea.gradle.structure.model.repositories.search.MavenCentralRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchResult;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.io.HttpRequests;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/gradle/structure/model/repositories/search/MavenCentralRepository;", "Lcom/android/tools/idea/gradle/structure/model/repositories/search/ArtifactRepository;", "()V", "isRemote", "", "()Z", "name", "", "getName", "()Ljava/lang/String;", "createRequestUrl", "request", "Lcom/android/tools/idea/gradle/structure/model/repositories/search/SearchRequest;", "doSearch", "Lcom/android/tools/idea/gradle/structure/model/repositories/search/SearchResult;", "parse", "response", "Ljava/io/Reader;", "intellij.android.core"})
public final class MavenCentralRepository
extends ArtifactRepository {
    @NotNull
    private static final String name = "Maven Central";
    private static final boolean isRemote = true;
    public static final MavenCentralRepository INSTANCE;

    @Override
    @NotNull
    public String getName() {
        return name;
    }

    @Override
    public boolean isRemote() {
        return isRemote;
    }

    @Override
    @NotNull
    protected SearchResult doSearch(@NotNull SearchRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Object object = HttpRequests.request((String)this.createRequestUrl(request)).accept("application/xml").connect((HttpRequests.RequestProcessor)doSearch.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"HttpRequests\n      .requ\u2026it\", e)\n        }\n      }");
        return (SearchResult)object;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final SearchResult parse(@NotNull Reader response) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        parse.1 findStringAttribute$ = parse.1.INSTANCE;
        Object object = JDOMUtil.load((Reader)response);
        if (object != null && (object = object.getChild("result")) != null && (object = object.getChildren("doc")) != null) {
            void $receiver$iv$iv;
            void $receiver$iv;
            Iterable iterable = (Iterable)object;
            void var5_4 = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            void $receiver$iv$iv$iv = $receiver$iv$iv;
            Iterator iterator = $receiver$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                FoundArtifact foundArtifact;
                FoundArtifact foundArtifact2;
                GradleVersion latestVersion;
                GradleVersion gradleVersion;
                Object it;
                Object object2;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                Element docElement = (Element)element$iv$iv;
                boolean bl = false;
                Element element = docElement;
                Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"docElement");
                String id = parse.1.INSTANCE.invoke(element, "id");
                if (parse.1.INSTANCE.invoke(docElement, "latestVersion") != null) {
                    it = object2;
                    boolean bl2 = false;
                    gradleVersion = GradleVersion.tryParse((String)it);
                } else {
                    gradleVersion = latestVersion = null;
                }
                if (id == null || (object2 = (CharSequence)id).length() == 0 || latestVersion == null) {
                    foundArtifact2 = null;
                } else {
                    it = object2 = StringsKt.split$default((CharSequence)id, (char[])new char[]{':'}, (boolean)false, (int)0, (int)6, null);
                    boolean bl3 = false;
                    Object object3 = it.size() == 2 ? object2 : null;
                    if (object3 != null) {
                        it = object2 = object3;
                        boolean bl4 = false;
                        foundArtifact2 = new FoundArtifact(INSTANCE.getName(), (String)it.get(0), (String)it.get(1), latestVersion);
                    } else {
                        foundArtifact2 = null;
                    }
                }
                if (foundArtifact2 == null) continue;
                FoundArtifact it$iv$iv = foundArtifact = foundArtifact2;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List result2 = list;
        return new SearchResult(result2);
    }

    @VisibleForTesting
    @NotNull
    public final String createRequestUrl(@NotNull SearchRequest request) {
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        boolean bl = false;
        $receiver.append("https://search.maven.org/solrsearch/select?");
        $receiver.append("rows=" + request.getRowCount() + '&');
        $receiver.append("start=" + request.getStart() + '&');
        $receiver.append("wt=xml&");
        $receiver.append("q=");
        String string = request.getGroupId();
        if (string != null) {
            String string2;
            String it = string2 = string;
            boolean bl2 = false;
            string = !StringsKt.isBlank((CharSequence)it) ? string2 : null;
            if (string != null) {
                String groupId = string2 = string;
                boolean bl3 = false;
                $receiver.append("g:%22" + groupId + "%22+AND+");
            }
        }
        $receiver.append("a:%22" + request.getArtifactName() + "%22");
        String string3 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        return string3;
    }

    private MavenCentralRepository() {
    }

    static {
        MavenCentralRepository mavenCentralRepository;
        INSTANCE = mavenCentralRepository = new MavenCentralRepository();
        name = name;
        isRemote = true;
    }
}

