/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.model.repositories.search;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.FoundArtifact;
import com.android.tools.idea.gradle.structure.model.repositories.search.JCenterRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchResult;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.util.io.HttpRequests;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/gradle/structure/model/repositories/search/JCenterRepository;", "Lcom/android/tools/idea/gradle/structure/model/repositories/search/ArtifactRepository;", "()V", "isRemote", "", "()Z", "name", "", "getName", "()Ljava/lang/String;", "createRequestUrl", "request", "Lcom/android/tools/idea/gradle/structure/model/repositories/search/SearchRequest;", "doSearch", "Lcom/android/tools/idea/gradle/structure/model/repositories/search/SearchResult;", "parse", "response", "Ljava/io/Reader;", "intellij.android.core"})
public final class JCenterRepository
extends ArtifactRepository {
    @NotNull
    private static final String name = "JCenter";
    private static final boolean isRemote = true;
    public static final JCenterRepository INSTANCE;

    @Override
    @NotNull
    public String getName() {
        return name;
    }

    @Override
    public boolean isRemote() {
        return isRemote;
    }

    @Override
    @NotNull
    protected SearchResult doSearch(@NotNull SearchRequest request) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Object object = HttpRequests.request((String)this.createRequestUrl(request)).accept("application/json").connect((HttpRequests.RequestProcessor)doSearch.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"HttpRequests.request(cre\u2026nect { parse(it.reader) }");
        return (SearchResult)object;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final SearchResult parse(@NotNull Reader response) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        JsonParser parser = new JsonParser();
        JsonElement jsonElement = parser.parse(response);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement, (String)"parser.parse(response)");
        JsonArray array = jsonElement.getAsJsonArray();
        List errors = new ArrayList();
        JsonArray jsonArray = array;
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"array");
        Iterable iterable = $receiver$iv = (Iterable)jsonArray;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            List list;
            JsonElement result2 = (JsonElement)element$iv$iv;
            boolean bl = false;
            JsonElement jsonElement2 = result2;
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement2, (String)"result");
            JsonObject root = jsonElement2.getAsJsonObject();
            try {
                Object object;
                Object element$iv$iv2;
                Object element$iv$iv$iv;
                Iterable $receiver$iv$iv2;
                Iterable $receiver$iv2;
                JsonArray versions = root.getAsJsonArray("versions");
                JsonArray systemIds = root.getAsJsonArray("system_ids");
                JsonArray jsonArray2 = versions;
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray2, (String)"versions");
                Iterable iterable2 = $receiver$iv2 = (Iterable)jsonArray2;
                Collection destination$iv$iv2 = new ArrayList();
                Iterable $receiver$iv$iv$iv = $receiver$iv$iv2;
                Iterator iterator = $receiver$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv$iv2 = element$iv$iv$iv = iterator.next();
                    JsonElement it = (JsonElement)element$iv$iv2;
                    boolean bl2 = false;
                    JsonElement jsonElement3 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement3, (String)"it");
                    if (GradleVersion.tryParse((String)jsonElement3.getAsString()) == null) continue;
                    GradleVersion it$iv$iv = object;
                    destination$iv$iv2.add(it$iv$iv);
                }
                Set availableVersions = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
                JsonArray jsonArray3 = systemIds;
                Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray3, (String)"systemIds");
                $receiver$iv$iv2 = $receiver$iv2 = (Iterable)jsonArray3;
                destination$iv$iv2 = new ArrayList();
                $receiver$iv$iv$iv = $receiver$iv$iv2;
                iterator = $receiver$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    FoundArtifact foundArtifact;
                    FoundArtifact foundArtifact2;
                    element$iv$iv2 = element$iv$iv$iv = iterator.next();
                    JsonElement name = (JsonElement)element$iv$iv2;
                    boolean bl3 = false;
                    JsonElement jsonElement4 = name;
                    Intrinsics.checkExpressionValueIsNotNull((Object)jsonElement4, (String)"name");
                    String string = jsonElement4.getAsString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name\n            .asString");
                    Object it = object = StringsKt.split$default((CharSequence)string, (char[])new char[]{':'}, (boolean)false, (int)0, (int)6, null);
                    boolean bl4 = false;
                    Object object2 = it.size() == 2 ? object : null;
                    if (object2 != null) {
                        it = object = object2;
                        boolean bl5 = false;
                        foundArtifact2 = new FoundArtifact(INSTANCE.getName(), (String)it.get(0), (String)it.get(1), availableVersions);
                    } else {
                        foundArtifact2 = null;
                    }
                    if (foundArtifact2 == null) continue;
                    FoundArtifact it$iv$iv = foundArtifact = foundArtifact2;
                    destination$iv$iv2.add(it$iv$iv);
                }
                list = (List)destination$iv$iv2;
            }
            catch (Exception ex) {
                errors.add(ex);
                list = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List artifacts = (List)destination$iv$iv;
        return new SearchResult(artifacts, errors);
    }

    @VisibleForTesting
    @NotNull
    public final String createRequestUrl(@NotNull SearchRequest request) {
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        boolean bl = false;
        $receiver.append("https://api.bintray.com/search/packages/maven?");
        String groupId = request.getGroupId();
        CharSequence charSequence = groupId;
        if (!(charSequence == null || charSequence.length() == 0)) {
            $receiver.append("g=");
            $receiver.append(groupId);
            $receiver.append("&");
        }
        $receiver.append("a=");
        $receiver.append(request.getArtifactName());
        $receiver.append("&subject=bintray&repo=jcenter");
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private JCenterRepository() {
    }

    static {
        JCenterRepository jCenterRepository;
        INSTANCE = jCenterRepository = new JCenterRepository();
        name = name;
        isRemote = true;
    }
}

