/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.editors;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.parser.BuildFileStatement;
import com.android.tools.idea.gradle.parser.Dependency;
import com.android.tools.idea.gradle.parser.UnparseableStatement;
import com.android.tools.idea.gradle.structure.editors.ModuleDependenciesTableItem;
import com.google.common.collect.Lists;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.util.ui.ItemRemovable;
import java.util.List;
import javax.swing.RowFilter;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDependenciesTableModel
extends AbstractTableModel
implements ItemRemovable {
    private static final String SCOPE_COLUMN_NAME = ProjectBundle.message((String)"modules.order.export.scope.column", (Object[])new Object[0]);
    public static final int ITEM_COLUMN = 0;
    public static final int SCOPE_COLUMN = 1;
    private final List<ModuleDependenciesTableItem> myItems = Lists.newArrayList();
    private boolean myModified;

    public ModuleDependenciesTableItem getItemAt(int row) {
        return this.myItems.get(row);
    }

    public void addItem(ModuleDependenciesTableItem item) {
        this.myItems.add(item);
        this.myModified = true;
    }

    public void addItemAt(ModuleDependenciesTableItem item, int row) {
        this.myItems.add(row, item);
        this.myModified = true;
    }

    public ModuleDependenciesTableItem removeDataRow(int row) {
        this.myModified = true;
        return this.myItems.remove(row);
    }

    public void removeRow(int row) {
        this.removeDataRow(row);
    }

    public void clear() {
        this.myModified = true;
        this.myItems.clear();
    }

    @Override
    public int getRowCount() {
        return this.myItems.size();
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        ModuleDependenciesTableItem item = this.myItems.get(rowIndex);
        if (columnIndex == 1) {
            return item.getScope();
        }
        if (columnIndex == 0) {
            return item;
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        ModuleDependenciesTableItem item = this.myItems.get(rowIndex);
        if (columnIndex == 1 && aValue instanceof Dependency.Scope) {
            item.setScope((Dependency.Scope)((Object)aValue));
        }
        this.myModified = true;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 1) {
            return SCOPE_COLUMN_NAME;
        }
        return "";
    }

    @Nullable
    public Class getColumnClass(int column) {
        if (column == 1) {
            return Dependency.Scope.class;
        }
        if (column == 0) {
            return ModuleDependenciesTableItem.class;
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 1;
    }

    public List<ModuleDependenciesTableItem> getItems() {
        return this.myItems;
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void resetModified() {
        this.myModified = false;
    }

    public void setModified() {
        this.myModified = true;
    }

    public RowFilter<ModuleDependenciesTableModel, Integer> getFilter() {
        return new RowFilter<ModuleDependenciesTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends ModuleDependenciesTableModel, ? extends Integer> entry) {
                ModuleDependenciesTableItem item = (ModuleDependenciesTableItem)ModuleDependenciesTableModel.this.myItems.get(entry.getIdentifier());
                BuildFileStatement e = item.getEntry();
                return e instanceof Dependency || e instanceof UnparseableStatement && !((UnparseableStatement)e).isComment();
            }
        };
    }

    public int getRow(@NotNull GradleCoordinate dependency) {
        if (dependency == null) {
            ModuleDependenciesTableModel.$$$reportNull$$$0(0);
        }
        int rowCount = this.getRowCount();
        for (int i2 = 0; i2 < rowCount; ++i2) {
            String current;
            GradleCoordinate currentCoordinate;
            BuildFileStatement entry;
            Object value2 = this.getValueAt(i2, 0);
            if (!(value2 instanceof ModuleDependenciesTableItem) || !((entry = ((ModuleDependenciesTableItem)value2).getEntry()) instanceof Dependency) || (currentCoordinate = GradleCoordinate.parseCoordinateString((String)(current = ((Dependency)entry).getValueAsString()))) == null || !dependency.equals((Object)currentCoordinate)) continue;
            return i2;
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/structure/editors/ModuleDependenciesTableModel", "getRow"));
    }
}

