/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.editors;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.structure.AndroidProjectStructureConfigurable;
import com.android.tools.idea.project.AndroidProjectInfo;
import com.android.tools.idea.structure.dialog.ProjectStructureConfigurable;
import com.intellij.compiler.actions.ArtifactAwareProjectSettingsService;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.IdeaProjectSettingsService;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.ui.navigation.Place;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidProjectSettingsService
extends ProjectSettingsService
implements ArtifactAwareProjectSettingsService {
    private final Project myProject;
    private final IdeaProjectSettingsService myDelegate;

    public AndroidProjectSettingsService(Project project) {
        this.myProject = project;
        this.myDelegate = new IdeaProjectSettingsService(project);
    }

    public void openProjectSettings() {
        this.myDelegate.openProjectSettings();
    }

    public void openGlobalLibraries() {
        if (!this.isGradleProjectInAndroidStudio()) {
            this.myDelegate.openGlobalLibraries();
        }
    }

    public void openLibrary(@NotNull Library library) {
        if (library == null) {
            AndroidProjectSettingsService.$$$reportNull$$$0(0);
        }
        if (!this.isGradleProjectInAndroidStudio()) {
            this.myDelegate.openLibrary(library);
        }
    }

    public boolean canOpenModuleSettings() {
        if (this.isGradleProjectInAndroidStudio()) {
            return true;
        }
        return this.myDelegate.canOpenModuleSettings();
    }

    public void openModuleLibrarySettings(Module module) {
        if (this.isGradleProjectInAndroidStudio()) {
            this.openModuleSettings(module);
        } else {
            this.myDelegate.openModuleLibrarySettings(module);
        }
    }

    private void showNewPsd(@NotNull Place place) {
        if (place == null) {
            AndroidProjectSettingsService.$$$reportNull$$$0(1);
        }
        ProjectStructureConfigurable.getInstance(this.myProject).showPlace(place);
    }

    public void openModuleSettings(Module module) {
        if (this.isGradleProjectInAndroidStudio()) {
            if (((Boolean)StudioFlags.NEW_PSD_ENABLED.get()).booleanValue()) {
                this.showNewPsd(new Place().putPath("categoryName", (Object)"Modules").putPath("modules.place", (Object)module.getName()));
            } else {
                AndroidProjectStructureConfigurable.getInstance(this.myProject).showDialogAndSelect(module);
            }
        } else {
            this.myDelegate.openModuleSettings(module);
        }
    }

    public void openSigningConfiguration(@NotNull Module module) {
        if (module == null) {
            AndroidProjectSettingsService.$$$reportNull$$$0(2);
        }
        if (((Boolean)StudioFlags.NEW_PSD_ENABLED.get()).booleanValue()) {
            this.showNewPsd(new Place().putPath("categoryName", (Object)"Modules").putPath("modules.place", (Object)module.getName()).putPath("android.psd.module", (Object)"Signing Configs"));
        } else {
            AndroidProjectStructureConfigurable configurable = AndroidProjectStructureConfigurable.getInstance(this.myProject);
            configurable.showDialogAndOpenSigningConfiguration(module);
        }
    }

    public void openSdkSettings() {
        if (((Boolean)StudioFlags.NEW_PSD_ENABLED.get()).booleanValue()) {
            this.showNewPsd(new Place().putPath("categoryName", (Object)"SDK Location"));
        } else {
            AndroidProjectStructureConfigurable configurable = AndroidProjectStructureConfigurable.getInstance(this.myProject);
            configurable.showDialogAndSelectSdksPage();
        }
    }

    public void chooseJdkLocation() {
        if (((Boolean)StudioFlags.NEW_PSD_ENABLED.get()).booleanValue()) {
            this.showNewPsd(new Place().putPath("categoryName", (Object)"SDK Location"));
        } else {
            AndroidProjectStructureConfigurable configurable = AndroidProjectStructureConfigurable.getInstance(this.myProject);
            configurable.showDialogAndChooseJdkLocation();
        }
    }

    public void openAndSelectDependency(@NotNull Module module, @NotNull GradleCoordinate dependency) {
        if (module == null) {
            AndroidProjectSettingsService.$$$reportNull$$$0(3);
        }
        if (dependency == null) {
            AndroidProjectSettingsService.$$$reportNull$$$0(4);
        }
        if (((Boolean)StudioFlags.NEW_PSD_ENABLED.get()).booleanValue()) {
            this.showNewPsd(new Place().putPath("categoryName", (Object)"Dependencies").putPath("dependencies.place", (Object)module.getName()).putPath(String.format("dependencies.%s.place", module.getName()), (Object)dependency.toString()));
        } else {
            AndroidProjectStructureConfigurable configurable = AndroidProjectStructureConfigurable.getInstance(this.myProject);
            configurable.showDialogAndSelectDependency(module, dependency);
        }
    }

    public void openAndSelectBuildTypesEditor(@NotNull Module module) {
        if (module == null) {
            AndroidProjectSettingsService.$$$reportNull$$$0(5);
        }
        if (((Boolean)StudioFlags.NEW_PSD_ENABLED.get()).booleanValue()) {
            this.showNewPsd(new Place().putPath("categoryName", (Object)"Build Variants").putPath("build_variants.place", (Object)module.getName()).putPath("android.psd.build_variants", (Object)"Build Types"));
        } else {
            AndroidProjectStructureConfigurable configurable = AndroidProjectStructureConfigurable.getInstance(this.myProject);
            configurable.showDialogAndSelectBuildTypesEditor(module);
        }
    }

    public void openAndSelectFlavorsEditor(@NotNull Module module) {
        if (module == null) {
            AndroidProjectSettingsService.$$$reportNull$$$0(6);
        }
        if (((Boolean)StudioFlags.NEW_PSD_ENABLED.get()).booleanValue()) {
            this.showNewPsd(new Place().putPath("categoryName", (Object)"Build Variants").putPath("build_variants.place", (Object)module.getName()).putPath("android.psd.build_variants", (Object)"Flavors"));
        } else {
            AndroidProjectStructureConfigurable configurable = AndroidProjectStructureConfigurable.getInstance(this.myProject);
            configurable.showDialogAndSelectFlavorsEditor(module);
        }
    }

    public void openAndSelectDependenciesEditor(@NotNull Module module) {
        if (module == null) {
            AndroidProjectSettingsService.$$$reportNull$$$0(7);
        }
        if (((Boolean)StudioFlags.NEW_PSD_ENABLED.get()).booleanValue()) {
            this.showNewPsd(new Place().putPath("categoryName", (Object)"Dependencies").putPath("dependencies.place", (Object)module.getName()));
        } else {
            AndroidProjectStructureConfigurable configurable = AndroidProjectStructureConfigurable.getInstance(this.myProject);
            configurable.showDialogAndSelectDependenciesEditor(module);
        }
    }

    public boolean canOpenModuleLibrarySettings() {
        if (this.isGradleProjectInAndroidStudio()) {
            return false;
        }
        return this.myDelegate.canOpenModuleLibrarySettings();
    }

    public boolean canOpenContentEntriesSettings() {
        if (this.isGradleProjectInAndroidStudio()) {
            return false;
        }
        return this.myDelegate.canOpenContentEntriesSettings();
    }

    public void openContentEntriesSettings(Module module) {
        if (this.isGradleProjectInAndroidStudio()) {
            this.openModuleSettings(module);
        } else {
            this.myDelegate.openContentEntriesSettings(module);
        }
    }

    public boolean canOpenModuleDependenciesSettings() {
        if (this.isGradleProjectInAndroidStudio()) {
            return false;
        }
        return this.myDelegate.canOpenModuleDependenciesSettings();
    }

    public void openModuleDependenciesSettings(@NotNull Module module, @Nullable OrderEntry orderEntry) {
        if (module == null) {
            AndroidProjectSettingsService.$$$reportNull$$$0(8);
        }
        if (this.isGradleProjectInAndroidStudio()) {
            this.openModuleSettings(module);
        } else {
            this.myDelegate.openModuleDependenciesSettings(module, orderEntry);
        }
    }

    public boolean canOpenLibraryOrSdkSettings(OrderEntry orderEntry) {
        if (this.isGradleProjectInAndroidStudio()) {
            return false;
        }
        return this.myDelegate.canOpenLibraryOrSdkSettings(orderEntry);
    }

    public void openLibraryOrSdkSettings(@NotNull OrderEntry orderEntry) {
        if (orderEntry == null) {
            AndroidProjectSettingsService.$$$reportNull$$$0(9);
        }
        if (!this.isGradleProjectInAndroidStudio()) {
            this.myDelegate.openLibraryOrSdkSettings(orderEntry);
        }
    }

    public boolean processModulesMoved(Module[] modules, @Nullable ModuleGroup targetGroup) {
        if (this.isGradleProjectInAndroidStudio()) {
            return false;
        }
        return this.myDelegate.processModulesMoved(modules, targetGroup);
    }

    public void showModuleConfigurationDialog(String moduleToSelect, String editorNameToSelect) {
        if (this.isGradleProjectInAndroidStudio()) {
            Module module = ModuleManager.getInstance((Project)this.myProject).findModuleByName(moduleToSelect);
            assert (module != null);
            if (((Boolean)StudioFlags.NEW_PSD_ENABLED.get()).booleanValue()) {
                this.showNewPsd(new Place().putPath("categoryName", (Object)"Modules").putPath("modules.place", (Object)module.getName()));
            } else {
                AndroidProjectStructureConfigurable.getInstance(this.myProject).showDialogAndSelect(module);
            }
        } else {
            this.myDelegate.showModuleConfigurationDialog(moduleToSelect, editorNameToSelect);
        }
    }

    public Sdk chooseAndSetSdk() {
        return this.myDelegate.chooseAndSetSdk();
    }

    public void openArtifactSettings(@Nullable Artifact artifact) {
        if (!this.isGradleProjectInAndroidStudio()) {
            this.myDelegate.openArtifactSettings(artifact);
        }
    }

    private boolean isGradleProjectInAndroidStudio() {
        return IdeInfo.getInstance().isAndroidStudio() && AndroidProjectInfo.getInstance(this.myProject).requiresAndroidModel();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/structure/editors/AndroidProjectSettingsService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "openLibrary";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "showNewPsd";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "openSigningConfiguration";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "openAndSelectDependency";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "openAndSelectBuildTypesEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "openAndSelectFlavorsEditor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "openAndSelectDependenciesEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "openModuleDependenciesSettings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "openLibraryOrSdkSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

