/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.RepositorySearchFactory;
import com.android.tools.idea.gradle.structure.daemon.AvailableLibraryUpdateStorage;
import com.android.tools.idea.gradle.structure.daemon.LibraryUpdateId;
import com.android.tools.idea.gradle.structure.daemon.PsDaemon;
import com.android.tools.idea.gradle.structure.daemon.PsLibraryUpdateCheckerDaemon;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.android.tools.idea.gradle.structure.model.android.PsDeclaredLibraryAndroidDependency;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepository;
import com.android.tools.idea.gradle.structure.model.repositories.search.ArtifactRepositorySearchService;
import com.android.tools.idea.gradle.structure.model.repositories.search.FoundArtifact;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchRequest;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchResult;
import com.android.tools.idea.gradle.structure.model.repositories.search.SearchResultKt;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003&'(B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u0017J\b\u0010\u001f\u001a\u00020\u0017H\u0002J$\u0010 \u001a\u00020\u00172\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\"H\u0002R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u000fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon;", "Lcom/android/tools/idea/gradle/structure/daemon/PsDaemon;", "context", "Lcom/android/tools/idea/gradle/structure/configurables/PsContext;", "repositorySearchFactory", "Lcom/android/tools/idea/gradle/structure/configurables/RepositorySearchFactory;", "(Lcom/android/tools/idea/gradle/structure/configurables/PsContext;Lcom/android/tools/idea/gradle/structure/configurables/RepositorySearchFactory;)V", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon$AvailableUpdatesListener;", "kotlin.jvm.PlatformType", "isRunning", "", "()Z", "mainQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "getMainQueue", "()Lcom/intellij/util/ui/update/MergingUpdateQueue;", "resultsUpdaterQueue", "getResultsUpdaterQueue", "running", "Ljava/util/concurrent/atomic/AtomicBoolean;", "add", "", "listener", "Lkotlin/Function0;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "getAvailableUpdates", "Lcom/android/tools/idea/gradle/structure/daemon/AvailableLibraryUpdateStorage$AvailableLibraryUpdates;", "queueAutomaticUpdateCheck", "queueUpdateCheck", "search", "repositories", "", "Lcom/android/tools/idea/gradle/structure/model/repositories/search/ArtifactRepository;", "ids", "Lcom/android/tools/idea/gradle/structure/daemon/LibraryUpdateId;", "AvailableUpdatesListener", "SearchForAvailableUpdates", "UpdatesAvailable", "intellij.android.core"})
public final class PsLibraryUpdateCheckerDaemon
extends PsDaemon {
    @NotNull
    private final MergingUpdateQueue mainQueue;
    @NotNull
    private final MergingUpdateQueue resultsUpdaterQueue;
    private final AtomicBoolean running;
    private final EventDispatcher<AvailableUpdatesListener> eventDispatcher;
    private final RepositorySearchFactory repositorySearchFactory;

    @Override
    @NotNull
    protected MergingUpdateQueue getMainQueue() {
        return this.mainQueue;
    }

    @Override
    @NotNull
    protected MergingUpdateQueue getResultsUpdaterQueue() {
        return this.resultsUpdaterQueue;
    }

    @NotNull
    public final AvailableLibraryUpdateStorage.AvailableLibraryUpdates getAvailableUpdates() {
        AvailableLibraryUpdateStorage.AvailableLibraryUpdates availableLibraryUpdates = AvailableLibraryUpdateStorage.getInstance(this.getContext().getProject().getIdeProject()).getState();
        Intrinsics.checkExpressionValueIsNotNull((Object)availableLibraryUpdates, (String)"AvailableLibraryUpdateSt\u2026ct.ideProject).getState()");
        return availableLibraryUpdates;
    }

    public final void queueAutomaticUpdateCheck() {
        long elapsed;
        long daysPastSinceLastUpdate;
        long searchTimeMillis = this.getAvailableUpdates().lastSearchTimeMillis;
        if (searchTimeMillis > 0L && (daysPastSinceLastUpdate = TimeUnit.MILLISECONDS.toDays(elapsed = System.currentTimeMillis() - searchTimeMillis)) < (long)3) {
            this.getResultsUpdaterQueue().queue((Update)new UpdatesAvailable());
            return;
        }
        this.queueUpdateCheck();
    }

    private final void queueUpdateCheck() {
        this.getMainQueue().queue((Update)new SearchForAvailableUpdates());
    }

    public final void add(@NotNull Function0<Unit> listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkParameterIsNotNull(listener2, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        this.eventDispatcher.addListener((EventListener)new AvailableUpdatesListener(listener2){
            final /* synthetic */ Function0 $listener;

            public void availableUpdates() {
                this.$listener.invoke();
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        }, parentDisposable);
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    /*
     * WARNING - void declaration
     */
    private final void search(Collection<? extends ArtifactRepository> repositories, Collection<? extends LibraryUpdateId> ids) {
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        FoundArtifact it;
        Iterable $receiver$iv$iv2;
        Object object;
        Collection collection;
        void $receiver$iv$iv3;
        void $receiver$iv2;
        this.running.set(true);
        this.getAvailableUpdates().clear();
        Iterable iterable = ids;
        void var5_4 = $receiver$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv3) {
            Iterator id;
            LibraryUpdateId libraryUpdateId = (LibraryUpdateId)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = ((LibraryUpdateId)((Object)id)).getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"id.name");
            object = new ListenableFuture<SearchResult>(string, ((LibraryUpdateId)((Object)id)).getGroupId(), 1, 0);
            collection.add(object);
        }
        Set requests = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        ArtifactRepositorySearchService searcher = this.repositorySearchFactory.create(repositories);
        Iterable $receiver$iv3 = requests;
        Iterable iterable2 = $receiver$iv3;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv3, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            SearchRequest $i$f$mapTo = (SearchRequest)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            object = searcher.search((SearchRequest)((Object)it));
            collection.add(object);
        }
        List resultFutures = (List)destination$iv$iv2;
        Disposer.register((Disposable)this, (Disposable)new Disposable(resultFutures){
            final /* synthetic */ List $resultFutures;

            public final void dispose() {
                Iterable $receiver$iv = this.$resultFutures;
                for (T element$iv : $receiver$iv) {
                    ListenableFuture it = (ListenableFuture)element$iv;
                    boolean bl = false;
                    it.cancel(true);
                }
            }
            {
                this.$resultFutures = list;
            }
        });
        $receiver$iv$iv2 = resultFutures;
        destination$iv$iv2 = $receiver$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it2;
            ListenableFuture bl = (ListenableFuture)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl2 = false;
            object = SearchResultKt.getResultSafely((Future)it2);
            collection.add(object);
        }
        $receiver$iv = (List)destination$iv$iv3;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv3 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            SearchResult it3 = (SearchResult)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it3.getArtifacts();
            CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
        }
        List foundArtifacts = (List)destination$iv$iv3;
        AvailableLibraryUpdateStorage.AvailableLibraryUpdates updates = this.getAvailableUpdates();
        Iterable $receiver$iv4 = foundArtifacts;
        for (Object element$iv : $receiver$iv4) {
            it = (FoundArtifact)element$iv;
            boolean bl = false;
            updates.add(it);
        }
        updates.lastSearchTimeMillis = System.currentTimeMillis();
        this.getResultsUpdaterQueue().queue((Update)new UpdatesAvailable());
    }

    public PsLibraryUpdateCheckerDaemon(@NotNull PsContext context, @NotNull RepositorySearchFactory repositorySearchFactory) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)repositorySearchFactory, (String)"repositorySearchFactory");
        super(context);
        this.repositorySearchFactory = repositorySearchFactory;
        this.mainQueue = this.createQueue("Project Structure Daemon Update Checker", null);
        this.resultsUpdaterQueue = this.createQueue("Project Structure Available Update Results Updater", MergingUpdateQueue.ANY_COMPONENT);
        this.running = new AtomicBoolean(true);
        EventDispatcher eventDispatcher = EventDispatcher.create(AvailableUpdatesListener.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)eventDispatcher, (String)"EventDispatcher.create(A\u2026atesListener::class.java)");
        this.eventDispatcher = eventDispatcher;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon$SearchForAvailableUpdates;", "Lcom/intellij/util/ui/update/Update;", "(Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon;)V", "run", "", "intellij.android.core"})
    private final class SearchForAvailableUpdates
    extends Update {
        public void run() {
            Set repositories = new LinkedHashSet();
            Set ids = new LinkedHashSet();
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(this, repositories, ids){
                final /* synthetic */ SearchForAvailableUpdates this$0;
                final /* synthetic */ Set $repositories;
                final /* synthetic */ Set $ids;

                public final void run() {
                    this.this$0.PsLibraryUpdateCheckerDaemon.this.getContext().getProject().forEachModule(new Consumer<PsModule>(this){
                        final /* synthetic */ run.1 this$0;

                        public final void accept(@NotNull PsModule module) {
                            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
                            this.this$0.$repositories.addAll(module.getArtifactRepositories());
                            if (module instanceof PsAndroidModule) {
                                ((PsAndroidModule)module).getDependencies().forEachLibraryDependency((Function1)new Function1<PsDeclaredLibraryAndroidDependency, Unit>(this){
                                    final /* synthetic */ SearchForAvailableUpdates.run.1 this$0;

                                    public final void invoke(@NotNull PsDeclaredLibraryAndroidDependency dependency) {
                                        Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
                                        PsArtifactDependencySpec spec = dependency.getSpec();
                                        if (StringUtil.isNotEmpty((String)spec.getVersion())) {
                                            GradleVersion version2;
                                            String string = spec.getVersion();
                                            if (string == null) {
                                                Intrinsics.throwNpe();
                                            }
                                            if ((version2 = GradleVersion.tryParse((String)string)) != null) {
                                                this.this$0.this$0.$ids.add(new LibraryUpdateId(spec.getName(), spec.getGroup()));
                                            }
                                        }
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(1);
                                    }
                                });
                            }
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.this$0 = searchForAvailableUpdates;
                    this.$repositories = set;
                    this.$ids = set2;
                }
            });
            if (!repositories.isEmpty() && !ids.isEmpty()) {
                PsLibraryUpdateCheckerDaemon.this.search(repositories, ids);
            } else {
                PsLibraryUpdateCheckerDaemon.this.getResultsUpdaterQueue().queue((Update)new UpdatesAvailable());
            }
        }

        public SearchForAvailableUpdates() {
            super((Object)PsLibraryUpdateCheckerDaemon.this.getContext().getProject());
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon$UpdatesAvailable;", "Lcom/intellij/util/ui/update/Update;", "(Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon;)V", "run", "", "intellij.android.core"})
    private final class UpdatesAvailable
    extends Update {
        public void run() {
            ((AvailableUpdatesListener)PsLibraryUpdateCheckerDaemon.this.eventDispatcher.getMulticaster()).availableUpdates();
            PsLibraryUpdateCheckerDaemon.this.running.set(false);
        }

        public UpdatesAvailable() {
            super((Object)PsLibraryUpdateCheckerDaemon.this.getContext().getProject());
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/android/tools/idea/gradle/structure/daemon/PsLibraryUpdateCheckerDaemon$AvailableUpdatesListener;", "Ljava/util/EventListener;", "availableUpdates", "", "intellij.android.core"})
    private static interface AvailableUpdatesListener
    extends EventListener {
        public void availableUpdates();
    }
}

