/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.suggestions;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.issues.IssueRenderer;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.android.tools.idea.gradle.structure.model.PsPathKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/gradle/structure/configurables/suggestions/SuggestionsViewIssueRenderer;", "Lcom/android/tools/idea/gradle/structure/configurables/issues/IssueRenderer;", "context", "Lcom/android/tools/idea/gradle/structure/configurables/PsContext;", "(Lcom/android/tools/idea/gradle/structure/configurables/PsContext;)V", "getContext", "()Lcom/android/tools/idea/gradle/structure/configurables/PsContext;", "renderIssue", "", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "issue", "Lcom/android/tools/idea/gradle/structure/model/PsIssue;", "scope", "Lcom/android/tools/idea/gradle/structure/model/PsPath;", "intellij.android.core"})
public final class SuggestionsViewIssueRenderer
implements IssueRenderer {
    @NotNull
    private final PsContext context;

    @Override
    public void renderIssue(@NotNull StringBuilder buffer, @NotNull PsIssue issue2, @Nullable PsPath scope) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        PsPath issuePath = issue2.getPath();
        String issuePathHref = issuePath.getHyperlinkDestination(this.context);
        String issuePathText = this.makeTextWrappable(issuePath.toString());
        String issueText = this.makeTextWrappable(issue2.getText());
        buffer.append("<table width='100%'><tr><td width='32' valign='top'>");
        buffer.append("<img width=16 height=16 src='" + issue2.getSeverity().getIcon() + "'></img>");
        buffer.append("</td><td valign='top'>");
        buffer.append("<b>");
        buffer.append(issuePathText);
        Iterable $receiver$iv = CollectionsKt.asReversed(PsPathKt.getParents(issuePath));
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $receiver$iv) {
            PsPath it = (PsPath)item$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it, (Object)scope) ^ true)) break;
            list$iv.add(item$iv);
        }
        $receiver$iv = CollectionsKt.asReversed((List)list$iv);
        for (Object element$iv : $receiver$iv) {
            PsPath parentPath = (PsPath)element$iv;
            boolean bl = false;
            String parentPathHref = parentPath.getHyperlinkDestination(this.context);
            String parentPathText = this.makeTextWrappable(parentPath.toString());
            buffer.append(" (<a href=\"" + parentPathHref + "\">" + parentPathText + "</a>)");
        }
        buffer.append(" : ");
        buffer.append(issueText);
        buffer.append("</b>");
        if (issuePathHref != null) {
            buffer.append("<br/><a href='" + issuePathHref + "'>View usage</a>");
        }
        buffer.append("</td></tr></table>");
    }

    @NotNull
    public final PsContext getContext() {
        return this.context;
    }

    public SuggestionsViewIssueRenderer(@NotNull PsContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    @NotNull
    public String renderIssue(@NotNull PsIssue issue2, @Nullable PsPath scope) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        return IssueRenderer.DefaultImpls.renderIssue(this, issue2, scope);
    }

    @Override
    @NotNull
    public String makeTextWrappable(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return IssueRenderer.DefaultImpls.makeTextWrappable(this, $receiver);
    }
}

