/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.issues;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.issues.IssueRenderer;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.android.tools.idea.gradle.structure.model.PsPathKt;
import com.android.tools.idea.gradle.structure.model.PsQuickFix;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/gradle/structure/configurables/issues/DependencyViewIssueRenderer;", "Lcom/android/tools/idea/gradle/structure/configurables/issues/IssueRenderer;", "context", "Lcom/android/tools/idea/gradle/structure/configurables/PsContext;", "renderDescription", "", "(Lcom/android/tools/idea/gradle/structure/configurables/PsContext;Z)V", "renderIssue", "", "buffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "issue", "Lcom/android/tools/idea/gradle/structure/model/PsIssue;", "scope", "Lcom/android/tools/idea/gradle/structure/model/PsPath;", "intellij.android.core"})
public final class DependencyViewIssueRenderer
implements IssueRenderer {
    private final PsContext context;
    private final boolean renderDescription;

    @Override
    public void renderIssue(@NotNull StringBuilder buffer, @NotNull PsIssue issue2, @Nullable PsPath scope) {
        String description;
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Iterable $receiver$iv = CollectionsKt.asReversed((List)CollectionsKt.plus((Collection)PsPathKt.getParents(issue2.getPath()), (Object)issue2.getPath()));
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $receiver$iv) {
            PsPath it = (PsPath)item$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it, (Object)scope) ^ true)) break;
            list$iv.add(item$iv);
        }
        $receiver$iv = CollectionsKt.asReversed((List)list$iv);
        for (Object element$iv : $receiver$iv) {
            PsPath parentPath = (PsPath)element$iv;
            boolean bl = false;
            String parentPathHref = parentPath.getHyperlinkDestination(this.context);
            String parentPathText = this.makeTextWrappable(parentPath.toString());
            buffer.append("<a href=\"" + parentPathHref + "\">" + parentPathText + "</a>: ");
        }
        buffer.append(issue2.getText());
        PsQuickFix quickFixPath = issue2.getQuickFix();
        if (quickFixPath != null) {
            buffer.append(" ").append(quickFixPath.getHtml(this.context));
        }
        if (this.renderDescription && StringUtil.isNotEmpty((String)(description = issue2.getDescription()))) {
            buffer.append("<br/><br/>").append(description);
        }
    }

    public DependencyViewIssueRenderer(@NotNull PsContext context, boolean renderDescription) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.renderDescription = renderDescription;
    }

    @Override
    @NotNull
    public String renderIssue(@NotNull PsIssue issue2, @Nullable PsPath scope) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        return IssueRenderer.DefaultImpls.renderIssue(this, issue2, scope);
    }

    @Override
    @NotNull
    public String makeTextWrappable(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return IssueRenderer.DefaultImpls.makeTextWrappable(this, $receiver);
    }
}

