/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure;

import com.android.tools.idea.gradle.structure.ProjectConfigurationError;
import com.google.common.collect.Lists;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.ui.configuration.ConfigurationError;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.BaseButtonBehavior;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.TimedDeadzone;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ConfigurationErrorsPanel
extends JPanel
implements Disposable,
ListDataListener {
    private static final int MAX_ERRORS_TO_SHOW = SystemProperties.getIntProperty((String)"idea.project.structure.max.errors.to.show", (int)100);
    @NonNls
    private static final String FIX_ACTION_NAME = "FIX";
    @NonNls
    private static final String NAVIGATE_ACTION_NAME = "NAVIGATE";
    private ConfigurationErrorsListModel myListModel;
    private ErrorView myCurrentView;

    ConfigurationErrorsPanel() {
        this.setLayout(new BorderLayout());
        this.myListModel = new ConfigurationErrorsListModel();
        this.myListModel.addListDataListener(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ConfigurationErrorsPanel.this.revalidate();
                ConfigurationErrorsPanel.this.repaint();
            }
        });
        this.ensureCurrentViewIs(ViewType.ONE_LINE);
    }

    public void dispose() {
        if (this.myListModel != null) {
            this.myListModel.removeListDataListener(this);
            this.myListModel = null;
        }
    }

    private void ensureCurrentViewIs(ViewType viewType) {
        if (viewType == ViewType.ONE_LINE) {
            if (this.myCurrentView instanceof OneLineErrorComponent) {
                return;
            }
            OneLineErrorComponent c = new OneLineErrorComponent(this.myListModel){

                @Override
                public void onViewChange(Object data) {
                    ConfigurationErrorsPanel.this.ensureCurrentViewIs(ViewType.MULTI_LINE);
                }
            };
            if (this.myCurrentView != null) {
                this.remove(this.myCurrentView.self());
                Disposer.dispose((Disposable)this.myCurrentView);
            }
            this.myCurrentView = c;
        } else {
            if (this.myCurrentView instanceof MultiLineErrorComponent) {
                return;
            }
            MultiLineErrorComponent c = new MultiLineErrorComponent(this.myListModel){

                @Override
                public void onViewChange(Object data) {
                    ConfigurationErrorsPanel.this.ensureCurrentViewIs(ViewType.ONE_LINE);
                }
            };
            if (this.myCurrentView != null) {
                this.remove(this.myCurrentView.self());
                Disposer.dispose((Disposable)this.myCurrentView);
            }
            this.myCurrentView = c;
        }
        this.add((Component)this.myCurrentView.self(), "Center");
        this.myCurrentView.updateView();
        UIUtil.adjustWindowToMinimumSize((Window)SwingUtilities.getWindowAncestor(this));
        this.revalidate();
        this.repaint();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.updateCurrentView();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.updateCurrentView();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.updateCurrentView();
    }

    private void updateCurrentView() {
        if (this.myCurrentView instanceof MultiLineErrorComponent && this.myListModel.getSize() == 0) {
            this.ensureCurrentViewIs(ViewType.ONE_LINE);
        }
        this.myCurrentView.updateView();
    }

    void addErrors(@NotNull Collection<ProjectConfigurationError> errors) {
        if (errors == null) {
            ConfigurationErrorsPanel.$$$reportNull$$$0(0);
        }
        if (this.myListModel != null) {
            this.myListModel.addErrors(errors);
        }
    }

    void removeAllErrors() {
        if (this.myListModel != null) {
            this.myListModel.removeErrors();
        }
    }

    boolean hasCriticalErrors() {
        List errors = this.myListModel.getErrors();
        if (!errors.isEmpty()) {
            for (ProjectConfigurationError error : errors) {
                if (error.isIgnored()) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errors", "com/android/tools/idea/gradle/structure/ConfigurationErrorsPanel", "addErrors"));
    }

    private static enum ViewType {
        ONE_LINE,
        MULTI_LINE;

    }

    private static class ConfigurationErrorsListModel
    extends AbstractListModel {
        private List<ProjectConfigurationError> myAllErrors = Lists.newArrayList();

        private ConfigurationErrorsListModel() {
        }

        @Override
        public int getSize() {
            return Math.min(this.myAllErrors.size(), MAX_ERRORS_TO_SHOW);
        }

        @Override
        @Nullable
        public Object getElementAt(int index) {
            return this.myAllErrors.get(index);
        }

        void addErrors(@NotNull Collection<ProjectConfigurationError> errors) {
            if (errors == null) {
                ConfigurationErrorsListModel.$$$reportNull$$$0(0);
            }
            for (ProjectConfigurationError error : errors) {
                this.addError(error);
            }
        }

        private void addError(@NotNull ProjectConfigurationError error) {
            if (error == null) {
                ConfigurationErrorsListModel.$$$reportNull$$$0(1);
            }
            if (!this.myAllErrors.contains((Object)error)) {
                this.myAllErrors.add(error);
                int i2 = this.myAllErrors.indexOf((Object)error);
                if (i2 != -1 && i2 < MAX_ERRORS_TO_SHOW) {
                    this.fireIntervalAdded(this, i2, i2);
                }
            }
        }

        @NotNull
        private List<ProjectConfigurationError> getErrors() {
            List<ProjectConfigurationError> list = this.myAllErrors;
            if (list == null) {
                ConfigurationErrorsListModel.$$$reportNull$$$0(2);
            }
            return list;
        }

        public void removeErrors() {
            boolean hadErrors = !this.myAllErrors.isEmpty();
            this.myAllErrors.clear();
            if (hadErrors) {
                this.fireContentsChanged(this, 0, 0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errors";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/structure/ConfigurationErrorsPanel$ConfigurationErrorsListModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/structure/ConfigurationErrorsPanel$ConfigurationErrorsListModel";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getErrors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addErrors";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addError";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class OneLineErrorComponent
    extends JComponent
    implements ErrorView,
    LinkListener {
        private LinkLabel myErrorsLabel;
        private JLabel mySingleErrorLabel;
        private ConfigurationErrorsListModel myModel;

        private OneLineErrorComponent(@NotNull ConfigurationErrorsListModel model) {
            if (model == null) {
                OneLineErrorComponent.$$$reportNull$$$0(0);
            }
            this.myErrorsLabel = new LinkLabel("", null);
            this.mySingleErrorLabel = new JLabel();
            this.myModel = model;
            this.setLayout(new BorderLayout());
            this.setOpaque(true);
            OneLineErrorComponent.updateLabel((JLabel)this.myErrorsLabel, MessageType.ERROR.getPopupBackground(), this, "Errors");
            OneLineErrorComponent.updateLabel(this.mySingleErrorLabel, MessageType.ERROR.getPopupBackground(), null, null);
        }

        public void dispose() {
            this.myModel = null;
        }

        private static void updateLabel(@NotNull JLabel label, @NotNull Color bgColor, @Nullable LinkListener listener2, @Nullable Object linkData) {
            if (label == null) {
                OneLineErrorComponent.$$$reportNull$$$0(1);
            }
            if (bgColor == null) {
                OneLineErrorComponent.$$$reportNull$$$0(2);
            }
            label.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
            label.setOpaque(true);
            label.setBackground(bgColor);
            if (label instanceof LinkLabel) {
                ((LinkLabel)label).setListener(listener2, linkData);
            }
        }

        @Override
        public void updateView() {
            if (this.myModel.getSize() == 0) {
                this.setBorder(null);
            } else if (this.getBorder() == null) {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(5, 0, 5, 0, UIUtil.getPanelBackground()), BorderFactory.createLineBorder(UIUtil.getPanelBackground().darker())));
            }
            List errors = this.myModel.getErrors();
            if (!errors.isEmpty()) {
                if (errors.size() == 1) {
                    this.mySingleErrorLabel.setText(((ProjectConfigurationError)((Object)this.myModel.getErrors().get(0))).getPlainTextTitle());
                } else {
                    this.myErrorsLabel.setText(String.format("%s errors found", OneLineErrorComponent.getErrorsCount(errors.size())));
                }
            }
            this.removeAll();
            if (!errors.isEmpty()) {
                if (errors.size() == 1) {
                    this.add((Component)this.wrapLabel(this.mySingleErrorLabel, (ConfigurationError)errors.get(0)), "Center");
                    this.mySingleErrorLabel.setToolTipText(((ProjectConfigurationError)((Object)errors.get(0))).getDescription());
                } else {
                    this.add((Component)this.myErrorsLabel, "Center");
                }
            }
            this.revalidate();
            this.repaint();
        }

        private static String getErrorsCount(int size) {
            return size < MAX_ERRORS_TO_SHOW ? String.valueOf(size) : MAX_ERRORS_TO_SHOW + "+";
        }

        private JComponent wrapLabel(@NotNull JLabel label, @NotNull ConfigurationError configurationError) {
            if (label == null) {
                OneLineErrorComponent.$$$reportNull$$$0(3);
            }
            if (configurationError == null) {
                OneLineErrorComponent.$$$reportNull$$$0(4);
            }
            JPanel result2 = new JPanel(new BorderLayout());
            result2.setBackground(label.getBackground());
            result2.add((Component)label, "Center");
            JPanel buttonsPanel = new JPanel();
            buttonsPanel.setOpaque(false);
            buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
            if (configurationError.canBeFixed()) {
                buttonsPanel.add(new ToolbarAlikeButton(AllIcons.Actions.QuickfixBulb){
                    {
                        super(icon);
                        this.setToolTipText("Fix error");
                    }

                    @Override
                    public void onClick(MouseEvent e) {
                        Object o = myModel.getElementAt(0);
                        if (o instanceof ConfigurationError) {
                            ((ConfigurationError)o).fix((JComponent)this, new RelativePoint(e));
                            this.updateView();
                            Container ancestor = SwingUtilities.getAncestorOfClass(ConfigurationErrorsPanel.class, this);
                            if (ancestor != null && ancestor instanceof JComponent) {
                                ((JComponent)ancestor).revalidate();
                                ancestor.repaint();
                            }
                        }
                    }
                });
                buttonsPanel.add(Box.createHorizontalStrut(3));
            }
            buttonsPanel.add(new ToolbarAlikeButton(AllIcons.General.AutoscrollToSource){
                {
                    super(icon);
                    this.setToolTipText("Navigate to error");
                }

                @Override
                public void onClick(MouseEvent e) {
                    Object o = myModel.getElementAt(0);
                    if (o instanceof ConfigurationError) {
                        ((ConfigurationError)o).navigate();
                    }
                }
            });
            buttonsPanel.add(Box.createHorizontalStrut(3));
            result2.add((Component)buttonsPanel, "East");
            return result2;
        }

        @Override
        @NotNull
        public JComponent self() {
            OneLineErrorComponent oneLineErrorComponent = this;
            if (oneLineErrorComponent == null) {
                OneLineErrorComponent.$$$reportNull$$$0(5);
            }
            return oneLineErrorComponent;
        }

        @Override
        public abstract void onViewChange(Object var1);

        public void linkSelected(LinkLabel aSource, Object data) {
            this.onViewChange(data);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "label";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bgColor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurationError";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/structure/ConfigurationErrorsPanel$OneLineErrorComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/structure/ConfigurationErrorsPanel$OneLineErrorComponent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "self";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "updateLabel";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "wrapLabel";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ErrorListRenderer
    extends JComponent
    implements ListCellRenderer {
        private boolean mySelected;
        private boolean myHasFocus;
        private JTextPane myText;
        private JTextPane myFakeTextPane;
        private JViewport myFakeViewport;
        private JList myList;
        private JPanel myButtonsPanel;
        private JPanel myFixGroup;

        private ErrorListRenderer(@NotNull JList list) {
            if (list == null) {
                ErrorListRenderer.$$$reportNull$$$0(0);
            }
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.setOpaque(false);
            this.myList = list;
            this.myText = new JTextPane();
            this.myButtonsPanel = new JPanel(new BorderLayout());
            this.myButtonsPanel.setBorder(BorderFactory.createEmptyBorder(5, 3, 5, 3));
            this.myButtonsPanel.setOpaque(false);
            JPanel buttons = new JPanel();
            buttons.setOpaque(false);
            buttons.setLayout(new BoxLayout(buttons, 0));
            this.myButtonsPanel.add((Component)buttons, "North");
            this.add((Component)this.myButtonsPanel, "East");
            this.myFixGroup = new JPanel();
            this.myFixGroup.setOpaque(false);
            this.myFixGroup.setLayout(new BoxLayout(this.myFixGroup, 1));
            this.myFixGroup.add(new ToolbarAlikeButton(AllIcons.Actions.QuickfixBulb, ConfigurationErrorsPanel.FIX_ACTION_NAME){});
            this.myFixGroup.add(Box.createHorizontalStrut(3));
            buttons.add(this.myFixGroup);
            buttons.add(new ToolbarAlikeButton(AllIcons.General.AutoscrollToSource, ConfigurationErrorsPanel.NAVIGATE_ACTION_NAME){});
            buttons.add(Box.createHorizontalStrut(3));
            this.myFakeTextPane = new JTextPane();
            this.myText.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
            this.myFakeTextPane.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
            this.myText.setOpaque(false);
            this.myText.setEditable(false);
            this.myFakeTextPane.setEditable(false);
            this.myText.setEditorKit(UIUtil.getHTMLEditorKit());
            this.myFakeTextPane.setEditorKit(UIUtil.getHTMLEditorKit());
            this.myFakeViewport = new JViewport();
            this.myFakeViewport.setView(this.myFakeTextPane);
            this.add((Component)this.myText, "Center");
        }

        @Override
        public Dimension getPreferredSize() {
            Container parent = this.myList.getParent();
            if (parent != null) {
                this.myFakeTextPane.setText(this.myText.getText());
                Dimension size = parent.getSize();
                this.myFakeViewport.setSize(size);
                Dimension preferredSize = this.myFakeTextPane.getPreferredSize();
                Dimension buttonsPrefSize = this.myButtonsPanel.getPreferredSize();
                int maxHeight = Math.max(buttonsPrefSize.height, preferredSize.height);
                Insets insets = this.getInsets();
                return new Dimension(Math.min(size.width - JBUI.scale((int)20), preferredSize.width), maxHeight + insets.top + insets.bottom);
            }
            return super.getPreferredSize();
        }

        public Component getListCellRendererComponent(JList list, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
            ConfigurationError error = (ConfigurationError)value2;
            this.myList = list;
            this.mySelected = isSelected;
            this.myHasFocus = cellHasFocus;
            this.myFixGroup.setVisible(error.canBeFixed());
            this.myText.setText(error.getDescription());
            this.setBackground(error.isIgnored() ? MessageType.WARNING.getPopupBackground() : MessageType.ERROR.getPopupBackground());
            return this;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Rectangle bounds = this.getBounds();
            Insets insets = this.getInsets();
            GraphicsConfig cfg = new GraphicsConfig(g);
            cfg.setAntialiasing(true);
            RoundRectangle2D.Double shape = new RoundRectangle2D.Double(insets.left, insets.top, bounds.width - 1 - insets.left - insets.right, bounds.height - 1 - insets.top - insets.bottom, 6.0, 6.0);
            if (this.mySelected) {
                g2d.setColor(UIUtil.getListSelectionBackground());
                g2d.fillRect(0, 0, bounds.width, bounds.height);
            }
            g2d.setColor((Color)JBColor.WHITE);
            g2d.fill(shape);
            Color bgColor = this.getBackground();
            g2d.setColor(bgColor);
            g2d.fill(shape);
            g2d.setColor(this.myHasFocus || this.mySelected ? this.getBackground().darker().darker() : this.getBackground().darker());
            g2d.draw(shape);
            cfg.restore();
            super.paintComponent(g);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/gradle/structure/ConfigurationErrorsPanel$ErrorListRenderer", "<init>"));
        }
    }

    private static abstract class ToolbarAlikeButton
    extends JComponent {
        private BaseButtonBehavior myBehavior;
        private Icon myIcon;
        private String myName;

        private ToolbarAlikeButton(@NotNull Icon icon, @NotNull String name) {
            if (icon == null) {
                ToolbarAlikeButton.$$$reportNull$$$0(0);
            }
            if (name == null) {
                ToolbarAlikeButton.$$$reportNull$$$0(1);
            }
            this(icon);
            this.myName = name;
        }

        private ToolbarAlikeButton(@NotNull Icon icon) {
            if (icon == null) {
                ToolbarAlikeButton.$$$reportNull$$$0(2);
            }
            this.myIcon = icon;
            this.myBehavior = new BaseButtonBehavior(this, TimedDeadzone.NULL){

                protected void execute(MouseEvent e) {
                    this.onClick(e);
                }
            };
            this.setOpaque(false);
        }

        public String getButtonName() {
            return this.myName;
        }

        public void onClick(MouseEvent e) {
        }

        @Override
        public Insets getInsets() {
            return new Insets(2, 2, 2, 2);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension size = new Dimension(this.myIcon.getIconWidth(), this.myIcon.getIconHeight());
            JBInsets.addTo((Dimension)size, (Insets)this.getInsets());
            return size;
        }

        @Override
        public void paint(Graphics g) {
            Rectangle bounds = new Rectangle(this.getWidth(), this.getHeight());
            JBInsets.removeFrom((Rectangle)bounds, (Insets)this.getInsets());
            bounds.x += (bounds.width - this.myIcon.getIconWidth()) / 2;
            bounds.y += (bounds.height - this.myIcon.getIconHeight()) / 2;
            if (this.myBehavior.isPressedByMouse()) {
                ++bounds.x;
                ++bounds.y;
            }
            this.myIcon.paintIcon(this, g, bounds.x, bounds.y);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "icon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/structure/ConfigurationErrorsPanel$ToolbarAlikeButton";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class MultiLineErrorComponent
    extends JPanel
    implements ErrorView {
        private JList myList;

        protected MultiLineErrorComponent(@NotNull ConfigurationErrorsListModel model) {
            if (model == null) {
                MultiLineErrorComponent.$$$reportNull$$$0(0);
            }
            this.myList = new JBList();
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            this.myList.setModel(model);
            this.myList.setCellRenderer(new ErrorListRenderer(this.myList));
            this.myList.setBackground(UIUtil.getPanelBackground());
            this.myList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (!e.isPopupTrigger()) {
                        this.processListMouseEvent(e, true);
                    }
                }
            });
            this.myList.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (!e.isPopupTrigger()) {
                        this.processListMouseEvent(e, false);
                    }
                }
            });
            this.myList.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    myList.setCellRenderer(new ErrorListRenderer(myList));
                    this.updatePreferredSize();
                }
            });
            this.add((Component)new JBScrollPane((Component)this.myList), "Center");
            this.add((Component)this.buildToolbar(), "West");
        }

        public void dispose() {
        }

        /*
         * Enabled aggressive block sorting
         */
        private void processListMouseEvent(@NotNull MouseEvent e, boolean wasClicked) {
            block8: {
                ConfigurationError error;
                block9: {
                    String name;
                    block10: {
                        Object value2;
                        int index;
                        if (e == null) {
                            MultiLineErrorComponent.$$$reportNull$$$0(1);
                        }
                        if ((index = this.myList.locationToIndex(e.getPoint())) <= -1 || !((value2 = this.myList.getModel().getElementAt(index)) instanceof ConfigurationError)) break block8;
                        error = (ConfigurationError)value2;
                        Component renderer = this.myList.getCellRenderer().getListCellRendererComponent(this.myList, value2, index, false, false);
                        if (!(renderer instanceof ErrorListRenderer)) break block8;
                        Rectangle bounds = this.myList.getCellBounds(index, index);
                        renderer.setBounds(bounds);
                        renderer.doLayout();
                        Point point = e.getPoint();
                        point.translate(-bounds.x, -bounds.y);
                        Component deepestComponentAt = SwingUtilities.getDeepestComponentAt(renderer, point.x, point.y);
                        if (!(deepestComponentAt instanceof ToolbarAlikeButton)) break block9;
                        name = ((ToolbarAlikeButton)deepestComponentAt).getButtonName();
                        if (!wasClicked) break block10;
                        if (ConfigurationErrorsPanel.FIX_ACTION_NAME.equals(name)) {
                            MultiLineErrorComponent.onClickFix(error, (JComponent)deepestComponentAt, e);
                            break block8;
                        } else if (ConfigurationErrorsPanel.NAVIGATE_ACTION_NAME.equals(name)) {
                            error.navigate();
                        }
                        break block8;
                    }
                    String toolTip = "";
                    if (ConfigurationErrorsPanel.FIX_ACTION_NAME.equals(name)) {
                        toolTip = "Fix";
                    } else if (ConfigurationErrorsPanel.NAVIGATE_ACTION_NAME.equals(name)) {
                        toolTip = "Navigate to the problem";
                    }
                    this.myList.setToolTipText(toolTip);
                    return;
                }
                if (e.getClickCount() == 2) {
                    error.navigate();
                }
            }
            this.myList.setToolTipText(null);
        }

        private static void onClickFix(@NotNull ConfigurationError error, @NotNull JComponent component, @NotNull MouseEvent e) {
            if (error == null) {
                MultiLineErrorComponent.$$$reportNull$$$0(2);
            }
            if (component == null) {
                MultiLineErrorComponent.$$$reportNull$$$0(3);
            }
            if (e == null) {
                MultiLineErrorComponent.$$$reportNull$$$0(4);
            }
            error.fix(component, new RelativePoint(e));
        }

        @Override
        public void addNotify() {
            super.addNotify();
            this.updatePreferredSize();
        }

        private void updatePreferredSize() {
            Window window = SwingUtilities.getWindowAncestor(this);
            if (window != null) {
                Dimension preferredSize = this.getPreferredSize();
                this.setPreferredSize(new Dimension(preferredSize.width, JBUI.scale((int)200)));
                this.setMinimumSize(this.getPreferredSize());
            }
        }

        private JComponent buildToolbar() {
            JPanel result2 = new JPanel();
            result2.setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)0, (int)0));
            result2.setLayout(new BorderLayout());
            result2.add((Component)new ToolbarAlikeButton(AllIcons.Actions.Collapseall){
                {
                    super(icon);
                    this.setToolTipText("Collapse");
                }

                @Override
                public void onClick(MouseEvent e) {
                    this.onViewChange(null);
                }
            }, "North");
            return result2;
        }

        @Override
        public void updateView() {
        }

        @Override
        @NotNull
        public JComponent self() {
            MultiLineErrorComponent multiLineErrorComponent = this;
            if (multiLineErrorComponent == null) {
                MultiLineErrorComponent.$$$reportNull$$$0(5);
            }
            return multiLineErrorComponent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/structure/ConfigurationErrorsPanel$MultiLineErrorComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/structure/ConfigurationErrorsPanel$MultiLineErrorComponent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "self";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "processListMouseEvent";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "onClickFix";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface ErrorView
    extends Disposable {
        public void updateView();

        public void onViewChange(@Nullable Object var1);

        @NotNull
        public JComponent self();
    }
}

