/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.validation.common;

import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.validation.common.CommonProjectValidationStrategy;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class UniquePathModuleValidatorStrategy
extends CommonProjectValidationStrategy {
    @NotNull
    private final Multimap<String, Module> myModulesByPath;

    UniquePathModuleValidatorStrategy(@NotNull Project project) {
        if (project == null) {
            UniquePathModuleValidatorStrategy.$$$reportNull$$$0(0);
        }
        super(project);
        this.myModulesByPath = HashMultimap.create();
    }

    @Override
    void validate(@NotNull Module module) {
        if (module == null) {
            UniquePathModuleValidatorStrategy.$$$reportNull$$$0(1);
        }
        if (!GradleProjects.isIdeaAndroidModule(module)) {
            return;
        }
        File moduleFolderPath = GradleProjects.findModuleRootFolderPath(module);
        if (moduleFolderPath != null) {
            this.myModulesByPath.put((Object)moduleFolderPath.getPath(), (Object)module);
        }
    }

    @Override
    void fixAndReportFoundIssues() {
        Set modulePaths = this.myModulesByPath.keySet();
        for (String modulePath : modulePaths) {
            ArrayList<Module> modules = new ArrayList<Module>(this.myModulesByPath.get((Object)modulePath));
            modules.sort(Comparator.comparing(Module::getName));
            int moduleCount = modules.size();
            if (moduleCount <= 1) continue;
            StringBuilder msg = new StringBuilder();
            msg.append("The modules [");
            int i2 = 0;
            for (Module module : modules) {
                if (i2++ != 0) {
                    msg.append(", ");
                }
                String name = module.getName();
                msg.append("'").append(name).append("'");
            }
            msg.append("] point to the same directory in the file system.");
            String[] lines = new String[]{msg.toString(), "Each module must have a unique path."};
            SyncMessage message = new SyncMessage("Project Structure Issues", MessageType.ERROR, lines);
            Project project = this.getProject();
            GradleSyncMessages.getInstance(project).report(message);
        }
    }

    @VisibleForTesting
    @NotNull
    Multimap<String, Module> getModulesByPath() {
        Multimap<String, Module> multimap = this.myModulesByPath;
        if (multimap == null) {
            UniquePathModuleValidatorStrategy.$$$reportNull$$$0(2);
        }
        return multimap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/validation/common/UniquePathModuleValidatorStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/validation/common/UniquePathModuleValidatorStrategy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesByPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

