/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post.project;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleModelProvider;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectSetupStep;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.android.utils.FileUtils;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgnoredBuildScriptSetupStep
extends ProjectSetupStep {
    public static final String IGNORED_PATH_IN_SETTINGS = "File \u2192 Settings \u2192 Editor \u2192 File Types";

    @Override
    public void setUpProject(@NotNull Project project, @Nullable ProgressIndicator indicator) {
        File projectPath;
        File projectBuildPath;
        if (project == null) {
            IgnoredBuildScriptSetupStep.$$$reportNull$$$0(0);
        }
        if ((projectBuildPath = GradleUtil.getGradleBuildFilePath(projectPath = Projects.getBaseDirPath((Project)project))).exists()) {
            IgnoredBuildScriptSetupStep.checkIsNotIgnored("Build script for project " + project.getName(), projectBuildPath, project);
        }
        File dotGradleFolder = new File(projectPath, ".gradle");
        IgnoredBuildScriptSetupStep.checkIsNotIgnored("Project " + project.getName() + " " + ".gradle" + " folder", dotGradleFolder, project);
        GradleModelProvider modelProvider = GradleModelProvider.get();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            File moduleBuildPath;
            GradleBuildModel buildModel = modelProvider.getBuildModel(module);
            if (buildModel == null || !(moduleBuildPath = new File(buildModel.getVirtualFile().getPath())).exists() || FileUtils.isSameFile((File)moduleBuildPath, (File)projectBuildPath)) continue;
            IgnoredBuildScriptSetupStep.checkIsNotIgnored("Build script for module " + module.getName(), moduleBuildPath, project);
        }
    }

    @Override
    public boolean invokeOnFailedSync() {
        return false;
    }

    public static void checkIsNotIgnored(@NotNull String prefix, @NotNull File path, @NotNull Project project) {
        if (prefix == null) {
            IgnoredBuildScriptSetupStep.$$$reportNull$$$0(1);
        }
        if (path == null) {
            IgnoredBuildScriptSetupStep.$$$reportNull$$$0(2);
        }
        if (project == null) {
            IgnoredBuildScriptSetupStep.$$$reportNull$$$0(3);
        }
        IgnoredBuildScriptSetupStep.checkIsNotIgnored(prefix, path, FileTypeManager.getInstance(), GradleSyncMessages.getInstance(project));
    }

    static void checkIsNotIgnored(@NotNull String prefix, @NotNull File path, @NotNull FileTypeManager fileTypeManager, @NotNull GradleSyncMessages messages) {
        if (prefix == null) {
            IgnoredBuildScriptSetupStep.$$$reportNull$$$0(4);
        }
        if (path == null) {
            IgnoredBuildScriptSetupStep.$$$reportNull$$$0(5);
        }
        if (fileTypeManager == null) {
            IgnoredBuildScriptSetupStep.$$$reportNull$$$0(6);
        }
        if (messages == null) {
            IgnoredBuildScriptSetupStep.$$$reportNull$$$0(7);
        }
        if (fileTypeManager.isFileIgnored(path.getPath())) {
            String[] text = new String[]{prefix + " is being ignored. This can cause issues on the IDE.", "Ignored path: " + path, "You can change ignored files and folders from File \u2192 Settings \u2192 Editor \u2192 File Types"};
            messages.report(new SyncMessage("Gradle Sync Issues", MessageType.WARNING, text));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/post/project/IgnoredBuildScriptSetupStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setUpProject";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIsNotIgnored";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

