/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.builder.model.SyncIssue;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.Projects;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.ProjectBuildFileChecksums;
import com.android.tools.idea.gradle.project.ProjectStructure;
import com.android.tools.idea.gradle.project.RunConfigurationChecker;
import com.android.tools.idea.gradle.project.SupportedModuleChecker;
import com.android.tools.idea.gradle.project.build.BuildStatus;
import com.android.tools.idea.gradle.project.build.GradleBuildState;
import com.android.tools.idea.gradle.project.build.GradleProjectBuilder;
import com.android.tools.idea.gradle.project.build.output.AndroidGradleSyncTextConsoleView;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.compatibility.VersionCompatibilityChecker;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.module.common.DependencySetupIssues;
import com.android.tools.idea.gradle.project.sync.setup.post.EnableDisableSingleVariantSyncStep;
import com.android.tools.idea.gradle.project.sync.setup.post.ModuleSetup;
import com.android.tools.idea.gradle.project.sync.setup.post.PluginVersionUpgrade;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectSetup;
import com.android.tools.idea.gradle.project.sync.setup.post.ProjectStructureUsageTracker;
import com.android.tools.idea.gradle.project.sync.setup.post.project.DisposedModules;
import com.android.tools.idea.gradle.project.sync.validation.common.CommonModuleValidator;
import com.android.tools.idea.gradle.run.MakeBeforeRunTaskProvider;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.variant.conflict.Conflict;
import com.android.tools.idea.gradle.variant.conflict.ConflictSet;
import com.android.tools.idea.gradle.variant.profiles.ProjectProfileSelectionDialog;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.templates.TemplateManager;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfiguration;
import com.android.tools.idea.testartifacts.junit.AndroidJUnitConfigurationType;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.Failure;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.concurrency.JobLauncher;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SystemProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostSyncProjectSetup {
    @NotNull
    private final Project myProject;
    @NotNull
    private final IdeInfo myIdeInfo;
    @NotNull
    private final ProjectStructure myProjectStructure;
    @NotNull
    private final GradleProjectInfo myGradleProjectInfo;
    @NotNull
    private final GradleSyncInvoker mySyncInvoker;
    @NotNull
    private final GradleSyncState mySyncState;
    @NotNull
    private final DependencySetupIssues myDependencySetupIssues;
    @NotNull
    private final ProjectSetup myProjectSetup;
    @NotNull
    private final ModuleSetup myModuleSetup;
    @NotNull
    private final PluginVersionUpgrade myPluginVersionUpgrade;
    @NotNull
    private final VersionCompatibilityChecker myVersionCompatibilityChecker;
    @NotNull
    private final GradleProjectBuilder myProjectBuilder;
    @NotNull
    private final CommonModuleValidator.Factory myModuleValidatorFactory;
    @NotNull
    private final RunManagerEx myRunManager;

    @NotNull
    public static PostSyncProjectSetup getInstance(@NotNull Project project) {
        if (project == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(0);
        }
        PostSyncProjectSetup postSyncProjectSetup = (PostSyncProjectSetup)ServiceManager.getService((Project)project, PostSyncProjectSetup.class);
        if (postSyncProjectSetup == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(1);
        }
        return postSyncProjectSetup;
    }

    public PostSyncProjectSetup(@NotNull Project project, @NotNull IdeInfo ideInfo, @NotNull ProjectStructure projectStructure, @NotNull GradleProjectInfo gradleProjectInfo, @NotNull GradleSyncInvoker syncInvoker, @NotNull GradleSyncState syncState, @NotNull GradleSyncMessages syncMessages, @NotNull DependencySetupIssues dependencySetupIssues, @NotNull PluginVersionUpgrade pluginVersionUpgrade, @NotNull VersionCompatibilityChecker versionCompatibilityChecker, @NotNull GradleProjectBuilder projectBuilder) {
        if (project == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(2);
        }
        if (ideInfo == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(3);
        }
        if (projectStructure == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(4);
        }
        if (gradleProjectInfo == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(5);
        }
        if (syncInvoker == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(6);
        }
        if (syncState == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(7);
        }
        if (syncMessages == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(8);
        }
        if (dependencySetupIssues == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(9);
        }
        if (pluginVersionUpgrade == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(10);
        }
        if (versionCompatibilityChecker == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(11);
        }
        if (projectBuilder == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(12);
        }
        this(project, ideInfo, projectStructure, gradleProjectInfo, syncInvoker, syncState, dependencySetupIssues, new ProjectSetup(project), new ModuleSetup(project), pluginVersionUpgrade, versionCompatibilityChecker, projectBuilder, new CommonModuleValidator.Factory(), RunManagerEx.getInstanceEx((Project)project));
    }

    @VisibleForTesting
    PostSyncProjectSetup(@NotNull Project project, @NotNull IdeInfo ideInfo, @NotNull ProjectStructure projectStructure, @NotNull GradleProjectInfo gradleProjectInfo, @NotNull GradleSyncInvoker syncInvoker, @NotNull GradleSyncState syncState, @NotNull DependencySetupIssues dependencySetupIssues, @NotNull ProjectSetup projectSetup, @NotNull ModuleSetup moduleSetup, @NotNull PluginVersionUpgrade pluginVersionUpgrade, @NotNull VersionCompatibilityChecker versionCompatibilityChecker, @NotNull GradleProjectBuilder projectBuilder, @NotNull CommonModuleValidator.Factory moduleValidatorFactory, @NotNull RunManagerEx runManager) {
        if (project == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(13);
        }
        if (ideInfo == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(14);
        }
        if (projectStructure == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(15);
        }
        if (gradleProjectInfo == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(16);
        }
        if (syncInvoker == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(17);
        }
        if (syncState == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(18);
        }
        if (dependencySetupIssues == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(19);
        }
        if (projectSetup == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(20);
        }
        if (moduleSetup == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(21);
        }
        if (pluginVersionUpgrade == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(22);
        }
        if (versionCompatibilityChecker == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(23);
        }
        if (projectBuilder == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(24);
        }
        if (moduleValidatorFactory == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(25);
        }
        if (runManager == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(26);
        }
        this.myProject = project;
        this.myIdeInfo = ideInfo;
        this.myProjectStructure = projectStructure;
        this.myGradleProjectInfo = gradleProjectInfo;
        this.mySyncInvoker = syncInvoker;
        this.mySyncState = syncState;
        this.myDependencySetupIssues = dependencySetupIssues;
        this.myProjectSetup = projectSetup;
        this.myModuleSetup = moduleSetup;
        this.myPluginVersionUpgrade = pluginVersionUpgrade;
        this.myVersionCompatibilityChecker = versionCompatibilityChecker;
        this.myProjectBuilder = projectBuilder;
        this.myModuleValidatorFactory = moduleValidatorFactory;
        this.myRunManager = runManager;
    }

    public void setUpProject(@NotNull Request request, @NotNull ProgressIndicator progressIndicator, @Nullable ExternalSystemTaskId taskId) {
        if (request == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(27);
        }
        if (progressIndicator == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(28);
        }
        try {
            if (!((Boolean)StudioFlags.NEW_SYNC_INFRA_ENABLED.get()).booleanValue()) {
                ModuleSetupContext.removeSyncContextDataFrom(this.myProject);
            }
            this.myGradleProjectInfo.setNewProject(false);
            this.myGradleProjectInfo.setImportedProject(false);
            boolean syncFailed = this.mySyncState.lastSyncFailedOrHasIssues();
            if (syncFailed && request.usingCachedGradleModels) {
                this.onCachedModelsSetupFailure(request);
                return;
            }
            this.myDependencySetupIssues.reportIssues();
            this.myVersionCompatibilityChecker.checkAndReportComponentIncompatibilities(this.myProject);
            ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
            List<Module> modules = Arrays.asList(moduleManager.getModules());
            CommonModuleValidator moduleValidator = this.myModuleValidatorFactory.create(this.myProject);
            JobLauncher.getInstance().invokeConcurrentlyUnderProgress(modules, progressIndicator, module -> {
                moduleValidator.validate((Module)module);
                return true;
            });
            moduleValidator.fixAndReportFoundIssues();
            if (syncFailed) {
                this.failTestsIfSyncIssuesPresent();
                this.myProjectSetup.setUpProject(progressIndicator, true);
                this.mySyncState.syncFailed("");
                PostSyncProjectSetup.finishFailedSync(taskId, this.myProject);
                return;
            }
            boolean skipAgpUpgrade = SystemProperties.getBooleanProperty((String)"studio.skip.agp.upgrade", (boolean)false);
            if (!skipAgpUpgrade && !request.skipAndroidPluginUpgrade && this.myPluginVersionUpgrade.checkAndPerformUpgrade()) {
                this.finishSuccessfulSync(taskId);
                return;
            }
            new ProjectStructureUsageTracker(this.myProject).trackProjectStructure();
            DisposedModules.getInstance(this.myProject).deleteImlFilesForDisposedModules();
            SupportedModuleChecker.getInstance().checkForSupportedModules(this.myProject);
            this.findAndShowVariantConflicts();
            this.myProjectSetup.setUpProject(progressIndicator, false);
            this.modifyJUnitRunConfigurations();
            RunConfigurationChecker.getInstance(this.myProject).ensureRunConfigsInvokeBuild();
            ProjectStructure.AndroidPluginVersionsInProject agpVersions = this.myProjectStructure.getAndroidPluginVersions();
            this.myProjectStructure.analyzeProjectStructure(progressIndicator);
            boolean cleanProjectAfterSync = this.myProjectStructure.getAndroidPluginVersions().haveVersionsChanged(agpVersions);
            this.attemptToGenerateSources(request, cleanProjectAfterSync);
            this.notifySyncFinished(request);
            TemplateManager.getInstance().refreshDynamicTemplateMenu(this.myProject);
            this.myModuleSetup.setUpModules(null);
            this.finishSuccessfulSync(taskId);
            EnableDisableSingleVariantSyncStep.setSingleVariantSyncState(this.myProject);
        }
        catch (Throwable t) {
            this.mySyncState.syncFailed("setup project failed: " + t.getMessage());
            PostSyncProjectSetup.finishFailedSync(taskId, this.myProject);
            this.getLog().error(t);
        }
    }

    private void finishSuccessfulSync(@Nullable ExternalSystemTaskId taskId) {
        if (taskId == null) {
            return;
        }
        String message = "synced successfully";
        GradleSyncMessages messages = GradleSyncMessages.getInstance(this.myProject);
        List<Failure> failures = messages.showEvents(taskId);
        Object result2 = failures.isEmpty() ? new SuccessResultImpl() : new FailureResultImpl(failures);
        FinishBuildEventImpl finishBuildEvent = new FinishBuildEventImpl((Object)taskId, null, System.currentTimeMillis(), message, (EventResult)result2);
        ((SyncViewManager)ServiceManager.getService((Project)this.myProject, SyncViewManager.class)).onEvent((BuildEvent)finishBuildEvent);
    }

    public static void finishFailedSync(@Nullable ExternalSystemTaskId taskId, @NotNull Project project) {
        if (project == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(29);
        }
        if (taskId != null) {
            String message = "sync failed";
            GradleSyncMessages messages = GradleSyncMessages.getInstance(project);
            List<Failure> failures = messages.showEvents(taskId);
            FailureResultImpl failureResult = new FailureResultImpl(failures);
            FinishBuildEventImpl finishBuildEvent = new FinishBuildEventImpl((Object)taskId, null, System.currentTimeMillis(), message, (EventResult)failureResult);
            ((SyncViewManager)ServiceManager.getService((Project)project, SyncViewManager.class)).onEvent((BuildEvent)finishBuildEvent);
        }
    }

    public void onCachedModelsSetupFailure(@NotNull Request request) {
        long syncTimestamp;
        if (request == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(30);
        }
        if ((syncTimestamp = request.lastSyncTimestamp) < 0L) {
            syncTimestamp = System.currentTimeMillis();
        }
        this.mySyncState.syncSkipped(syncTimestamp);
        this.mySyncInvoker.requestProjectSyncAndSourceGeneration(this.myProject, GradleSyncStats.Trigger.TRIGGER_PROJECT_LOADED);
    }

    private void failTestsIfSyncIssuesPresent() {
        if (ApplicationManager.getApplication().isUnitTestMode() && this.mySyncState.getSummary().hasSyncErrors()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Sync issues found!").append('\n');
            this.myGradleProjectInfo.forEachAndroidModule((Consumer<AndroidFacet>)((Consumer)facet -> {
                Collection<SyncIssue> issues;
                AndroidModel androidModel = ((AndroidFacetConfiguration)facet.getConfiguration()).getModel();
                if (androidModel instanceof AndroidModuleModel && (issues = ((AndroidModuleModel)androidModel).getSyncIssues()) != null && !issues.isEmpty()) {
                    buffer.append("Module '").append(facet.getModule().getName()).append("':").append('\n');
                    for (SyncIssue issue2 : issues) {
                        buffer.append(issue2.getMessage()).append('\n');
                    }
                }
            }));
            throw new IllegalStateException(buffer.toString());
        }
    }

    private void notifySyncFinished(@NotNull Request request) {
        if (request == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(31);
        }
        if (request.usingCachedGradleModels) {
            long timestamp = System.currentTimeMillis();
            this.mySyncState.syncSkipped(timestamp);
            GradleBuildState.getInstance(this.myProject).buildFinished(BuildStatus.SKIPPED);
        } else {
            if (this.mySyncState.lastSyncFailedOrHasIssues()) {
                this.mySyncState.syncFailed("");
            } else {
                this.mySyncState.syncEnded();
            }
            ProjectBuildFileChecksums.saveToDisk(this.myProject);
        }
    }

    private void findAndShowVariantConflicts() {
        ConflictSet conflicts = ConflictSet.findConflicts(this.myProject);
        List<Conflict> structureConflicts = conflicts.getStructureConflicts();
        if (!structureConflicts.isEmpty() && SystemProperties.getBooleanProperty((String)"enable.project.profiles", (boolean)false)) {
            ProjectProfileSelectionDialog dialog = new ProjectProfileSelectionDialog(this.myProject, structureConflicts);
            dialog.show();
        }
        conflicts.showSelectionConflicts();
    }

    private void modifyJUnitRunConfigurations() {
        AndroidJUnitConfigurationType junitConfigurationType = AndroidJUnitConfigurationType.getInstance();
        BeforeRunTaskProvider[] taskProviders = (BeforeRunTaskProvider[])Extensions.getExtensions((ExtensionPointName)BeforeRunTaskProvider.EXTENSION_POINT_NAME, (AreaInstance)this.myProject);
        RunManagerEx runManager = RunManagerEx.getInstanceEx((Project)this.myProject);
        Key makeTaskId = this.myIdeInfo.isAndroidStudio() ? MakeBeforeRunTaskProvider.ID : CompileStepBeforeRun.ID;
        BeforeRunTaskProvider targetProvider = null;
        for (BeforeRunTaskProvider provider : taskProviders) {
            if (!makeTaskId.equals((Object)provider.getId())) continue;
            targetProvider = provider;
            break;
        }
        if (targetProvider != null) {
            HashMap currentTasks = new HashMap();
            for (RunConfiguration runConfiguration : this.myRunManager.getConfigurationsList((ConfigurationType)junitConfigurationType)) {
                currentTasks.put(runConfiguration, new ArrayList(runManager.getBeforeRunTasks(runConfiguration)));
            }
            for (ConfigurationFactory configurationFactory : junitConfigurationType.getConfigurationFactories()) {
                RunnerAndConfigurationSettings template = this.myRunManager.getConfigurationTemplate(configurationFactory);
                AndroidJUnitConfiguration runConfiguration = (AndroidJUnitConfiguration)template.getConfiguration();
                this.setMakeStepInJUnitConfiguration(targetProvider, (RunConfiguration)runConfiguration);
                runConfiguration.setWorkingDirectory("$MODULE_DIR$");
            }
            for (RunConfiguration runConfiguration : this.myRunManager.getConfigurationsList((ConfigurationType)junitConfigurationType)) {
                runManager.setBeforeRunTasks(runConfiguration, (List)currentTasks.get(runConfiguration), false);
            }
        }
    }

    private void setMakeStepInJUnitConfiguration(@NotNull BeforeRunTaskProvider targetProvider, @NotNull RunConfiguration runConfiguration) {
        if (targetProvider == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(32);
        }
        if (runConfiguration == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(33);
        }
        LinkedList<BeforeRunTask> newBeforeRunTasks = new LinkedList<BeforeRunTask>();
        RunManagerEx runManager = RunManagerEx.getInstanceEx((Project)this.myProject);
        for (BeforeRunTask beforeRunTask : runManager.getBeforeRunTasks(runConfiguration)) {
            if (beforeRunTask.getProviderId().equals((Object)CompileStepBeforeRun.ID)) {
                BeforeRunTask task;
                if (!runManager.getBeforeRunTasks(runConfiguration, MakeBeforeRunTaskProvider.ID).isEmpty() || (task = targetProvider.createTask(runConfiguration)) == null) continue;
                task.setEnabled(true);
                newBeforeRunTasks.add(task);
                continue;
            }
            newBeforeRunTasks.add(beforeRunTask);
        }
        runManager.setBeforeRunTasks(runConfiguration, newBeforeRunTasks);
    }

    private void attemptToGenerateSources(@NotNull Request request, boolean cleanProjectAfterSync) {
        if (request == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(34);
        }
        if (!request.generateSourcesAfterSync) {
            return;
        }
        if (cleanProjectAfterSync) {
            this.myProjectBuilder.cleanAndGenerateSources();
            return;
        }
        this.myProjectBuilder.generateSources();
    }

    @NotNull
    private Logger getLog() {
        Logger logger = Logger.getInstance(this.getClass());
        if (logger == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(35);
        }
        return logger;
    }

    @NotNull
    public static ExternalSystemTaskId createProjectSetupFromCacheTaskWithStartMessage(Project project) {
        ExternalSystemTaskId taskId = ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.EXECUTE_TASK, (Project)project);
        String workingDir = FileUtil.toCanonicalPath((String)Projects.getBaseDirPath((Project)project).getPath());
        DefaultBuildDescriptor buildDescriptor = new DefaultBuildDescriptor((Object)taskId, "Project setup", workingDir, System.currentTimeMillis());
        SyncViewManager syncManager = (SyncViewManager)ServiceManager.getService((Project)project, SyncViewManager.class);
        syncManager.onEvent((BuildEvent)new StartBuildEventImpl((BuildDescriptor)buildDescriptor, "reading from cache...").withContentDescriptorSupplier(() -> {
            AndroidGradleSyncTextConsoleView consoleView = new AndroidGradleSyncTextConsoleView(project);
            return new RunContentDescriptor((ExecutionConsole)consoleView, null, consoleView.getComponent(), "Gradle Sync");
        }));
        ExternalSystemTaskId externalSystemTaskId = taskId;
        if (externalSystemTaskId == null) {
            PostSyncProjectSetup.$$$reportNull$$$0(36);
        }
        return externalSystemTaskId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 35: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 35: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideInfo";
                break;
            }
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectStructure";
                break;
            }
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProjectInfo";
                break;
            }
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncInvoker";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncState";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncMessages";
                break;
            }
            case 9: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencySetupIssues";
                break;
            }
            case 10: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginVersionUpgrade";
                break;
            }
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionCompatibilityChecker";
                break;
            }
            case 12: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectBuilder";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSetup";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleSetup";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleValidatorFactory";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runManager";
                break;
            }
            case 27: 
            case 30: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetProvider";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/post/PostSyncProjectSetup";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectSetupFromCacheTaskWithStartMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 35: 
            case 36: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setUpProject";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "finishFailedSync";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "onCachedModelsSetupFailure";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "notifySyncFinished";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setMakeStepInJUnitConfiguration";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "attemptToGenerateSources";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 35: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Request {
        public boolean usingCachedGradleModels;
        public boolean cleanProjectAfterSync;
        public boolean generateSourcesAfterSync = true;
        public boolean skipAndroidPluginUpgrade;
        public long lastSyncTimestamp = -1L;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return this.usingCachedGradleModels == request.usingCachedGradleModels && this.cleanProjectAfterSync == request.cleanProjectAfterSync && this.generateSourcesAfterSync == request.generateSourcesAfterSync && this.lastSyncTimestamp == request.lastSyncTimestamp;
        }

        public int hashCode() {
            return Objects.hash(this.usingCachedGradleModels, this.cleanProjectAfterSync, this.generateSourcesAfterSync, this.lastSyncTimestamp);
        }
    }
}

