/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.post;

import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.facet.ndk.NdkFacet;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EnableDisableSingleVariantSyncStep {
    public static final String PATH_IN_SETTINGS = "File \u2192 Settings \u2192 Experimental \u2192 Gradle \u2192 Only sync the active variant";

    public static void setSingleVariantSyncState(@NotNull Project project) {
        if (project == null) {
            EnableDisableSingleVariantSyncStep.$$$reportNull$$$0(0);
        }
        EligibilityState state = EnableDisableSingleVariantSyncStep.isEligibleForSingleVariantSync(project);
    }

    @NotNull
    static EligibilityState isEligibleForSingleVariantSync(@NotNull Project project) {
        if (project == null) {
            EnableDisableSingleVariantSyncStep.$$$reportNull$$$0(1);
        }
        boolean hasAndroidModule = false;
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (EnableDisableSingleVariantSyncStep.hasKotlinPlugin(module)) {
                EligibilityState eligibilityState = EligibilityState.HAS_KOTLIN;
                if (eligibilityState == null) {
                    EnableDisableSingleVariantSyncStep.$$$reportNull$$$0(2);
                }
                return eligibilityState;
            }
            for (Facet facet : FacetManager.getInstance((Module)module).getAllFacets()) {
                NdkModuleModel ndkModel;
                if ("Android".equals(facet.getName())) {
                    hasAndroidModule = true;
                    AndroidModuleModel androidModel = AndroidModuleModel.get(module);
                    if (androidModel != null && !androidModel.getFeatures().isSingleVariantSyncSupported()) {
                        EligibilityState eligibilityState = EligibilityState.OLD_PLUGIN;
                        if (eligibilityState == null) {
                            EnableDisableSingleVariantSyncStep.$$$reportNull$$$0(3);
                        }
                        return eligibilityState;
                    }
                }
                if (NdkFacet.getFacetName().equals(facet.getName()) && (ndkModel = NdkModuleModel.get(module)) != null && !ndkModel.getFeatures().isSingleVariantSyncSupported()) {
                    EligibilityState eligibilityState = EligibilityState.OLD_PLUGIN;
                    if (eligibilityState == null) {
                        EnableDisableSingleVariantSyncStep.$$$reportNull$$$0(4);
                    }
                    return eligibilityState;
                }
                if (!"Kotlin".equals(facet.getName())) continue;
                EligibilityState eligibilityState = EligibilityState.HAS_KOTLIN;
                if (eligibilityState == null) {
                    EnableDisableSingleVariantSyncStep.$$$reportNull$$$0(5);
                }
                return eligibilityState;
            }
        }
        EligibilityState eligibilityState = hasAndroidModule ? EligibilityState.ELIGIBLE : EligibilityState.PURE_JAVA;
        if (eligibilityState == null) {
            EnableDisableSingleVariantSyncStep.$$$reportNull$$$0(6);
        }
        return eligibilityState;
    }

    static boolean hasKotlinPlugin(@NotNull Module module) {
        GradleModuleModel moduleModel;
        GradleFacet gradleFacet;
        if (module == null) {
            EnableDisableSingleVariantSyncStep.$$$reportNull$$$0(7);
        }
        if ((gradleFacet = GradleFacet.getInstance(module)) != null && (moduleModel = gradleFacet.getGradleModuleModel()) != null) {
            List<String> plugins = moduleModel.getGradlePlugins();
            return plugins.stream().anyMatch(p -> p.startsWith("org.jetbrains.kotlin"));
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/post/EnableDisableSingleVariantSyncStep";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/post/EnableDisableSingleVariantSyncStep";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "isEligibleForSingleVariantSync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setSingleVariantSyncState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isEligibleForSingleVariantSync";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasKotlinPlugin";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum EligibilityState {
        ELIGIBLE{

            @Override
            @NotNull
            String getReason() {
                if ("" == null) {
                    1.$$$reportNull$$$0(0);
                }
                return "";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/post/EnableDisableSingleVariantSyncStep$EligibilityState$1", "getReason"));
            }
        }
        ,
        OLD_PLUGIN{

            @Override
            @NotNull
            String getReason() {
                if ("use Android Gradle Plugin older than 3.3" == null) {
                    2.$$$reportNull$$$0(0);
                }
                return "use Android Gradle Plugin older than 3.3";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/post/EnableDisableSingleVariantSyncStep$EligibilityState$2", "getReason"));
            }
        }
        ,
        HAS_KOTLIN{

            @Override
            @NotNull
            String getReason() {
                if ("use Kotlin" == null) {
                    3.$$$reportNull$$$0(0);
                }
                return "use Kotlin";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/post/EnableDisableSingleVariantSyncStep$EligibilityState$3", "getReason"));
            }
        }
        ,
        HAS_NATIVE{

            @Override
            @NotNull
            String getReason() {
                if ("contain native module" == null) {
                    4.$$$reportNull$$$0(0);
                }
                return "contain native module";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/post/EnableDisableSingleVariantSyncStep$EligibilityState$4", "getReason"));
            }
        }
        ,
        PURE_JAVA{

            @Override
            @NotNull
            String getReason() {
                if ("do not contain Android module" == null) {
                    5.$$$reportNull$$$0(0);
                }
                return "do not contain Android module";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/project/sync/setup/post/EnableDisableSingleVariantSyncStep$EligibilityState$5", "getReason"));
            }
        };


        @NotNull
        abstract String getReason();
    }
}

