/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.idea.java;

import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.setup.module.idea.JavaModuleSetupStep;
import com.android.tools.idea.project.messages.MessageType;
import com.android.tools.idea.project.messages.SyncMessage;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class CheckAndroidModuleWithoutVariantsStep
extends JavaModuleSetupStep {
    @Override
    protected void doSetUpModule(@NotNull ModuleSetupContext context, @NotNull JavaModuleModel gradleModel) {
        if (context == null) {
            CheckAndroidModuleWithoutVariantsStep.$$$reportNull$$$0(0);
        }
        if (gradleModel == null) {
            CheckAndroidModuleWithoutVariantsStep.$$$reportNull$$$0(1);
        }
        Module module = context.getModule();
        if (gradleModel.isAndroidModuleWithoutVariants()) {
            if (gradleModel.getSyncIssues().isEmpty()) {
                GradleSyncMessages messages = GradleSyncMessages.getInstance(module.getProject());
                String[] text = new String[]{String.format("The module '%1$s' is an Android project without build variants, and cannot be built.", module.getName()), "Please fix the module's configuration in the build.gradle file and sync the project again."};
                messages.report(new SyncMessage("Project Structure Issues", MessageType.ERROR, text));
            }
            CheckAndroidModuleWithoutVariantsStep.cleanUpAndroidModuleWithoutVariants(module, context.getIdeModelsProvider());
            this.myShouldTerminateSetup = true;
        }
    }

    private static void cleanUpAndroidModuleWithoutVariants(@NotNull Module module, @NotNull IdeModifiableModelsProvider ideModelsProvider) {
        if (module == null) {
            CheckAndroidModuleWithoutVariantsStep.$$$reportNull$$$0(2);
        }
        if (ideModelsProvider == null) {
            CheckAndroidModuleWithoutVariantsStep.$$$reportNull$$$0(3);
        }
        Facets.removeAllFacets(ideModelsProvider.getModifiableFacetModel(module), AndroidFacet.ID);
        ModifiableRootModel rootModel = ideModelsProvider.getModifiableRootModel(module);
        for (ContentEntry contentEntry : rootModel.getContentEntries()) {
            contentEntry.clearSourceFolders();
            contentEntry.clearExcludeFolders();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideModelsProvider";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/idea/java/CheckAndroidModuleWithoutVariantsStep";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doSetUpModule";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanUpAndroidModuleWithoutVariants";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

