/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.dependency;

import com.android.tools.idea.gradle.project.sync.setup.module.dependency.Dependency;
import com.android.tools.idea.io.FilePaths;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class LibraryDependency
extends Dependency {
    @NotNull
    public static final String NAME_PREFIX = GradleConstants.SYSTEM_ID.getReadableName() + ": ";
    @NotNull
    private final Collection<File> myBinaryPaths;
    @NotNull
    private final File myArtifactPath;
    private String myName;

    @VisibleForTesting
    public LibraryDependency(@NotNull File artifactPath, @NotNull DependencyScope scope) {
        if (artifactPath == null) {
            LibraryDependency.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            LibraryDependency.$$$reportNull$$$0(1);
        }
        this(artifactPath, FileUtil.getNameWithoutExtension((File)artifactPath), scope);
        this.addBinaryPath(artifactPath);
    }

    LibraryDependency(@NotNull File artifactPath, @NotNull String name, @NotNull DependencyScope scope) {
        if (artifactPath == null) {
            LibraryDependency.$$$reportNull$$$0(2);
        }
        if (name == null) {
            LibraryDependency.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            LibraryDependency.$$$reportNull$$$0(4);
        }
        super(scope);
        this.myBinaryPaths = new HashSet<File>();
        this.myArtifactPath = artifactPath;
        this.setName(name);
    }

    void addBinaryPath(@NotNull File path) {
        if (path == null) {
            LibraryDependency.$$$reportNull$$$0(5);
        }
        this.myBinaryPaths.add(path);
    }

    void addBinaryPath(@NotNull String path) {
        if (path == null) {
            LibraryDependency.$$$reportNull$$$0(6);
        }
        this.addBinaryPath(FilePaths.toSystemDependentPath((String)path));
    }

    @NotNull
    public File[] getBinaryPaths() {
        File[] fileArray = this.myBinaryPaths.isEmpty() ? ArrayUtilRt.EMPTY_FILE_ARRAY : this.myBinaryPaths.toArray(new File[0]);
        if (fileArray == null) {
            LibraryDependency.$$$reportNull$$$0(7);
        }
        return fileArray;
    }

    @NotNull
    public File getArtifactPath() {
        File file = this.myArtifactPath;
        if (file == null) {
            LibraryDependency.$$$reportNull$$$0(8);
        }
        return file;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            LibraryDependency.$$$reportNull$$$0(9);
        }
        return string;
    }

    void setName(@NotNull String name) {
        if (name == null) {
            LibraryDependency.$$$reportNull$$$0(10);
        }
        this.myName = name.isEmpty() || StringUtil.startsWith((CharSequence)name, (CharSequence)NAME_PREFIX) ? name : NAME_PREFIX + name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LibraryDependency)) {
            return false;
        }
        LibraryDependency that = (LibraryDependency)o;
        return Objects.equals(this.myBinaryPaths, that.myBinaryPaths) && Objects.equals(this.myArtifactPath, that.myArtifactPath) && Objects.equals(this.myName, that.myName);
    }

    public int hashCode() {
        return Objects.hash(this.myBinaryPaths, this.myArtifactPath, this.myName);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name='" + this.myName + '\'' + ", scope=" + this.getScope() + ", pathsByType=" + this.myBinaryPaths + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactPath";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/module/dependency/LibraryDependency";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/dependency/LibraryDependency";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryPaths";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addBinaryPath";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

