/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.dependency;

import com.android.tools.idea.gradle.project.sync.setup.module.dependency.Dependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.LibraryDependency;
import com.android.tools.idea.gradle.project.sync.setup.module.dependency.ModuleDependency;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DependencySet {
    @NotNull
    public static DependencySet EMPTY = new DependencySet();
    private final Multimap<String, LibraryDependency> myLibrariesByName = ArrayListMultimap.create();
    private final Map<String, ModuleDependency> myModulesByPath = Maps.newHashMap();

    DependencySet() {
    }

    void add(@NotNull LibraryDependency dependency) {
        String originalName;
        Collection allStored;
        if (dependency == null) {
            DependencySet.$$$reportNull$$$0(0);
        }
        Object object = allStored = (allStored = this.myLibrariesByName.get((Object)(originalName = dependency.getName()))) == null ? null : ImmutableSet.copyOf((Collection)allStored);
        if (allStored == null || allStored.isEmpty()) {
            this.myLibrariesByName.put((Object)originalName, (Object)dependency);
            return;
        }
        LibraryDependency toAdd = dependency;
        LibraryDependency replaced = null;
        for (LibraryDependency stored : allStored) {
            if (!DependencySet.areSameArtifact(dependency, stored)) continue;
            toAdd = null;
            if (!DependencySet.hasHigherScope(dependency, stored)) break;
            replaced = stored;
            dependency.setName(stored.getName());
            this.myLibrariesByName.put((Object)originalName, (Object)dependency);
            break;
        }
        if (replaced != null) {
            this.myLibrariesByName.remove((Object)originalName, replaced);
        }
        if (toAdd != null) {
            String newName2 = allStored.size() + "_" + dependency.getName();
            dependency.setName(newName2);
            this.myLibrariesByName.put((Object)originalName, (Object)dependency);
        }
    }

    public void addAll(DependencySet other) {
        for (LibraryDependency libraryDependency : other.onLibraries()) {
            this.add(libraryDependency);
        }
        for (ModuleDependency moduleDependency : other.onModules()) {
            this.add(moduleDependency);
        }
    }

    private static boolean areSameArtifact(@NotNull LibraryDependency d1, @NotNull LibraryDependency d2) {
        if (d1 == null) {
            DependencySet.$$$reportNull$$$0(1);
        }
        if (d2 == null) {
            DependencySet.$$$reportNull$$$0(2);
        }
        return Arrays.equals(d1.getBinaryPaths(), d2.getBinaryPaths());
    }

    void add(@NotNull ModuleDependency dependency) {
        String gradlePath;
        Dependency storedDependency;
        if (dependency == null) {
            DependencySet.$$$reportNull$$$0(3);
        }
        if ((storedDependency = (Dependency)this.myModulesByPath.get(gradlePath = dependency.getGradlePath())) == null || DependencySet.hasHigherScope(dependency, storedDependency)) {
            this.myModulesByPath.put(gradlePath, dependency);
        }
    }

    private static <T extends Dependency> boolean hasHigherScope(T d1, T d2) {
        return Dependency.SUPPORTED_SCOPES.indexOf(d1.getScope()) < Dependency.SUPPORTED_SCOPES.indexOf(d2.getScope());
    }

    @NotNull
    public ImmutableCollection<LibraryDependency> onLibraries() {
        ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)this.myLibrariesByName.values());
        if (immutableSet == null) {
            DependencySet.$$$reportNull$$$0(4);
        }
        return immutableSet;
    }

    @NotNull
    public ImmutableCollection<ModuleDependency> onModules() {
        ImmutableSet immutableSet = ImmutableSet.copyOf(this.myModulesByPath.values());
        if (immutableSet == null) {
            DependencySet.$$$reportNull$$$0(5);
        }
        return immutableSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "d2";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependencySet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/dependency/DependencySet";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "onLibraries";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "onModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "areSameArtifact";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

