/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.setup.module.common;

import com.android.tools.idea.gradle.project.sync.setup.module.common.RootSourceFolder;
import com.android.tools.idea.gradle.util.ContentEntries;
import com.android.tools.idea.io.FilePaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class ContentEntriesSetup {
    @NotNull
    private final ModifiableRootModel myModuleModel;
    @NotNull
    private final List<RootSourceFolder> myOrphans;

    protected ContentEntriesSetup(@NotNull ModifiableRootModel moduleModel) {
        if (moduleModel == null) {
            ContentEntriesSetup.$$$reportNull$$$0(0);
        }
        this.myOrphans = new ArrayList<RootSourceFolder>();
        this.myModuleModel = moduleModel;
    }

    public static void removeExistingContentEntries(@NotNull ModifiableRootModel rootModel) {
        if (rootModel == null) {
            ContentEntriesSetup.$$$reportNull$$$0(1);
        }
        for (ContentEntry contentEntry : rootModel.getContentEntries()) {
            rootModel.removeContentEntry(contentEntry);
        }
    }

    public abstract void execute(@NotNull List<ContentEntry> var1);

    protected void addSourceFolder(@NotNull File folderPath, @NotNull Collection<ContentEntry> contentEntries, @NotNull JpsModuleSourceRootType type, boolean generated) {
        ContentEntry parent;
        if (folderPath == null) {
            ContentEntriesSetup.$$$reportNull$$$0(2);
        }
        if (contentEntries == null) {
            ContentEntriesSetup.$$$reportNull$$$0(3);
        }
        if (type == null) {
            ContentEntriesSetup.$$$reportNull$$$0(4);
        }
        if ((parent = ContentEntries.findParentContentEntry(folderPath, contentEntries.stream())) == null) {
            this.myOrphans.add(new RootSourceFolder(folderPath, type, generated));
            return;
        }
        ContentEntriesSetup.addSourceFolder(parent, folderPath, type, generated);
    }

    private static void addSourceFolder(@NotNull ContentEntry contentEntry, @NotNull File folderPath, @NotNull JpsModuleSourceRootType type, boolean generated) {
        JpsModuleSourceRoot sourceRoot;
        JpsElement properties;
        if (contentEntry == null) {
            ContentEntriesSetup.$$$reportNull$$$0(5);
        }
        if (folderPath == null) {
            ContentEntriesSetup.$$$reportNull$$$0(6);
        }
        if (type == null) {
            ContentEntriesSetup.$$$reportNull$$$0(7);
        }
        String url = FilePaths.pathToIdeaUrl((File)folderPath);
        SourceFolder sourceFolder = contentEntry.addSourceFolder(url, type);
        if (generated && (properties = (sourceRoot = sourceFolder.getJpsElement()).getProperties()) instanceof JavaSourceRootProperties) {
            ((JavaSourceRootProperties)properties).setForGeneratedSources(true);
        }
    }

    protected boolean addExcludedFolder(@NotNull ContentEntry contentEntry, @NotNull File folderPath) {
        if (contentEntry == null) {
            ContentEntriesSetup.$$$reportNull$$$0(8);
        }
        if (folderPath == null) {
            ContentEntriesSetup.$$$reportNull$$$0(9);
        }
        if (!ContentEntries.isPathInContentEntry(folderPath, contentEntry)) {
            return false;
        }
        contentEntry.addExcludeFolder(FilePaths.pathToIdeaUrl((File)folderPath));
        return true;
    }

    protected void addOrphans() {
        for (RootSourceFolder orphan : this.myOrphans) {
            File path = orphan.getPath();
            ContentEntry contentEntry = this.myModuleModel.addContentEntry(FilePaths.pathToIdeaUrl((File)path));
            ContentEntriesSetup.addSourceFolder(contentEntry, path, orphan.getType(), orphan.isGenerated());
        }
    }

    @NotNull
    protected Module getModule() {
        Module module = this.myModuleModel.getModule();
        if (module == null) {
            ContentEntriesSetup.$$$reportNull$$$0(10);
        }
        return module;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentEntries";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentEntry";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/setup/module/common/ContentEntriesSetup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/setup/module/common/ContentEntriesSetup";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeExistingContentEntries";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addSourceFolder";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addExcludedFolder";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

