/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng.variantonly;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Dependencies;
import com.android.builder.model.ModelBuilderParameter;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.NativeVariantAbi;
import com.android.builder.model.NativeVariantInfo;
import com.android.builder.model.Variant;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.builder.model.level2.GlobalLibraryMap;
import com.android.builder.model.level2.GraphItem;
import com.android.tools.idea.gradle.project.sync.Modules;
import com.android.tools.idea.gradle.project.sync.ng.AndroidModule;
import com.android.tools.idea.gradle.project.sync.ng.SelectedVariantChooser;
import com.android.tools.idea.gradle.project.sync.ng.variantonly.VariantOnlySyncOptions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VariantOnlyProjectModels
implements Serializable {
    private static final long serialVersionUID = 3L;
    @NotNull
    private final Map<String, VariantOnlyModuleModel> myModuleModelsById;
    @NotNull
    private final Map<File, GlobalLibraryMap> myLibraryMapsByBuildId;
    @NotNull
    private final VariantOnlySyncOptions mySyncOptions;

    public VariantOnlyProjectModels(@NotNull VariantOnlySyncOptions syncOptions) {
        if (syncOptions == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(0);
        }
        this.myModuleModelsById = new HashMap<String, VariantOnlyModuleModel>();
        this.myLibraryMapsByBuildId = new HashMap<File, GlobalLibraryMap>();
        this.mySyncOptions = syncOptions;
    }

    public void populate(@NotNull BuildController controller) {
        if (controller == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(1);
        }
        this.populateModelsForModule(controller, this.mySyncOptions.myBuildId, this.mySyncOptions.myGradlePath, this.mySyncOptions.myVariantName);
        this.populateGlobalLibraryMap(controller);
    }

    private void populateModelsForModule(@NotNull BuildController controller, @NotNull File buildId2, @NotNull String gradlePath, @NotNull String variantName) {
        AndroidProject androidProject;
        String moduleId;
        VariantOnlyModuleModel moduleModel;
        if (controller == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(2);
        }
        if (buildId2 == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(3);
        }
        if (gradlePath == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(4);
        }
        if (variantName == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(5);
        }
        if ((moduleModel = this.myModuleModelsById.get(moduleId = Modules.createUniqueModuleId(buildId2, gradlePath))) != null && moduleModel.containsVariant(variantName)) {
            return;
        }
        if (moduleModel != null) {
            this.syncAndAddVariant(moduleModel, variantName, controller);
            return;
        }
        GradleProject gradleProject = VariantOnlyProjectModels.findGradleProject(controller, buildId2, gradlePath);
        if (gradleProject != null && (androidProject = (AndroidProject)controller.findModel((Model)gradleProject, AndroidProject.class, ModelBuilderParameter.class, parameter -> parameter.setShouldBuildVariant(false))) != null) {
            moduleModel = new VariantOnlyModuleModel(androidProject, gradleProject, moduleId, buildId2);
            this.myModuleModelsById.put(moduleId, moduleModel);
            this.syncAndAddNativeVariant(moduleModel, variantName, controller);
            Variant variant = this.syncAndAddVariant(moduleModel, variantName, controller);
            if (variant != null) {
                this.populateForDependencyModules(controller, variant);
                this.populateForFeatureModules(controller, androidProject.getDynamicFeatures(), variantName, buildId2);
            }
        }
    }

    private void populateForDependencyModules(@NotNull BuildController controller, @NotNull Variant variant) {
        AndroidArtifact artifact;
        Dependencies dependencies;
        if (controller == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(6);
        }
        if (variant == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(7);
        }
        if (!(dependencies = (artifact = variant.getMainArtifact()).getDependencies()).getLibraries().isEmpty()) {
            this.populateForDependencyModules(controller, dependencies);
        } else {
            this.populateForDependencyModules(controller, artifact.getDependencyGraphs());
        }
    }

    private void populateForDependencyModules(@NotNull BuildController controller, @NotNull DependencyGraphs dependencyGraphs) {
        if (controller == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(8);
        }
        if (dependencyGraphs == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(9);
        }
        for (GraphItem item : dependencyGraphs.getCompileDependencies()) {
            String address = item.getArtifactAddress();
            Matcher matcher = AndroidModule.MODULE_ARTIFACT_ADDRESS_PATTERN.matcher(address);
            if (!matcher.matches()) continue;
            String dependencyBuildId = matcher.group(1);
            String projectPath = matcher.group(2);
            String variantToSelect = matcher.group(4);
            if (projectPath == null || dependencyBuildId == null || variantToSelect == null) continue;
            this.populateModelsForModule(controller, new File(dependencyBuildId), projectPath, variantToSelect);
        }
    }

    private void populateForDependencyModules(@NotNull BuildController controller, @NotNull Dependencies dependencies) {
        if (controller == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(10);
        }
        if (dependencies == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(11);
        }
        for (AndroidLibrary library : dependencies.getLibraries()) {
            String projectPath = library.getProject();
            String dependencyBuildId = library.getBuildId();
            String variantToSelect = library.getProjectVariant();
            if (projectPath == null || dependencyBuildId == null || variantToSelect == null) continue;
            this.populateModelsForModule(controller, new File(dependencyBuildId), projectPath, variantToSelect);
        }
    }

    private void populateForFeatureModules(@NotNull BuildController controller, @NotNull Collection<String> features, @NotNull String variantToSelect, @NotNull File buildId2) {
        if (controller == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(12);
        }
        if (features == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(13);
        }
        if (variantToSelect == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(14);
        }
        if (buildId2 == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(15);
        }
        for (String feature : features) {
            this.populateModelsForModule(controller, buildId2, feature, variantToSelect);
        }
    }

    private void populateGlobalLibraryMap(@NotNull BuildController controller) {
        if (controller == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(16);
        }
        for (VariantOnlyModuleModel moduleModel : this.myModuleModelsById.values()) {
            GlobalLibraryMap map2;
            File buildId2 = moduleModel.getBuildId();
            if (this.myLibraryMapsByBuildId.containsKey(buildId2) || (map2 = (GlobalLibraryMap)controller.findModel((Model)moduleModel.getGradleProject(), GlobalLibraryMap.class)) == null) continue;
            this.myLibraryMapsByBuildId.put(buildId2, map2);
        }
    }

    @Nullable
    private Variant syncAndAddVariant(@NotNull VariantOnlyModuleModel moduleModel, @NotNull String variantName, @NotNull BuildController controller) {
        GradleProject gradleProject;
        Variant variant;
        if (moduleModel == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(17);
        }
        if (variantName == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(18);
        }
        if (controller == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(19);
        }
        if ((variant = (Variant)controller.findModel((Model)(gradleProject = moduleModel.getGradleProject()), Variant.class, ModelBuilderParameter.class, parameter -> {
            parameter.setVariantName(variantName);
            parameter.setShouldGenerateSources(this.mySyncOptions.myShouldGenerateSources);
        })) != null) {
            moduleModel.addVariant(variant);
        }
        return variant;
    }

    private void syncAndAddNativeVariant(@NotNull VariantOnlyModuleModel moduleModel, @NotNull String variantName, @NotNull BuildController controller) {
        String finalAbiToSelect;
        NativeVariantAbi nativeVariantAbi;
        if (moduleModel == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(20);
        }
        if (variantName == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(21);
        }
        if (controller == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(22);
        }
        if (moduleModel.getNativeVariantAbi() != null) {
            return;
        }
        GradleProject gradleProject = moduleModel.getGradleProject();
        NativeAndroidProject nativeProject = (NativeAndroidProject)controller.findModel((Model)gradleProject, NativeAndroidProject.class, ModelBuilderParameter.class, parameter -> parameter.setShouldBuildVariant(false));
        if (nativeProject == null) {
            return;
        }
        String abiToSelect = this.mySyncOptions.myAbiName;
        List abiNames = ((NativeVariantInfo)nativeProject.getVariantInfos().get(variantName)).getAbiNames();
        if (abiToSelect == null || !abiNames.contains(abiToSelect)) {
            abiToSelect = SelectedVariantChooser.getDefaultOrFirstItem(abiNames, "x86");
        }
        if (abiToSelect != null && (nativeVariantAbi = (NativeVariantAbi)controller.findModel((Model)gradleProject, NativeVariantAbi.class, ModelBuilderParameter.class, arg_0 -> VariantOnlyProjectModels.lambda$syncAndAddNativeVariant$3(variantName, finalAbiToSelect = abiToSelect, arg_0))) != null) {
            String variantAbiName = variantName + "-" + finalAbiToSelect;
            moduleModel.setNativeVariantAbi(variantAbiName, nativeVariantAbi);
        }
    }

    @Nullable
    private static GradleProject findGradleProject(@NotNull BuildController controller, @NotNull File buildId2, @NotNull String gradlePath) {
        GradleProject gradleProject;
        GradleBuild rootBuild;
        GradleBuild gradleBuild;
        if (controller == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(23);
        }
        if (buildId2 == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(24);
        }
        if (gradlePath == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(25);
        }
        if ((gradleBuild = VariantOnlyProjectModels.findGradleBuild(rootBuild = controller.getBuildModel(), buildId2)) != null && (gradleProject = (GradleProject)controller.findModel((Model)gradleBuild.getRootProject(), GradleProject.class)) != null) {
            return VariantOnlyProjectModels.findGradleProject(gradleProject, gradlePath);
        }
        return null;
    }

    @Nullable
    private static GradleBuild findGradleBuild(@NotNull GradleBuild gradleBuild, @NotNull File buildId2) {
        if (gradleBuild == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(26);
        }
        if (buildId2 == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(27);
        }
        Path projectRootDir = gradleBuild.getBuildIdentifier().getRootDir().toPath();
        try {
            if (Files.isSameFile(projectRootDir, buildId2.toPath())) {
                return gradleBuild;
            }
        }
        catch (IOException e) {
            return null;
        }
        for (GradleBuild childBuild : gradleBuild.getIncludedBuilds()) {
            GradleBuild build2 = VariantOnlyProjectModels.findGradleBuild(childBuild, buildId2);
            if (build2 == null) continue;
            return build2;
        }
        return null;
    }

    @Nullable
    private static GradleProject findGradleProject(@NotNull GradleProject gradleProject, @NotNull String gradlePath) {
        if (gradleProject == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(28);
        }
        if (gradlePath == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(29);
        }
        if (gradleProject.getPath().equals(gradlePath)) {
            return gradleProject;
        }
        for (GradleProject child : gradleProject.getChildren()) {
            GradleProject project = VariantOnlyProjectModels.findGradleProject(child, gradlePath);
            if (project == null) continue;
            return project;
        }
        return null;
    }

    @NotNull
    public List<GlobalLibraryMap> getGlobalLibraryMap() {
        ImmutableList immutableList = ImmutableList.copyOf(this.myLibraryMapsByBuildId.values());
        if (immutableList == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(30);
        }
        return immutableList;
    }

    @NotNull
    public List<VariantOnlyModuleModel> getModuleModels() {
        ImmutableList immutableList = ImmutableList.copyOf(this.myModuleModelsById.values());
        if (immutableList == null) {
            VariantOnlyProjectModels.$$$reportNull$$$0(31);
        }
        return immutableList;
    }

    private static /* synthetic */ void lambda$syncAndAddNativeVariant$3(String variantName, String finalAbiToSelect, ModelBuilderParameter parameter) {
        parameter.setVariantName(variantName);
        parameter.setAbiName(finalAbiToSelect);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncOptions";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 16: 
            case 19: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 3: 
            case 15: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildId";
                break;
            }
            case 4: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePath";
                break;
            }
            case 5: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyGraphs";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "features";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantToSelect";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleBuild";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProject";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/variantonly/VariantOnlyProjectModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/variantonly/VariantOnlyProjectModels";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalLibraryMap";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "populate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "populateModelsForModule";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "populateForDependencyModules";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "populateForFeatureModules";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "populateGlobalLibraryMap";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "syncAndAddVariant";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "syncAndAddNativeVariant";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findGradleProject";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findGradleBuild";
                break;
            }
            case 30: 
            case 31: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class VariantOnlyModuleModel
    implements Serializable {
        @NotNull
        private final AndroidProject myAndroidProject;
        @NotNull
        private final GradleProject myGradleProject;
        @NotNull
        private final String myModuleId;
        @NotNull
        private final File myBuildId;
        @NotNull
        private final Map<String, Variant> myVariantsByName;
        @Nullable
        private NativeVariantAbiModel myNativeVariantAbiModel;

        public VariantOnlyModuleModel(@NotNull AndroidProject androidProject, @NotNull GradleProject gradleProject, @NotNull String moduleId, @NotNull File buildId2) {
            if (androidProject == null) {
                VariantOnlyModuleModel.$$$reportNull$$$0(0);
            }
            if (gradleProject == null) {
                VariantOnlyModuleModel.$$$reportNull$$$0(1);
            }
            if (moduleId == null) {
                VariantOnlyModuleModel.$$$reportNull$$$0(2);
            }
            if (buildId2 == null) {
                VariantOnlyModuleModel.$$$reportNull$$$0(3);
            }
            this.myVariantsByName = new HashMap<String, Variant>();
            this.myAndroidProject = androidProject;
            this.myGradleProject = gradleProject;
            this.myModuleId = moduleId;
            this.myBuildId = buildId2;
        }

        @NotNull
        public AndroidProject getAndroidProject() {
            AndroidProject androidProject = this.myAndroidProject;
            if (androidProject == null) {
                VariantOnlyModuleModel.$$$reportNull$$$0(4);
            }
            return androidProject;
        }

        @NotNull
        public GradleProject getGradleProject() {
            GradleProject gradleProject = this.myGradleProject;
            if (gradleProject == null) {
                VariantOnlyModuleModel.$$$reportNull$$$0(5);
            }
            return gradleProject;
        }

        @NotNull
        public String getModuleId() {
            String string = this.myModuleId;
            if (string == null) {
                VariantOnlyModuleModel.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public File getBuildId() {
            File file = this.myBuildId;
            if (file == null) {
                VariantOnlyModuleModel.$$$reportNull$$$0(7);
            }
            return file;
        }

        @NotNull
        public List<Variant> getVariants() {
            ImmutableList immutableList = ImmutableList.copyOf(this.myVariantsByName.values());
            if (immutableList == null) {
                VariantOnlyModuleModel.$$$reportNull$$$0(8);
            }
            return immutableList;
        }

        private void addVariant(@NotNull Variant variant) {
            if (variant == null) {
                VariantOnlyModuleModel.$$$reportNull$$$0(9);
            }
            this.myVariantsByName.put(variant.getName(), variant);
        }

        public boolean containsVariant(@NotNull String variantName) {
            if (variantName == null) {
                VariantOnlyModuleModel.$$$reportNull$$$0(10);
            }
            return this.myVariantsByName.containsKey(variantName);
        }

        public void setNativeVariantAbi(@NotNull String name, @NotNull NativeVariantAbi nativeVariantAbi) {
            if (name == null) {
                VariantOnlyModuleModel.$$$reportNull$$$0(11);
            }
            if (nativeVariantAbi == null) {
                VariantOnlyModuleModel.$$$reportNull$$$0(12);
            }
            this.myNativeVariantAbiModel = new NativeVariantAbiModel(name, nativeVariantAbi);
        }

        @Nullable
        public NativeVariantAbiModel getNativeVariantAbi() {
            return this.myNativeVariantAbiModel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "androidProject";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gradleProject";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleId";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildId";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/variantonly/VariantOnlyProjectModels$VariantOnlyModuleModel";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variant";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variantName";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nativeVariantAbi";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/variantonly/VariantOnlyProjectModels$VariantOnlyModuleModel";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAndroidProject";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGradleProject";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleId";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBuildId";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "addVariant";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "containsVariant";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "setNativeVariantAbi";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static class NativeVariantAbiModel
        implements Serializable {
            @NotNull
            final String name;
            @NotNull
            public final NativeVariantAbi model;

            public NativeVariantAbiModel(@NotNull String name, @NotNull NativeVariantAbi nativeVariantAbi) {
                if (name == null) {
                    NativeVariantAbiModel.$$$reportNull$$$0(0);
                }
                if (nativeVariantAbi == null) {
                    NativeVariantAbiModel.$$$reportNull$$$0(1);
                }
                this.name = name;
                this.model = nativeVariantAbi;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "nativeVariantAbi";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/gradle/project/sync/ng/variantonly/VariantOnlyProjectModels$VariantOnlyModuleModel$NativeVariantAbiModel";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

