/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.builder.model.AndroidProject;
import com.android.builder.model.ModelBuilderParameter;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.NativeVariantAbi;
import com.android.builder.model.NativeVariantInfo;
import com.android.builder.model.Variant;
import com.android.tools.idea.gradle.project.sync.Modules;
import com.android.tools.idea.gradle.project.sync.ng.AndroidModule;
import com.android.tools.idea.gradle.project.sync.ng.SelectedVariants;
import com.android.tools.idea.gradle.project.sync.ng.SyncModuleModels;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectedVariantChooser
implements Serializable {
    void chooseSelectedVariants(@NotNull List<SyncModuleModels> projectModels, @NotNull BuildController controller, @NotNull SelectedVariants selectedVariants2, boolean shouldGenerateSources) {
        if (projectModels == null) {
            SelectedVariantChooser.$$$reportNull$$$0(0);
        }
        if (controller == null) {
            SelectedVariantChooser.$$$reportNull$$$0(1);
        }
        if (selectedVariants2 == null) {
            SelectedVariantChooser.$$$reportNull$$$0(2);
        }
        HashMap<String, AndroidModule> modulesById = new HashMap<String, AndroidModule>();
        LinkedList<String> allModules = new LinkedList<String>();
        HashSet<String> visitedModules = new HashSet<String>();
        for (SyncModuleModels moduleModels : projectModels) {
            AndroidProject androidProject = moduleModels.findModel(AndroidProject.class);
            GradleProject gradleProject = moduleModels.findModel(GradleProject.class);
            if (gradleProject == null || androidProject == null || !androidProject.getVariants().isEmpty()) continue;
            NativeAndroidProject nativeAndroidProject = moduleModels.findModel(NativeAndroidProject.class);
            AndroidModule module = new AndroidModule(androidProject, moduleModels, nativeAndroidProject);
            String id = Modules.createUniqueModuleId(gradleProject);
            modulesById.put(id, module);
            if (androidProject.getProjectType() == 0) {
                allModules.addFirst(id);
                continue;
            }
            allModules.addLast(id);
        }
        for (String moduleId : allModules) {
            if (visitedModules.contains(moduleId)) continue;
            visitedModules.add(moduleId);
            AndroidModule module = (AndroidModule)modulesById.get(moduleId);
            Objects.requireNonNull(module);
            Variant variant = SelectedVariantChooser.selectVariantForAppOrLeaf(module, controller, selectedVariants2, moduleId, shouldGenerateSources);
            if (variant == null) continue;
            String abi = SelectedVariantChooser.syncAndAddNativeVariantAbi(module, controller, variant.getName(), selectedVariants2.getSelectedAbi(moduleId));
            module.addSelectedVariant(variant, abi);
            SelectedVariantChooser.selectVariantForDependencyModules(module, controller, modulesById, visitedModules, shouldGenerateSources);
        }
    }

    private static void selectVariantForDependencyModules(@NotNull AndroidModule androidModule, @NotNull BuildController controller, @NotNull Map<String, AndroidModule> libModulesById, @NotNull Set<String> visitedModules, boolean shouldGenerateSources) {
        if (androidModule == null) {
            SelectedVariantChooser.$$$reportNull$$$0(3);
        }
        if (controller == null) {
            SelectedVariantChooser.$$$reportNull$$$0(4);
        }
        if (libModulesById == null) {
            SelectedVariantChooser.$$$reportNull$$$0(5);
        }
        if (visitedModules == null) {
            SelectedVariantChooser.$$$reportNull$$$0(6);
        }
        for (AndroidModule.ModuleDependency dependency : androidModule.getModuleDependencies()) {
            Variant dependencyVariant;
            AndroidModule dependencyModule;
            String dependencyModuleId = dependency.id;
            visitedModules.add(dependencyModuleId);
            String variantName = dependency.variant;
            String abiName = null;
            if (variantName == null || (dependencyModule = libModulesById.get(dependencyModuleId)) == null || dependencyModule.containsVariant(variantName)) continue;
            NativeAndroidProject nativeProject = androidModule.getNativeAndroidProject();
            if (nativeProject != null) {
                abiName = SelectedVariantChooser.syncAndAddNativeVariantAbi(dependencyModule, controller, variantName, dependency.abi);
            }
            if ((dependencyVariant = SelectedVariantChooser.syncAndAddVariant(variantName, dependencyModule.getModuleModels(), controller, shouldGenerateSources)) == null) continue;
            dependencyModule.addSelectedVariant(dependencyVariant, abiName);
            SelectedVariantChooser.selectVariantForDependencyModules(dependencyModule, controller, libModulesById, visitedModules, shouldGenerateSources);
        }
    }

    @Nullable
    private static Variant selectVariantForAppOrLeaf(@NotNull AndroidModule androidModule, @NotNull BuildController controller, @NotNull SelectedVariants selectedVariants2, @NotNull String moduleId, boolean shouldGenerateSources) {
        if (androidModule == null) {
            SelectedVariantChooser.$$$reportNull$$$0(7);
        }
        if (controller == null) {
            SelectedVariantChooser.$$$reportNull$$$0(8);
        }
        if (selectedVariants2 == null) {
            SelectedVariantChooser.$$$reportNull$$$0(9);
        }
        if (moduleId == null) {
            SelectedVariantChooser.$$$reportNull$$$0(10);
        }
        String variant = selectedVariants2.getSelectedVariant(moduleId);
        Collection variantNames = androidModule.getAndroidProject().getVariantNames();
        if (variant == null || !variantNames.contains(variant)) {
            variant = SelectedVariantChooser.getDefaultOrFirstItem(variantNames, "debug");
        }
        return variant != null ? SelectedVariantChooser.syncAndAddVariant(variant, androidModule.getModuleModels(), controller, shouldGenerateSources) : null;
    }

    @Nullable
    public static String getDefaultOrFirstItem(@NotNull Collection<String> names, @NotNull String defaultValue) {
        if (names == null) {
            SelectedVariantChooser.$$$reportNull$$$0(11);
        }
        if (defaultValue == null) {
            SelectedVariantChooser.$$$reportNull$$$0(12);
        }
        if (names.isEmpty()) {
            return null;
        }
        return names.contains(defaultValue) ? defaultValue : Collections.min(names, String::compareTo);
    }

    @Nullable
    private static Variant syncAndAddVariant(@NotNull String variantName, @NotNull SyncModuleModels moduleModels, @NotNull BuildController controller, boolean shouldGenerateSources) {
        if (variantName == null) {
            SelectedVariantChooser.$$$reportNull$$$0(13);
        }
        if (moduleModels == null) {
            SelectedVariantChooser.$$$reportNull$$$0(14);
        }
        if (controller == null) {
            SelectedVariantChooser.$$$reportNull$$$0(15);
        }
        GradleProject gradleProject = moduleModels.findModel(GradleProject.class);
        Objects.requireNonNull(gradleProject);
        Variant variant = (Variant)controller.findModel((Model)gradleProject, Variant.class, ModelBuilderParameter.class, parameter -> {
            parameter.setVariantName(variantName);
            parameter.setShouldGenerateSources(shouldGenerateSources);
        });
        if (variant != null) {
            moduleModels.addModel(Variant.class, variant);
        }
        return variant;
    }

    @Nullable
    private static String syncAndAddNativeVariantAbi(@NotNull AndroidModule androidModule, @NotNull BuildController controller, @NotNull String variant, @Nullable String abi) {
        NativeAndroidProject nativeAndroidProject;
        if (androidModule == null) {
            SelectedVariantChooser.$$$reportNull$$$0(16);
        }
        if (controller == null) {
            SelectedVariantChooser.$$$reportNull$$$0(17);
        }
        if (variant == null) {
            SelectedVariantChooser.$$$reportNull$$$0(18);
        }
        if ((nativeAndroidProject = androidModule.getNativeAndroidProject()) != null) {
            List abiNames;
            try {
                abiNames = ((NativeVariantInfo)nativeAndroidProject.getVariantInfos().get(variant)).getAbiNames();
            }
            catch (UnsupportedMethodException e) {
                return null;
            }
            if (abi == null || !abiNames.contains(abi)) {
                abi = SelectedVariantChooser.getDefaultOrFirstItem(abiNames, "x86");
            }
            if (abi != null) {
                String abiToSelect = abi;
                SyncModuleModels moduleModels = androidModule.getModuleModels();
                GradleProject gradleProject = moduleModels.findModel(GradleProject.class);
                Objects.requireNonNull(gradleProject);
                NativeVariantAbi variantAbi = (NativeVariantAbi)controller.findModel((Model)gradleProject, NativeVariantAbi.class, ModelBuilderParameter.class, parameter -> {
                    parameter.setVariantName(variant);
                    parameter.setAbiName(abiToSelect);
                });
                if (variantAbi != null) {
                    moduleModels.addModel(NativeVariantAbi.class, variantAbi);
                }
                return abiToSelect;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectModels";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedVariants";
                break;
            }
            case 3: 
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModule";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libModulesById";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedModules";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModels";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variant";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/SelectedVariantChooser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "chooseSelectedVariants";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "selectVariantForDependencyModules";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "selectVariantForAppOrLeaf";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getDefaultOrFirstItem";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "syncAndAddVariant";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "syncAndAddNativeVariantAbi";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

