/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.sync.GradleModuleModels;
import com.android.tools.idea.gradle.project.sync.ModuleSetupContext;
import com.android.tools.idea.gradle.project.sync.Modules;
import com.android.tools.idea.gradle.project.sync.ng.SyncProjectModels;
import com.android.tools.idea.gradle.project.sync.setup.module.ModuleFinder;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.internal.InternalExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.IOException;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class ProjectDataNodeSetup {
    public void setupProjectDataNode(@NotNull SyncProjectModels projectModels, @NotNull Project project) {
        if (projectModels == null) {
            ProjectDataNodeSetup.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ProjectDataNodeSetup.$$$reportNull$$$0(1);
        }
        String projectFolder = project.getBasePath();
        assert (projectFolder != null);
        ProjectData projectData = new ProjectData(GradleConstants.SYSTEM_ID, project.getName(), projectFolder, projectFolder);
        DataNode projectDataNode = new DataNode(ProjectKeys.PROJECT, (Object)projectData, null);
        for (GradleModuleModels gradleModuleModels : projectModels.getModuleModels()) {
            DataNode<ModuleData> moduleData = ProjectDataNodeSetup.createModuleDataNode(gradleModuleModels, (DataNode<ProjectData>)projectDataNode, project);
            ProjectDataNodeSetup.createTaskDataNode(gradleModuleModels, moduleData);
        }
        InternalExternalProjectInfo projectInfo = new InternalExternalProjectInfo(GradleConstants.SYSTEM_ID, projectFolder, projectDataNode);
        ProjectDataManager.getInstance().updateExternalProjectData(project, (ExternalProjectInfo)projectInfo);
    }

    @NotNull
    private static DataNode<ModuleData> createModuleDataNode(@NotNull GradleModuleModels moduleModels, @NotNull DataNode<ProjectData> projectDataNode, @NotNull Project project) {
        String moduleConfigPath;
        if (moduleModels == null) {
            ProjectDataNodeSetup.$$$reportNull$$$0(2);
        }
        if (projectDataNode == null) {
            ProjectDataNodeSetup.$$$reportNull$$$0(3);
        }
        if (project == null) {
            ProjectDataNodeSetup.$$$reportNull$$$0(4);
        }
        GradleProject gradleProject = moduleModels.findModel(GradleProject.class);
        assert (gradleProject != null);
        try {
            moduleConfigPath = ExternalSystemApiUtil.toCanonicalPath((String)gradleProject.getProjectDirectory().getCanonicalPath());
        }
        catch (IOException e) {
            moduleConfigPath = GradleUtil.getConfigPath((GradleProject)gradleProject, (String)((ProjectData)projectDataNode.getData()).getLinkedExternalProjectPath());
        }
        String moduleName = moduleModels.getModuleName();
        String gradlePath = gradleProject.getPath();
        String moduleId = StringUtil.isEmpty((String)gradlePath) || ":".equals(gradlePath) ? moduleName : gradlePath;
        String typeId = StdModuleTypes.JAVA.getId();
        ModuleData moduleData = new ModuleData(moduleId, GradleConstants.SYSTEM_ID, typeId, moduleName, moduleConfigPath, moduleConfigPath);
        moduleData.setDescription(gradleProject.getDescription());
        Module module = ProjectDataNodeSetup.findModule(project, gradleProject);
        if (module != null) {
            ExternalSystemModulePropertyManager.getInstance((Module)module).setExternalOptions(moduleData.getOwner(), moduleData, (ProjectData)projectDataNode.getData());
        }
        DataNode dataNode = projectDataNode.createChild(ProjectKeys.MODULE, (Object)moduleData);
        if (dataNode == null) {
            ProjectDataNodeSetup.$$$reportNull$$$0(5);
        }
        return dataNode;
    }

    @Nullable
    private static Module findModule(@NotNull Project project, @NotNull GradleProject gradleProject) {
        ModuleFinder finder;
        if (project == null) {
            ProjectDataNodeSetup.$$$reportNull$$$0(6);
        }
        if (gradleProject == null) {
            ProjectDataNodeSetup.$$$reportNull$$$0(7);
        }
        if ((finder = (ModuleFinder)project.getUserData(ModuleSetupContext.MODULES_BY_GRADLE_PATH_KEY)) != null) {
            return finder.findModuleByModuleId(Modules.createUniqueModuleId(gradleProject));
        }
        return null;
    }

    private static void createTaskDataNode(@NotNull GradleModuleModels moduleModels, @NotNull DataNode<ModuleData> moduleData) {
        if (moduleModels == null) {
            ProjectDataNodeSetup.$$$reportNull$$$0(8);
        }
        if (moduleData == null) {
            ProjectDataNodeSetup.$$$reportNull$$$0(9);
        }
        GradleProject gradleProject = moduleModels.findModel(GradleProject.class);
        assert (gradleProject != null);
        for (GradleTask task : gradleProject.getTasks()) {
            String taskGroup;
            String taskName = task.getName();
            try {
                taskGroup = task.getGroup();
            }
            catch (UnsupportedMethodException e) {
                taskGroup = null;
            }
            if (taskName == null || taskName.trim().isEmpty() || GradleProjectResolverUtil.isIdeaTask((String)taskName, (String)taskGroup)) continue;
            TaskData taskData = new TaskData(GradleConstants.SYSTEM_ID, taskName, ((ModuleData)moduleData.getData()).getLinkedExternalProjectPath(), task.getDescription());
            taskData.setGroup(taskGroup);
            moduleData.createChild(ProjectKeys.TASK, (Object)taskData);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectModels";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModels";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDataNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/ProjectDataNodeSetup";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProject";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/ProjectDataNodeSetup";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleDataNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setupProjectDataNode";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createModuleDataNode";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findModule";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTaskDataNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

