/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleModuleModels;
import com.android.tools.idea.gradle.project.sync.setup.Facets;
import com.android.tools.idea.gradle.project.sync.validation.android.AndroidModuleValidator;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AndroidModuleProcessor {
    static Key<GradleModuleModels> MODULE_GRADLE_MODELS_KEY = Key.create((String)"module.gradle.models");
    @NotNull
    private final Project myProject;
    @NotNull
    private final IdeModifiableModelsProvider myModelsProvider;
    @NotNull
    private final AndroidModuleValidator.Factory myModuleValidatorFactory;

    AndroidModuleProcessor(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (project == null) {
            AndroidModuleProcessor.$$$reportNull$$$0(0);
        }
        if (modelsProvider == null) {
            AndroidModuleProcessor.$$$reportNull$$$0(1);
        }
        this(project, modelsProvider, new AndroidModuleValidator.Factory());
    }

    @VisibleForTesting
    AndroidModuleProcessor(@NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull AndroidModuleValidator.Factory moduleValidatorFactory) {
        if (project == null) {
            AndroidModuleProcessor.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            AndroidModuleProcessor.$$$reportNull$$$0(3);
        }
        if (moduleValidatorFactory == null) {
            AndroidModuleProcessor.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myModelsProvider = modelsProvider;
        this.myModuleValidatorFactory = moduleValidatorFactory;
    }

    void processAndroidModels(@NotNull List<Module> androidModules) {
        if (androidModules == null) {
            AndroidModuleProcessor.$$$reportNull$$$0(5);
        }
        AndroidModuleValidator moduleValidator = this.myModuleValidatorFactory.create(this.myProject);
        for (Module module : androidModules) {
            AndroidModuleModel androidModel = this.findAndroidModel(module);
            if (androidModel == null) continue;
            moduleValidator.validate(module, androidModel);
        }
        moduleValidator.fixAndReportFoundIssues();
    }

    @Nullable
    private AndroidModuleModel findAndroidModel(@NotNull Module module) {
        AndroidFacet facet;
        if (module == null) {
            AndroidModuleProcessor.$$$reportNull$$$0(6);
        }
        return (facet = Facets.findFacet(module, this.myModelsProvider, AndroidFacet.ID)) != null ? AndroidModuleModel.get(facet) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleValidatorFactory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidModules";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/AndroidModuleProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processAndroidModels";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "findAndroidModel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

