/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.ng;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.Dependencies;
import com.android.builder.model.NativeAndroidProject;
import com.android.builder.model.Variant;
import com.android.builder.model.level2.DependencyGraphs;
import com.android.builder.model.level2.GraphItem;
import com.android.tools.idea.gradle.project.sync.Modules;
import com.android.tools.idea.gradle.project.sync.ng.SyncModuleModels;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidModule {
    @NotNull
    private final AndroidProject myAndroidProject;
    @NotNull
    private final SyncModuleModels myModuleModels;
    @NotNull
    private final List<ModuleDependency> myModuleDependencies;
    @NotNull
    private final Map<String, Variant> myVariantsByName;
    @NotNull
    public static final Pattern MODULE_ARTIFACT_ADDRESS_PATTERN = Pattern.compile("([^@]*)@@(.[^:]*)(::(.*))?");
    @Nullable
    private final NativeAndroidProject myNativeAndroidProject;

    AndroidModule(@NotNull AndroidProject androidProject, @NotNull SyncModuleModels moduleModels, @Nullable NativeAndroidProject nativeAndroidProject) {
        if (androidProject == null) {
            AndroidModule.$$$reportNull$$$0(0);
        }
        if (moduleModels == null) {
            AndroidModule.$$$reportNull$$$0(1);
        }
        this.myModuleDependencies = new ArrayList<ModuleDependency>();
        this.myVariantsByName = new HashMap<String, Variant>();
        this.myAndroidProject = androidProject;
        this.myModuleModels = moduleModels;
        this.myNativeAndroidProject = nativeAndroidProject;
    }

    void addSelectedVariant(@NotNull Variant selectedVariant, @Nullable String abi) {
        if (selectedVariant == null) {
            AndroidModule.$$$reportNull$$$0(2);
        }
        this.myVariantsByName.put(selectedVariant.getName(), selectedVariant);
        AndroidArtifact artifact = selectedVariant.getMainArtifact();
        Dependencies dependencies = artifact.getDependencies();
        if (!dependencies.getLibraries().isEmpty()) {
            this.populateDependencies(dependencies, abi);
        } else {
            this.populateDependencies(artifact.getDependencyGraphs(), abi);
        }
    }

    private void populateDependencies(@NotNull Dependencies dependencies, @Nullable String abi) {
        if (dependencies == null) {
            AndroidModule.$$$reportNull$$$0(3);
        }
        for (AndroidLibrary library : dependencies.getLibraries()) {
            String project = library.getProject();
            if (project == null) continue;
            String id = Modules.createUniqueModuleId(Strings.nullToEmpty((String)library.getBuildId()), project);
            String variant = library.getProjectVariant();
            this.addModuleDependency(id, variant, abi);
        }
    }

    private void populateDependencies(@NotNull DependencyGraphs dependencyGraphs, @Nullable String abi) {
        if (dependencyGraphs == null) {
            AndroidModule.$$$reportNull$$$0(4);
        }
        for (GraphItem item : dependencyGraphs.getCompileDependencies()) {
            String address = item.getArtifactAddress();
            Matcher matcher = MODULE_ARTIFACT_ADDRESS_PATTERN.matcher(address);
            if (!matcher.matches()) continue;
            String buildId2 = matcher.group(1);
            String project = matcher.group(2);
            if (buildId2 == null || project == null) continue;
            String id = Modules.createUniqueModuleId(Strings.nullToEmpty((String)buildId2), project);
            String variant = matcher.group(4);
            this.addModuleDependency(id, variant, abi);
        }
    }

    private void addModuleDependency(@NotNull String id, @Nullable String variant, @Nullable String abi) {
        if (id == null) {
            AndroidModule.$$$reportNull$$$0(5);
        }
        ModuleDependency dependency = new ModuleDependency(id, variant, abi);
        this.myModuleDependencies.add(dependency);
    }

    @NotNull
    AndroidProject getAndroidProject() {
        AndroidProject androidProject = this.myAndroidProject;
        if (androidProject == null) {
            AndroidModule.$$$reportNull$$$0(6);
        }
        return androidProject;
    }

    @Nullable
    NativeAndroidProject getNativeAndroidProject() {
        return this.myNativeAndroidProject;
    }

    @NotNull
    List<ModuleDependency> getModuleDependencies() {
        List<ModuleDependency> list = this.myModuleDependencies;
        if (list == null) {
            AndroidModule.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    SyncModuleModels getModuleModels() {
        SyncModuleModels syncModuleModels = this.myModuleModels;
        if (syncModuleModels == null) {
            AndroidModule.$$$reportNull$$$0(8);
        }
        return syncModuleModels;
    }

    boolean containsVariant(@NotNull String variantName) {
        if (variantName == null) {
            AndroidModule.$$$reportNull$$$0(9);
        }
        return this.myVariantsByName.containsKey(variantName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "androidProject";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModels";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedVariant";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyGraphs";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/ng/AndroidModule";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/ng/AndroidModule";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndroidProject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleDependencies";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addSelectedVariant";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "populateDependencies";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addModuleDependency";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "containsVariant";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ModuleDependency {
        @NotNull
        final String id;
        @Nullable
        final String variant;
        @Nullable
        final String abi;

        ModuleDependency(@NotNull String id, @Nullable String variant, @Nullable String abi) {
            if (id == null) {
                ModuleDependency.$$$reportNull$$$0(0);
            }
            this.id = id;
            this.variant = variant;
            this.abi = abi;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/idea/gradle/project/sync/ng/AndroidModule$ModuleDependency", "<init>"));
        }
    }
}

