/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.issues;

import com.android.builder.model.SyncIssue;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.ProductFlavorModel;
import com.android.tools.idea.gradle.dsl.api.ext.ResolvedPropertyModel;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.project.sync.hyperlink.RemoveSdkFromManifestHyperlink;
import com.android.tools.idea.gradle.project.sync.issues.SimpleDeduplicatingSyncIssueReporter;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.UsesSdk;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SdkInManifestIssuesReporter
extends SimpleDeduplicatingSyncIssueReporter {
    @Override
    protected abstract int getSupportedIssueType();

    @NotNull
    protected abstract SdkProperty getProperty();

    @Override
    @NotNull
    protected OpenFileHyperlink createModuleLink(@NotNull Project project, @NotNull Module module, @NotNull ProjectBuildModel projectBuildModel, @NotNull List<SyncIssue> syncIssues, @NotNull VirtualFile buildFile) {
        AndroidFacet androidFacet;
        if (project == null) {
            SdkInManifestIssuesReporter.$$$reportNull$$$0(0);
        }
        if (module == null) {
            SdkInManifestIssuesReporter.$$$reportNull$$$0(1);
        }
        if (projectBuildModel == null) {
            SdkInManifestIssuesReporter.$$$reportNull$$$0(2);
        }
        if (syncIssues == null) {
            SdkInManifestIssuesReporter.$$$reportNull$$$0(3);
        }
        if (buildFile == null) {
            SdkInManifestIssuesReporter.$$$reportNull$$$0(4);
        }
        if ((androidFacet = AndroidFacet.getInstance(module)) != null) {
            VirtualFile manifestFile;
            Manifest manifest = androidFacet.getManifest();
            PsiElement element = null;
            if (manifest != null) {
                element = (PsiElement)ApplicationManager.getApplication().runReadAction(() -> {
                    List<UsesSdk> usesSdks = manifest.getUsesSdks();
                    if (!usesSdks.isEmpty()) {
                        return usesSdks.get(0).getXmlElement();
                    }
                    return null;
                });
            }
            if ((manifestFile = AndroidRootUtil.getPrimaryManifestFile(androidFacet)) != null) {
                int lineNumber = element != null ? SdkInManifestIssuesReporter.getLineNumberForElement(project, element) : -1;
                OpenFileHyperlink openFileHyperlink = new OpenFileHyperlink(manifestFile.getPath(), module.getName(), lineNumber, -1);
                if (openFileHyperlink == null) {
                    SdkInManifestIssuesReporter.$$$reportNull$$$0(5);
                }
                return openFileHyperlink;
            }
        }
        OpenFileHyperlink openFileHyperlink = super.createModuleLink(project, module, projectBuildModel, syncIssues, buildFile);
        if (openFileHyperlink == null) {
            SdkInManifestIssuesReporter.$$$reportNull$$$0(6);
        }
        return openFileHyperlink;
    }

    @Override
    @Nullable
    protected Object getDeduplicationKey(@NotNull SyncIssue issue2) {
        if (issue2 == null) {
            SdkInManifestIssuesReporter.$$$reportNull$$$0(7);
        }
        return issue2;
    }

    @Override
    @NotNull
    protected List<NotificationHyperlink> getCustomLinks(@NotNull Project project, @NotNull List<SyncIssue> syncIssues, @NotNull List<Module> affectedModules, @NotNull Map<Module, VirtualFile> buildFileMap) {
        if (project == null) {
            SdkInManifestIssuesReporter.$$$reportNull$$$0(8);
        }
        if (syncIssues == null) {
            SdkInManifestIssuesReporter.$$$reportNull$$$0(9);
        }
        if (affectedModules == null) {
            SdkInManifestIssuesReporter.$$$reportNull$$$0(10);
        }
        if (buildFileMap == null) {
            SdkInManifestIssuesReporter.$$$reportNull$$$0(11);
        }
        if (affectedModules.isEmpty()) {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                SdkInManifestIssuesReporter.$$$reportNull$$$0(12);
            }
            return immutableList;
        }
        ImmutableList immutableList = ImmutableList.of((Object)new RemoveSdkFromManifestHyperlink(affectedModules, this.getProperty()));
        if (immutableList == null) {
            SdkInManifestIssuesReporter.$$$reportNull$$$0(13);
        }
        return immutableList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectBuildModel";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncIssues";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFile";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/issues/SdkInManifestIssuesReporter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issue";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedModules";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFileMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/issues/SdkInManifestIssuesReporter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleLink";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomLinks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createModuleLink";
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDeduplicationKey";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getCustomLinks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum SdkProperty {
        MIN("minSdkVersion", 14, UsesSdk::getMinSdkVersion, ProductFlavorModel::minSdkVersion),
        TARGET("targetSdkVersion", 27, UsesSdk::getTargetSdkVersion, ProductFlavorModel::targetSdkVersion),
        MAX("maxSdkVersion", 28, UsesSdk::getMaxSdkVersion, ProductFlavorModel::maxSdkVersion);

        @NotNull
        private final String myName;
        private final int myDefaultValue;
        @NotNull
        private final Function<UsesSdk, AndroidAttributeValue<String>> myManifestFunction;
        @NotNull
        private final Function<ProductFlavorModel, ResolvedPropertyModel> myBuildFileFunction;

        private SdkProperty(@NotNull String propertyName, @NotNull int defaultValue, Function<UsesSdk, AndroidAttributeValue<String>> manifestFunction, Function<ProductFlavorModel, ResolvedPropertyModel> buildFileFunction) {
            if (propertyName == null) {
                SdkProperty.$$$reportNull$$$0(0);
            }
            if (manifestFunction == null) {
                SdkProperty.$$$reportNull$$$0(1);
            }
            if (buildFileFunction == null) {
                SdkProperty.$$$reportNull$$$0(2);
            }
            this.myName = propertyName;
            this.myDefaultValue = defaultValue;
            this.myManifestFunction = manifestFunction;
            this.myBuildFileFunction = buildFileFunction;
        }

        @NotNull
        public String getPropertyName() {
            String string = this.myName;
            if (string == null) {
                SdkProperty.$$$reportNull$$$0(3);
            }
            return string;
        }

        public int getDefaultValue() {
            return this.myDefaultValue;
        }

        @NotNull
        public Function<UsesSdk, AndroidAttributeValue<String>> getManifestFunction() {
            Function<UsesSdk, AndroidAttributeValue<String>> function = this.myManifestFunction;
            if (function == null) {
                SdkProperty.$$$reportNull$$$0(4);
            }
            return function;
        }

        @NotNull
        public Function<ProductFlavorModel, ResolvedPropertyModel> getBuildFileFunction() {
            Function<ProductFlavorModel, ResolvedPropertyModel> function = this.myBuildFileFunction;
            if (function == null) {
                SdkProperty.$$$reportNull$$$0(5);
            }
            return function;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manifestFunction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildFileFunction";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/gradle/project/sync/issues/SdkInManifestIssuesReporter$SdkProperty";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/gradle/project/sync/issues/SdkInManifestIssuesReporter$SdkProperty";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPropertyName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getManifestFunction";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBuildFileFunction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

