/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.errors;

import com.android.tools.idea.gradle.project.sync.errors.ErrorAndLocation;
import com.android.tools.idea.gradle.project.sync.errors.SyncErrorHandler;
import com.android.tools.idea.gradle.project.sync.messages.GradleSyncMessages;
import com.android.tools.idea.util.PositionInFile;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.pom.NonNavigatable;
import org.jetbrains.annotations.NotNull;

public class SyncErrorHandlerManager {
    @NotNull
    private final GradleSyncMessages mySyncMessages;
    @NotNull
    private final ErrorAndLocation.Factory myCauseAndLocationFactory;
    @NotNull
    private final SyncErrorHandler[] myErrorHandlers;
    @NotNull
    private final Project myProject;

    public SyncErrorHandlerManager(@NotNull Project project) {
        if (project == null) {
            SyncErrorHandlerManager.$$$reportNull$$$0(0);
        }
        this(project, GradleSyncMessages.getInstance(project), new ErrorAndLocation.Factory(), SyncErrorHandler.getExtensions());
    }

    @VisibleForTesting
    SyncErrorHandlerManager(@NotNull Project project, @NotNull GradleSyncMessages syncMessages, @NotNull ErrorAndLocation.Factory causeAndLocationFactory, SyncErrorHandler ... errorHandlers) {
        if (project == null) {
            SyncErrorHandlerManager.$$$reportNull$$$0(1);
        }
        if (syncMessages == null) {
            SyncErrorHandlerManager.$$$reportNull$$$0(2);
        }
        if (causeAndLocationFactory == null) {
            SyncErrorHandlerManager.$$$reportNull$$$0(3);
        }
        if (errorHandlers == null) {
            SyncErrorHandlerManager.$$$reportNull$$$0(4);
        }
        this.mySyncMessages = syncMessages;
        this.myCauseAndLocationFactory = causeAndLocationFactory;
        this.myErrorHandlers = errorHandlers;
        this.myProject = project;
    }

    public void handleError(@NotNull Throwable error) {
        if (error == null) {
            SyncErrorHandlerManager.$$$reportNull$$$0(5);
        }
        Runnable runnable = () -> {
            ErrorAndLocation errorAndLocation = this.myCauseAndLocationFactory.create(error);
            ExternalSystemException errorToReport = errorAndLocation.getError();
            String message = ExternalSystemApiUtil.buildErrorMessage((Throwable)errorToReport);
            PositionInFile positionInFile = errorAndLocation.getPositionInFile();
            NotificationData notificationData = this.mySyncMessages.createNotification("Gradle Sync Issues", message, NotificationCategory.ERROR, positionInFile);
            for (SyncErrorHandler errorHandler : this.myErrorHandlers) {
                if (errorHandler.handleError(errorToReport, notificationData, this.myProject)) break;
            }
            if (notificationData.getNavigatable() == null) {
                notificationData.setNavigatable(NonNavigatable.INSTANCE);
            }
            this.mySyncMessages.report(notificationData);
        };
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(runnable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncMessages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "causeAndLocationFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorHandlers";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/gradle/project/sync/errors/SyncErrorHandlerManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "handleError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

