/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync.compatibility;

import com.android.tools.idea.gradle.project.sync.compatibility.version.VersionRange;
import com.google.common.collect.ImmutableList;
import com.intellij.util.SystemProperties;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class Component {
    @NotNull
    private final String myName;
    @NotNull
    private final VersionRange myVersionRange;
    @NotNull
    private final List<Component> myRequirements;
    @Nullable
    private final String myFailureMessage;

    Component(@NotNull String name, @NotNull String version2, @Nullable String failureMessage) {
        if (name == null) {
            Component.$$$reportNull$$$0(0);
        }
        if (version2 == null) {
            Component.$$$reportNull$$$0(1);
        }
        this.myName = name;
        this.myVersionRange = VersionRange.parse(version2);
        this.myFailureMessage = failureMessage;
        this.myRequirements = new ArrayList<Component>();
    }

    @NotNull
    String getName() {
        String string = this.myName;
        if (string == null) {
            Component.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    VersionRange getVersionRange() {
        VersionRange versionRange = this.myVersionRange;
        if (versionRange == null) {
            Component.$$$reportNull$$$0(3);
        }
        return versionRange;
    }

    @Nullable
    String getFailureMessage() {
        return this.myFailureMessage;
    }

    @NotNull
    List<Component> getRequirements() {
        ImmutableList immutableList = ImmutableList.copyOf(this.myRequirements);
        if (immutableList == null) {
            Component.$$$reportNull$$$0(4);
        }
        return immutableList;
    }

    void addRequirement(@NotNull Component component) {
        if (component == null) {
            Component.$$$reportNull$$$0(5);
        }
        this.myRequirements.add(component);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.myName).append(" ").append(this.myVersionRange);
        if (!this.myRequirements.isEmpty()) {
            String lineSeparator = SystemProperties.getLineSeparator();
            buffer.append(lineSeparator).append("Requirements:");
            for (Component requirement : this.myRequirements) {
                buffer.append(lineSeparator).append("  ").append(requirement);
            }
        }
        return buffer.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/compatibility/Component";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/compatibility/Component";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionRange";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequirements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addRequirement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

