/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.GradleWrapper;
import com.google.common.collect.Lists;
import com.intellij.concurrency.JobLauncher;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.ui.EditorNotifications;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;

public class GradleFiles {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Object myLock;
    @NotNull
    private final Set<VirtualFile> myChangedFiles;
    @NotNull
    private final Set<VirtualFile> myChangedExternalFiles;
    @NotNull
    private final Map<VirtualFile, Integer> myFileHashes;
    @NotNull
    private final Set<VirtualFile> myExternalBuildFiles;
    @NotNull
    private final SyncListener mySyncListener;
    @NotNull
    private final FileEditorManagerListener myFileEditorListener;

    @NotNull
    public static GradleFiles getInstance(@NotNull Project project) {
        if (project == null) {
            GradleFiles.$$$reportNull$$$0(0);
        }
        GradleFiles gradleFiles = (GradleFiles)ServiceManager.getService((Project)project, GradleFiles.class);
        if (gradleFiles == null) {
            GradleFiles.$$$reportNull$$$0(1);
        }
        return gradleFiles;
    }

    private GradleFiles(@NotNull Project project) {
        if (project == null) {
            GradleFiles.$$$reportNull$$$0(2);
        }
        this.myLock = new Object();
        this.myChangedFiles = new HashSet<VirtualFile>();
        this.myChangedExternalFiles = new HashSet<VirtualFile>();
        this.myFileHashes = new HashMap<VirtualFile, Integer>();
        this.myExternalBuildFiles = new HashSet<VirtualFile>();
        this.mySyncListener = new SyncListener();
        this.myProject = project;
        final GradleFileChangeListener fileChangeListener = new GradleFileChangeListener(this);
        this.myFileEditorListener = new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (event.getNewFile() == null || !event.getNewFile().isValid()) {
                    return;
                }
                PsiFile psiFile = PsiManager.getInstance((Project)GradleFiles.this.myProject).findFile(event.getNewFile());
                if (psiFile == null) {
                    return;
                }
                if (GradleFiles.this.isGradleFile(psiFile) || GradleFiles.this.isExternalBuildFile(psiFile)) {
                    PsiManager.getInstance((Project)GradleFiles.this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)fileChangeListener);
                } else {
                    PsiManager.getInstance((Project)GradleFiles.this.myProject).removePsiTreeChangeListener((PsiTreeChangeListener)fileChangeListener);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/gradle/project/sync/GradleFiles$1", "selectionChanged"));
            }
        };
        if (this.myProject.isDefault()) {
            return;
        }
        this.myProject.getMessageBus().connect().subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this.myFileEditorListener);
        GradleSyncState.subscribe(this.myProject, this.mySyncListener);
        if (this.myProject.isInitialized()) {
            this.updateFileHashes();
        } else {
            StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity(this::updateFileHashes);
        }
    }

    @NotNull
    GradleSyncListener getSyncListener() {
        SyncListener syncListener = this.mySyncListener;
        if (syncListener == null) {
            GradleFiles.$$$reportNull$$$0(3);
        }
        return syncListener;
    }

    @NotNull
    FileEditorManagerListener getFileEditorListener() {
        FileEditorManagerListener fileEditorManagerListener = this.myFileEditorListener;
        if (fileEditorManagerListener == null) {
            GradleFiles.$$$reportNull$$$0(4);
        }
        return fileEditorManagerListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasHashForFile(@NotNull VirtualFile file) {
        if (file == null) {
            GradleFiles.$$$reportNull$$$0(5);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myFileHashes.containsKey(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChangedFiles() {
        Object object = this.myLock;
        synchronized (object) {
            this.myChangedFiles.clear();
            this.myChangedExternalFiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChangedFile(@NotNull VirtualFile file, boolean isExternal) {
        if (file == null) {
            GradleFiles.$$$reportNull$$$0(6);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (isExternal) {
                this.myChangedExternalFiles.add(file);
            } else {
                this.myChangedFiles.add(file);
            }
        }
    }

    private void putHashForFile(@NotNull Map<VirtualFile, Integer> map2, @NotNull VirtualFile file) {
        Integer hash2;
        if (map2 == null) {
            GradleFiles.$$$reportNull$$$0(7);
        }
        if (file == null) {
            GradleFiles.$$$reportNull$$$0(8);
        }
        if ((hash2 = this.computeHash(file)) != null) {
            map2.put(file, hash2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeHashesForFiles(@NotNull Map<VirtualFile, Integer> files2) {
        if (files2 == null) {
            GradleFiles.$$$reportNull$$$0(9);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myFileHashes.clear();
            this.myFileHashes.putAll(files2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Integer getStoredHashForFile(@NotNull VirtualFile file) {
        if (file == null) {
            GradleFiles.$$$reportNull$$$0(10);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myFileHashes.get(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean containsChangedFile(@NotNull VirtualFile file) {
        if (file == null) {
            GradleFiles.$$$reportNull$$$0(11);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myChangedFiles.contains(file) || this.myChangedExternalFiles.contains(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExternalBuildFiles() {
        Object object = this.myLock;
        synchronized (object) {
            this.myExternalBuildFiles.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeExternalBuildFiles(@NotNull Collection<VirtualFile> externalBuildFiles) {
        if (externalBuildFiles == null) {
            GradleFiles.$$$reportNull$$$0(12);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myExternalBuildFiles.addAll(externalBuildFiles);
        }
    }

    @Nullable
    private Integer computeHash(@NotNull VirtualFile file) {
        PsiFile psiFile;
        if (file == null) {
            GradleFiles.$$$reportNull$$$0(13);
        }
        if ((psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file)) != null && psiFile.isValid()) {
            return psiFile.getText().hashCode();
        }
        return null;
    }

    private boolean areHashesEqual(@NotNull VirtualFile file) {
        Integer oldHash;
        if (file == null) {
            GradleFiles.$$$reportNull$$$0(14);
        }
        return (oldHash = this.getStoredHashForFile(file)) != null && oldHash.equals(this.computeHash(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkHashesOfChangedFiles() {
        Object object = this.myLock;
        synchronized (object) {
            return this.filterHashes(this.myChangedFiles) && this.filterHashes(this.myChangedExternalFiles);
        }
    }

    private boolean filterHashes(@NotNull Collection<VirtualFile> files2) {
        if (files2 == null) {
            GradleFiles.$$$reportNull$$$0(15);
        }
        boolean status = true;
        HashSet<VirtualFile> toRemove = new HashSet<VirtualFile>();
        for (VirtualFile file : files2) {
            if (!this.areHashesEqual(file)) {
                status = false;
                continue;
            }
            toRemove.add(file);
        }
        files2.removeAll(toRemove);
        return status;
    }

    private void updateFileHashes() {
        VirtualFile propertiesFile;
        File propertiesFilePath;
        HashMap<VirtualFile, Integer> fileHashes = new HashMap<VirtualFile, Integer>();
        GradleWrapper gradleWrapper = GradleWrapper.find(this.myProject);
        if (gradleWrapper != null && (propertiesFilePath = gradleWrapper.getPropertiesFilePath()).isFile() && (propertiesFile = gradleWrapper.getPropertiesFile()) != null) {
            this.putHashForFile(fileHashes, propertiesFile);
        }
        this.removeExternalBuildFiles();
        ArrayList<VirtualFile> externalBuildFiles = new ArrayList<VirtualFile>();
        ArrayList modules = Lists.newArrayList((Object[])ModuleManager.getInstance((Project)this.myProject).getModules());
        JobLauncher jobLauncher = JobLauncher.getInstance();
        jobLauncher.invokeConcurrentlyUnderProgress((List)modules, null, module -> {
            NdkModuleModel ndkModuleModel;
            File path;
            VirtualFile buildFile = GradleUtil.getGradleBuildFile(module);
            if (buildFile != null && (path = VfsUtilCore.virtualToIoFile((VirtualFile)buildFile)).isFile()) {
                this.putHashForFile(fileHashes, buildFile);
            }
            if ((ndkModuleModel = NdkModuleModel.get(module)) != null) {
                for (File externalBuildFile : ndkModuleModel.getAndroidProject().getBuildFiles()) {
                    if (!externalBuildFile.isFile()) continue;
                    VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)externalBuildFile, (boolean)true);
                    externalBuildFiles.add(virtualFile);
                    if (virtualFile == null) continue;
                    this.putHashForFile(fileHashes, virtualFile);
                }
            }
            return true;
        });
        this.storeExternalBuildFiles(externalBuildFiles);
        String[] fileNames = new String[]{"settings.gradle", "gradle.properties"};
        File rootFolderPath = Projects.getBaseDirPath((Project)this.myProject);
        for (String fileName : fileNames) {
            File filePath = new File(rootFolderPath, fileName);
            if (!filePath.isFile()) continue;
            VirtualFile rootFolder = this.myProject.getBaseDir();
            assert (rootFolder != null);
            VirtualFile virtualFile = rootFolder.findChild(fileName);
            if (virtualFile == null || !virtualFile.exists() || virtualFile.isDirectory()) continue;
            this.putHashForFile(fileHashes, virtualFile);
        }
        this.storeHashesForFiles(fileHashes);
    }

    public boolean areGradleFilesModified() {
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> !this.checkHashesOfChangedFiles());
    }

    public boolean areExternalBuildFilesModified() {
        return (Boolean)ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myLock;
            synchronized (object) {
                return !this.filterHashes(this.myChangedExternalFiles);
            }
        });
    }

    public boolean isGradleFile(@NotNull PsiFile psiFile) {
        VirtualFile file;
        if (psiFile == null) {
            GradleFiles.$$$reportNull$$$0(16);
        }
        if (psiFile.getFileType() == GroovyFileType.GROOVY_FILE_TYPE && (file = psiFile.getVirtualFile()) != null && "gradle".equals(file.getExtension())) {
            return true;
        }
        return psiFile.getFileType() == PropertiesFileType.INSTANCE && (file = psiFile.getVirtualFile()) != null && ("gradle.properties".equals(file.getName()) || "gradle-wrapper.properties".equals(file.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExternalBuildFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            GradleFiles.$$$reportNull$$$0(17);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myExternalBuildFiles.contains(psiFile.getVirtualFile());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/sync/GradleFiles";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalBuildFiles";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/sync/GradleFiles";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyncListener";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileEditorListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasHashForFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addChangedFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "putHashForFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "storeHashesForFiles";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getStoredHashForFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "containsChangedFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "storeExternalBuildFiles";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "computeHash";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "areHashesEqual";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "filterHashes";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isGradleFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isExternalBuildFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GradleFileChangeListener
    extends PsiTreeChangeAdapter {
        @NotNull
        private final GradleFiles myGradleFiles;

        private GradleFileChangeListener(@NotNull GradleFiles gradleFiles) {
            if (gradleFiles == null) {
                GradleFileChangeListener.$$$reportNull$$$0(0);
            }
            this.myGradleFiles = gradleFiles;
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                GradleFileChangeListener.$$$reportNull$$$0(1);
            }
            this.processEvent(event, event.getChild());
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                GradleFileChangeListener.$$$reportNull$$$0(2);
            }
            this.processEvent(event, event.getChild());
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                GradleFileChangeListener.$$$reportNull$$$0(3);
            }
            this.processEvent(event, event.getNewChild(), event.getOldChild());
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                GradleFileChangeListener.$$$reportNull$$$0(4);
            }
            this.processEvent(event, event.getChild());
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                GradleFileChangeListener.$$$reportNull$$$0(5);
            }
            this.processEvent(event, event.getOldChild(), event.getNewChild());
        }

        private void processEvent(@NotNull PsiTreeChangeEvent event, PsiElement ... elements) {
            PsiFile psiFile;
            if (event == null) {
                GradleFileChangeListener.$$$reportNull$$$0(6);
            }
            if (elements == null) {
                GradleFileChangeListener.$$$reportNull$$$0(7);
            }
            if ((psiFile = event.getFile()) == null) {
                return;
            }
            boolean isExternalBuildFile = this.myGradleFiles.isExternalBuildFile(psiFile);
            if (!this.myGradleFiles.isGradleFile(psiFile) && !isExternalBuildFile) {
                return;
            }
            if (this.myGradleFiles.containsChangedFile(psiFile.getVirtualFile())) {
                return;
            }
            if (!this.myGradleFiles.myProject.isInitialized() || !PsiManager.getInstance((Project)this.myGradleFiles.myProject).isInProject((PsiElement)psiFile)) {
                return;
            }
            boolean foundChange = false;
            for (PsiElement element : elements) {
                if (element == null || element instanceof PsiWhiteSpace || element.getNode().getElementType().equals(GroovyTokenTypes.mNLS)) continue;
                foundChange = true;
                break;
            }
            if (foundChange) {
                this.myGradleFiles.addChangedFile(psiFile.getVirtualFile(), isExternalBuildFile);
                EditorNotifications.getInstance((Project)psiFile.getProject()).updateNotifications(psiFile.getVirtualFile());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gradleFiles";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/gradle/project/sync/GradleFiles$GradleFileChangeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childAdded";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childRemoved";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childReplaced";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childMoved";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childrenChanged";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processEvent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SyncListener
    implements GradleSyncListener {
        private SyncListener() {
        }

        @Override
        public void syncStarted(@NotNull Project project, boolean skipped, boolean sourceGenerationRequested) {
            if (project == null) {
                SyncListener.$$$reportNull$$$0(0);
            }
            this.maybeProcessSyncStarted(project);
        }

        private void maybeProcessSyncStarted(@NotNull Project project) {
            if (project == null) {
                SyncListener.$$$reportNull$$$0(1);
            }
            if (!project.isInitialized() && project.equals(GradleFiles.this.myProject)) {
                return;
            }
            if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                GradleFiles.this.updateFileHashes();
                GradleFiles.this.removeChangedFiles();
            } else {
                ApplicationManager.getApplication().runReadAction(() -> {
                    GradleFiles.this.updateFileHashes();
                    GradleFiles.this.removeChangedFiles();
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "project";
            objectArray2[1] = "com/android/tools/idea/gradle/project/sync/GradleFiles$SyncListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "syncStarted";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "maybeProcessSyncStarted";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

