/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.model;

import com.android.tools.idea.gradle.project.model.ModuleModel;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.GradleTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleModuleModel
implements ModuleModel {
    private static final long serialVersionUID = 3L;
    @NotNull
    private final String myModuleName;
    @NotNull
    private final List<String> myTaskNames;
    @NotNull
    private final String myGradlePath;
    @NotNull
    private final File myRootFolderPath;
    @NotNull
    private final List<String> myGradlePlugins;
    @Nullable
    private final File myBuildFilePath;
    @Nullable
    private final String myGradleVersion;

    public GradleModuleModel(@NotNull String moduleName, @NotNull GradleProject gradleProject, @NotNull Collection<String> gradlePlugins, @Nullable File buildFilePath, @Nullable String gradleVersion) {
        if (moduleName == null) {
            GradleModuleModel.$$$reportNull$$$0(0);
        }
        if (gradleProject == null) {
            GradleModuleModel.$$$reportNull$$$0(1);
        }
        if (gradlePlugins == null) {
            GradleModuleModel.$$$reportNull$$$0(2);
        }
        this.myModuleName = moduleName;
        this.myTaskNames = GradleModuleModel.getTaskNames(gradleProject);
        this.myGradlePath = gradleProject.getPath();
        this.myRootFolderPath = gradleProject.getProjectIdentifier().getBuildIdentifier().getRootDir();
        this.myGradlePlugins = ImmutableList.copyOf(gradlePlugins);
        this.myBuildFilePath = buildFilePath;
        this.myGradleVersion = gradleVersion;
    }

    @NotNull
    private static List<String> getTaskNames(@NotNull GradleProject gradleProject) {
        if (gradleProject == null) {
            GradleModuleModel.$$$reportNull$$$0(3);
        }
        ArrayList<String> taskNames = new ArrayList<String>();
        DomainObjectSet tasks = gradleProject.getTasks();
        if (!tasks.isEmpty()) {
            for (GradleTask task : tasks) {
                String name = task.getName();
                if (!StringUtil.isNotEmpty((String)name)) continue;
                taskNames.add(task.getProject().getPath() + ":" + task.getName());
            }
        }
        ArrayList<String> arrayList = taskNames;
        if (arrayList == null) {
            GradleModuleModel.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            GradleModuleModel.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getGradlePath() {
        String string = this.myGradlePath;
        if (string == null) {
            GradleModuleModel.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public File getRootFolderPath() {
        File file = this.myRootFolderPath;
        if (file == null) {
            GradleModuleModel.$$$reportNull$$$0(7);
        }
        return file;
    }

    @NotNull
    public List<String> getTaskNames() {
        List<String> list = this.myTaskNames;
        if (list == null) {
            GradleModuleModel.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    public VirtualFile getBuildFile() {
        return this.myBuildFilePath != null ? VfsUtil.findFileByIoFile((File)this.myBuildFilePath, (boolean)true) : null;
    }

    @Nullable
    public File getBuildFilePath() {
        return this.myBuildFilePath;
    }

    @Nullable
    public String getGradleVersion() {
        return this.myGradleVersion;
    }

    @NotNull
    public List<String> getGradlePlugins() {
        List<String> list = this.myGradlePlugins;
        if (list == null) {
            GradleModuleModel.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProject";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradlePlugins";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/model/GradleModuleModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/model/GradleModuleModel";
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTaskNames";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradlePath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootFolderPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getGradlePlugins";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTaskNames";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

