/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.build.invoker.messages;

import com.intellij.icons.AllIcons;
import com.intellij.ide.errorTreeView.ErrorTreeElement;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorTreeNodeDescriptor;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.NavigatableMessageElement;
import com.intellij.ide.errorTreeView.SimpleMessageElement;
import com.intellij.ui.MultilineTreeCellRenderer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MessageTreeRenderer
extends MultilineTreeCellRenderer {
    MessageTreeRenderer() {
    }

    protected void initComponent(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        ErrorTreeElement element = MessageTreeRenderer.getElement(value2);
        if (element != null) {
            String[] text = element.getText();
            if (text == null) {
                text = ArrayUtil.EMPTY_STRING_ARRAY;
            }
            if (text.length > 0 && text[0] == null) {
                text[0] = "";
            }
            this.setText(text, "");
        }
        Icon icon = null;
        if (element instanceof GroupingElement) {
            GroupingElement groupingElement = (GroupingElement)element;
            icon = groupingElement.getFile() != null ? groupingElement.getFile().getFileType().getIcon() : AllIcons.FileTypes.Java;
        } else if (element instanceof SimpleMessageElement || element instanceof NavigatableMessageElement) {
            ErrorTreeElementKind kind = element.getKind();
            icon = MessageTreeRenderer.getIconFor(kind);
        }
        if (icon == null) {
            icon = EmptyIcon.ICON_16;
        }
        this.setIcon(icon);
    }

    @NotNull
    private static Icon getIconFor(@NotNull ErrorTreeElementKind kind) {
        if (kind == null) {
            MessageTreeRenderer.$$$reportNull$$$0(0);
        }
        switch (kind) {
            case ERROR: {
                Icon icon = AllIcons.General.BalloonError;
                if (icon == null) {
                    MessageTreeRenderer.$$$reportNull$$$0(1);
                }
                return icon;
            }
            case WARNING: {
                Icon icon = AllIcons.General.BalloonWarning;
                if (icon == null) {
                    MessageTreeRenderer.$$$reportNull$$$0(2);
                }
                return icon;
            }
            case INFO: {
                Icon icon = AllIcons.General.BalloonInformation;
                if (icon == null) {
                    MessageTreeRenderer.$$$reportNull$$$0(3);
                }
                return icon;
            }
        }
        Icon icon = EmptyIcon.ICON_16;
        if (icon == null) {
            MessageTreeRenderer.$$$reportNull$$$0(4);
        }
        return icon;
    }

    @Nullable
    private static ErrorTreeElement getElement(@Nullable Object value2) {
        Object userObject;
        if (value2 instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)value2).getUserObject()) instanceof ErrorTreeNodeDescriptor) {
            return ((ErrorTreeNodeDescriptor)userObject).getElement();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/build/invoker/messages/MessageTreeRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/build/invoker/messages/MessageTreeRenderer";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIconFor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

