/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.project.facet.gradle.GradleFacet;
import com.android.tools.idea.gradle.project.model.GradleModuleModel;
import com.android.tools.idea.gradle.project.model.NdkModuleModel;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectBuildFileChecksums
implements Serializable {
    private Map<String, byte[]> myFileChecksums = new HashMap<String, byte[]>();
    private long myLastGradleSyncTimestamp = -1L;
    private transient File myRootFolderPath;

    private ProjectBuildFileChecksums() {
    }

    @Nullable
    public static ProjectBuildFileChecksums findFor(@NotNull Project project) {
        if (project == null) {
            ProjectBuildFileChecksums.$$$reportNull$$$0(0);
        }
        if (ProjectBuildFileChecksums.needsAndroidSdkSync(project)) {
            return null;
        }
        try {
            return ProjectBuildFileChecksums.loadFromDisk(project);
        }
        catch (IOException e) {
            ProjectBuildFileChecksums.getLog().warn(String.format("Error accessing state cache for project '%1$s', sync will be needed.", project.getName()));
        }
        catch (ClassNotFoundException e) {
            ProjectBuildFileChecksums.getLog().warn(String.format("Cannot recover state cache for project '%1$s', sync will be needed.", project.getName()));
        }
        return null;
    }

    private static boolean needsAndroidSdkSync(@NotNull Project project) {
        if (project == null) {
            ProjectBuildFileChecksums.$$$reportNull$$$0(1);
        }
        if (IdeInfo.getInstance().isAndroidStudio()) {
            File ideSdkPath = IdeSdks.getInstance().getAndroidSdkPath();
            if (ideSdkPath != null) {
                try {
                    LocalProperties localProperties = new LocalProperties(project);
                    File projectSdkPath = localProperties.getAndroidSdkPath();
                    return projectSdkPath == null || !FileUtil.filesEqual((File)ideSdkPath, (File)projectSdkPath);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private static ProjectBuildFileChecksums loadFromDisk(@NotNull Project project) throws IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void saveToDisk(@NotNull Project project) {
        if (project == null) {
            ProjectBuildFileChecksums.$$$reportNull$$$0(3);
        }
        boolean cacheSaved = false;
        try {
            ProjectBuildFileChecksums buildFileChecksums = ProjectBuildFileChecksums.createFrom(project);
            if (buildFileChecksums != null) {
                File file = ProjectBuildFileChecksums.getProjectStateFile(project);
                FileUtil.ensureExists((File)file.getParentFile());
                buildFileChecksums.saveTo(file);
                cacheSaved = true;
            }
        }
        catch (Throwable e) {
            ProjectBuildFileChecksums.getLog().info(String.format("Error while saving persistent state from project '%1$s'", project.getName()), e);
        }
        if (!cacheSaved) {
            ProjectBuildFileChecksums.getLog().info("Failed to generate new cache. Deleting the old one.");
            ProjectBuildFileChecksums.removeFrom(project);
        }
    }

    @Nullable
    static ProjectBuildFileChecksums createFrom(@NotNull Project project) throws IOException {
        if (project == null) {
            ProjectBuildFileChecksums.$$$reportNull$$$0(4);
        }
        ProjectBuildFileChecksums buildFileChecksums = new ProjectBuildFileChecksums();
        File rootFolderPath = Projects.getBaseDirPath((Project)project);
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            NdkModuleModel ndkModel;
            GradleFacet gradleFacet = GradleFacet.getInstance(module);
            if (gradleFacet != null) {
                GradleModuleModel gradleModel = gradleFacet.getGradleModuleModel();
                if (gradleModel == null) {
                    ProjectBuildFileChecksums.getLog().warn(String.format("Trying to create project data from a not initialized project '%1$s'. Abort.", project.getName()));
                    return null;
                }
                buildFileChecksums.addFileChecksum(rootFolderPath, gradleModel.getBuildFile());
            }
            if (GradleProjects.isGradleProjectModule(module)) {
                buildFileChecksums.addFileChecksum(rootFolderPath, GradleUtil.getGradleBuildFile(module));
                buildFileChecksums.addFileChecksum(rootFolderPath, GradleUtil.getGradleSettingsFile(rootFolderPath));
                buildFileChecksums.addFileChecksum(rootFolderPath, new File(rootFolderPath, "gradle.properties"));
                buildFileChecksums.addFileChecksum(rootFolderPath, new File(rootFolderPath, "local.properties"));
                buildFileChecksums.addFileChecksum(rootFolderPath, GradleUtil.getGradleUserSettingsFile());
            }
            if ((ndkModel = NdkModuleModel.get(module)) == null) continue;
            for (File externalBuildFile : ndkModel.getAndroidProject().getBuildFiles()) {
                buildFileChecksums.addFileChecksum(rootFolderPath, externalBuildFile);
            }
        }
        GradleSyncState syncState = GradleSyncState.getInstance(project);
        buildFileChecksums.myLastGradleSyncTimestamp = syncState.getSummary().getSyncTimestamp();
        return buildFileChecksums;
    }

    @NotNull
    private static File getProjectStateFile(@NotNull Project project) throws IOException {
        if (project == null) {
            ProjectBuildFileChecksums.$$$reportNull$$$0(5);
        }
        File file = new File(GradleUtil.getCacheFolderRootPath(project), "build_file_checksums.ser");
        if (file == null) {
            ProjectBuildFileChecksums.$$$reportNull$$$0(6);
        }
        return file;
    }

    private void addFileChecksum(@NotNull File rootFolderPath, @Nullable VirtualFile file) throws IOException {
        if (rootFolderPath == null) {
            ProjectBuildFileChecksums.$$$reportNull$$$0(7);
        }
        if (file == null) {
            return;
        }
        this.addFileChecksum(rootFolderPath, VfsUtilCore.virtualToIoFile((VirtualFile)file));
    }

    private void addFileChecksum(@NotNull File rootFolderPath, @Nullable File file) throws IOException {
        if (rootFolderPath == null) {
            ProjectBuildFileChecksums.$$$reportNull$$$0(8);
        }
        if (file == null) {
            return;
        }
        String key = FileUtil.isAncestor((File)rootFolderPath, (File)file, (boolean)true) ? FileUtil.getRelativePath((File)rootFolderPath, (File)file) : file.getAbsolutePath();
        this.myFileChecksums.put(key, ProjectBuildFileChecksums.createChecksum(file));
    }

    private void saveTo(@NotNull File file) throws IOException {
        if (file == null) {
            ProjectBuildFileChecksums.$$$reportNull$$$0(9);
        }
        try (FileOutputStream fos = new FileOutputStream(file);
             ObjectOutputStream oos = new ObjectOutputStream(fos);){
            oos.writeObject(this);
        }
    }

    public static void removeFrom(@NotNull Project project) {
        if (project == null) {
            ProjectBuildFileChecksums.$$$reportNull$$$0(10);
        }
        try {
            File stateFile = ProjectBuildFileChecksums.getProjectStateFile(project);
            if (stateFile.isFile()) {
                FileUtil.delete((File)stateFile);
            }
        }
        catch (IOException e) {
            ProjectBuildFileChecksums.getLog().warn(String.format("Failed to remove state for project '%1$s'", project.getName()));
        }
    }

    @NotNull
    private static Logger getLog() {
        Logger logger = Logger.getInstance(ProjectBuildFileChecksums.class);
        if (logger == null) {
            ProjectBuildFileChecksums.$$$reportNull$$$0(11);
        }
        return logger;
    }

    public boolean canUseCachedData() {
        for (Map.Entry<String, byte[]> entry : this.myFileChecksums.entrySet()) {
            File file = new File(entry.getKey());
            if (!file.isAbsolute()) {
                file = new File(this.myRootFolderPath, file.getPath());
            }
            try {
                if (Arrays.equals(entry.getValue(), ProjectBuildFileChecksums.createChecksum(file))) continue;
                return false;
            }
            catch (Throwable e) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    private static byte[] createChecksum(@NotNull File file) throws IOException {
        if (file == null) {
            ProjectBuildFileChecksums.$$$reportNull$$$0(12);
        }
        byte[] data = file.exists() ? Files.toByteArray((File)file) : ArrayUtilRt.EMPTY_BYTE_ARRAY;
        byte[] byArray = Hashing.md5().hashBytes(data).asBytes();
        if (byArray == null) {
            ProjectBuildFileChecksums.$$$reportNull$$$0(13);
        }
        return byArray;
    }

    public long getLastGradleSyncTimestamp() {
        return this.myLastGradleSyncTimestamp;
    }

    @NotNull
    Map<String, byte[]> getFileChecksums() {
        Map<String, byte[]> map2 = this.myFileChecksums;
        if (map2 == null) {
            ProjectBuildFileChecksums.$$$reportNull$$$0(14);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/ProjectBuildFileChecksums";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFolderPath";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/ProjectBuildFileChecksums";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectStateFile";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLog";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createChecksum";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileChecksums";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "needsAndroidSdkSync";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadFromDisk";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveToDisk";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFrom";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getProjectStateFile";
                break;
            }
            case 6: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addFileChecksum";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "saveTo";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeFrom";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createChecksum";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Loader {
        @Nullable
        public ProjectBuildFileChecksums loadFromDisk(@NotNull Project project) {
            if (project == null) {
                Loader.$$$reportNull$$$0(0);
            }
            return ProjectBuildFileChecksums.findFor(project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/project/ProjectBuildFileChecksums$Loader", "loadFromDisk"));
        }
    }
}

