/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project;

import com.android.tools.idea.gradle.parser.GradleSettingsFile;
import com.android.tools.idea.gradle.project.GradleProjectDependencyParser;
import com.android.tools.idea.gradle.project.GradleSiblingLookup;
import com.android.tools.idea.gradle.project.ModuleImporter;
import com.android.tools.idea.gradle.project.ModuleToImport;
import com.android.tools.idea.gradle.project.sync.GradleSyncInvoker;
import com.android.tools.idea.gradle.project.sync.GradleSyncListener;
import com.android.tools.idea.gradle.util.GradleProjects;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GradleModuleImporter
extends ModuleImporter {
    private final Logger LOG;
    @Nullable
    private final Project myProject;
    private final boolean myIsWizard;

    public GradleModuleImporter(@NotNull WizardContext context) {
        if (context == null) {
            GradleModuleImporter.$$$reportNull$$$0(0);
        }
        this(context.getProject(), true);
    }

    public GradleModuleImporter(@NotNull Project project) {
        if (project == null) {
            GradleModuleImporter.$$$reportNull$$$0(1);
        }
        this(project, false);
    }

    private GradleModuleImporter(@Nullable Project project, boolean isWizard) {
        this.LOG = Logger.getInstance(this.getClass());
        this.myIsWizard = isWizard;
        this.myProject = project;
    }

    @Override
    public boolean isStepVisible(@NotNull ModuleWizardStep step) {
        if (step == null) {
            GradleModuleImporter.$$$reportNull$$$0(2);
        }
        return false;
    }

    @Override
    @NotNull
    public List<? extends ModuleWizardStep> createWizardSteps() {
        List list = Collections.emptyList();
        if (list == null) {
            GradleModuleImporter.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public void importProjects(Map<String, VirtualFile> projects) {
        try {
            GradleModuleImporter.importModules(this, projects, this.myProject, null);
        }
        catch (ConfigurationException | IOException e) {
            this.LOG.error(e);
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean canImport(@NotNull VirtualFile importSource) {
        if (importSource == null) {
            GradleModuleImporter.$$$reportNull$$$0(4);
        }
        try {
            return GradleProjects.canImportAsGradleProject(importSource) && (this.myIsWizard || this.findModules(importSource).size() == 1);
        }
        catch (IOException e) {
            this.LOG.error((Throwable)e);
            return false;
        }
    }

    @Override
    @NotNull
    public Set<ModuleToImport> findModules(@NotNull VirtualFile importSource) throws IOException {
        if (importSource == null) {
            GradleModuleImporter.$$$reportNull$$$0(5);
        }
        assert (this.myProject != null);
        Set<ModuleToImport> set = GradleModuleImporter.getRelatedProjects(importSource, this.myProject);
        if (set == null) {
            GradleModuleImporter.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    public static Set<ModuleToImport> getRelatedProjects(@NotNull VirtualFile sourceProject, @NotNull Project destinationProject) {
        VirtualFile settingsGradle;
        if (sourceProject == null) {
            GradleModuleImporter.$$$reportNull$$$0(7);
        }
        if (destinationProject == null) {
            GradleModuleImporter.$$$reportNull$$$0(8);
        }
        if ((settingsGradle = sourceProject.findFileByRelativePath("settings.gradle")) != null) {
            Set<ModuleToImport> set = GradleModuleImporter.buildModulesSet(GradleModuleImporter.getSubProjects(settingsGradle, destinationProject), GradleProjectDependencyParser.newInstance(destinationProject));
            if (set == null) {
                GradleModuleImporter.$$$reportNull$$$0(9);
            }
            return set;
        }
        Set<ModuleToImport> set = GradleModuleImporter.getRequiredProjects(sourceProject, destinationProject);
        if (set == null) {
            GradleModuleImporter.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    private static Set<ModuleToImport> getRequiredProjects(@NotNull VirtualFile sourceProject, @NotNull Project destinationProject) {
        if (sourceProject == null) {
            GradleModuleImporter.$$$reportNull$$$0(11);
        }
        if (destinationProject == null) {
            GradleModuleImporter.$$$reportNull$$$0(12);
        }
        GradleSiblingLookup subProjectLocations = new GradleSiblingLookup(sourceProject, destinationProject);
        Function<VirtualFile, Iterable<String>> parser = GradleProjectDependencyParser.newInstance(destinationProject);
        HashMap modules = Maps.newHashMap();
        LinkedList toAnalyze = Lists.newLinkedList();
        toAnalyze.add(sourceProject);
        while (!toAnalyze.isEmpty()) {
            HashSet dependencies = Sets.newHashSet((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)toAnalyze, parser)));
            Iterable notAnalyzed = Iterables.filter((Iterable)dependencies, (Predicate)Predicates.not((Predicate)Predicates.in(modules.keySet())));
            HashMap dependencyToLocation = Maps.newHashMap();
            for (String dependency : notAnalyzed) {
                dependencyToLocation.put(dependency, subProjectLocations.apply(dependency));
            }
            modules.putAll(dependencyToLocation);
            toAnalyze = FluentIterable.from(dependencyToLocation.values()).filter(Predicates.notNull()).toList();
        }
        modules.put(subProjectLocations.getPrimaryProjectName(), sourceProject);
        Set<ModuleToImport> set = GradleModuleImporter.buildModulesSet(modules, parser);
        if (set == null) {
            GradleModuleImporter.$$$reportNull$$$0(13);
        }
        return set;
    }

    @NotNull
    private static Set<ModuleToImport> buildModulesSet(@NotNull Map<String, VirtualFile> modules, @NotNull Function<VirtualFile, Iterable<String>> parser) {
        if (modules == null) {
            GradleModuleImporter.$$$reportNull$$$0(14);
        }
        if (parser == null) {
            GradleModuleImporter.$$$reportNull$$$0(15);
        }
        HashSet modulesSet = Sets.newHashSetWithExpectedSize((int)modules.size());
        for (Map.Entry<String, VirtualFile> entry : modules.entrySet()) {
            VirtualFile location = entry.getValue();
            Supplier dependencyComputer = location != null ? Suppliers.compose(parser, (Supplier)Suppliers.ofInstance((Object)location)) : Suppliers.ofInstance((Object)ImmutableSet.of());
            modulesSet.add(new ModuleToImport(entry.getKey(), location, (Supplier<? extends Iterable<String>>)dependencyComputer));
        }
        HashSet hashSet = modulesSet;
        if (hashSet == null) {
            GradleModuleImporter.$$$reportNull$$$0(16);
        }
        return hashSet;
    }

    @NotNull
    public static Map<String, VirtualFile> getSubProjects(@NotNull VirtualFile settingsGradle, Project destinationProject) {
        if (settingsGradle == null) {
            GradleModuleImporter.$$$reportNull$$$0(17);
        }
        GradleSettingsFile settingsFile = new GradleSettingsFile(settingsGradle, destinationProject);
        Map<String, File> allProjects = settingsFile.getModulesWithLocation();
        Map map2 = Maps.transformValues(allProjects, (Function)new ResolvePath(VfsUtilCore.virtualToIoFile((VirtualFile)settingsGradle.getParent())));
        if (map2 == null) {
            GradleModuleImporter.$$$reportNull$$$0(18);
        }
        return map2;
    }

    @VisibleForTesting
    static void importModules(final @NotNull Object requestor, final @NotNull Map<String, VirtualFile> modules, final @Nullable Project project, final @Nullable GradleSyncListener listener2) throws IOException, ConfigurationException {
        String error;
        if (requestor == null) {
            GradleModuleImporter.$$$reportNull$$$0(19);
        }
        if (modules == null) {
            GradleModuleImporter.$$$reportNull$$$0(20);
        }
        if ((error = GradleModuleImporter.validateProjectsForImport(modules)) != null) {
            if (listener2 != null && project != null) {
                listener2.syncFailed(project, error);
                return;
            }
            throw new IOException(error);
        }
        assert (project != null);
        Throwable throwable = new WriteCommandAction.Simple(project, new PsiFile[0]){

            protected void run() throws Throwable {
                GradleModuleImporter.copyAndRegisterModule(requestor, modules, project, listener2);
            }

            public boolean isSilentExecution() {
                return true;
            }
        }.execute().getThrowable();
        GradleModuleImporter.rethrowAsProperlyTypedException(throwable);
    }

    @Nullable
    private static String validateProjectsForImport(@NotNull Map<String, VirtualFile> modules) {
        if (modules == null) {
            GradleModuleImporter.$$$reportNull$$$0(21);
        }
        TreeSet<String> projects = new TreeSet<String>();
        for (Map.Entry<String, VirtualFile> mapping : modules.entrySet()) {
            if (mapping.getValue() != null) continue;
            projects.add(mapping.getKey());
        }
        if (projects.isEmpty()) {
            return null;
        }
        if (projects.size() == 1) {
            return String.format("Sources for module '%1$s' were not found", Iterables.getFirst(projects, null));
        }
        String projectsList = Joiner.on((String)"', '").join(projects);
        return String.format("Sources were not found for modules '%1$s'", projectsList);
    }

    private static void rethrowAsProperlyTypedException(Throwable throwable) throws IOException, ConfigurationException {
        if (throwable != null) {
            Throwables.propagateIfPossible((Throwable)throwable, IOException.class, ConfigurationException.class);
            throw new IllegalStateException(throwable);
        }
    }

    private static void copyAndRegisterModule(@NotNull Object requestor, @NotNull Map<String, VirtualFile> modules, @NotNull Project project, @Nullable GradleSyncListener listener2) throws IOException {
        VirtualFile projectRoot;
        if (requestor == null) {
            GradleModuleImporter.$$$reportNull$$$0(22);
        }
        if (modules == null) {
            GradleModuleImporter.$$$reportNull$$$0(23);
        }
        if (project == null) {
            GradleModuleImporter.$$$reportNull$$$0(24);
        }
        if ((projectRoot = project.getBaseDir()).findChild("settings.gradle") == null) {
            projectRoot.createChildData(requestor, "settings.gradle");
        }
        for (Map.Entry<String, VirtualFile> module : modules.entrySet()) {
            String name = module.getKey();
            File targetFile = GradleUtil.getModuleDefaultPath(projectRoot, name);
            VirtualFile moduleSource = module.getValue();
            if (moduleSource != null) {
                if (!VfsUtilCore.isAncestor((VirtualFile)projectRoot, (VirtualFile)moduleSource, (boolean)true)) {
                    VirtualFile target = VfsUtil.createDirectoryIfMissing((String)targetFile.getAbsolutePath());
                    if (target == null) {
                        throw new IOException(String.format("Unable to create directory %1$s", targetFile));
                    }
                    if (target.exists()) {
                        target.delete(requestor);
                    }
                    moduleSource.copy(requestor, target.getParent(), target.getName());
                } else {
                    targetFile = VfsUtilCore.virtualToIoFile((VirtualFile)moduleSource);
                }
            }
            GradleSettingsFile gradleSettingsFile = GradleSettingsFile.get(project);
            assert (gradleSettingsFile != null) : "File should have been created";
            gradleSettingsFile.addModule(name, targetFile);
        }
        GradleSyncInvoker.Request request = GradleSyncInvoker.Request.projectModified();
        request.generateSourcesOnSuccess = false;
        GradleSyncInvoker.getInstance().requestProjectSync(project, request, listener2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/project/GradleModuleImporter";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSource";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceProject";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationProject";
                break;
            }
            case 14: 
            case 20: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsGradle";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/project/GradleModuleImporter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createWizardSteps";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findModules";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedProjects";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredProjects";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "buildModulesSet";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubProjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isStepVisible";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 18: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canImport";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findModules";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedProjects";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredProjects";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "buildModulesSet";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSubProjects";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "importModules";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "validateProjectsForImport";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "copyAndRegisterModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ResolvePath
    implements Function<File, VirtualFile> {
        private final File mySourceDir;

        ResolvePath(File sourceDir) {
            this.mySourceDir = sourceDir;
        }

        public VirtualFile apply(File path) {
            if (!path.isAbsolute()) {
                path = new File(this.mySourceDir, path.getPath());
            }
            return VfsUtil.findFileByIoFile((File)path, (boolean)true);
        }
    }
}

