/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.editor.ui;

import com.android.tools.idea.gradle.editor.entity.AbstractSimpleGradleEditorEntity;
import com.android.tools.idea.gradle.editor.metadata.StdGradleEditorEntityMetaData;
import com.android.tools.idea.gradle.editor.ui.GradleEditorComboBox;
import com.android.tools.idea.gradle.editor.ui.GradleEditorEntityUi;
import com.android.tools.idea.gradle.editor.ui.GradleEditorUiConstants;
import com.android.tools.idea.gradle.editor.ui.ReferencedValuesGradleEditorComponent;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=100)
public class SimpleGradleEntityUi
implements GradleEditorEntityUi<AbstractSimpleGradleEditorEntity> {
    private final MyComponent myRenderer = new MyComponent();
    private final MyComponent myEditor = new MyComponent();
    private final MyComponent mySizeComponent = new MyComponent();

    @Override
    @NotNull
    public Class<AbstractSimpleGradleEditorEntity> getTargetEntityClass() {
        if (AbstractSimpleGradleEditorEntity.class == null) {
            SimpleGradleEntityUi.$$$reportNull$$$0(0);
        }
        return AbstractSimpleGradleEditorEntity.class;
    }

    @Override
    @NotNull
    public JComponent getComponent(@Nullable JComponent component, @NotNull JTable table2, @NotNull AbstractSimpleGradleEditorEntity entity, @NotNull Project project, boolean editing, boolean isSelected, boolean hasFocus, boolean sizeOnly, int row, int column) {
        MyComponent c;
        if (table2 == null) {
            SimpleGradleEntityUi.$$$reportNull$$$0(1);
        }
        if (entity == null) {
            SimpleGradleEntityUi.$$$reportNull$$$0(2);
        }
        if (project == null) {
            SimpleGradleEntityUi.$$$reportNull$$$0(3);
        }
        if (component != null) {
            JComponent jComponent = component;
            if (jComponent == null) {
                SimpleGradleEntityUi.$$$reportNull$$$0(4);
            }
            return jComponent;
        }
        if (sizeOnly) {
            c = this.mySizeComponent;
            c.editorSimpleValue.setSize(new Dimension(table2.getSize().width, table2.getRowHeight(row)));
        } else {
            c = editing ? this.myEditor : this.myRenderer;
        }
        c.bind(entity, project, table2, editing);
        c.getPreferredSize();
        MyComponent myComponent = c;
        if (myComponent == null) {
            SimpleGradleEntityUi.$$$reportNull$$$0(5);
        }
        return myComponent;
    }

    @Override
    @Nullable
    public String flush(@NotNull AbstractSimpleGradleEditorEntity entity) {
        if (entity == null) {
            SimpleGradleEntityUi.$$$reportNull$$$0(6);
        }
        if (!this.myEditor.editorSimpleValue.isVisible()) {
            return null;
        }
        Object selected = this.myEditor.editorSimpleValue.getEditor().getItem();
        if (selected != null) {
            return entity.changeValue(selected.toString());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/editor/ui/SimpleGradleEntityUi";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetEntityClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/editor/ui/SimpleGradleEntityUi";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "flush";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyComponent
    extends JBPanel {
        private final JBLabel myName = new JBLabel();
        private final JBLabel mySimpleValue = new JBLabel();
        private final ReferencedValuesGradleEditorComponent myRefValue = new ReferencedValuesGradleEditorComponent();
        private final DefaultComboBoxModel myEditorSimpleValueModel = new DefaultComboBoxModel();
        final GradleEditorComboBox editorSimpleValue = new GradleEditorComboBox(this.myEditorSimpleValueModel);
        @Nullable
        private WeakReference<JTable> myTableRef;

        MyComponent() {
            super((LayoutManager)new GridBagLayout());
            GridBag constraints = new GridBag().anchor(17);
            this.add((Component)this.myName, constraints);
            this.add((Component)((Object)this.editorSimpleValue), constraints);
            this.add((Component)this.mySimpleValue, constraints.insets(0, 8, 0, 0));
            this.add((Component)((Object)this.myRefValue), constraints);
            this.setBackground(GradleEditorUiConstants.BACKGROUND_COLOR);
            this.editorSimpleValue.setBackground(GradleEditorUiConstants.BACKGROUND_COLOR);
            this.editorSimpleValue.setEditable(true);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Component editorComponent;
                    if (myTableRef == null) {
                        return;
                    }
                    JTable table2 = (JTable)myTableRef.get();
                    if (table2 == null) {
                        return;
                    }
                    Component c = SwingUtilities.getDeepestComponentAt((Component)((Object)this), e.getX(), e.getY());
                    if ((c == null || c != myRefValue && c != editorSimpleValue) && (editorComponent = table2.getEditorComponent()) != null && UIUtil.isAncestor((Component)editorComponent, (Component)((Object)this))) {
                        table2.getCellEditor().stopCellEditing();
                    }
                }
            });
        }

        public void bind(@NotNull AbstractSimpleGradleEditorEntity entity, @NotNull Project project, @NotNull JTable table2, boolean editing) {
            if (entity == null) {
                MyComponent.$$$reportNull$$$0(0);
            }
            if (project == null) {
                MyComponent.$$$reportNull$$$0(1);
            }
            if (table2 == null) {
                MyComponent.$$$reportNull$$$0(2);
            }
            this.myTableRef = new WeakReference<JTable>(table2);
            this.myName.setText(entity.getName() + ":");
            String currentValue = entity.getCurrentValue();
            this.mySimpleValue.setText(currentValue);
            this.myRefValue.bind(project, entity.getDefinitionValueSourceBindings());
            boolean simpleValue = !currentValue.isEmpty() && (entity.getDefinitionValueSourceBindings().size() == 1 || entity.getMetaData().contains(StdGradleEditorEntityMetaData.READ_ONLY));
            this.mySimpleValue.setVisible(!editing && simpleValue);
            this.editorSimpleValue.setVisible(editing && simpleValue);
            this.editorSimpleValue.setTable(table2);
            this.myRefValue.setVisible(!simpleValue);
            if (editing && simpleValue) {
                this.myEditorSimpleValueModel.removeAllElements();
                List<String> versions = entity.getValueManager().hintAvailableVersions();
                if (versions == null) {
                    this.myEditorSimpleValueModel.addElement(currentValue);
                } else {
                    boolean currentValueIsInAvailableList = versions.contains(currentValue);
                    if (!currentValueIsInAvailableList) {
                        this.myEditorSimpleValueModel.addElement(currentValue);
                    }
                    for (String version2 : versions) {
                        this.myEditorSimpleValueModel.addElement(version2);
                    }
                }
            }
            this.editorSimpleValue.setSelectedItem(currentValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "entity";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "table";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/gradle/editor/ui/SimpleGradleEntityUi$MyComponent";
            objectArray[2] = "bind";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

