/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.eclipse;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.repository.Revision;
import com.android.tools.idea.gradle.eclipse.GradleImport;
import com.android.tools.idea.gradle.eclipse.ImportModule;
import com.android.utils.SdkUtils;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ImportSummary {
    static final String MSG_HEADER = "ECLIPSE ANDROID PROJECT IMPORT SUMMARY\n======================================\n";
    static final String MSG_MANIFEST = "\nManifest Merging:\n-----------------\nYour project uses libraries that provide manifests, and your Eclipse\nproject did not explicitly turn on manifest merging. In Android Gradle\nprojects, manifests are always merged (meaning that contents from your\nlibraries' manifests will be merged into the app manifest. If you had\nmanually copied contents from library manifests into your app manifest\nyou may need to remove these for the app to build correctly.\n";
    static final String MSG_UNHANDLED = "\nIgnored Files:\n--------------\nThe following files were *not* copied into the new Gradle project; you\nshould evaluate whether these are still needed in your project and if\nso manually move them:\n\n";
    static final String MSG_REPLACED_JARS = "\nReplaced Jars with Dependencies:\n--------------------------------\nThe importer recognized the following .jar files as third party\nlibraries and replaced them with Gradle dependencies instead. This has\nthe advantage that more explicit version information is known, and the\nlibraries can be updated automatically. However, it is possible that\nthe .jar file in your project was of an older version than the\ndependency we picked, which could render the project not compileable.\nYou can disable the jar replacement in the import wizard and try again:\n\n";
    static final String MSG_REPLACED_LIBS = "\nReplaced Libraries with Dependencies:\n-------------------------------------\nThe importer recognized the following library projects as third party\nlibraries and replaced them with Gradle dependencies instead. This has\nthe advantage that more explicit version information is known, and the\nlibraries can be updated automatically. However, it is possible that\nthe source files in your project were of an older version than the\ndependency we picked, which could render the project not compileable.\nYou can disable the library replacement in the import wizard and try\nagain:\n\n";
    static final String MSG_FOOTER = "\nNext Steps:\n-----------\nYou can now build the project. The Gradle project needs network\nconnectivity to download dependencies.\n\nBugs:\n-----\nIf for some reason your project does not build, and you determine that\nit is due to a bug or limitation of the Eclipse to Gradle importer,\nplease file a bug at http://b.android.com with category\nComponent-Tools.\n\n(This import summary is for your information only, and can be deleted\nafter import once you are satisfied with the results.)\n";
    static final String MSG_FOLDER_STRUCTURE = "\nMoved Files:\n------------\nAndroid Gradle projects use a different directory structure than ADT\nEclipse projects. Here's how the projects were restructured:\n\n";
    static final String MSG_MISSING_REPO_1 = "\nMissing Android Support Repository:\n-----------------------------------\nSome useful libraries, such as the Android Support Library, are\ninstalled from a special Maven repository, which should be installed\nvia the SDK manager.\n\nIt looks like this library is missing from your SDK installation at:\n";
    static final String MSG_MISSING_REPO_2 = "\nTo install it, open the SDK manager, and in the Extras category,\nselect \"Android Support Repository\". You may also want to install the\n\"Google Repository\" if you want to use libraries like Google Play\nServices.\n";
    static final String MSG_MISSING_GOOGLE_REPOSITORY_1 = "\nMissing Google Repository:\n--------------------------\nThe Google Play Services library is installed from a special Maven\nRepository, which should be installed via the SDK manager.\n\nIt looks like this library is missing from your SDK installation at:\n";
    static final String MSG_MISSING_GOOGLE_REPOSITORY_2 = "\nTo install it, open the SDK manager, and in the Extras category,\nselect \"Google Repository\".\n";
    static final String MSG_BUILD_TOOLS_VERSION = "\nOld Build Tools:\n----------------\nThe version of the build tools installed with your SDK is old. It\nshould be at least version 19.0.1 to work well with the Gradle build\nsystem. To update it, open the Android SDK Manager, and install the\nhighest available version of Tools > Android SDK Build-tools.\n";
    static final String MSG_GUESSED_VERSIONS = "\nPotentially Missing Dependency:\n-------------------------------\nWhen we replaced the following .jar files with a Gradle dependency, we\ninferred the dependency version number from the filename. This\nspecific version may not actually be available from the repository.\nIf you get a build error stating that the dependency is missing, edit\nthe version number to for example \"+\" to pick up the latest version\ninstead. (This may require you to update your code if the library APIs\nhave changed.)\n\n";
    static final String MSG_USER_HOME_PROGUARD = "\nIgnored Per-User ProGuard Configuration File:\n---------------------------------------------\nThe ProGuard configuration in the imported project pointed to a\nProGuard rule file in the current user's home directory. This is not\nsupported from the Android Gradle build system (which emphasizes\nrepeatable builds). If you want to share ProGuard rules between\nprojects, use relative paths (from the project location) instead.\n";
    static final String MSG_RISKY_PROJECT_LOCATION = "\nRisky Project Location:\n-----------------------\nThe tools *should* handle project locations in any directory. However,\ndue to bugs, placing projects in directories containing spaces in the\npath, or characters like \", ' and &, have had issues. We're working to\neliminate these bugs, but to save yourself headaches you may want to\nmove your project to a location where this is not a problem.\n";
    private final GradleImport myImporter;
    private File myDestDir;
    private boolean myManifestsMayDiffer;
    private Map<String, List<String>> myNotMigrated = Maps.newHashMap();
    private Map<ImportModule, Map<File, File>> myMoved = Maps.newHashMap();
    private Map<File, GradleCoordinate> myJarDependencies = Maps.newHashMap();
    private Map<String, List<GradleCoordinate>> myLibDependencies = Maps.newHashMap();
    private List<String> myGuessedDependencyVersions = Lists.newArrayList();
    private File myLastGuessedJar;
    private List<String> myIgnoredUserHomeProGuardFiles = Lists.newArrayList();
    private boolean myHasRiskyPathChars;
    private boolean myWrapErrorMessages = true;

    ImportSummary(GradleImport importer) {
        this.myImporter = importer;
    }

    private static boolean isRiskyPathChar(char c) {
        return c == ' ' || c == '\'' || c == '\"' || c == '&';
    }

    public void write(File file) throws IOException {
        String summary = this.createSummary();
        assert (file.getParentFile().exists());
        Files.write((CharSequence)summary, (File)file, (Charset)Charsets.UTF_8);
    }

    public void setDestDir(File destDir) {
        this.myDestDir = destDir;
        this.myHasRiskyPathChars = false;
        String path = destDir.getPath();
        int n = path.length();
        for (int i2 = 0; i2 < n; ++i2) {
            char c = path.charAt(i2);
            if (!ImportSummary.isRiskyPathChar(c)) continue;
            this.myHasRiskyPathChars = true;
        }
    }

    void setWrapErrorMessages(boolean wrap) {
        this.myWrapErrorMessages = wrap;
    }

    public void reportManifestsMayDiffer() {
        this.myManifestsMayDiffer = true;
    }

    public void reportReplacedJar(File jar, GradleCoordinate dependency) {
        this.myJarDependencies.put(jar, dependency);
        if (jar.equals(this.myLastGuessedJar)) {
            boolean replaced = this.myGuessedDependencyVersions.remove(jar.getName());
            if (replaced) {
                this.myGuessedDependencyVersions.add(jar.getName() + " => version " + dependency.getRevision() + " in " + dependency.toString());
            }
            this.myLastGuessedJar = null;
        }
    }

    public void reportReplacedLib(String module, List<GradleCoordinate> dependencies) {
        this.myLibDependencies.put(module, dependencies);
    }

    public void reportGuessedVersion(File jar) {
        this.myGuessedDependencyVersions.add(jar.getName());
        this.myLastGuessedJar = jar;
    }

    public void reportIgnoredUserHomeProGuardFile(String relativePath) {
        this.myIgnoredUserHomeProGuardFiles.add(relativePath);
    }

    public void reportMoved(ImportModule module, File from, File to) {
        Map<File, File> map2 = this.myMoved.get(module);
        if (map2 == null) {
            map2 = new LinkedHashMap<File, File>();
            this.myMoved.put(module, map2);
        }
        map2.put(from, to);
    }

    public void reportIgnored(String module, String path) {
        ArrayList list = this.myNotMigrated.get(module);
        if (list == null) {
            list = Lists.newArrayList();
            this.myNotMigrated.put(module, list);
        }
        list.add(path);
    }

    public String createSummary() {
        ArrayList modules;
        StringBuilder sb = new StringBuilder(2000);
        sb.append(MSG_HEADER);
        ArrayList problems = Lists.newArrayList();
        problems.addAll(this.myImporter.getErrors());
        problems.addAll(this.myImporter.getWarnings());
        if (!problems.isEmpty()) {
            sb.append("\n");
            for (String warning : problems) {
                sb.append(" * ");
                if (this.myWrapErrorMessages) {
                    sb.append(SdkUtils.wrap((String)warning, (int)80, (String)"   "));
                } else {
                    sb.append(warning);
                }
                sb.append("\n");
            }
        }
        if (this.myHasRiskyPathChars) {
            sb.append(MSG_RISKY_PROJECT_LOCATION);
            String path = this.myDestDir.getPath();
            sb.append(path).append("\n");
            int n = path.length();
            for (int i2 = 0; i2 < n; ++i2) {
                char c = path.charAt(i2);
                sb.append(ImportSummary.isRiskyPathChar(c) ? (char)'-' : ' ');
            }
            sb.append("\n");
        }
        if (this.myManifestsMayDiffer) {
            sb.append(MSG_MANIFEST);
        }
        if (!this.myNotMigrated.isEmpty()) {
            sb.append(MSG_UNHANDLED);
            modules = Lists.newArrayList(this.myNotMigrated.keySet());
            Collections.sort(modules);
            for (String module : modules) {
                if (modules.size() > 1) {
                    sb.append("From ").append(module).append(":\n");
                }
                ArrayList sorted = new ArrayList(this.myNotMigrated.get(module));
                Collections.sort(sorted);
                for (String path : sorted) {
                    sb.append("* ").append(path).append("\n");
                }
            }
        }
        if (!this.myJarDependencies.isEmpty()) {
            sb.append(MSG_REPLACED_JARS);
            ArrayList files2 = Lists.newArrayList(this.myJarDependencies.keySet());
            Collections.sort(files2);
            Iterator i2 = files2.iterator();
            while (i2.hasNext()) {
                File file = (File)i2.next();
                String jar = file.getName();
                GradleCoordinate dependency = this.myJarDependencies.get(file);
                sb.append(jar).append(" => ").append(dependency).append("\n");
            }
        }
        if (!this.myGuessedDependencyVersions.isEmpty()) {
            sb.append(MSG_GUESSED_VERSIONS);
            Collections.sort(this.myGuessedDependencyVersions);
            for (String replaced : this.myGuessedDependencyVersions) {
                sb.append(replaced).append("\n");
            }
        }
        if (!this.myLibDependencies.isEmpty()) {
            sb.append(MSG_REPLACED_LIBS);
            modules = Lists.newArrayList(this.myLibDependencies.keySet());
            Collections.sort(modules);
            for (String module : modules) {
                List<GradleCoordinate> dependencies = this.myLibDependencies.get(module);
                if (dependencies.size() == 1) {
                    sb.append(module).append(" => ").append(dependencies).append("\n");
                    continue;
                }
                sb.append(module).append(" =>\n");
                for (GradleCoordinate dependency : dependencies) {
                    sb.append("    ").append(dependency).append("\n");
                }
            }
        }
        if (!this.myMoved.isEmpty()) {
            sb.append(MSG_FOLDER_STRUCTURE);
            modules = Lists.newArrayList(this.myMoved.keySet());
            Collections.sort(modules);
            for (ImportModule module : modules) {
                if (modules.size() > 1) {
                    sb.append("In ").append(module.getOriginalName()).append(":\n");
                }
                Map<File, File> map2 = this.myMoved.get(module);
                ArrayList<File> sorted = new ArrayList<File>(map2.keySet());
                Collections.sort(sorted);
                for (File from : sorted) {
                    sb.append("* ");
                    File to = map2.get(from);
                    assert (to != null) : from;
                    File fromRelative = null;
                    File toRelative = null;
                    try {
                        fromRelative = module.computeProjectRelativePath(from);
                        if (this.myDestDir != null) {
                            toRelative = GradleImport.computeRelativePath(this.myDestDir.getCanonicalFile(), to);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (fromRelative == null) {
                        fromRelative = from;
                    }
                    if (toRelative == null) {
                        toRelative = to;
                    }
                    sb.append(fromRelative.getPath());
                    if (from.isDirectory()) {
                        sb.append(File.separator);
                    }
                    sb.append(" => ");
                    sb.append(toRelative.getPath());
                    if (to.isDirectory()) {
                        sb.append(File.separator);
                    }
                    sb.append("\n");
                }
            }
        }
        if (this.myImporter.needSupportRepository() && this.myImporter.isMissingSupportRepository()) {
            sb.append(MSG_MISSING_REPO_1);
            sb.append(this.myImporter.getSdkLocation()).append("\n");
            sb.append(MSG_MISSING_REPO_2);
        }
        if (this.myImporter.needGoogleRepository() && this.myImporter.isMissingGoogleRepository()) {
            sb.append(MSG_MISSING_GOOGLE_REPOSITORY_1);
            sb.append(this.myImporter.getSdkLocation()).append("\n");
            sb.append(MSG_MISSING_GOOGLE_REPOSITORY_2);
        }
        if (Revision.parseRevision((String)this.myImporter.getBuildToolsVersion()).getMajor() < 19) {
            sb.append(MSG_BUILD_TOOLS_VERSION);
        }
        if (!this.myIgnoredUserHomeProGuardFiles.isEmpty()) {
            sb.append(MSG_USER_HOME_PROGUARD);
            Collections.sort(this.myIgnoredUserHomeProGuardFiles);
            for (String path : this.myIgnoredUserHomeProGuardFiles) {
                sb.append(path).append("\n");
            }
        }
        sb.append(MSG_FOOTER);
        return sb.toString().replace("\n", GradleImport.NL);
    }
}

