/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.groovy;

import com.android.tools.idea.gradle.dsl.api.ext.RawText;
import com.android.tools.idea.gradle.dsl.parser.GradleReferenceInjection;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslClosure;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSettableExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslSimpleExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public final class GroovyDslUtil {
    @Nullable
    static GroovyPsiElement ensureGroovyPsi(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof GroovyPsiElement) {
            return (GroovyPsiElement)element;
        }
        throw new IllegalArgumentException("Wrong PsiElement type for writer! Must be of type GoovyPsiElement");
    }

    static void addConfigBlock(@NotNull GradleDslSettableExpression expression) {
        PsiElement unsavedConfigBlock;
        if (expression == null) {
            GroovyDslUtil.$$$reportNull$$$0(0);
        }
        if ((unsavedConfigBlock = expression.getUnsavedConfigBlock()) == null) {
            return;
        }
        GroovyPsiElement psiElement = GroovyDslUtil.ensureGroovyPsi(expression.getPsiElement());
        if (psiElement == null) {
            return;
        }
        GroovyPsiElementFactory factory = GroovyDslUtil.getPsiElementFactory(expression);
        if (factory == null) {
            return;
        }
        GrApplicationStatement methodCallStatement = (GrApplicationStatement)factory.createStatementFromText((CharSequence)"foo 1, 2");
        PsiElement comma = methodCallStatement.getArgumentList().getFirstChild().getNextSibling();
        psiElement.addAfter(comma, psiElement.getLastChild());
        psiElement.addAfter(factory.createWhiteSpace(), psiElement.getLastChild());
        psiElement.addAfter(unsavedConfigBlock, psiElement.getLastChild());
        expression.setUnsavedConfigBlock(null);
    }

    @Nullable
    static GrClosableBlock getClosableBlock(@NotNull PsiElement element) {
        if (element == null) {
            GroovyDslUtil.$$$reportNull$$$0(1);
        }
        if (!(element instanceof GrMethodCallExpression)) {
            return null;
        }
        GrClosableBlock[] closureArguments = ((GrMethodCallExpression)element).getClosureArguments();
        if (closureArguments.length > 0) {
            return closureArguments[0];
        }
        return null;
    }

    static GroovyPsiElementFactory getPsiElementFactory(@NotNull GradleDslElement element) {
        GroovyPsiElement psiElement;
        if (element == null) {
            GroovyDslUtil.$$$reportNull$$$0(2);
        }
        if ((psiElement = GroovyDslUtil.ensureGroovyPsi(element.getPsiElement())) == null) {
            return null;
        }
        Project project = psiElement.getProject();
        return GroovyPsiElementFactory.getInstance((Project)project);
    }

    static boolean isNewEmptyBlockElement(@NotNull GradleDslElement element) {
        if (element == null) {
            GroovyDslUtil.$$$reportNull$$$0(3);
        }
        if (element.getPsiElement() != null) {
            return false;
        }
        if (!element.isBlockElement() || !element.isInsignificantIfEmpty()) {
            return false;
        }
        Collection<GradleDslElement> children = element.getChildren();
        if (children.isEmpty()) {
            return true;
        }
        for (GradleDslElement child : children) {
            if (GroovyDslUtil.isNewEmptyBlockElement(child)) continue;
            return false;
        }
        return true;
    }

    static void maybeDeleteIfEmpty(@Nullable PsiElement element, @NotNull GradleDslElement dslElement) {
        GradleDslElement parentDslElement;
        if (dslElement == null) {
            GroovyDslUtil.$$$reportNull$$$0(4);
        }
        if ((parentDslElement = dslElement.getParent()) instanceof GradleDslExpressionList && !((GradleDslExpressionList)parentDslElement).shouldBeDeleted() || parentDslElement instanceof GradleDslExpressionMap && !((GradleDslExpressionMap)parentDslElement).shouldBeDeleted() && parentDslElement.getPsiElement() == element) {
            return;
        }
        GroovyDslUtil.deleteIfEmpty(element, dslElement);
    }

    private static void deleteIfEmpty(@Nullable PsiElement element, @NotNull GradleDslElement containingDslElement) {
        if (containingDslElement == null) {
            GroovyDslUtil.$$$reportNull$$$0(5);
        }
        if (element == null) {
            return;
        }
        PsiElement parent = element.getParent();
        GradleDslElement dslParent = GroovyDslUtil.getNextValidParent(containingDslElement);
        if (element.isValid()) {
            if (element instanceof GrAssignmentExpression) {
                if (((GrAssignmentExpression)element).getRValue() == null) {
                    element.delete();
                }
            } else if (element instanceof GrApplicationStatement) {
                if (((GrApplicationStatement)element).getArgumentList() == null) {
                    element.delete();
                }
            } else if (element instanceof GrClosableBlock) {
                if (dslParent == null || dslParent.isInsignificantIfEmpty()) {
                    final Boolean[] isEmpty = new Boolean[]{true};
                    ((GrClosableBlock)element).acceptChildren(new GroovyElementVisitor(){

                        public void visitElement(@NotNull GroovyPsiElement child) {
                            if (child == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (child instanceof GrParameterList && ((GrParameterList)child).getParameters().length == 0) {
                                return;
                            }
                            isEmpty[0] = false;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/android/tools/idea/gradle/dsl/parser/groovy/GroovyDslUtil$1", "visitElement"));
                        }
                    });
                    if (isEmpty[0].booleanValue()) {
                        element.delete();
                    }
                }
            } else if (element instanceof GrMethodCallExpression) {
                GrMethodCallExpression call = (GrMethodCallExpression)element;
                GrArgumentList argumentList = null;
                try {
                    for (PsiElement curr = call.getFirstChild(); curr != null; curr = curr.getNextSibling()) {
                        if (!(curr instanceof GrArgumentList)) continue;
                        argumentList = (GrArgumentList)curr;
                        break;
                    }
                }
                catch (AssertionError e) {
                    argumentList = null;
                }
                GrClosableBlock[] closureArguments = call.getClosureArguments();
                if ((argumentList == null || argumentList.getAllArguments().length == 0) && closureArguments.length == 0) {
                    element.delete();
                }
            } else if (element instanceof GrCommandArgumentList) {
                GrCommandArgumentList commandArgumentList = (GrCommandArgumentList)element;
                if (commandArgumentList.getAllArguments().length == 0) {
                    commandArgumentList.delete();
                }
            } else if (element instanceof GrNamedArgument) {
                GrNamedArgument namedArgument = (GrNamedArgument)element;
                if (namedArgument.getExpression() == null) {
                    namedArgument.delete();
                }
            } else if (element instanceof GrVariableDeclaration) {
                GrVariableDeclaration variableDeclaration = (GrVariableDeclaration)element;
                for (GrVariable grVariable : variableDeclaration.getVariables()) {
                    if (grVariable.getInitializerGroovy() != null) continue;
                    grVariable.delete();
                }
                if (variableDeclaration.getVariables().length == 0) {
                    variableDeclaration.delete();
                }
            } else if (element instanceof GrVariable) {
                GrVariable variable = (GrVariable)element;
                if (variable.getInitializerGroovy() == null) {
                    variable.delete();
                }
            } else if (element instanceof GrListOrMap) {
                GrListOrMap listOrMap = (GrListOrMap)element;
                if (listOrMap.isMap() && listOrMap.getNamedArguments().length == 0) {
                    listOrMap.delete();
                } else if (!listOrMap.isMap() && listOrMap.getInitializers().length == 0) {
                    listOrMap.delete();
                }
            }
        }
        if (!element.isValid()) {
            GroovyDslUtil.handleElementRemoved(parent, element);
            if (dslParent != null && dslParent.isInsignificantIfEmpty()) {
                GroovyDslUtil.maybeDeleteIfEmpty(parent, element == dslParent.getPsiElement() ? dslParent : containingDslElement);
            }
        }
    }

    @Nullable
    static GradleDslElement getNextValidParent(@NotNull GradleDslElement element) {
        if (element == null) {
            GroovyDslUtil.$$$reportNull$$$0(6);
        }
        PsiElement psi = element.getPsiElement();
        while (!(element == null || psi != null && psi.isValid())) {
            if ((element = element.getParent()) == null) continue;
            psi = element.getPsiElement();
        }
        return element;
    }

    static void removePsiIfInvalid(@Nullable GradleDslElement element) {
        if (element == null) {
            return;
        }
        if (element.getPsiElement() != null && !element.getPsiElement().isValid()) {
            element.setPsiElement(null);
        }
        if (element.getParent() != null) {
            GroovyDslUtil.removePsiIfInvalid(element.getParent());
        }
    }

    static void handleElementRemoved(@Nullable PsiElement psiElement, @Nullable PsiElement removed) {
        if (psiElement == null) {
            return;
        }
        if (psiElement instanceof GrListOrMap) {
            GrListOrMap listOrMap = (GrListOrMap)psiElement;
            if (removed instanceof GrNamedArgument && listOrMap.isEmpty()) {
                ASTNode node = listOrMap.getNode();
                node.addLeaf(GroovyTokenTypes.mCOLON, (CharSequence)":", listOrMap.getRBrack().getNode());
            }
        }
    }

    @Nullable
    static GrExpression extractUnsavedExpression(@NotNull GradleDslSettableExpression literal) {
        GroovyPsiElement newElement;
        if (literal == null) {
            GroovyDslUtil.$$$reportNull$$$0(7);
        }
        if (!((newElement = GroovyDslUtil.ensureGroovyPsi(literal.getUnsavedValue())) instanceof GrExpression)) {
            return null;
        }
        return (GrExpression)newElement;
    }

    private static String escapeString(@NotNull String str, boolean forGString) {
        if (str == null) {
            GroovyDslUtil.$$$reportNull$$$0(8);
        }
        StringBuilder sb = new StringBuilder();
        GrStringUtil.escapeStringCharacters((int)str.length(), (CharSequence)str, (String)(forGString ? "\"" : "'"), (boolean)true, (boolean)true, (StringBuilder)sb);
        return sb.toString();
    }

    @Nullable
    static PsiElement createLiteral(@NotNull GradleDslElement context, @NotNull Object unsavedValue) throws IncorrectOperationException {
        if (context == null) {
            GroovyDslUtil.$$$reportNull$$$0(9);
        }
        if (unsavedValue == null) {
            GroovyDslUtil.$$$reportNull$$$0(10);
        }
        String unsavedValueText = null;
        if (unsavedValue instanceof String) {
            String stringValue = (String)unsavedValue;
            if (StringUtil.isQuotedString((String)stringValue)) {
                String unquotedString = GrStringUtil.removeQuotes((String)stringValue);
                unsavedValueText = GrStringUtil.addQuotes((String)GroovyDslUtil.escapeString(unquotedString, true), (boolean)true);
            } else {
                unsavedValueText = GrStringUtil.addQuotes((String)GroovyDslUtil.escapeString((String)unsavedValue, false), (boolean)false);
            }
        } else if (unsavedValue instanceof Integer || unsavedValue instanceof Boolean) {
            unsavedValueText = unsavedValue.toString();
        } else if (unsavedValue instanceof RawText) {
            unsavedValueText = ((RawText)unsavedValue).getText();
        }
        if (unsavedValueText == null) {
            return null;
        }
        GroovyPsiElementFactory factory = GroovyDslUtil.getPsiElementFactory(context);
        if (factory == null) {
            return null;
        }
        return factory.createExpressionFromText((CharSequence)unsavedValueText);
    }

    static PsiElement createDerivedMap(@NotNull GradleDslExpressionMap expressionMap) {
        PsiElement parentPsiElement;
        if (expressionMap == null) {
            GroovyDslUtil.$$$reportNull$$$0(11);
        }
        if ((parentPsiElement = GroovyDslUtil.getParentPsi(expressionMap)) == null) {
            return null;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)parentPsiElement.getProject());
        GrExpression emptyMap = factory.createExpressionFromText((CharSequence)"[:]");
        GrNamedArgument namedArgument = factory.createNamedArgument(expressionMap.getName(), emptyMap);
        PsiElement addedElement = GroovyDslUtil.addToMap((GrListOrMap)parentPsiElement, namedArgument);
        assert (addedElement instanceof GrNamedArgument);
        GrExpression added = ((GrNamedArgument)addedElement).getExpression();
        expressionMap.setPsiElement((PsiElement)added);
        return added;
    }

    private static PsiElement realAddBefore(@NotNull GrListOrMap element, @NotNull PsiElement newElement, @NotNull PsiElement anchor) {
        if (element == null) {
            GroovyDslUtil.$$$reportNull$$$0(12);
        }
        if (newElement == null) {
            GroovyDslUtil.$$$reportNull$$$0(13);
        }
        if (anchor == null) {
            GroovyDslUtil.$$$reportNull$$$0(14);
        }
        CheckUtil.checkWritable((PsiElement)element);
        TreeElement elementCopy = ChangeUtil.copyToElement((PsiElement)newElement);
        ASTNode anchorNode = GroovyDslUtil.getAnchorNode((PsiElement)element, anchor.getNode(), true);
        ASTNode newNode = CodeEditUtil.addChildren((ASTNode)element.getNode(), (ASTNode)elementCopy, (ASTNode)elementCopy, (ASTNode)anchorNode);
        if (newNode == null) {
            throw new IncorrectOperationException("Element cannot be added");
        }
        if (newNode instanceof TreeElement) {
            return ChangeUtil.decodeInformation((TreeElement)((TreeElement)newNode)).getPsi();
        }
        return newNode.getPsi();
    }

    private static ASTNode getAnchorNode(@NotNull PsiElement element, ASTNode anchor, Boolean before) {
        if (element == null) {
            GroovyDslUtil.$$$reportNull$$$0(15);
        }
        ASTNode anchorBefore = anchor != null ? (before != false ? anchor : anchor.getTreeNext()) : (before != null && before == false ? element.getNode().getFirstChildNode() : null);
        return anchorBefore;
    }

    static PsiElement addToMap(@NotNull GrListOrMap map2, @NotNull GrNamedArgument newValue) {
        if (map2 == null) {
            GroovyDslUtil.$$$reportNull$$$0(16);
        }
        if (newValue == null) {
            GroovyDslUtil.$$$reportNull$$$0(17);
        }
        ASTNode astNode = map2.getNode();
        if (map2.getNamedArguments().length != 0) {
            astNode.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", map2.getRBrack().getNode());
        } else {
            while (map2.getLBrack().getNextSibling() != map2.getRBrack()) {
                map2.getLBrack().getNextSibling().delete();
            }
        }
        return GroovyDslUtil.realAddBefore(map2, (PsiElement)newValue, map2.getRBrack());
    }

    @Nullable
    static PsiElement processListElement(@NotNull GradleDslSettableExpression expression) {
        GradleDslElement parent;
        if (expression == null) {
            GroovyDslUtil.$$$reportNull$$$0(18);
        }
        if ((parent = expression.getParent()) == null) {
            return null;
        }
        PsiElement parentPsi = parent.create();
        if (parentPsi == null) {
            return null;
        }
        PsiElement newExpressionPsi = expression.getUnsavedValue();
        if (newExpressionPsi == null) {
            return null;
        }
        PsiElement added = GroovyDslUtil.createPsiElementInsideList(parent, expression, parentPsi, newExpressionPsi);
        expression.setPsiElement(added);
        expression.commit();
        return expression.getPsiElement();
    }

    @Nullable
    static PsiElement processMapElement(@NotNull GradleDslSettableExpression expression) {
        GrNamedArgument added;
        if (expression == null) {
            GroovyDslUtil.$$$reportNull$$$0(19);
        }
        GradleDslElement parent = expression.getParent();
        assert (parent != null);
        GroovyPsiElement parentPsiElement = GroovyDslUtil.ensureGroovyPsi(parent.create());
        if (parentPsiElement == null) {
            return null;
        }
        expression.setPsiElement((PsiElement)parentPsiElement);
        GrExpression newLiteral = GroovyDslUtil.extractUnsavedExpression(expression);
        if (newLiteral == null) {
            return null;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)newLiteral.getProject());
        GrNamedArgument namedArgument = factory.createNamedArgument(expression.getName(), newLiteral);
        if (parentPsiElement instanceof GrArgumentList) {
            added = ((GrArgumentList)parentPsiElement).addNamedArgument(namedArgument);
        } else if (parentPsiElement instanceof GrListOrMap) {
            GrListOrMap grListOrMap = (GrListOrMap)parentPsiElement;
            added = GroovyDslUtil.addToMap(grListOrMap, namedArgument);
        } else {
            added = parentPsiElement.addBefore((PsiElement)namedArgument, parentPsiElement.getLastChild());
        }
        if (added instanceof GrNamedArgument) {
            GrNamedArgument addedNameArgument = added;
            GrExpression grExpression = (GrExpression)PsiTreeUtil.getChildOfType((PsiElement)addedNameArgument, GrExpression.class);
            if (grExpression != null) {
                expression.setExpression((PsiElement)grExpression);
                expression.commit();
                expression.reset();
                return expression.getPsiElement();
            }
            return null;
        }
        throw new IllegalStateException("Unexpected element type added to Mpa: " + added);
    }

    static void applyDslLiteralOrReference(@NotNull GradleDslSettableExpression expression) {
        GroovyPsiElement psiElement;
        if (expression == null) {
            GroovyDslUtil.$$$reportNull$$$0(20);
        }
        if ((psiElement = GroovyDslUtil.ensureGroovyPsi(expression.getPsiElement())) == null) {
            return;
        }
        GroovyDslUtil.maybeUpdateName(expression);
        GrExpression newLiteral = GroovyDslUtil.extractUnsavedExpression(expression);
        if (newLiteral == null) {
            return;
        }
        GroovyPsiElement psiExpression = GroovyDslUtil.ensureGroovyPsi(expression.getExpression());
        if (psiExpression != null) {
            PsiElement replace = psiExpression.replace((PsiElement)newLiteral);
            if (replace instanceof GrLiteral || replace instanceof GrReferenceExpression || replace instanceof GrIndexProperty) {
                expression.setExpression(replace);
            }
        } else {
            PsiElement added = psiElement.addAfter((PsiElement)newLiteral, psiElement.getLastChild());
            expression.setExpression(added);
            if (expression.getUnsavedConfigBlock() != null) {
                GroovyDslUtil.addConfigBlock(expression);
            }
        }
        expression.reset();
        expression.commit();
    }

    @Nullable
    static PsiElement createNamedArgumentList(@NotNull GradleDslExpressionList expressionList) {
        PsiElement added;
        if (expressionList == null) {
            GroovyDslUtil.$$$reportNull$$$0(21);
        }
        GradleDslElement parent = expressionList.getParent();
        assert (parent instanceof GradleDslExpressionMap);
        PsiElement parentPsiElement = parent.create();
        if (parentPsiElement == null) {
            return null;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)parentPsiElement.getProject());
        GrExpression expressionFromText = factory.createExpressionFromText((CharSequence)"[]");
        GrNamedArgument namedArgument = factory.createNamedArgument(expressionList.getName(), expressionFromText);
        if (parentPsiElement instanceof GrArgumentList) {
            GrArgumentList argList = (GrArgumentList)parentPsiElement;
            argList.addNamedArgument(namedArgument);
            GrNamedArgument[] args = argList.getNamedArguments();
            added = args[args.length - 1];
        } else if (parentPsiElement instanceof GrListOrMap) {
            GrListOrMap listOrMap = (GrListOrMap)parentPsiElement;
            if (!listOrMap.isEmpty()) {
                ASTNode node = listOrMap.getNode();
                node.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", listOrMap.getLBrack().getNextSibling().getNode());
            }
            added = parentPsiElement.addAfter((PsiElement)namedArgument, parentPsiElement.getLastChild());
        } else {
            added = parentPsiElement.addAfter((PsiElement)namedArgument, parentPsiElement.getLastChild());
        }
        if (added instanceof GrNamedArgument) {
            GrNamedArgument addedNameArgument = (GrNamedArgument)added;
            expressionList.setPsiElement((PsiElement)addedNameArgument.getExpression());
            return expressionList.getPsiElement();
        }
        return null;
    }

    @Nullable
    static String getInjectionName(@NotNull GrStringInjection injection) {
        if (injection == null) {
            GroovyDslUtil.$$$reportNull$$$0(22);
        }
        String variableName = null;
        GrClosableBlock closableBlock = injection.getClosableBlock();
        if (closableBlock != null) {
            String blockText = closableBlock.getText();
            variableName = blockText.substring(1, blockText.length() - 1);
        } else {
            GrExpression expression = injection.getExpression();
            if (expression != null) {
                variableName = expression.getText();
            }
        }
        return variableName;
    }

    @NotNull
    static String ensureUnquotedText(@NotNull String str) {
        if (str == null) {
            GroovyDslUtil.$$$reportNull$$$0(23);
        }
        if (StringUtil.isQuotedString((String)str)) {
            str = StringUtil.unquoteString((String)str);
        }
        String string = str;
        if (string == null) {
            GroovyDslUtil.$$$reportNull$$$0(24);
        }
        return string;
    }

    @Nullable
    static PsiElement getParentPsi(@NotNull GradleDslElement element) {
        GradleDslElement parent;
        if (element == null) {
            GroovyDslUtil.$$$reportNull$$$0(25);
        }
        if ((parent = element.getParent()) == null) {
            return null;
        }
        GroovyPsiElement parentPsiElement = GroovyDslUtil.ensureGroovyPsi(parent.create());
        if (parentPsiElement == null) {
            return null;
        }
        return parentPsiElement;
    }

    static String maybeTrimForParent(@NotNull GradleNameElement name, @Nullable GradleDslElement parent) {
        if (name == null) {
            GroovyDslUtil.$$$reportNull$$$0(26);
        }
        if (parent == null) {
            return name.fullName();
        }
        ArrayList<String> parts = new ArrayList<String>(name.fullNameParts());
        if (parts.isEmpty()) {
            return name.fullName();
        }
        String lastNamePart = (String)parts.remove(parts.size() - 1);
        List parentParts = Splitter.on((String)".").splitToList((CharSequence)parent.getQualifiedName());
        for (int i2 = 0; i2 < parentParts.size() && !parts.isEmpty() && ((String)parentParts.get(i2)).equals(parts.get(0)); ++i2) {
            parts.remove(0);
        }
        parts.add(lastNamePart);
        return GradleNameElement.createNameFromParts(parts);
    }

    static boolean shouldAddToListInternal(@NotNull GradleDslElement element) {
        GradleDslElement parent;
        if (element == null) {
            GroovyDslUtil.$$$reportNull$$$0(27);
        }
        if (!((parent = element.getParent()) instanceof GradleDslExpressionList)) {
            return false;
        }
        PsiElement parentPsi = parent.getPsiElement();
        return parentPsi instanceof GrListOrMap && ((GrListOrMap)parentPsi).getInitializers().length > 0 || parentPsi instanceof GrArgumentList && ((GrArgumentList)parentPsi).getAllArguments().length > 0;
    }

    static void emplaceElementIntoList(@NotNull PsiElement anchorBefore, @NotNull PsiElement list, @NotNull PsiElement newElement) {
        if (anchorBefore == null) {
            GroovyDslUtil.$$$reportNull$$$0(28);
        }
        if (list == null) {
            GroovyDslUtil.$$$reportNull$$$0(29);
        }
        if (newElement == null) {
            GroovyDslUtil.$$$reportNull$$$0(30);
        }
        ASTNode node = list.getNode();
        ASTNode anchor = anchorBefore.getNode().getTreeNext();
        node.addChild(newElement.getNode(), anchor);
        node.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", newElement.getNode());
    }

    static PsiElement emplaceElementToFrontOfList(@NotNull PsiElement listElement, @NotNull PsiElement newElement) {
        if (listElement == null) {
            GroovyDslUtil.$$$reportNull$$$0(31);
        }
        if (newElement == null) {
            GroovyDslUtil.$$$reportNull$$$0(32);
        }
        assert (listElement instanceof GrListOrMap || listElement instanceof GrArgumentList);
        ASTNode node = listElement.getNode();
        if (listElement instanceof GrListOrMap) {
            GrListOrMap list = (GrListOrMap)listElement;
            ASTNode anchor = list.getLBrack().getNode().getTreeNext();
            if (!list.isEmpty()) {
                node.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", anchor);
                node.addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", anchor);
            }
            node.addChild(newElement.getNode(), list.getLBrack().getNode().getTreeNext());
        } else if (((GrArgumentList)listElement).getLeftParen() != null) {
            GrArgumentList list = (GrArgumentList)listElement;
            PsiElement leftParen = list.getLeftParen();
            assert (leftParen != null);
            ASTNode anchor = list.getLeftParen().getNode().getTreeNext();
            if (list.getAllArguments().length != 0) {
                node.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", anchor);
                node.addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", anchor);
            }
            node.addChild(newElement.getNode(), list.getLeftParen().getNode().getTreeNext());
        } else {
            ASTNode anchor = GroovyDslUtil.getFirstASTNode(listElement);
            if (anchor != null) {
                node.addLeaf(GroovyTokenTypes.mCOMMA, (CharSequence)",", anchor);
                node.addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", anchor);
            }
            node.addChild(newElement.getNode(), GroovyDslUtil.getFirstASTNode(listElement));
        }
        return newElement;
    }

    @Nullable
    static ASTNode getFirstASTNode(@NotNull PsiElement parent) {
        PsiElement firstChild;
        if (parent == null) {
            GroovyDslUtil.$$$reportNull$$$0(33);
        }
        if ((firstChild = parent.getFirstChild()) == null) {
            return null;
        }
        return firstChild.getNode();
    }

    @NotNull
    static PsiElement createPsiElementInsideList(@NotNull GradleDslElement parentDslElement, @NotNull GradleDslElement dslElement, @NotNull PsiElement parentPsiElement, @NotNull PsiElement newElement) {
        PsiElement added;
        if (parentDslElement == null) {
            GroovyDslUtil.$$$reportNull$$$0(34);
        }
        if (dslElement == null) {
            GroovyDslUtil.$$$reportNull$$$0(35);
        }
        if (parentPsiElement == null) {
            GroovyDslUtil.$$$reportNull$$$0(36);
        }
        if (newElement == null) {
            GroovyDslUtil.$$$reportNull$$$0(37);
        }
        GradleDslElement anchor = parentDslElement.requestAnchor(dslElement);
        if (GroovyDslUtil.shouldAddToListInternal(dslElement) && anchor != null) {
            PsiElement anchorPsi = anchor.getPsiElement();
            assert (anchorPsi != null);
            GroovyDslUtil.emplaceElementIntoList(anchorPsi, parentPsiElement, newElement);
            added = newElement;
        } else {
            added = GroovyDslUtil.emplaceElementToFrontOfList(parentPsiElement, newElement);
        }
        PsiElement psiElement = added;
        if (psiElement == null) {
            GroovyDslUtil.$$$reportNull$$$0(38);
        }
        return psiElement;
    }

    @Nullable
    static PsiElement createNameElement(@NotNull GradleDslElement context, @NotNull String name) {
        GroovyPsiElementFactory factory;
        if (context == null) {
            GroovyDslUtil.$$$reportNull$$$0(39);
        }
        if (name == null) {
            GroovyDslUtil.$$$reportNull$$$0(40);
        }
        if ((factory = GroovyDslUtil.getPsiElementFactory(context)) == null) {
            return null;
        }
        String str = name + " = 1";
        GrExpression expression = factory.createExpressionFromText((CharSequence)str);
        assert (expression instanceof GrAssignmentExpression);
        return ((GrAssignmentExpression)expression).getLValue();
    }

    static void maybeUpdateName(@NotNull GradleDslElement element) {
        PsiNamedElement newElement;
        if (element == null) {
            GroovyDslUtil.$$$reportNull$$$0(41);
        }
        PsiElement oldName = element.getNameElement().getNamedPsiElement();
        String newName2 = element.getNameElement().getUnsavedName();
        if (newName2 == null || oldName == null) {
            return;
        }
        if (oldName instanceof PsiNamedElement) {
            PsiNamedElement namedElement = (PsiNamedElement)oldName;
            namedElement.setName(newName2);
            newElement = namedElement;
        } else {
            PsiElement psiElement = GroovyDslUtil.createNameElement(element, newName2);
            if (psiElement == null) {
                throw new IllegalStateException("Can't create new GrExpression for name element");
            }
            newElement = oldName.replace(psiElement);
        }
        element.getNameElement().commitNameChange((PsiElement)newElement);
    }

    @Nullable
    static PsiElement findLastPsiElementIn(@NotNull GradleDslElement startElement) {
        PsiElement psiElement;
        if (startElement == null) {
            GroovyDslUtil.$$$reportNull$$$0(42);
        }
        if ((psiElement = startElement.getPsiElement()) != null) {
            return psiElement;
        }
        for (GradleDslElement element : Lists.reverse(new ArrayList<GradleDslElement>(startElement.getChildren()))) {
            PsiElement psi;
            if (element == null || (psi = GroovyDslUtil.findLastPsiElementIn(element)) == null) continue;
            return psi;
        }
        return null;
    }

    @Nullable
    static PsiElement getPsiElementForAnchor(@NotNull PsiElement parent, @Nullable GradleDslElement dslAnchor) {
        PsiElement anchorAfter;
        if (parent == null) {
            GroovyDslUtil.$$$reportNull$$$0(43);
        }
        PsiElement psiElement = anchorAfter = dslAnchor == null ? null : GroovyDslUtil.findLastPsiElementIn(dslAnchor);
        if (anchorAfter == null && parent instanceof GrClosableBlock) {
            return GroovyDslUtil.adjustForCloseableBlock((GrClosableBlock)parent);
        }
        while (anchorAfter != null && !(anchorAfter instanceof PsiFile) && anchorAfter.getParent() != parent) {
            anchorAfter = anchorAfter.getParent();
        }
        return anchorAfter instanceof PsiFile ? (parent instanceof GrClosableBlock ? GroovyDslUtil.adjustForCloseableBlock((GrClosableBlock)parent) : null) : anchorAfter;
    }

    private static PsiElement adjustForCloseableBlock(@NotNull GrClosableBlock block) {
        PsiElement element;
        if (block == null) {
            GroovyDslUtil.$$$reportNull$$$0(44);
        }
        if ((element = block.getFirstChild()) != null) {
            element = element.getNextSibling();
        }
        while (element != null && (element = element.getNextSibling()) != null && (Strings.isNullOrEmpty((String)element.getText()) || element.getText().matches("[\\t ]+"))) {
        }
        return element == null ? null : element.getPrevSibling();
    }

    static boolean needToCreateParent(@NotNull GradleDslElement element) {
        GradleDslElement parent;
        if (element == null) {
            GroovyDslUtil.$$$reportNull$$$0(45);
        }
        return (parent = element.getParent()) != null && parent.getPsiElement() == null;
    }

    static boolean hasNewLineBetween(@NotNull PsiElement start, @NotNull PsiElement end) {
        if (start == null) {
            GroovyDslUtil.$$$reportNull$$$0(46);
        }
        if (end == null) {
            GroovyDslUtil.$$$reportNull$$$0(47);
        }
        assert (start.getParent() == end.getParent() && start.getStartOffsetInParent() <= end.getStartOffsetInParent());
        for (PsiElement element = start; element != end; element = element.getNextSibling()) {
            if (!element.getNode().getElementType().equals(GroovyTokenTypes.mNLS)) continue;
            return true;
        }
        return false;
    }

    static List<GradleReferenceInjection> findInjections(@NotNull GradleDslSimpleExpression context, @NotNull PsiElement psiElement, boolean includeUnresolved) {
        GrStringInjection[] grStringInjections;
        if (context == null) {
            GroovyDslUtil.$$$reportNull$$$0(48);
        }
        if (psiElement == null) {
            GroovyDslUtil.$$$reportNull$$$0(49);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (psiElement instanceof GrReferenceExpression || psiElement instanceof GrIndexProperty) {
            String text = psiElement.getText();
            GradleDslElement element = context.resolveReference(text, true);
            return ImmutableList.of((Object)new GradleReferenceInjection(context, element, psiElement, text));
        }
        if (!(psiElement instanceof GrString)) {
            return Collections.emptyList();
        }
        ArrayList injections = Lists.newArrayList();
        for (GrStringInjection injection : grStringInjections = ((GrString)psiElement).getInjections()) {
            String name;
            if (injection == null || (name = GroovyDslUtil.getInjectionName(injection)) == null) continue;
            GradleDslElement referenceElement = context.resolveReference(name, true);
            if (!includeUnresolved && referenceElement == null) continue;
            injections.add(new GradleReferenceInjection(context, referenceElement, (PsiElement)injection, name));
        }
        return injections;
    }

    static void createAndAddClosure(@NotNull GradleDslClosure closure, @NotNull GradleDslElement element) {
        GroovyPsiElement psiElement;
        if (closure == null) {
            GroovyDslUtil.$$$reportNull$$$0(50);
        }
        if (element == null) {
            GroovyDslUtil.$$$reportNull$$$0(51);
        }
        if ((psiElement = GroovyDslUtil.ensureGroovyPsi(element.getPsiElement())) == null) {
            return;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)psiElement.getProject());
        GrClosableBlock block = factory.createClosureFromText("{ }");
        psiElement.addAfter(factory.createWhiteSpace(), psiElement.getLastChild());
        PsiElement newElement = psiElement.addAfter((PsiElement)block, psiElement.getLastChild());
        closure.setPsiElement(newElement);
        closure.applyChanges();
        element.setParsedClosureElement(closure);
        element.setNewClosureElement(null);
    }

    static void deletePsiElement(@NotNull GradleDslElement context, @Nullable PsiElement psiElement) {
        if (context == null) {
            GroovyDslUtil.$$$reportNull$$$0(52);
        }
        if (psiElement == null || !psiElement.isValid()) {
            return;
        }
        PsiElement parent = psiElement.getParent();
        psiElement.delete();
        GroovyDslUtil.maybeDeleteIfEmpty(parent, context);
        GroovyDslUtil.removePsiIfInvalid(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 24: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 24: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 12: 
            case 15: 
            case 25: 
            case 27: 
            case 41: 
            case 45: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dslElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingDslElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 8: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 9: 
            case 39: 
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unsavedValue";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionMap";
                break;
            }
            case 13: 
            case 30: 
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionList";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injection";
                break;
            }
            case 24: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/groovy/GroovyDslUtil";
                break;
            }
            case 26: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchorBefore";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listElement";
                break;
            }
            case 33: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDslElement";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentPsiElement";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "start";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/groovy/GroovyDslUtil";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureUnquotedText";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createPsiElementInsideList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addConfigBlock";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getClosableBlock";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementFactory";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isNewEmptyBlockElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "maybeDeleteIfEmpty";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deleteIfEmpty";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNextValidParent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "extractUnsavedExpression";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "escapeString";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createLiteral";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createDerivedMap";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "realAddBefore";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAnchorNode";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addToMap";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processListElement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processMapElement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "applyDslLiteralOrReference";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createNamedArgumentList";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getInjectionName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "ensureUnquotedText";
                break;
            }
            case 24: 
            case 38: {
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getParentPsi";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "maybeTrimForParent";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "shouldAddToListInternal";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "emplaceElementIntoList";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "emplaceElementToFrontOfList";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getFirstASTNode";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createPsiElementInsideList";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "createNameElement";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "maybeUpdateName";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findLastPsiElementIn";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementForAnchor";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "adjustForCloseableBlock";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "needToCreateParent";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "hasNewLineBetween";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "findInjections";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "createAndAddClosure";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "deletePsiElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 24: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

