/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.files;

import com.android.tools.idea.gradle.dsl.api.BuildModelNotification;
import com.android.tools.idea.gradle.dsl.parser.BuildModelContext;
import com.android.tools.idea.gradle.dsl.parser.GradleDslParser;
import com.android.tools.idea.gradle.dsl.parser.GradleDslWriter;
import com.android.tools.idea.gradle.dsl.parser.apply.ApplyDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleNameElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradlePropertiesDslElement;
import com.android.tools.idea.gradle.dsl.parser.groovy.GroovyDslParser;
import com.android.tools.idea.gradle.dsl.parser.groovy.GroovyDslWriter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;

public abstract class GradleDslFile
extends GradlePropertiesDslElement {
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<GradleDslFile> myChildModuleDslFiles;
    @NotNull
    private final GradleDslWriter myGradleDslWriter;
    @NotNull
    private final GradleDslParser myGradleDslParser;
    @Nullable
    private GradleDslFile myParentModuleDslFile;
    @Nullable
    private GradleDslFile mySiblingDslFile;
    @Nullable
    private ApplyDslElement myApplyDslElement;
    @NotNull
    private final BuildModelContext myBuildModelContext;

    protected GradleDslFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName, @NotNull BuildModelContext context) {
        if (file == null) {
            GradleDslFile.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GradleDslFile.$$$reportNull$$$0(1);
        }
        if (moduleName == null) {
            GradleDslFile.$$$reportNull$$$0(2);
        }
        if (context == null) {
            GradleDslFile.$$$reportNull$$$0(3);
        }
        super(null, null, GradleNameElement.fake(moduleName));
        this.myChildModuleDslFiles = Sets.newHashSet();
        this.myFile = file;
        this.myProject = project;
        this.myBuildModelContext = context;
        Application application = ApplicationManager.getApplication();
        PsiFile psiFile = (PsiFile)application.runReadAction(() -> PsiManager.getInstance((Project)this.myProject).findFile(this.myFile));
        if (!(psiFile instanceof GroovyFile)) {
            this.myGradleDslParser = new GradleDslParser.Adapter();
            this.myGradleDslWriter = new GradleDslWriter.Adapter();
            return;
        }
        GroovyFile groovyPsiFile = (GroovyFile)psiFile;
        this.myGradleDslParser = new GroovyDslParser(groovyPsiFile, this);
        this.myGradleDslWriter = new GroovyDslWriter();
        this.setPsiElement((PsiElement)groovyPsiFile);
    }

    public void reparse() {
        this.clear();
        this.parse();
    }

    public void parse() {
        this.myGradleDslParser.parse();
        this.getContext().getDependencyManager().resolveAll();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            GradleDslFile.$$$reportNull$$$0(4);
        }
        return project;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            GradleDslFile.$$$reportNull$$$0(5);
        }
        return virtualFile;
    }

    @NotNull
    public File getDirectoryPath() {
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)this.getFile().getParent());
        if (file == null) {
            GradleDslFile.$$$reportNull$$$0(6);
        }
        return file;
    }

    @NotNull
    public List<GradleDslFile> getApplyDslElement() {
        Object object = this.myApplyDslElement == null ? ImmutableList.of() : this.myApplyDslElement.getAppliedDslFiles();
        if (object == null) {
            GradleDslFile.$$$reportNull$$$0(7);
        }
        return object;
    }

    public void setParentModuleDslFile(@NotNull GradleDslFile parentModuleDslFile) {
        if (parentModuleDslFile == null) {
            GradleDslFile.$$$reportNull$$$0(8);
        }
        this.myParentModuleDslFile = parentModuleDslFile;
        this.myParentModuleDslFile.myChildModuleDslFiles.add(this);
    }

    @Nullable
    public GradleDslFile getParentModuleDslFile() {
        return this.myParentModuleDslFile;
    }

    @NotNull
    public Collection<GradleDslFile> getChildModuleDslFiles() {
        Set<GradleDslFile> set = this.myChildModuleDslFiles;
        if (set == null) {
            GradleDslFile.$$$reportNull$$$0(9);
        }
        return set;
    }

    public void setSiblingDslFile(@NotNull GradleDslFile siblingDslFile) {
        if (siblingDslFile == null) {
            GradleDslFile.$$$reportNull$$$0(10);
        }
        this.mySiblingDslFile = siblingDslFile;
    }

    @Nullable
    public GradleDslFile getSiblingDslFile() {
        return this.mySiblingDslFile;
    }

    @NotNull
    public GradleDslWriter getWriter() {
        GradleDslWriter gradleDslWriter = this.myGradleDslWriter;
        if (gradleDslWriter == null) {
            GradleDslFile.$$$reportNull$$$0(11);
        }
        return gradleDslWriter;
    }

    @NotNull
    public GradleDslParser getParser() {
        GradleDslParser gradleDslParser = this.myGradleDslParser;
        if (gradleDslParser == null) {
            GradleDslFile.$$$reportNull$$$0(12);
        }
        return gradleDslParser;
    }

    @NotNull
    public BuildModelContext getContext() {
        BuildModelContext buildModelContext = this.myBuildModelContext;
        if (buildModelContext == null) {
            GradleDslFile.$$$reportNull$$$0(13);
        }
        return buildModelContext;
    }

    @Override
    protected void apply() {
        if (this.myApplyDslElement != null) {
            for (GradleDslFile file : this.myApplyDslElement.getAppliedDslFiles()) {
                file.apply();
            }
        }
        super.apply();
    }

    public void registerApplyElement(@NotNull ApplyDslElement applyElement) {
        if (applyElement == null) {
            GradleDslFile.$$$reportNull$$$0(14);
        }
        this.myApplyDslElement = applyElement;
    }

    @NotNull
    public List<BuildModelNotification> getPublicNotifications() {
        List<BuildModelNotification> list = this.myBuildModelContext.getPublicNotifications();
        if (list == null) {
            GradleDslFile.$$$reportNull$$$0(15);
        }
        return list;
    }

    public void saveAllChanges() {
        PsiElement element = this.getPsiElement();
        if (element == null) {
            return;
        }
        assert (element instanceof PsiFile);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.getProject());
        Document document = psiDocumentManager.getDocument((PsiFile)element);
        if (document == null) {
            return;
        }
        if (psiDocumentManager.isDocumentBlockedByPsi(document)) {
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
        }
        FileDocumentManager.getInstance().saveDocument(document);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/files/GradleDslFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentModuleDslFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "siblingDslFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/files/GradleDslFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectoryPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplyDslElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildModuleDslFiles";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getWriter";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getParser";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPublicNotifications";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setParentModuleDslFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setSiblingDslFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerApplyElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

