/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.Projects;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.GradleSettingsModel;
import com.android.tools.idea.gradle.dsl.api.ProjectBuildModel;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModelImpl;
import com.android.tools.idea.gradle.dsl.model.GradleSettingsModelImpl;
import com.android.tools.idea.gradle.dsl.parser.BuildModelContext;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElementImpl;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectBuildModelImpl
implements ProjectBuildModel {
    @NotNull
    private final BuildModelContext myBuildModelContext;
    @NotNull
    private final Project myProject;
    @Nullable
    private final GradleBuildFile myProjectBuildFile;

    @NotNull
    public static ProjectBuildModel get(@NotNull Project project) {
        if (project == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(0);
        }
        VirtualFile file = GradleUtil.getGradleBuildFile(Projects.getBaseDirPath((Project)project));
        ProjectBuildModelImpl projectBuildModelImpl = new ProjectBuildModelImpl(project, file);
        if (projectBuildModelImpl == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(1);
        }
        return projectBuildModelImpl;
    }

    private ProjectBuildModelImpl(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(2);
        }
        this.myBuildModelContext = BuildModelContext.create(project);
        this.myProject = project;
        GradleBuildFile gradleBuildFile = this.myProjectBuildFile = file != null ? new GradleBuildFile(file, this.myProject, project.getName(), this.myBuildModelContext) : null;
        if (this.myProjectBuildFile != null) {
            this.myBuildModelContext.setRootProjectFile(this.myProjectBuildFile);
            ApplicationManager.getApplication().runReadAction(() -> {
                GradleBuildModelImpl.populateWithParentModuleSubProjectsProperties(this.myProjectBuildFile, this.myBuildModelContext);
                GradleBuildModelImpl.populateSiblingDslFileWithGradlePropertiesFile(this.myProjectBuildFile, this.myBuildModelContext);
                this.myProjectBuildFile.parse();
            });
            this.myBuildModelContext.putBuildFile(file.getUrl(), this.myProjectBuildFile);
        }
    }

    @Override
    @Nullable
    public GradleBuildModel getProjectBuildModel() {
        return this.myProjectBuildFile == null ? null : new GradleBuildModelImpl(this.myProjectBuildFile);
    }

    @Override
    @Nullable
    public GradleBuildModel getModuleBuildModel(@NotNull Module module) {
        VirtualFile file;
        if (module == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(3);
        }
        return (file = GradleUtil.getGradleBuildFile(module)) == null ? null : this.getModuleBuildModel(file);
    }

    @Override
    @Nullable
    public GradleBuildModel getModuleBuildModel(@NotNull File modulePath) {
        VirtualFile file;
        if (modulePath == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(4);
        }
        return (file = GradleUtil.getGradleBuildFile(modulePath)) == null ? null : this.getModuleBuildModel(file);
    }

    @Override
    @NotNull
    public GradleBuildModel getModuleBuildModel(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(5);
        }
        GradleBuildFile dslFile = this.myBuildModelContext.getOrCreateBuildFile(file);
        GradleBuildModelImpl gradleBuildModelImpl = new GradleBuildModelImpl(dslFile);
        if (gradleBuildModelImpl == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(6);
        }
        return gradleBuildModelImpl;
    }

    @Override
    @Nullable
    public GradleSettingsModel getProjectSettingsModel() {
        GradleSettingsFile settingsFile = this.myBuildModelContext.getOrCreateSettingsFile(this.myProject);
        if (settingsFile == null) {
            return null;
        }
        return new GradleSettingsModelImpl(settingsFile);
    }

    @Override
    public void applyChanges() {
        this.runOverProjectTree(file -> {
            file.applyChanges();
            file.saveAllChanges();
        });
    }

    @Override
    public void resetState() {
        this.runOverProjectTree(GradleDslElementImpl::resetState);
    }

    @Override
    public void reparse() {
        this.myBuildModelContext.reset();
        this.runOverProjectTree(GradleDslFile::reparse);
    }

    private void runOverProjectTree(@NotNull Consumer<GradleDslFile> func) {
        if (func == null) {
            ProjectBuildModelImpl.$$$reportNull$$$0(7);
        }
        this.myBuildModelContext.getAllRequestedFiles().forEach(func);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/ProjectBuildModelImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/ProjectBuildModelImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleBuildModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModuleBuildModel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runOverProjectTree";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

