/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fonts;

import com.android.ide.common.fonts.MutableFontDetail;
import com.android.ide.common.fonts.QueryParser;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class FontFamilyParser {
    FontFamilyParser() {
    }

    @NotNull
    static QueryParser.ParseResult parseFontFamily(@NotNull File xmlFile) {
        QueryParser.ParseResult parseResult;
        if (xmlFile == null) {
            FontFamilyParser.$$$reportNull$$$0(0);
        }
        try {
            parseResult = FontFamilyParser.parseFontReference(xmlFile);
        }
        catch (QueryParser.FontQueryParserError ex) {
            ParseErrorResult parseErrorResult = new ParseErrorResult(ex.getMessage());
            if (parseErrorResult == null) {
                FontFamilyParser.$$$reportNull$$$0(2);
            }
            return parseErrorResult;
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            String message = "Could not parse font xml file " + xmlFile;
            Logger.getInstance(FontFamilyParser.class).error(message, (Throwable)ex);
            ParseErrorResult parseErrorResult = new ParseErrorResult(message);
            if (parseErrorResult == null) {
                FontFamilyParser.$$$reportNull$$$0(3);
            }
            return parseErrorResult;
        }
        if (parseResult == null) {
            FontFamilyParser.$$$reportNull$$$0(1);
        }
        return parseResult;
    }

    private static QueryParser.ParseResult parseFontReference(@NotNull File xmlFile) throws SAXException, ParserConfigurationException, IOException {
        if (xmlFile == null) {
            FontFamilyParser.$$$reportNull$$$0(4);
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        FontFamilyHandler handler = new FontFamilyHandler(xmlFile);
        parser.parse(xmlFile, (DefaultHandler)handler);
        return handler.getResult();
    }

    static int parseInt(@Nullable String intAsString, int defaultValue) {
        if (intAsString == null) {
            return defaultValue;
        }
        try {
            return Math.round(Float.parseFloat(intAsString));
        }
        catch (NumberFormatException ex) {
            return defaultValue;
        }
    }

    static boolean parseFontStyle(@Nullable String fontStyle) {
        return fontStyle != null && fontStyle.startsWith("italic");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/fonts/FontFamilyParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/fonts/FontFamilyParser";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseFontFamily";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseFontFamily";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseFontReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class CompoundFontResult
    extends QueryParser.ParseResult {
        private Map<String, MutableFontDetail> myFonts = new HashMap<String, MutableFontDetail>();

        CompoundFontResult() {
        }

        @NotNull
        Map<String, MutableFontDetail> getFonts() {
            Map<String, MutableFontDetail> map2 = this.myFonts;
            if (map2 == null) {
                CompoundFontResult.$$$reportNull$$$0(0);
            }
            return map2;
        }

        private void addFont(@NotNull String fontName, int weight, int width, boolean italics) {
            if (fontName == null) {
                CompoundFontResult.$$$reportNull$$$0(1);
            }
            this.myFonts.put(fontName, new MutableFontDetail(weight, width, italics));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/fonts/FontFamilyParser$CompoundFontResult";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fontName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFonts";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/fonts/FontFamilyParser$CompoundFontResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addFont";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class FontFamilyHandler
    extends DefaultHandler {
        private static final String FONT_FAMILY = "font-family";
        private static final String FONT = "font";
        private static final String ATTR_AUTHORITY = "fontProviderAuthority";
        private static final String ATTR_QUERY = "fontProviderQuery";
        private static final String ATTR_FONT = "font";
        private static final String ATTR_FONT_WEIGHT = "fontWeight";
        private static final String ATTR_FONT_WIDTH = "fontWidth";
        private static final String ATTR_FONT_STYLE = "fontStyle";
        private final File myFile;
        private QueryParser.ParseResult myResult;

        private FontFamilyHandler(@NotNull File file) {
            if (file == null) {
                FontFamilyHandler.$$$reportNull$$$0(0);
            }
            this.myFile = file;
        }

        @NotNull
        private QueryParser.ParseResult getResult() {
            if (this.myResult == null) {
                this.myResult = new ParseErrorResult("The font file is empty");
            }
            QueryParser.ParseResult parseResult = this.myResult;
            if (parseResult == null) {
                FontFamilyHandler.$$$reportNull$$$0(1);
            }
            return parseResult;
        }

        @Override
        public void startElement(@NotNull String uri, @NotNull String localName, @NotNull String name, @NotNull Attributes attributes) throws SAXException {
            if (uri == null) {
                FontFamilyHandler.$$$reportNull$$$0(2);
            }
            if (localName == null) {
                FontFamilyHandler.$$$reportNull$$$0(3);
            }
            if (name == null) {
                FontFamilyHandler.$$$reportNull$$$0(4);
            }
            if (attributes == null) {
                FontFamilyHandler.$$$reportNull$$$0(5);
            }
            switch (name) {
                case "font-family": {
                    this.myResult = this.parseQuery(FontFamilyHandler.getAttributeValue(attributes, ATTR_AUTHORITY), FontFamilyHandler.getAttributeValue(attributes, ATTR_QUERY));
                    break;
                }
                case "font": {
                    String fontName = FontFamilyHandler.getAttributeValue(attributes, "font");
                    int weight = FontFamilyParser.parseInt(FontFamilyHandler.getAttributeValue(attributes, ATTR_FONT_WEIGHT), 400);
                    int width = FontFamilyParser.parseInt(FontFamilyHandler.getAttributeValue(attributes, ATTR_FONT_WIDTH), 100);
                    boolean italics = FontFamilyParser.parseFontStyle(FontFamilyHandler.getAttributeValue(attributes, ATTR_FONT_STYLE));
                    this.myResult = this.addFont(fontName, weight, width, italics);
                    break;
                }
                default: {
                    Logger.getInstance(FontFamilyParser.class).warn("Unrecognized tag: " + name + " in file: " + this.myFile);
                }
            }
        }

        @Nullable
        private static String getAttributeValue(@NotNull Attributes attributes, @NotNull String attrName) {
            String value2;
            if (attributes == null) {
                FontFamilyHandler.$$$reportNull$$$0(6);
            }
            if (attrName == null) {
                FontFamilyHandler.$$$reportNull$$$0(7);
            }
            if ((value2 = attributes.getValue("http://schemas.android.com/apk/res/android", attrName)) != null) {
                return value2;
            }
            return attributes.getValue("http://schemas.android.com/apk/res-auto", attrName);
        }

        @Nullable
        private QueryParser.ParseResult parseQuery(@Nullable String authority, @Nullable String query) {
            if (this.myResult instanceof ParseErrorResult) {
                return this.myResult;
            }
            if (authority == null && query == null) {
                return this.myResult;
            }
            if (this.myResult != null) {
                return new ParseErrorResult("<font-family> must be the root element");
            }
            if (authority == null) {
                return new ParseErrorResult("The <font-family> tag must contain an fontProviderAuthority attribute");
            }
            if (query == null) {
                return new ParseErrorResult("The <font-family> tag must contain a fontProviderQuery attribute");
            }
            return QueryParser.parseDownloadableFont((String)authority, (String)query);
        }

        private QueryParser.ParseResult addFont(@Nullable String fontName, int weight, int width, boolean italics) {
            if (this.myResult instanceof ParseErrorResult) {
                return this.myResult;
            }
            if (this.myResult != null && !(this.myResult instanceof CompoundFontResult)) {
                return new ParseErrorResult("<font> is not allowed in a downloadable font definition");
            }
            if (fontName == null) {
                return new ParseErrorResult("The <font> tag must contain a font attribute");
            }
            CompoundFontResult result2 = (CompoundFontResult)this.myResult;
            if (result2 == null) {
                result2 = new CompoundFontResult();
            }
            result2.addFont(fontName, weight, width, italics);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/fonts/FontFamilyParser$FontFamilyHandler";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uri";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attrName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/fonts/FontFamilyParser$FontFamilyHandler";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "startElement";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getAttributeValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class ParseErrorResult
    extends QueryParser.ParseResult {
        private final String myMessage;

        ParseErrorResult(@NotNull String message) {
            if (message == null) {
                ParseErrorResult.$$$reportNull$$$0(0);
            }
            this.myMessage = message;
        }

        public String getMessage() {
            return this.myMessage;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/fonts/FontFamilyParser$ParseErrorResult", "<init>"));
        }
    }
}

