/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fonts;

import com.android.ide.common.fonts.FontDetail;
import com.android.ide.common.fonts.FontFamily;
import com.android.tools.idea.fonts.DownloadableFontCacheServiceImpl;
import com.android.tools.idea.fonts.FontFileDownloader;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FontDownloadService {
    private final DownloadableFontCacheServiceImpl myCacheService;
    private final File myFontPath;
    private final List<FontFamily> myFontsToDownload;
    private final boolean myDownloadMenuFontsOnly;
    private final Runnable mySuccess;
    private final Runnable myFailure;

    public static void download(@NotNull List<FontFamily> fontsToDownload, boolean menuFontsOnly, @Nullable Runnable success, @Nullable Runnable failure) {
        if (fontsToDownload == null) {
            FontDownloadService.$$$reportNull$$$0(0);
        }
        FontDownloadService service = new FontDownloadService(fontsToDownload, menuFontsOnly, success, failure);
        service.download();
    }

    private FontDownloadService(@NotNull List<FontFamily> fontsToDownload, boolean menuFontsOnly, @Nullable Runnable success, @Nullable Runnable failure) {
        if (fontsToDownload == null) {
            FontDownloadService.$$$reportNull$$$0(1);
        }
        this.myCacheService = DownloadableFontCacheServiceImpl.getInstance();
        this.myFontPath = this.myCacheService.getFontPath();
        this.myFontsToDownload = fontsToDownload;
        this.myDownloadMenuFontsOnly = menuFontsOnly;
        this.mySuccess = success;
        this.myFailure = failure;
    }

    public void download() {
        ApplicationManager.getApplication().executeOnPooledThread(this::performDownload);
    }

    private void performDownload() {
        block5: {
            ArrayList<DownloadableFileDescription> files2 = new ArrayList<DownloadableFileDescription>();
            for (FontFamily fontFamily : this.myFontsToDownload) {
                this.addFontFamily(files2, fontFamily);
            }
            if (this.myFontPath == null) {
                FontDownloadService.notify(this.myFailure);
                return;
            }
            FontFileDownloader downloader = new FontFileDownloader(files2, null, null, "Download Fonts");
            try {
                downloader.download(this.myFontPath);
                FontDownloadService.notify(this.mySuccess);
            }
            catch (Exception ex) {
                if (FontDownloadService.performSingleFileDownloads(this.myFontPath, files2)) {
                    FontDownloadService.notify(this.mySuccess);
                }
                if (this.myFailure == null) break block5;
                FontDownloadService.notify(this.myFailure);
            }
        }
    }

    private static void notify(@Nullable Runnable callback) {
        if (callback != null) {
            callback.run();
        }
    }

    private static boolean performSingleFileDownloads(@NotNull File fontPath, @NotNull List<DownloadableFileDescription> files2) {
        if (fontPath == null) {
            FontDownloadService.$$$reportNull$$$0(2);
        }
        if (files2 == null) {
            FontDownloadService.$$$reportNull$$$0(3);
        }
        boolean success = true;
        for (DownloadableFileDescription file : files2) {
            FontFileDownloader downloader = new FontFileDownloader(Collections.singletonList(file), null, null, "Download Fonts");
            try {
                downloader.download(fontPath);
            }
            catch (Exception ex) {
                Logger.getInstance(FontDownloadService.class).warn("Unable to download: " + file.getDownloadUrl(), (Throwable)ex);
                success = false;
            }
        }
        return success;
    }

    private boolean cachedFileExists(@NotNull File relativeCachedFile) {
        if (relativeCachedFile == null) {
            FontDownloadService.$$$reportNull$$$0(4);
        }
        File file = new File(this.myFontPath, relativeCachedFile.getPath());
        return file.exists();
    }

    private void addFontFamily(@NotNull List<DownloadableFileDescription> files2, @NotNull FontFamily fontFamily) {
        File file;
        if (files2 == null) {
            FontDownloadService.$$$reportNull$$$0(5);
        }
        if (fontFamily == null) {
            FontDownloadService.$$$reportNull$$$0(6);
        }
        if ((file = this.myCacheService.getRelativeCachedMenuFile(fontFamily)) != null && !this.cachedFileExists(file)) {
            files2.add(FontDownloadService.createFileDescription(fontFamily.getMenu(), file));
        }
        if (!this.myDownloadMenuFontsOnly) {
            for (FontDetail font : fontFamily.getFonts()) {
                this.addFont(files2, font);
            }
        }
    }

    private void addFont(@NotNull List<DownloadableFileDescription> files2, @NotNull FontDetail font) {
        File file;
        if (files2 == null) {
            FontDownloadService.$$$reportNull$$$0(7);
        }
        if (font == null) {
            FontDownloadService.$$$reportNull$$$0(8);
        }
        if ((file = this.myCacheService.getRelativeFontFile(font)) != null && !this.cachedFileExists(file)) {
            files2.add(FontDownloadService.createFileDescription(font.getFontUrl(), file));
        }
    }

    @NotNull
    private static DownloadableFileDescription createFileDescription(@NotNull String url, @NotNull File relativeFile) {
        if (url == null) {
            FontDownloadService.$$$reportNull$$$0(9);
        }
        if (relativeFile == null) {
            FontDownloadService.$$$reportNull$$$0(10);
        }
        DownloadableFileDescription downloadableFileDescription = DownloadableFileService.getInstance().createFileDescription(url, relativeFile.getPath());
        if (downloadableFileDescription == null) {
            FontDownloadService.$$$reportNull$$$0(11);
        }
        return downloadableFileDescription;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontsToDownload";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontPath";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeCachedFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontFamily";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/fonts/FontDownloadService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/fonts/FontDownloadService";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performSingleFileDownloads";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cachedFileExists";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addFontFamily";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addFont";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createFileDescription";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

