/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd.crash;

import com.android.tools.analytics.Anonymizer;
import com.android.tools.idea.fd.FlightRecorder;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PermanentInstallationID;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoogleCrash {
    private static final boolean UNIT_TEST_MODE = ApplicationManager.getApplication() == null;
    private static final boolean DEBUG_BUILD = !UNIT_TEST_MODE && ApplicationManager.getApplication().isInternal();
    private static final String CRASH_URL = UNIT_TEST_MODE || DEBUG_BUILD ? "https://clients2.google.com/cr/staging_report" : "https://clients2.google.com/cr/report";
    @Nullable
    private static final String ANONYMIZED_UID = GoogleCrash.getAnonymizedUid();
    private static final String LOCALE = Locale.getDefault() == null ? "unknown" : Locale.getDefault().toString();
    static final String KEY_PRODUCT_ID = "productId";
    static final String KEY_VERSION = "version";
    private static GoogleCrash ourInstance;
    private final String myCrashUrl;

    @Nullable
    private static String getAnonymizedUid() {
        if (UNIT_TEST_MODE) {
            return "UnitTest";
        }
        try {
            return Anonymizer.anonymizeUtf8((ILogger)new NullLogger(), (String)PermanentInstallationID.get());
        }
        catch (IOException e) {
            return null;
        }
    }

    private GoogleCrash() {
        this(CRASH_URL);
    }

    @VisibleForTesting
    GoogleCrash(@NotNull String crashUrl) {
        if (crashUrl == null) {
            GoogleCrash.$$$reportNull$$$0(0);
        }
        this.myCrashUrl = crashUrl;
    }

    public CompletableFuture<String> submit(@NotNull FlightRecorder flightRecorder, @NotNull String issueText, @NotNull List<Path> logFiles) {
        if (flightRecorder == null) {
            GoogleCrash.$$$reportNull$$$0(1);
        }
        if (issueText == null) {
            GoogleCrash.$$$reportNull$$$0(2);
        }
        if (logFiles == null) {
            GoogleCrash.$$$reportNull$$$0(3);
        }
        CompletableFuture<String> future2 = new CompletableFuture<String>();
        ForkJoinPool.commonPool().submit(() -> {
            try {
                CloseableHttpClient client = HttpClients.createDefault();
                HttpResponse response = client.execute(this.createPost(flightRecorder, issueText, logFiles));
                StatusLine statusLine = response.getStatusLine();
                if (statusLine.getStatusCode() >= 300) {
                    future2.completeExceptionally((Throwable)new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase()));
                    if (DEBUG_BUILD) {
                        System.out.println("Error submitting report: " + statusLine);
                    }
                    return;
                }
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    future2.completeExceptionally(new NullPointerException("Empty response entity"));
                    return;
                }
                String reportId = EntityUtils.toString((HttpEntity)entity);
                if (DEBUG_BUILD) {
                    System.out.println("Report submitted: http://go/crash-staging/" + reportId);
                }
                future2.complete(reportId);
            }
            catch (IOException e) {
                future2.completeExceptionally(e);
            }
        });
        return future2;
    }

    @NotNull
    private HttpUriRequest createPost(@NotNull FlightRecorder flightRecorder, @NotNull String issueText, @NotNull List<Path> logFiles) {
        if (flightRecorder == null) {
            GoogleCrash.$$$reportNull$$$0(4);
        }
        if (issueText == null) {
            GoogleCrash.$$$reportNull$$$0(5);
        }
        if (logFiles == null) {
            GoogleCrash.$$$reportNull$$$0(6);
        }
        HttpPost post = new HttpPost(this.myCrashUrl);
        ApplicationInfo applicationInfo = GoogleCrash.getApplicationInfo();
        String strictVersion = applicationInfo == null ? "0.0.0.0" : applicationInfo.getStrictVersion();
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addTextBody(KEY_PRODUCT_ID, "AndroidStudio");
        builder.addTextBody(KEY_VERSION, strictVersion);
        builder.addTextBody("exception_info", GoogleCrash.getUniqueStackTrace());
        builder.addTextBody("user_report", issueText);
        if (ANONYMIZED_UID != null) {
            builder.addTextBody("guid", ANONYMIZED_UID);
        }
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        builder.addTextBody("ptime", Long.toString(runtimeMXBean.getUptime()));
        builder.addTextBody("fullVersion", applicationInfo == null ? "0.0.0.0" : applicationInfo.getFullVersion());
        builder.addTextBody("osName", StringUtil.notNullize((String)SystemInfo.OS_NAME));
        builder.addTextBody("osVersion", StringUtil.notNullize((String)SystemInfo.OS_VERSION));
        builder.addTextBody("osArch", StringUtil.notNullize((String)SystemInfo.OS_ARCH));
        builder.addTextBody("locale", StringUtil.notNullize((String)LOCALE));
        builder.addTextBody("vmName", StringUtil.notNullize((String)runtimeMXBean.getVmName()));
        builder.addTextBody("vmVendor", StringUtil.notNullize((String)runtimeMXBean.getVmVendor()));
        builder.addTextBody("vmVersion", StringUtil.notNullize((String)runtimeMXBean.getVmVersion()));
        MemoryUsage usage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        builder.addTextBody("heapUsed", Long.toString(usage.getUsed()));
        builder.addTextBody("heapCommitted", Long.toString(usage.getCommitted()));
        builder.addTextBody("heapMax", Long.toString(usage.getMax()));
        builder.addTextBody("Type", "InstantRunFlightRecorder");
        GoogleCrash.addFlightRecorderLogs(builder, flightRecorder, logFiles);
        post.setEntity((HttpEntity)new GzipCompressingEntity(builder.build()));
        HttpPost httpPost = post;
        if (httpPost == null) {
            GoogleCrash.$$$reportNull$$$0(7);
        }
        return httpPost;
    }

    static String getUniqueStackTrace() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("com.android.InstantRunException: Flight Recorder Information: ");
        sb.append(System.currentTimeMillis());
        sb.append('\n');
        sb.append("\tat ");
        boolean i2 = false;
        for (String u : Splitter.on((char)'-').split((CharSequence)UUID.randomUUID().toString())) {
            sb.append('p');
            sb.append(u);
            sb.append('.');
        }
        sb.append("FlightRecorder.report(Flight");
        sb.append(System.currentTimeMillis());
        sb.append("Recorder.java:500)");
        return sb.toString();
    }

    private static void addFlightRecorderLogs(@NotNull MultipartEntityBuilder builder, @NotNull FlightRecorder flightRecorder, @NotNull List<Path> logFiles) {
        if (builder == null) {
            GoogleCrash.$$$reportNull$$$0(8);
        }
        if (flightRecorder == null) {
            GoogleCrash.$$$reportNull$$$0(9);
        }
        if (logFiles == null) {
            GoogleCrash.$$$reportNull$$$0(10);
        }
        try {
            Path path = GoogleCrash.zipFiles(flightRecorder, logFiles);
            builder.addBinaryBody(path.getFileName().toString(), Files.readAllBytes(path), ContentType.APPLICATION_OCTET_STREAM, path.getFileName().toString());
        }
        catch (IOException e) {
            builder.addTextBody("IOError", e.toString());
        }
    }

    @NotNull
    private static Path zipFiles(@NotNull FlightRecorder flightRecorder, @NotNull List<Path> logFiles) throws IOException {
        if (flightRecorder == null) {
            GoogleCrash.$$$reportNull$$$0(11);
        }
        if (logFiles == null) {
            GoogleCrash.$$$reportNull$$$0(12);
        }
        Path tempFile = Files.createTempFile("flr", ".zip", new FileAttribute[0]);
        String baseName = FileUtilRt.getNameWithoutExtension((String)tempFile.getFileName().toString());
        byte[] data = new byte[4096];
        try (FileOutputStream fos = new FileOutputStream(tempFile.toFile());
             BufferedOutputStream bos = new BufferedOutputStream(fos);
             ZipOutputStream zos = new ZipOutputStream(bos);){
            zos.setMethod(8);
            for (Path file : logFiles) {
                String name = baseName + "/" + flightRecorder.getPresentablePath(file);
                zos.putNextEntry(new ZipEntry(name.replace(File.separatorChar, '/')));
                InputStream is = Files.newInputStream(file, new OpenOption[0]);
                Throwable throwable = null;
                try {
                    BufferedInputStream bis = new BufferedInputStream(is);
                    Throwable throwable2 = null;
                    try {
                        int i2;
                        while ((i2 = bis.read(data)) > 0) {
                            zos.write(data, 0, i2);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (bis == null) continue;
                        if (throwable2 != null) {
                            try {
                                bis.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        bis.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        Path path = tempFile;
        if (path == null) {
            GoogleCrash.$$$reportNull$$$0(13);
        }
        return path;
    }

    @Nullable
    private static ApplicationInfo getApplicationInfo() {
        return ApplicationManager.getApplication() == null ? null : ApplicationInfo.getInstance();
    }

    public static synchronized GoogleCrash getInstance() {
        if (ourInstance == null) {
            ourInstance = new GoogleCrash();
        }
        return ourInstance;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "crashUrl";
                break;
            }
            case 1: 
            case 4: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flightRecorder";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issueText";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logFiles";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/fd/crash/GoogleCrash";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/fd/crash/GoogleCrash";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createPost";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "zipFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "submit";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPost";
                break;
            }
            case 7: 
            case 13: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addFlightRecorderLogs";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "zipFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

