/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.android.tools.idea.concurrent.EdtExecutor;
import com.android.tools.idea.fd.InstantRunConfiguration;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunConfigurable
implements SearchableConfigurable,
Configurable.NoScroll,
HyperlinkListener,
Disposable {
    private final InstantRunConfiguration myBuildConfiguration;
    private JPanel myContentPanel;
    private JBCheckBox myInstantRunCheckBox;
    private JBCheckBox myRestartActivityCheckBox;
    private JBLabel myGradleLabel;
    private HyperlinkLabel myOldVersionLabel;
    private JBCheckBox myShowToastCheckBox;
    private JBCheckBox myShowIrStatusNotifications;

    public InstantRunConfigurable() {
        this.$$$setupUI$$$();
        this.myInstantRunCheckBox.addActionListener(e -> this.enableIrOptions(this.myInstantRunCheckBox.isSelected()));
        this.myBuildConfiguration = InstantRunConfiguration.getInstance();
        this.updateLinkState();
        this.enableIrOptions(this.myBuildConfiguration.INSTANT_RUN);
    }

    @NotNull
    public String getId() {
        if ("instant.run" == null) {
            InstantRunConfigurable.$$$reportNull$$$0(0);
        }
        return "instant.run";
    }

    @Nls
    public String getDisplayName() {
        return "Instant Run";
    }

    @Nullable
    public JComponent createComponent() {
        return this.myContentPanel;
    }

    public boolean isModified() {
        return this.myBuildConfiguration.INSTANT_RUN != this.isInstantRunEnabled() || this.myBuildConfiguration.RESTART_ACTIVITY != this.isRestartActivity() || this.myBuildConfiguration.SHOW_TOAST != this.isShowToast() || this.myBuildConfiguration.SHOW_IR_STATUS_NOTIFICATIONS != this.isShowStatusNotifications() || this.myBuildConfiguration.ENABLE_RECORDER != this.isEnableRecorder();
    }

    public void apply() throws ConfigurationException {
        this.myBuildConfiguration.INSTANT_RUN = this.isInstantRunEnabled();
        this.myBuildConfiguration.RESTART_ACTIVITY = this.isRestartActivity();
        this.myBuildConfiguration.SHOW_TOAST = this.isShowToast();
        this.myBuildConfiguration.SHOW_IR_STATUS_NOTIFICATIONS = this.isShowStatusNotifications();
        this.myBuildConfiguration.ENABLE_RECORDER = this.isEnableRecorder();
    }

    public void reset() {
        this.myInstantRunCheckBox.setSelected(this.myBuildConfiguration.INSTANT_RUN);
        this.myRestartActivityCheckBox.setSelected(this.myBuildConfiguration.RESTART_ACTIVITY);
        this.myShowToastCheckBox.setSelected(this.myBuildConfiguration.SHOW_TOAST);
        this.myShowIrStatusNotifications.setSelected(this.myBuildConfiguration.SHOW_IR_STATUS_NOTIFICATIONS);
    }

    public void disposeUIResources() {
    }

    private boolean isInstantRunEnabled() {
        return this.myInstantRunCheckBox.isSelected();
    }

    private boolean isRestartActivity() {
        return this.myRestartActivityCheckBox.isSelected();
    }

    private boolean isShowToast() {
        return this.myShowToastCheckBox.isSelected();
    }

    private boolean isShowStatusNotifications() {
        return this.myShowIrStatusNotifications.isSelected();
    }

    private boolean isEnableRecorder() {
        return false;
    }

    private void createUIComponents() {
        this.myOldVersionLabel = new HyperlinkLabel();
        this.setSyncLinkMessage("");
        this.myOldVersionLabel.addHyperlinkListener((HyperlinkListener)this);
    }

    private void setSyncLinkMessage(@NotNull String syncMessage) {
        if (syncMessage == null) {
            InstantRunConfigurable.$$$reportNull$$$0(1);
        }
        this.myOldVersionLabel.setHyperlinkText("Instant Run requires a newer version of the Gradle plugin. ", "Update Project", syncMessage);
        this.myOldVersionLabel.repaint();
    }

    private void updateLinkState() {
        boolean isGradle = false;
        boolean isCurrentPlugin = false;
        block0: for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (project.isDefault()) continue;
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                AndroidModuleModel model = AndroidModuleModel.get(module);
                if (model == null) continue;
                isGradle = true;
                if (!ProjectSystemUtil.getModuleSystem(module).getInstantRunSupport().isSupported()) continue;
                isCurrentPlugin = true;
                continue block0;
            }
        }
        this.myGradleLabel.setVisible(!isGradle);
        this.myOldVersionLabel.setVisible(isGradle && !isCurrentPlugin);
        boolean enabled = isGradle && isCurrentPlugin;
        this.enableIrOptions(enabled);
    }

    private void enableIrOptions(boolean enabled) {
        this.myRestartActivityCheckBox.setEnabled(enabled);
        this.myShowToastCheckBox.setEnabled(enabled);
        this.myShowIrStatusNotifications.setEnabled(enabled);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            if (project.isDefault()) continue;
            AndroidProjectSystem projectSystem = ProjectSystemUtil.getProjectSystem(project);
            if (projectSystem.upgradeProjectToSupportInstantRun()) {
                this.updateUi(true, false);
                Futures.addCallback(projectSystem.getSyncManager().syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED, false), (FutureCallback)new FutureCallback<ProjectSystemSyncManager.SyncResult>(){

                    public void onSuccess(ProjectSystemSyncManager.SyncResult result2) {
                        InstantRunConfigurable.this.updateUi(false, result2.isSuccessful());
                    }

                    public void onFailure(@NotNull Throwable t) {
                        if (t == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        InstantRunConfigurable.this.updateUi(false, false);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/android/tools/idea/fd/InstantRunConfigurable$1", "onFailure"));
                    }
                }, (Executor)EdtExecutor.INSTANCE);
                continue;
            }
            this.showFailureMessage();
        }
    }

    private void showFailureMessage() {
        this.setSyncLinkMessage("Error updating to new Gradle version");
    }

    public void dispose() {
    }

    private void updateUi(boolean syncing, boolean failed) {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myContentPanel.isShowing()) {
                if (syncing) {
                    this.setSyncLinkMessage("(Syncing)");
                } else if (failed) {
                    this.setSyncLinkMessage("(Sync Failed)");
                } else {
                    this.setSyncLinkMessage("");
                }
                this.updateLinkState();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/fd/InstantRunConfigurable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/fd/InstantRunConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setSyncLinkMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBLabel jBLabel;
        JBCheckBox jBCheckBox3;
        JBCheckBox jBCheckBox4;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myInstantRunCheckBox = jBCheckBox4 = new JBCheckBox();
        jBCheckBox4.setText("Enable Instant Run to hot swap code/resource changes on deploy (default enabled)");
        jPanel.add((Component)jBCheckBox4, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myRestartActivityCheckBox = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("Restart activity on code changes");
        jPanel.add((Component)jBCheckBox3, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myGradleLabel = jBLabel = new JBLabel();
        jBLabel.setText("Instant Run requires the project to be built with Gradle.");
        jBLabel.setVisible(false);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        HyperlinkLabel hyperlinkLabel = this.myOldVersionLabel;
        jPanel.add((Component)hyperlinkLabel, new GridConstraints(1, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        this.myShowToastCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Show toasts in the running app when changes are applied");
        jPanel.add((Component)jBCheckBox2, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.myShowIrStatusNotifications = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Show Instant Run status notifications");
        jPanel.add((Component)jBCheckBox, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }
}

