/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.qualifiers;

import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.resources.ResourceEnum;
import com.android.tools.idea.editors.theme.qualifiers.QualifierUtils;
import com.android.tools.idea.editors.theme.qualifiers.RestrictedQualifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestrictedEnum
implements RestrictedQualifier {
    private final Class<? extends ResourceEnum> myEnumClass;
    private final EnumSet<? extends ResourceEnum> myPossibleValues;

    public RestrictedEnum(@NotNull Class<? extends ResourceEnum> enumClass) {
        if (enumClass == null) {
            RestrictedEnum.$$$reportNull$$$0(0);
        }
        this.myPossibleValues = EnumSet.copyOf(Arrays.asList(enumClass.getEnumConstants()));
        this.myEnumClass = enumClass;
    }

    @NotNull
    private static ResourceEnum getValue(@NotNull ResourceQualifier qualifier) {
        if (qualifier == null) {
            RestrictedEnum.$$$reportNull$$$0(1);
        }
        ResourceEnum resourceEnum = (ResourceEnum)QualifierUtils.getValue(qualifier);
        if (resourceEnum == null) {
            RestrictedEnum.$$$reportNull$$$0(2);
        }
        return resourceEnum;
    }

    @Override
    public void setRestrictions(@Nullable ResourceQualifier compatible, @NotNull Collection<ResourceQualifier> incompatibles) {
        if (incompatibles == null) {
            RestrictedEnum.$$$reportNull$$$0(3);
        }
        if (ResourceQualifier.isValid((ResourceQualifier)compatible)) {
            this.myPossibleValues.clear();
            this.myPossibleValues.addAll(Collections.singletonList(RestrictedEnum.getValue(compatible)));
        } else {
            for (ResourceQualifier qualifier : incompatibles) {
                if (!qualifier.isValid()) continue;
                this.myPossibleValues.remove(RestrictedEnum.getValue(qualifier));
            }
        }
    }

    @Override
    public boolean isMatchFor(@Nullable ResourceQualifier qualifier) {
        if (!ResourceQualifier.isValid((ResourceQualifier)qualifier)) {
            return false;
        }
        return this.myPossibleValues.contains(RestrictedEnum.getValue(qualifier));
    }

    @Override
    public boolean isEmpty() {
        return this.myPossibleValues.isEmpty();
    }

    @Override
    @Nullable
    public Object getAny() {
        assert (!this.myPossibleValues.isEmpty());
        if (this.myEnumClass.getEnumConstants().length == this.myPossibleValues.size()) {
            return null;
        }
        return this.myPossibleValues.iterator().next();
    }

    @Override
    @Nullable
    public RestrictedQualifier intersect(@NotNull RestrictedQualifier otherRestricted) {
        if (otherRestricted == null) {
            RestrictedEnum.$$$reportNull$$$0(4);
        }
        assert (otherRestricted instanceof RestrictedEnum);
        RestrictedEnum otherRestrictedEnum = (RestrictedEnum)otherRestricted;
        assert (this.myEnumClass.equals(otherRestrictedEnum.myEnumClass));
        RestrictedEnum result2 = new RestrictedEnum(this.myEnumClass);
        result2.myPossibleValues.retainAll(this.myPossibleValues);
        result2.myPossibleValues.retainAll(otherRestrictedEnum.myPossibleValues);
        if (result2.myPossibleValues.isEmpty()) {
            return null;
        }
        return result2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestrictedEnum that = (RestrictedEnum)o;
        if (!this.myPossibleValues.equals(that.myPossibleValues)) {
            return false;
        }
        return this.myEnumClass.equals(that.myEnumClass);
    }

    public int hashCode() {
        int result2 = this.myPossibleValues.hashCode();
        result2 = 31 * result2 + this.myEnumClass.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/qualifiers/RestrictedEnum";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incompatibles";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherRestricted";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/qualifiers/RestrictedEnum";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setRestrictions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "intersect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

