/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.editors;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.theme.ColorUtils;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.ThemeEditorUtils;
import com.android.tools.idea.editors.theme.attributes.editors.GraphicalResourceRendererEditor;
import com.android.tools.idea.editors.theme.datamodels.EditedStyleItem;
import com.android.tools.idea.editors.theme.preview.AndroidThemePreviewPanel;
import com.android.tools.idea.editors.theme.ui.ResourceComponent;
import com.android.tools.idea.res.ResourceHelper;
import com.android.tools.idea.ui.resourcechooser.ResourceSwatchComponent;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.awt.Color;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.annotations.NotNull;

public class ColorRendererEditor
extends GraphicalResourceRendererEditor {
    public ColorRendererEditor(@NotNull ThemeEditorContext context, @NotNull AndroidThemePreviewPanel previewPanel, boolean isEditor) {
        if (context == null) {
            ColorRendererEditor.$$$reportNull$$$0(0);
        }
        if (previewPanel == null) {
            ColorRendererEditor.$$$reportNull$$$0(1);
        }
        super(context, previewPanel, isEditor);
    }

    @Override
    protected void updateComponent(@NotNull ThemeEditorContext context, @NotNull ResourceComponent component, @NotNull EditedStyleItem item) {
        ResourceSwatchComponent.SwatchIcon icon;
        if (context == null) {
            ColorRendererEditor.$$$reportNull$$$0(2);
        }
        if (component == null) {
            ColorRendererEditor.$$$reportNull$$$0(3);
        }
        if (item == null) {
            ColorRendererEditor.$$$reportNull$$$0(4);
        }
        ResourceResolver resourceResolver = context.getResourceResolver();
        assert (resourceResolver != null);
        List<Color> colors = ResourceHelper.resolveMultipleColors((RenderResources)resourceResolver, (ResourceValue)item.getSelectedValue(), context.getProject());
        if (colors.isEmpty()) {
            icon = ResourceSwatchComponent.WARNING_ICON;
        } else {
            icon = new ResourceSwatchComponent.ColorIcon((Color)Iterables.getLast(colors));
            icon.setIsStack(colors.size() > 1);
        }
        component.setSwatchIcon(icon);
        component.setNameText(item.getQualifiedName());
        component.setValueText(item.getValue());
        if (!colors.isEmpty()) {
            Color color = (Color)Iterables.getLast(colors);
            String attributeName = item.getAttrName();
            ImmutableMap<String, Color> contrastColorsWithDescription = ColorUtils.getContrastColorsWithDescription(context, attributeName);
            component.setWarning(ColorUtils.getContrastWarningMessage(contrastColorsWithDescription, color, ColorUtils.isBackgroundAttribute(attributeName)));
        } else {
            component.setWarning(null);
        }
    }

    @Override
    @NotNull
    protected EnumSet<ResourceType> getAllowedResourceTypes() {
        AttributeDefinition attrDefinition = ResolutionUtils.getAttributeDefinition(this.myContext.getConfiguration(), this.myItem.getSelectedValue());
        String attributeName = this.myItem.getAttrName().toLowerCase(Locale.ENGLISH);
        if (attributeName.contains("color") || !ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.REFERENCE)) {
            EnumSet enumSet = COLORS_ONLY;
            if (enumSet == null) {
                ColorRendererEditor.$$$reportNull$$$0(5);
            }
            return enumSet;
        }
        if (attributeName.contains("drawable") || !ThemeEditorUtils.acceptsFormat(attrDefinition, AttributeFormat.COLOR)) {
            EnumSet enumSet = DRAWABLES_ONLY;
            if (enumSet == null) {
                ColorRendererEditor.$$$reportNull$$$0(6);
            }
            return enumSet;
        }
        EnumSet enumSet = COLORS_AND_DRAWABLES;
        if (enumSet == null) {
            ColorRendererEditor.$$$reportNull$$$0(7);
        }
        return enumSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/attributes/editors/ColorRendererEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/attributes/editors/ColorRendererEditor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllowedResourceTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateComponent";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

