/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.builder.model.AaptOptions;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceRepositoryUtil;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceValueMap;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.ResourceType;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ResourceResolverCache;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeResolver {
    private static final StyleResourceValue[] NO_BASE_THEMES = new StyleResourceValue[0];
    private final Map<ResourceReference, ConfiguredThemeEditorStyle> myThemesByStyle;
    private final ImmutableList<ConfiguredThemeEditorStyle> myFrameworkThemes;
    private final ImmutableList<ConfiguredThemeEditorStyle> myLocalThemes;
    private final ImmutableList<ConfiguredThemeEditorStyle> myExternalLibraryThemes;
    private final Configuration myConfiguration;
    private final ResourceResolver myResolver;
    private List<ResourceReference> myRecommendedThemes;

    public ThemeResolver(@NotNull Configuration configuration) {
        if (configuration == null) {
            ThemeResolver.$$$reportNull$$$0(0);
        }
        this.myThemesByStyle = new HashMap<ResourceReference, ConfiguredThemeEditorStyle>();
        this.myConfiguration = configuration;
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getOrCreateInstance(configuration.getModule());
        if (repositoryManager == null) {
            throw new IllegalArgumentException("\"" + configuration.getModule().getName() + "\" is not an Android module");
        }
        this.myResolver = configuration.getResourceResolver();
        if (this.myResolver == null) {
            throw new IllegalArgumentException("Acquired ResourceResolver is null, not an Android module?");
        }
        this.myFrameworkThemes = this.fillThemeResolverFromStyles(this.resolveFrameworkThemes());
        ImmutableList.Builder localThemes = ImmutableList.builder();
        for (Pair<StyleResourceValue, Module> pair : this.resolveLocallyDefinedModuleThemes()) {
            ConfiguredThemeEditorStyle theme = this.constructThemeFromResourceValue((StyleResourceValue)pair.getFirst(), (Module)pair.getSecond());
            if (theme == null) continue;
            localThemes.add((Object)theme);
        }
        this.myLocalThemes = localThemes.build();
        this.myExternalLibraryThemes = this.fillThemeResolverFromStyles(this.resolveNonFrameworkThemes());
    }

    @Nullable
    private ConfiguredThemeEditorStyle constructThemeFromResourceValue(@NotNull StyleResourceValue value2, @Nullable Module sourceModule) {
        ResourceReference styleReference;
        if (value2 == null) {
            ThemeResolver.$$$reportNull$$$0(1);
        }
        if (this.myThemesByStyle.containsKey(styleReference = value2.asReference())) {
            return null;
        }
        ConfiguredThemeEditorStyle theme = ResolutionUtils.getThemeEditorStyle(this.myConfiguration, styleReference, sourceModule);
        if (theme != null) {
            this.myThemesByStyle.put(styleReference, theme);
        }
        return theme;
    }

    private ImmutableList<ConfiguredThemeEditorStyle> fillThemeResolverFromStyles(@NotNull List<StyleResourceValue> source) {
        if (source == null) {
            ThemeResolver.$$$reportNull$$$0(2);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (StyleResourceValue value2 : source) {
            ConfiguredThemeEditorStyle theme = this.constructThemeFromResourceValue(value2, null);
            if (theme == null) continue;
            builder.add((Object)theme);
        }
        return builder.build();
    }

    @NotNull
    private List<StyleResourceValue> resolveFrameworkThemes() {
        ConfigurationManager configurationManager = this.myConfiguration.getConfigurationManager();
        ResourceResolverCache resolverCache = configurationManager.getResolverCache();
        IAndroidTarget target = this.myConfiguration.getTarget();
        if (target == null) {
            List<StyleResourceValue> list = Collections.emptyList();
            if (list == null) {
                ThemeResolver.$$$reportNull$$$0(3);
            }
            return list;
        }
        Map<ResourceType, ResourceValueMap> resources = resolverCache.getConfiguredFrameworkResources(target, this.myConfiguration.getFullConfig());
        ResourceValueMap styles2 = resources.get(ResourceType.STYLE);
        List<StyleResourceValue> list = ThemeResolver.getFrameworkThemes(styles2);
        if (list == null) {
            ThemeResolver.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    private List<StyleResourceValue> resolveNonFrameworkThemes() {
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getOrCreateInstance(this.myConfiguration.getModule());
        if (repositoryManager == null) {
            List<StyleResourceValue> list = Collections.emptyList();
            if (list == null) {
                ThemeResolver.$$$reportNull$$$0(5);
            }
            return list;
        }
        LocalResourceRepository repository = repositoryManager.getAppResources(true);
        ResourceValueMap configuredResources = ResourceRepositoryUtil.getConfiguredResources((ResourceRepository)repository, (ResourceNamespace)repositoryManager.getNamespace(), (ResourceType)ResourceType.STYLE, (FolderConfiguration)this.myConfiguration.getFullConfig());
        List<StyleResourceValue> list = this.getNonFrameworkThemes(configuredResources);
        if (list == null) {
            ThemeResolver.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private List<Pair<StyleResourceValue, Module>> resolveLocallyDefinedModuleThemes() {
        Module module = this.myConfiguration.getModule();
        ArrayList<Pair<StyleResourceValue, Module>> result2 = new ArrayList<Pair<StyleResourceValue, Module>>();
        this.fillModuleResources(module, ResourceRepositoryManager.getModuleResources(module), result2);
        List<AndroidFacet> allAndroidDependencies = AndroidUtils.getAllAndroidDependencies(module, false);
        for (AndroidFacet facet : allAndroidDependencies) {
            this.fillModuleResources(facet.getModule(), ResourceRepositoryManager.getModuleResources(facet), result2);
        }
        ArrayList<Pair<StyleResourceValue, Module>> arrayList = result2;
        if (arrayList == null) {
            ThemeResolver.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private void fillModuleResources(@NotNull Module module, @Nullable LocalResourceRepository repository, @NotNull List<Pair<StyleResourceValue, Module>> sink) {
        if (module == null) {
            ThemeResolver.$$$reportNull$$$0(8);
        }
        if (sink == null) {
            ThemeResolver.$$$reportNull$$$0(9);
        }
        if (repository == null) {
            return;
        }
        ResourceNamespace namespace = ((SingleNamespaceResourceRepository)repository).getNamespace();
        ResourceValueMap configuredResources = ResourceRepositoryUtil.getConfiguredResources((ResourceRepository)repository, (ResourceNamespace)namespace, (ResourceType)ResourceType.STYLE, (FolderConfiguration)this.myConfiguration.getFullConfig());
        for (StyleResourceValue value2 : this.getNonFrameworkThemes(configuredResources)) {
            sink.add((Pair<StyleResourceValue, Module>)Pair.create((Object)value2, (Object)module));
        }
    }

    @NotNull
    private List<StyleResourceValue> getNonFrameworkThemes(@NotNull ResourceValueMap styles2) {
        if (styles2 == null) {
            ThemeResolver.$$$reportNull$$$0(10);
        }
        Collection values2 = styles2.values();
        ArrayList<StyleResourceValue> themes = new ArrayList<StyleResourceValue>(values2.size());
        HashMap cache = Maps.newHashMapWithExpectedSize((int)values2.size());
        for (ResourceValue value2 : values2) {
            StyleResourceValue styleValue;
            if (!(value2 instanceof StyleResourceValue) || !this.myResolver.isTheme((ResourceValue)(styleValue = (StyleResourceValue)value2), (Map)cache)) continue;
            themes.add(styleValue);
        }
        ArrayList<StyleResourceValue> arrayList = themes;
        if (arrayList == null) {
            ThemeResolver.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    private static List<StyleResourceValue> getFrameworkThemes(@NotNull ResourceValueMap styles2) {
        if (styles2 == null) {
            ThemeResolver.$$$reportNull$$$0(12);
        }
        Collection values2 = styles2.values();
        ArrayList<StyleResourceValue> themes = new ArrayList<StyleResourceValue>(values2.size());
        for (ResourceValue value2 : values2) {
            String name = value2.getName();
            if (!name.startsWith("Theme.") && !name.equals("Theme")) continue;
            themes.add((StyleResourceValue)value2);
        }
        ArrayList<StyleResourceValue> arrayList = themes;
        if (arrayList == null) {
            ThemeResolver.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Deprecated
    @Nullable
    public ConfiguredThemeEditorStyle getTheme(@NotNull String themeName) {
        if (themeName == null) {
            ThemeResolver.$$$reportNull$$$0(14);
        }
        ResourceReference styleReference = ResolutionUtils.getStyleReference(themeName);
        return this.myThemesByStyle.get(styleReference);
    }

    @Nullable
    public ConfiguredThemeEditorStyle getTheme(@NotNull ResourceReference styleReference) {
        if (styleReference == null) {
            ThemeResolver.$$$reportNull$$$0(15);
        }
        assert (styleReference.getResourceType() == ResourceType.STYLE);
        return this.myThemesByStyle.get(styleReference);
    }

    @NotNull
    public ImmutableList<ConfiguredThemeEditorStyle> getLocalThemes() {
        ImmutableList<ConfiguredThemeEditorStyle> immutableList = this.myLocalThemes;
        if (immutableList == null) {
            ThemeResolver.$$$reportNull$$$0(16);
        }
        return immutableList;
    }

    @NotNull
    public ImmutableList<ConfiguredThemeEditorStyle> getExternalLibraryThemes() {
        ImmutableList<ConfiguredThemeEditorStyle> immutableList = this.myExternalLibraryThemes;
        if (immutableList == null) {
            ThemeResolver.$$$reportNull$$$0(17);
        }
        return immutableList;
    }

    @NotNull
    public ImmutableList<ConfiguredThemeEditorStyle> getFrameworkThemes() {
        ImmutableList<ConfiguredThemeEditorStyle> immutableList = this.myFrameworkThemes;
        if (immutableList == null) {
            ThemeResolver.$$$reportNull$$$0(18);
        }
        return immutableList;
    }

    public int getThemesCount() {
        return this.myFrameworkThemes.size() + this.myExternalLibraryThemes.size() + this.myLocalThemes.size();
    }

    @NotNull
    Configuration getConfiguration() {
        Configuration configuration = this.myConfiguration;
        if (configuration == null) {
            ThemeResolver.$$$reportNull$$$0(19);
        }
        return configuration;
    }

    public boolean isRecommendedTheme(@NotNull ResourceReference styleReference) {
        if (styleReference == null) {
            ThemeResolver.$$$reportNull$$$0(20);
        }
        return this.getRecommendedThemes().contains(styleReference);
    }

    @NotNull
    public List<ResourceReference> getRecommendedThemes() {
        if (this.myRecommendedThemes == null) {
            this.myRecommendedThemes = ThemeResolver.computeRecommendedThemes(this.myConfiguration.getModule());
        }
        List<ResourceReference> list = this.myRecommendedThemes;
        if (list == null) {
            ThemeResolver.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    public StyleResourceValue[] requiredBaseThemes() {
        Module module = this.myConfiguration.getModule();
        if (!DependencyManagementUtil.dependsOn(module, GoogleMavenArtifactId.DESIGN) && !DependencyManagementUtil.dependsOn(module, GoogleMavenArtifactId.ANDROIDX_DESIGN)) {
            if (NO_BASE_THEMES == null) {
                ThemeResolver.$$$reportNull$$$0(22);
            }
            return NO_BASE_THEMES;
        }
        ResourceNamespace namespace = ThemeResolver.getAppCompatNamespace(module);
        if (namespace == null) {
            if (NO_BASE_THEMES == null) {
                ThemeResolver.$$$reportNull$$$0(23);
            }
            return NO_BASE_THEMES;
        }
        StyleResourceValue theme1 = this.findTheme(namespace, "Platform.AppCompat");
        StyleResourceValue theme2 = this.findTheme(namespace, "Platform.AppCompat.Light");
        if (theme1 == null || theme2 == null) {
            if (NO_BASE_THEMES == null) {
                ThemeResolver.$$$reportNull$$$0(24);
            }
            return NO_BASE_THEMES;
        }
        StyleResourceValue[] styleResourceValueArray = new StyleResourceValue[]{theme1, theme2};
        if (styleResourceValueArray == null) {
            ThemeResolver.$$$reportNull$$$0(25);
        }
        return styleResourceValueArray;
    }

    public boolean themeIsChildOfAny(@NotNull StyleResourceValue childTheme, StyleResourceValue ... parentThemes) {
        if (childTheme == null) {
            ThemeResolver.$$$reportNull$$$0(26);
        }
        return this.myResolver.themeIsChildOfAny(childTheme, parentThemes);
    }

    private StyleResourceValue findTheme(@NotNull ResourceNamespace namespace, @NotNull String themeName) {
        if (namespace == null) {
            ThemeResolver.$$$reportNull$$$0(27);
        }
        if (themeName == null) {
            ThemeResolver.$$$reportNull$$$0(28);
        }
        ResourceReference reference2 = ResourceReference.style((ResourceNamespace)namespace, (String)themeName);
        return this.myResolver.getStyle(reference2);
    }

    @Nullable
    private static ResourceNamespace getAppCompatNamespace(@NotNull Module module) {
        if (module == null) {
            ThemeResolver.$$$reportNull$$$0(29);
        }
        if (DependencyManagementUtil.dependsOn(module, GoogleMavenArtifactId.ANDROIDX_APP_COMPAT_V7)) {
            return ThemeResolver.isNamespacingEnabled(module) ? ResourceNamespace.APPCOMPAT : ResourceNamespace.RES_AUTO;
        }
        if (DependencyManagementUtil.dependsOn(module, GoogleMavenArtifactId.APP_COMPAT_V7)) {
            return ThemeResolver.isNamespacingEnabled(module) ? ResourceNamespace.APPCOMPAT_LEGACY : ResourceNamespace.RES_AUTO;
        }
        return null;
    }

    @NotNull
    private static List<ResourceReference> computeRecommendedThemes(@NotNull Module module) {
        ResourceNamespace appcompatNamespace;
        if (module == null) {
            ThemeResolver.$$$reportNull$$$0(30);
        }
        if ((appcompatNamespace = ThemeResolver.getAppCompatNamespace(module)) == null) {
            ImmutableList immutableList = ImmutableList.of((Object)ResourceReference.style((ResourceNamespace)ResourceNamespace.ANDROID, (String)"Theme.Material.Light.NoActionBar"), (Object)ResourceReference.style((ResourceNamespace)ResourceNamespace.ANDROID, (String)"Theme.Material.NoActionBar"));
            if (immutableList == null) {
                ThemeResolver.$$$reportNull$$$0(31);
            }
            return immutableList;
        }
        ImmutableList immutableList = ImmutableList.of((Object)ResourceReference.style((ResourceNamespace)ResourceNamespace.ANDROID, (String)"Theme.Material.Light.NoActionBar"), (Object)ResourceReference.style((ResourceNamespace)ResourceNamespace.ANDROID, (String)"Theme.Material.NoActionBar"), (Object)ResourceReference.style((ResourceNamespace)appcompatNamespace, (String)"Theme.AppCompat.Light.NoActionBar"), (Object)ResourceReference.style((ResourceNamespace)appcompatNamespace, (String)"Theme.AppCompat.NoActionBar"));
        if (immutableList == null) {
            ThemeResolver.$$$reportNull$$$0(32);
        }
        return immutableList;
    }

    private static boolean isNamespacingEnabled(@NotNull Module module) {
        ResourceRepositoryManager repositoryManager;
        if (module == null) {
            ThemeResolver.$$$reportNull$$$0(33);
        }
        return (repositoryManager = ResourceRepositoryManager.getOrCreateInstance(module)) != null && repositoryManager.getNamespacing() == AaptOptions.Namespacing.REQUIRED;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/ThemeResolver";
                break;
            }
            case 8: 
            case 29: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styles";
                break;
            }
            case 14: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "themeName";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleReference";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTheme";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/ThemeResolver";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFrameworkThemes";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveNonFrameworkThemes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocallyDefinedModuleThemes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonFrameworkThemes";
                break;
            }
            case 13: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkThemes";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalThemes";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalLibraryThemes";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecommendedThemes";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "requiredBaseThemes";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRecommendedThemes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "constructThemeFromResourceValue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fillThemeResolverFromStyles";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 32: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fillModuleResources";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNonFrameworkThemes";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFrameworkThemes";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTheme";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isRecommendedTheme";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "themeIsChildOfAny";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findTheme";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getAppCompatNamespace";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "computeRecommendedThemes";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isNamespacingEnabled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

